/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ui.bindable.views.listControl;

import com.intellij.ide.DefaultTreeExpander;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.StatusText;
import com.jetbrains.ide.model.uiautomation.BeBackgroundColorModifier;
import com.jetbrains.ide.model.uiautomation.BeStyleControl;
import com.jetbrains.ide.model.uiautomation.BeTreeGrid;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rd.ui.bedsl.extensions.BeGetterExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTree;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeAndTableExtensionsKt;
import com.jetbrains.rd.ui.bindable.views.listControl.BeTreeOrTableKt;
import com.jetbrains.rd.ui.bindable.views.listControl.utils.SwingTreeUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdclient.util.idea.ui.ModelRichTextExKt;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0014\u0010 \u001a\u0004\u0018\u00010\u00162\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010!\u001a\u00020\tH\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rd/ui/bindable/views/listControl/BeTree;", "Lcom/intellij/ui/treeStructure/Tree;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ui/tree/TreePathBackgroundSupplier;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "treeModel", "Ljavax/swing/tree/DefaultTreeModel;", "showAsList", "", "viewModel", "Lcom/jetbrains/ide/model/uiautomation/BeTreeGrid;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Ljavax/swing/tree/DefaultTreeModel;ZLcom/jetbrains/ide/model/uiautomation/BeTreeGrid;)V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getShowAsList", "()Z", "treeExpander", "Lcom/intellij/ide/DefaultTreeExpander;", "getData", "", "dataId", "", "getPathBackground", "Ljava/awt/Color;", "path", "Ljavax/swing/tree/TreePath;", "row", "", "getRendererComponentToolTip", "event", "Ljava/awt/event/MouseEvent;", "getToolTipText", "shouldShowBusyIconIfNeeded", "intellij.rd.ui"})
@SourceDebugExtension(value={"SMAP\nBeTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeTree.kt\ncom/jetbrains/rd/ui/bindable/views/listControl/BeTree\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,100:1\n13#2:101\n13#3:102\n*S KotlinDebug\n*F\n+ 1 BeTree.kt\ncom/jetbrains/rd/ui/bindable/views/listControl/BeTree\n*L\n35#1:101\n35#1:102\n*E\n"})
public final class BeTree
extends Tree
implements DataProvider,
TreePathBackgroundSupplier {
    private final boolean showAsList;
    @NotNull
    private final BeTreeGrid viewModel;
    @NotNull
    private final Logger logger;
    @NotNull
    private final DefaultTreeExpander treeExpander;

    public BeTree(@NotNull Lifetime lifetime, @NotNull DefaultTreeModel treeModel, boolean showAsList, @NotNull BeTreeGrid viewModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)treeModel, (String)"treeModel");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
        super((TreeModel)treeModel);
        this.showAsList = showAsList;
        this.viewModel = viewModel;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BeTree.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.treeExpander = new DefaultTreeExpander((JTree)((Object)this));
        if (!this.showAsList) {
            this.setBorder((Border)new JBEmptyBorder(0, 4, 0, 0));
        } else {
            this.setBorder((Border)new JBEmptyBorder(0));
            KeyStroke pressedEnter = KeyStroke.getKeyStroke(10, 0);
            InputMap inputMap = SwingUtilities.getUIInputMap((JComponent)((Object)this), 2);
            if (inputMap != null) {
                inputMap.remove(pressedEnter);
            }
            InputMap inputMap2 = SwingUtilities.getUIInputMap((JComponent)((Object)this), 0);
            if (inputMap2 != null) {
                inputMap2.remove(pressedEnter);
            }
        }
        BeTreeAndTableExtensionsKt.bindProgress(lifetime, this.viewModel.getProgress(), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(){

            public final void invoke(boolean it) {
                this.setPaintBusy(it);
            }
        }));
        StatusText statusText = this.getEmptyText();
        Intrinsics.checkNotNullExpressionValue((Object)statusText, (String)"getEmptyText(...)");
        ModelRichTextExKt.bindToBeEmptyText(statusText, lifetime, this.viewModel.getEmptyText());
    }

    public final boolean getShowAsList() {
        return this.showAsList;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        return LangDataKeys.NO_NEW_ACTION.is(dataId) ? Boolean.valueOf(true) : (PlatformDataKeys.TREE_EXPANDER.is(dataId) ? this.treeExpander : BeTreeAndTableExtensionsKt.treeGetData(this, (String)this.viewModel.getControlId().getValue(), dataId, this.logger));
    }

    @Nullable
    public Color getPathBackground(@NotNull TreePath path, int row) {
        DefaultMutableTreeNode node;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object object = path.getLastPathComponent();
        DefaultMutableTreeNode defaultMutableTreeNode = node = object instanceof DefaultMutableTreeNode ? (DefaultMutableTreeNode)object : null;
        if (node == null) {
            return super.getPathBackground(path, row);
        }
        Object object2 = (IProperty<BeBackgroundColorModifier>)SequencesKt.firstOrNull(BeGetterExtensionsKt.descendantsOfType(BeTreeOrTableKt.line(node), BeStyleControl.class));
        if (object2 == null || (object2 = ((BeStyleControl)((Object)object2)).getBackgroundColor()) == null || (object2 = (BeBackgroundColorModifier)((Object)object2.getValue())) == null || (object2 = ((BeBackgroundColorModifier)((Object)object2)).getColor()) == null || (object2 = ColorHostKt.toColor((AbstractColor)object2)) == null) {
            return super.getPathBackground(path, row);
        }
        return object2;
    }

    protected boolean shouldShowBusyIconIfNeeded() {
        return true;
    }

    private final String getRendererComponentToolTip(MouseEvent event) {
        Point point = event.getPoint();
        TreePath treePath = this.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return null;
        }
        TreePath path = treePath;
        Rectangle rectangle = this.getPathBounds(path);
        if (rectangle == null) {
            return null;
        }
        Rectangle pathBounds = rectangle;
        int row = this.getRowForPath(path);
        if (row == -1) {
            return null;
        }
        TreeCellRenderer treeCellRenderer = this.getCellRenderer();
        if (treeCellRenderer == null) {
            return null;
        }
        TreeCellRenderer renderer = treeCellRenderer;
        Object lastPathComponent = path.getLastPathComponent();
        Component rendererComponent = renderer.getTreeCellRendererComponent((JTree)((Object)this), lastPathComponent, this.isRowSelected(row), super.isExpanded(row), this.getModel().isLeaf(lastPathComponent), row, true);
        if (!(rendererComponent instanceof JComponent)) {
            return null;
        }
        JComponent jComponent = SwingTreeUtilsKt.getDeepestRendererComponentByEvent((Container)((Object)this), rendererComponent, pathBounds, event);
        if (jComponent == null) {
            return null;
        }
        JComponent activeComponent = jComponent;
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull(SwingTreeUtilsKt.pathToRoot(activeComponent, (Component)((Object)this)), (Function1)getRendererComponentToolTip.1.INSTANCE));
    }

    @Nullable
    public String getToolTipText(@Nullable MouseEvent event) {
        if (event == null) {
            return this.getToolTipText();
        }
        String string = this.getRendererComponentToolTip(event);
        if (string == null) {
            string = this.getToolTipText();
        }
        return string;
    }
}

