/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.ide.requests;

import com.jetbrains.rd.ide.model.RdPatch;
import com.jetbrains.rd.ide.model.RdPatchDisableCaretShiftOnWhitespaceExtension;
import com.jetbrains.rd.ide.model.RdPatchExtension;
import com.jetbrains.rd.ide.model.RdPatchInitialCaretStateHintExtension;
import com.jetbrains.rd.ide.model.RdPatchItem;
import com.jetbrains.rd.ide.model.RdPatchItemId;
import com.jetbrains.rd.ide.model.RdPatchItemVersion;
import com.jetbrains.rd.ide.requests.ChangeScope;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0005H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\tH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rd/ide/requests/PatchBuilder;", "Lcom/jetbrains/rd/ide/requests/ChangeScope;", "()V", "changes", "", "Lcom/jetbrains/rd/ide/model/RdPatchItem;", "expectedItems", "", "Lcom/jetbrains/rd/ide/model/RdPatchItemId;", "Lcom/jetbrains/rd/ide/model/RdPatchItemVersion;", "extensions", "", "Lcom/jetbrains/rd/ide/model/RdPatchExtension;", "features", "updatedItems", "build", "Lcom/jetbrains/rd/ide/model/RdPatch;", "pushChange", "", "step", "pushExpected", "version", "pushExtension", "ext", "pushFeature", "pushUpdated", "intellij.rd.platform"})
public final class PatchBuilder
implements ChangeScope {
    @NotNull
    private final Map<RdPatchItemId, RdPatchItemVersion> expectedItems = new LinkedHashMap();
    @NotNull
    private final Map<RdPatchItemId, RdPatchItemVersion> updatedItems = new LinkedHashMap();
    @NotNull
    private final List<RdPatchItem> changes = new ArrayList();
    @NotNull
    private final List<RdPatchItem> features = new ArrayList();
    @NotNull
    private final Set<RdPatchExtension> extensions;

    public PatchBuilder() {
        Object[] objectArray = new RdPatchExtension[]{new RdPatchInitialCaretStateHintExtension(null), new RdPatchDisableCaretShiftOnWhitespaceExtension(false)};
        this.extensions = SetsKt.mutableSetOf((Object[])objectArray);
    }

    @Nullable
    public final RdPatch build() {
        if (this.changes.isEmpty() && this.features.isEmpty()) {
            return null;
        }
        List<RdPatchItem> list2 = this.changes;
        List<RdPatchItem> list3 = this.features;
        List list4 = CollectionsKt.toList((Iterable)this.expectedItems.values());
        List list5 = CollectionsKt.toList((Iterable)this.updatedItems.values());
        List list6 = CollectionsKt.toList((Iterable)this.extensions);
        return new RdPatch(list2, list3, list6, list4, list5);
    }

    @Override
    public void pushExpected(@NotNull RdPatchItemVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.expectedItems.putIfAbsent(version.getId(), version);
    }

    @Override
    public void pushUpdated(@NotNull RdPatchItemVersion version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        this.updatedItems.put(version.getId(), version);
    }

    @Override
    public void pushChange(@NotNull RdPatchItem step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.changes.add(step);
    }

    @Override
    public void pushFeature(@NotNull RdPatchItem step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.features.add(step);
    }

    @Override
    public void pushExtension(@NotNull RdPatchExtension ext2) {
        Intrinsics.checkNotNullParameter((Object)ext2, (String)"ext");
        this.extensions.remove(ext2);
        this.extensions.add(ext2);
    }
}

