/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.editorActions.BackspaceHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;

public class KotlinBackspaceHandler
extends BackspaceHandlerDelegate {
    private boolean deleteGt;

    public void beforeCharDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset() - 1;
        this.deleteGt = c == '<' && file.getFileType() == KotlinFileType.INSTANCE && (LtGtTypingUtils.isAfterToken(offset, editor, (KtToken)KtTokens.FUN_KEYWORD) || LtGtTypingUtils.isAfterToken(offset, editor, KtTokens.IDENTIFIER));
    }

    public boolean charDeleted(char c, PsiFile file, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        CharSequence chars = editor.getDocument().getCharsSequence();
        if (editor.getDocument().getTextLength() <= offset) {
            return false;
        }
        char c1 = chars.charAt(offset);
        if (c == '<' && this.deleteGt) {
            if (c1 == '>') {
                LtGtTypingUtils.handleKotlinLTDeletion(editor, offset);
            }
            return true;
        }
        return false;
    }
}

