/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.backend.ir;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.IrPredicatesKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializationBaseContext;
import org.jetbrains.kotlinx.serialization.compiler.backend.ir.SerializerSearchUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/IrSerializableProperty;", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/ISerializableProperty;", "ir", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "isConstructorParameterWithDefault", "", "hasBackingField", "declaresDefaultValue", "type", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "(Lorg/jetbrains/kotlin/ir/declarations/IrProperty;ZZZLorg/jetbrains/kotlin/ir/types/IrSimpleType;)V", "genericIndex", "", "getGenericIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getIr", "()Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "()Z", "name", "", "getName", "()Ljava/lang/String;", "optional", "getOptional", "originalDescriptorName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalDescriptorName", "()Lorg/jetbrains/kotlin/name/Name;", "transient", "getTransient", "getType", "()Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "serializableWith", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "ctx", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/ir/SerializationBaseContext;", "kotlinx-serialization-compiler-plugin.backend"})
public final class IrSerializableProperty
implements ISerializableProperty {
    @NotNull
    private final IrProperty ir;
    private final boolean isConstructorParameterWithDefault;
    @NotNull
    private final IrSimpleType type;
    @NotNull
    private final String name;
    @NotNull
    private final Name originalDescriptorName;
    @Nullable
    private final Integer genericIndex;
    private final boolean optional;
    private final boolean transient;

    public IrSerializableProperty(@NotNull IrProperty ir, boolean isConstructorParameterWithDefault, boolean hasBackingField, boolean declaresDefaultValue, @NotNull IrSimpleType type) {
        Intrinsics.checkNotNullParameter((Object)ir, (String)"ir");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.ir = ir;
        this.isConstructorParameterWithDefault = isConstructorParameterWithDefault;
        this.type = type;
        String string = IrPredicatesKt.getSerialNameValue(this.ir.getAnnotations());
        if (string == null) {
            String string2 = this.ir.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        this.name = string;
        this.originalDescriptorName = this.ir.getName();
        this.genericIndex = IrPredicatesKt.getGenericIndex((IrType)this.type);
        this.optional = !AdditionalIrUtilsKt.hasAnnotation((List)this.ir.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getRequiredAnnotationFqName()) && declaresDefaultValue;
        this.transient = AdditionalIrUtilsKt.hasAnnotation((List)this.ir.getAnnotations(), (FqName)SerializationAnnotations.INSTANCE.getSerialTransientFqName()) || !hasBackingField;
    }

    @NotNull
    public final IrProperty getIr() {
        return this.ir;
    }

    @Override
    public boolean isConstructorParameterWithDefault() {
        return this.isConstructorParameterWithDefault;
    }

    @NotNull
    public final IrSimpleType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Name getOriginalDescriptorName() {
        return this.originalDescriptorName;
    }

    @Nullable
    public final Integer getGenericIndex() {
        return this.genericIndex;
    }

    @Nullable
    public final IrClassSymbol serializableWith(@NotNull SerializationBaseContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        IrClassSymbol irClassSymbol = SerializerSearchUtilKt.serializableWith(this.ir.getAnnotations());
        if (irClassSymbol == null) {
            irClassSymbol = SerializerSearchUtilKt.analyzeSpecialSerializers(ctx, this.ir.getAnnotations());
        }
        return irClassSymbol;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public boolean getTransient() {
        return this.transient;
    }
}

