/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.text.MessageFormat;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.SSLHandshakeException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001d\u0010\u0007\u001a\u00070\u0002\u00a2\u0006\u0002\b\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\u0019\u0010\r\u001a\t\u0018\u00010\u0002\u00a2\u0006\u0002\b\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002\u001a\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0002\u001a\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\"!\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0019"}, d2={"linuxPamPasswordPromptTranslations", "", "", "getLinuxPamPasswordPromptTranslations", "()Ljava/util/Set;", "linuxPamPasswordPromptTranslations$delegate", "Lkotlin/Lazy;", "getMessage", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "throwable", "", "full", "", "getNetworkExceptionMessage", "Lorg/jetbrains/annotations/Nls;", "t", "isOpenPamPasswordPrompt", "message", "isPamUnixPasswordPrompted", "toTimeoutInMillis", "", "timeout", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "intellij.platform.ssh"})
@JvmName(name="SshConnectionUtil")
public final class SshConnectionUtil {
    @NotNull
    private static final Lazy linuxPamPasswordPromptTranslations$delegate = LazyKt.lazy((Function0)linuxPamPasswordPromptTranslations.2.INSTANCE);

    public static final int toTimeoutInMillis(long timeout, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        long timeoutInMillis = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
        if (timeoutInMillis < 0L) {
            throw new IllegalArgumentException("Invalid timeout value: " + timeoutInMillis);
        }
        if (timeoutInMillis > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)timeoutInMillis;
    }

    private static final Set<String> getLinuxPamPasswordPromptTranslations() {
        Lazy lazy = linuxPamPasswordPromptTranslations$delegate;
        return (Set)lazy.getValue();
    }

    private static final boolean isOpenPamPasswordPrompt(String message) {
        return Intrinsics.areEqual((Object)message, (Object)"Password:") || Pattern.compile("^Password for [^ ]+@[^ ]+:$").matcher(message).matches();
    }

    public static final boolean isPamUnixPasswordPrompted(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SshConnectionUtil.getLinuxPamPasswordPromptTranslations().contains(message) || SshConnectionUtil.isOpenPamPasswordPrompt(message);
    }

    @NotNull
    public static final String getMessage(@Nullable Throwable throwable, boolean full) {
        String string;
        Throwable grandCause;
        Throwable throwable2 = throwable;
        Intrinsics.checkNotNull((Object)throwable2);
        Object reason = throwable2.getMessage();
        Throwable cause = throwable.getCause();
        if (cause != throwable && (cause instanceof ConnectException || cause instanceof UnknownHostException || cause instanceof SshException)) {
            if (cause.getCause() != null) {
                reason = SshConnectionUtil.getNetworkExceptionMessage(cause.getCause());
            }
            if (reason == null || cause.getCause() == null) {
                reason = SshConnectionUtil.getNetworkExceptionMessage(cause);
            }
            if (reason == null) {
                reason = throwable.getMessage();
            }
        }
        if (cause instanceof SSLHandshakeException && (grandCause = ((SSLHandshakeException)cause).getCause()) instanceof CertificateException && !StringUtil.isEmptyOrSpaces((String)((CertificateException)grandCause).getMessage())) {
            reason = grandCause instanceof CertificateExpiredException ? SshBundle.message("expired.certificate", new Object[0]) + " " : SshBundle.message("invalid.certificate", new Object[0]) + " ";
            reason = (String)reason + ((CertificateException)grandCause).getMessage();
        }
        if (reason == null) {
            reason = SshBundle.message("unknown.reason", new Object[0]);
        }
        if (full) {
            String string2;
            if (!Intrinsics.areEqual((Object)reason, (Object)throwable.getMessage())) {
                Object[] objectArray = new Object[]{throwable.getMessage(), reason};
                string2 = MessageFormat.format("{0} ({1})", objectArray);
            } else {
                String string3 = throwable.getMessage();
                Intrinsics.checkNotNull((Object)string3);
                string2 = StringsKt.replace$default((String)StringsKt.replace$default((String)string3, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
            }
            String string4 = string2;
            Intrinsics.checkNotNull((Object)string4);
            string = string4;
        } else {
            string = StringsKt.replace$default((String)StringsKt.replace$default((String)reason, (String)"\n", (String)"", (boolean)false, (int)4, null), (String)"\r", (String)"", (boolean)false, (int)4, null);
        }
        return string;
    }

    private static final String getNetworkExceptionMessage(Throwable t2) {
        String string;
        if (t2 instanceof UnknownHostException) {
            string = SshBundle.message("host.not.found", new Object[0]);
        } else {
            Throwable throwable = t2;
            Intrinsics.checkNotNull((Object)throwable);
            string = throwable.getMessage();
        }
        return string;
    }
}

