/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ml.inline.completion.impl.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import java.io.Reader;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tJ\b\u0010\r\u001a\u00020\u000bH\u0016J!\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0096\u0010J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/LineAppendableReader;", "Ljava/io/Reader;", "()V", "firstMessageOffset", "", "isClosed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "messages", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "appendLine", "", "message", "close", "read", "cbuf", "", "off", "len", "ready", "", "Companion", "intellij.ml.inline.completion"})
@SourceDebugExtension(value={"SMAP\nDiagnosticsLogConsole.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiagnosticsLogConsole.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/LineAppendableReader\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n23#2:147\n*S KotlinDebug\n*F\n+ 1 DiagnosticsLogConsole.kt\ncom/intellij/ml/inline/completion/impl/diagnostic/LineAppendableReader\n*L\n143#1:147\n*E\n"})
final class LineAppendableReader
extends Reader {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ConcurrentLinkedQueue<String> messages = new ConcurrentLinkedQueue();
    @NotNull
    private AtomicBoolean isClosed = new AtomicBoolean(false);
    private int firstMessageOffset;
    private static final int QUEUE_LIMIT = 1000;
    @NotNull
    private static final Logger LOG;

    public final void appendLine(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (this.isClosed.get()) {
            return;
        }
        if (this.messages.size() >= 1000) {
            LOG.warn("Console messages queue exceeded its limit.");
            this.messages.poll();
            this.firstMessageOffset = 0;
        }
        ((Collection)this.messages).add(message + "\n");
    }

    @Override
    public int read(@NotNull char[] cbuf, int off, int len) {
        Object object;
        int toRead;
        String message;
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        while (true) {
            if (this_.isClosed.get()) {
                return -1;
            }
            if (len == 0) {
                return 0;
            }
            if (this_.messages.peek() == null) {
                return 0;
            }
            toRead = Math.min(len, message.length() - this_.firstMessageOffset);
            if (toRead > 0) break;
            this_.messages.poll();
            this_.firstMessageOffset = 0;
            LineAppendableReader lineAppendableReader = this_;
            object = cbuf;
            int n = off;
            int n2 = len;
            LineAppendableReader this_ = lineAppendableReader;
            cbuf = object;
            off = n;
            len = n2;
        }
        String string = message.substring(this_.firstMessageOffset, this_.firstMessageOffset + toRead);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String read = string;
        char[] cArray = read.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        ArraysKt.copyInto$default((char[])cArray, (char[])cbuf, (int)off, (int)0, (int)0, (int)12, null);
        object = this_;
        object.firstMessageOffset += toRead;
        return toRead;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ready() {
        if (this.messages.size() > 1) return true;
        String string = (String)CollectionsKt.firstOrNull((Iterable)this.messages);
        if ((string != null ? string.length() : 0) <= this.firstMessageOffset) return false;
        return true;
    }

    @Override
    public void close() {
        this.isClosed.set(true);
        this.messages.clear();
    }

    static {
        Companion $this$thisLogger$iv = Companion = new Companion(null);
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
        LOG = logger2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ml/inline/completion/impl/diagnostic/LineAppendableReader$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "QUEUE_LIMIT", "", "intellij.ml.inline.completion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

