/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.konan.util;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.file.ZipUtilKt;
import org.jetbrains.kotlin.konan.util.ArchiveType;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \f2\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyExtractor;", "", "archiveType", "Lorg/jetbrains/kotlin/konan/util/ArchiveType;", "(Lorg/jetbrains/kotlin/konan/util/ArchiveType;)V", "extract", "", "archive", "Ljava/io/File;", "targetDirectory", "extractTarGz", "tarGz", "Companion", "kotlin-native-utils"})
public final class DependencyExtractor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ArchiveType archiveType;
    private static final long extractionTimeout = 3600L;
    @NotNull
    private static final TimeUnit extractionTimeoutUntis = TimeUnit.SECONDS;

    public DependencyExtractor(@NotNull ArchiveType archiveType) {
        Intrinsics.checkNotNullParameter((Object)archiveType, "archiveType");
        this.archiveType = archiveType;
    }

    private final void extractTarGz(File tarGz, File targetDirectory) {
        ProcessBuilder processBuilder;
        ProcessBuilder $this$extractTarGz_u24lambda_u240 = processBuilder = new ProcessBuilder(new String[0]);
        boolean bl = false;
        String[] stringArray = new String[]{"tar", "-xzf", tarGz.getCanonicalPath()};
        $this$extractTarGz_u24lambda_u240.command(stringArray);
        $this$extractTarGz_u24lambda_u240.directory(targetDirectory);
        $this$extractTarGz_u24lambda_u240.inheritIO();
        Process tarProcess = processBuilder.start();
        boolean finished = tarProcess.waitFor(extractionTimeout, extractionTimeoutUntis);
        if (finished && tarProcess.exitValue() != 0) {
            throw new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\nTar exit code: " + tarProcess.exitValue() + '.');
        }
        if (!finished) {
            tarProcess.destroy();
            throw new RuntimeException("Cannot extract archive with dependency: " + tarGz.getCanonicalPath() + ".\nTar process hasn't finished in " + extractionTimeoutUntis.toSeconds(extractionTimeout) + " sec.");
        }
    }

    public final void extract(@NotNull File archive, @NotNull File targetDirectory) {
        Intrinsics.checkNotNullParameter(archive, "archive");
        Intrinsics.checkNotNullParameter(targetDirectory, "targetDirectory");
        switch (WhenMappings.$EnumSwitchMapping$0[this.archiveType.ordinal()]) {
            case 1: {
                Path path = archive.toPath();
                Intrinsics.checkNotNullExpressionValue(path, "archive.toPath()");
                Path path2 = targetDirectory.toPath();
                Intrinsics.checkNotNullExpressionValue(path2, "targetDirectory.toPath()");
                ZipUtilKt.unzipTo$default(path, path2, null, false, 6, null);
                break;
            }
            case 2: {
                this.extractTarGz(archive, targetDirectory);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/konan/util/DependencyExtractor$Companion;", "", "()V", "extractionTimeout", "", "getExtractionTimeout", "()J", "extractionTimeoutUntis", "Ljava/util/concurrent/TimeUnit;", "getExtractionTimeoutUntis", "()Ljava/util/concurrent/TimeUnit;", "kotlin-native-utils"})
    public static final class Companion {
        private Companion() {
        }

        public final long getExtractionTimeout() {
            return extractionTimeout;
        }

        @NotNull
        public final TimeUnit getExtractionTimeoutUntis() {
            return extractionTimeoutUntis;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArchiveType.values().length];
            try {
                nArray[ArchiveType.ZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ArchiveType.TAR_GZ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

