/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.ResolveTemporaryNamesKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.Scope;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDeclarationScope;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadataImpl;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\u0003\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a\u0018\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0002H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0002\u00a8\u0006\t"}, d2={"computeScopes", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/Scope;", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "liftUsedNames", "resolveNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "resolveTemporaryNames", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nresolveTemporaryNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n1#2:145\n1855#3,2:146\n1855#3,2:148\n*S KotlinDebug\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n*L\n51#1:146,2\n62#1:148,2\n*E\n"})
public final class ResolveTemporaryNamesKt {
    public static final void resolveTemporaryNames(@NotNull JsNode $this$resolveTemporaryNames) {
        Intrinsics.checkNotNullParameter($this$resolveTemporaryNames, "<this>");
        Map<JsName, JsName> renamings = ResolveTemporaryNamesKt.resolveNames($this$resolveTemporaryNames);
        $this$resolveTemporaryNames.accept(new RecursiveJsVisitor(renamings){
            final /* synthetic */ Map<JsName, JsName> $renamings;
            {
                this.$renamings = $renamings;
            }

            protected void visitElement(@NotNull JsNode node) {
                block1: {
                    JsName name2;
                    Intrinsics.checkNotNullParameter(node, "node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name2 = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = this.$renamings.get(name2);
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }
        });
    }

    private static final Map<JsName, JsName> resolveNames(JsNode $this$resolveNames) {
        Scope rootScope2 = ResolveTemporaryNamesKt.liftUsedNames(ResolveTemporaryNamesKt.computeScopes($this$resolveNames));
        HashMap<JsName, JsName> replacements = new HashMap<JsName, JsName>();
        ResolveTemporaryNamesKt.resolveNames$traverse(replacements, rootScope2);
        return replacements;
    }

    private static final Scope liftUsedNames(Scope $this$liftUsedNames) {
        ResolveTemporaryNamesKt.liftUsedNames$traverse$2($this$liftUsedNames);
        return $this$liftUsedNames;
    }

    private static final Scope computeScopes(JsNode $this$computeScopes) {
        Scope rootScope2 = new Scope();
        $this$computeScopes.accept(new RecursiveJsVisitor(rootScope2){
            @NotNull
            private Scope currentScope;
            {
                this.currentScope = $rootScope;
            }

            @NotNull
            public final Scope getCurrentScope() {
                return this.currentScope;
            }

            public final void setCurrentScope(@NotNull Scope scope2) {
                Intrinsics.checkNotNullParameter(scope2, "<set-?>");
                this.currentScope = scope2;
            }

            public void visitClass(@NotNull JsClass x) {
                Intrinsics.checkNotNullParameter(x, "x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName it = jsName;
                    boolean bl = false;
                    ((Collection)this.currentScope.getDeclaredNames()).add(it);
                }
                JsFunction jsFunction = x.getConstructor();
                if (jsFunction != null) {
                    jsFunction.accept(this);
                }
                JsExpression jsExpression = x.getBaseClass();
                if (jsExpression != null) {
                    jsExpression.accept(this);
                }
                Iterable $this$forEach$iv = x.getMembers();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsFunction it = (JsFunction)element$iv;
                    boolean bl = false;
                    this.visitFunction(it, false);
                }
            }

            public void visitFunction(@NotNull JsFunction x) {
                Intrinsics.checkNotNullParameter(x, "x");
                this.visitFunction(x, true);
            }

            /*
             * WARNING - void declaration
             */
            public final void visitFunction(@NotNull JsFunction x, boolean shouldReserveName) {
                void $this$mapTo$iv$iv;
                void $this$visitFunction_u24lambda_u244;
                Object object;
                Intrinsics.checkNotNullParameter(x, "x");
                Object object2 = x.getName();
                if (object2 != null) {
                    object = object2;
                    JsName it = object;
                    boolean bl = false;
                    object2 = shouldReserveName ? object : null;
                    if (object2 != null) {
                        it = object2;
                        boolean bl2 = false;
                        ((Collection)this.currentScope.getDeclaredNames()).add(it);
                    }
                }
                Scope oldScope = this.currentScope;
                Scope scope2 = new Scope();
                object = scope2;
                Object object3 = this;
                boolean bl = false;
                ((Collection)this.currentScope.getChildren()).add($this$visitFunction_u24lambda_u244);
                object3.currentScope = scope2;
                object = this.currentScope.getDeclaredNames();
                List<JsParameter> list2 = x.getParameters();
                Intrinsics.checkNotNullExpressionValue(list2, "getParameters(...)");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    object3 = destination$iv$iv;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNullExpressionValue(jsName, "getName(...)");
                    object3.add(jsName);
                }
                Iterable iterable2 = (List)destination$iv$iv;
                CollectionsKt.addAll(object, iterable2);
                super.visitFunction(x);
                this.currentScope = oldScope;
            }

            public void visitCatch(@NotNull JsCatch x) {
                Intrinsics.checkNotNullParameter(x, "x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x.getParameter().getName());
                super.visitCatch(x);
            }

            public void visit(@NotNull JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter(x, "x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x.getName());
                super.visit(x);
            }

            public void visitNameRef(@NotNull JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter(nameRef, "nameRef");
                if (nameRef.getQualifier() == null) {
                    JsName name2 = nameRef.getName();
                    Collection collection = this.currentScope.getUsedNames();
                    JsName jsName = name2;
                    if (jsName == null) {
                        JsName jsName2 = JsDynamicScope.INSTANCE.declareName(nameRef.getIdent());
                        jsName = jsName2;
                        Intrinsics.checkNotNullExpressionValue(jsName2, "declareName(...)");
                    }
                    collection.add(jsName);
                }
                super.visitNameRef(nameRef);
            }

            public void visitImport(@NotNull JsImport jsImport) {
                Intrinsics.checkNotNullParameter(jsImport, "import");
                JsImport.Target target = jsImport.getTarget();
                if (target instanceof JsImport.Target.All) {
                    JsName jsName = ((JsImport.Target.All)target).getAlias().getName();
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((Collection)this.currentScope.getDeclaredNames()).add(it);
                    }
                } else if (target instanceof JsImport.Target.Default) {
                    JsName jsName = ((JsImport.Target.Default)target).getName().getName();
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((Collection)this.currentScope.getDeclaredNames()).add(it);
                    }
                } else if (target instanceof JsImport.Target.Elements) {
                    Iterable $this$forEach$iv = ((JsImport.Target.Elements)target).getElements();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        JsImport.Element it = (JsImport.Element)element$iv;
                        boolean bl = false;
                        Collection collection = this.currentScope.getDeclaredNames();
                        HasMetadata hasMetadata = it.getAlias();
                        if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                            hasMetadata = it.getName();
                        }
                        collection.add(hasMetadata);
                    }
                }
                super.visitImport(jsImport);
            }

            public void visitBreak(@NotNull JsBreak x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }

            public void visitContinue(@NotNull JsContinue x) {
                Intrinsics.checkNotNullParameter(x, "x");
            }
        });
        return rootScope2;
    }

    private static final void resolveNames$traverse(HashMap<JsName, JsName> replacements, Scope scope2) {
        Set occupiedNames2 = SequencesKt.toMutableSet(SequencesKt.map(SequencesKt.filter(CollectionsKt.asSequence((Iterable)scope2.getDeclaredNames()), resolveNames.traverse.occupiedNames.1.INSTANCE), resolveNames.traverse.occupiedNames.2.INSTANCE));
        CollectionsKt.addAll((Collection)occupiedNames2, SequencesKt.mapNotNull(CollectionsKt.asSequence((Iterable)scope2.getUsedNames()), (Function1)new Function1<JsName, String>(replacements){
            final /* synthetic */ HashMap<JsName, JsName> $replacements;
            {
                this.$replacements = $replacements;
                super(1);
            }

            @Nullable
            public final String invoke(@NotNull JsName it) {
                String string2;
                Intrinsics.checkNotNullParameter(it, "it");
                if (!it.isTemporary()) {
                    string2 = it.getIdent();
                } else {
                    JsName jsName = this.$replacements.get(it);
                    string2 = jsName != null ? jsName.getIdent() : null;
                }
                return string2;
            }
        }));
        HashMap nextSuffix = new HashMap();
        Iterator iterator2 = SequencesKt.filter(CollectionsKt.asSequence((Iterable)scope2.getDeclaredNames()), resolveNames.traverse.2.INSTANCE).iterator();
        while (iterator2.hasNext()) {
            String resolvedName;
            JsName temporaryName = (JsName)iterator2.next();
            Intrinsics.checkNotNullExpressionValue(temporaryName.getIdent(), "getIdent(...)");
            Integer n = nextSuffix.getOrDefault(temporaryName.getIdent(), 0);
            Intrinsics.checkNotNullExpressionValue(n, "getOrDefault(...)");
            int suffix = ((Number)n).intValue();
            while (JsDeclarationScope.Companion.getRESERVED_WORDS().contains(resolvedName) || occupiedNames2.contains(resolvedName)) {
                resolvedName = temporaryName.getIdent() + '_' + suffix++;
            }
            Map map = nextSuffix;
            String string2 = temporaryName.getIdent();
            Intrinsics.checkNotNullExpressionValue(string2, "getIdent(...)");
            Object object = string2;
            Object object2 = suffix;
            map.put(object, object2);
            map = replacements;
            Object $this$resolveNames_u24traverse_u24lambda_u240 = object2 = JsDynamicScope.INSTANCE.declareName(resolvedName);
            boolean bl = false;
            ((HasMetadataImpl)$this$resolveNames_u24traverse_u24lambda_u240).copyMetadataFrom(temporaryName);
            Object object3 = object2;
            Intrinsics.checkNotNullExpressionValue(object3, "apply(...)");
            object = object3;
            map.put(temporaryName, object);
            ((Collection)occupiedNames2).add(resolvedName);
        }
        Iterable $this$forEach$iv = scope2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope p0 = (Scope)element$iv;
            boolean bl = false;
            ResolveTemporaryNamesKt.resolveNames$traverse(replacements, p0);
        }
    }

    private static final void liftUsedNames$traverse$2(Scope scope2) {
        Iterable $this$forEach$iv = scope2.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope child = (Scope)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)scope2.getUsedNames(), (Iterable)child.getDeclaredNames());
            ResolveTemporaryNamesKt.liftUsedNames$traverse$2(child);
            CollectionsKt.addAll((Collection)scope2.getUsedNames(), (Iterable)child.getUsedNames());
        }
    }
}

