/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LiveLocalsTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "localMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "receiver", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "unitType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "(Ljava/util/Map;Lkotlin/jvm/functions/Function0;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "visitGetValue", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitVariable", "Lorg/jetbrains/kotlin/ir/IrStatement;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nSuspendLoweringUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SuspendLoweringUtils.kt\norg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LiveLocalsTransformer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1#2:115\n*E\n"})
public final class LiveLocalsTransformer
extends IrElementTransformerVoid {
    @NotNull
    private final Map<IrValueSymbol, IrFieldSymbol> localMap;
    @NotNull
    private final Function0<IrExpression> receiver;
    @NotNull
    private final IrType unitType;

    public LiveLocalsTransformer(@NotNull Map<IrValueSymbol, ? extends IrFieldSymbol> localMap, @NotNull Function0<? extends IrExpression> receiver, @NotNull IrType unitType) {
        Intrinsics.checkNotNullParameter(localMap, "localMap");
        Intrinsics.checkNotNullParameter(receiver, "receiver");
        Intrinsics.checkNotNullParameter(unitType, "unitType");
        this.localMap = localMap;
        this.receiver = receiver;
        this.unitType = unitType;
    }

    @Override
    @NotNull
    public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrFieldSymbol irFieldSymbol = this.localMap.get(expression2.getSymbol());
        if (irFieldSymbol == null) {
            return MiscKt.isDispatchReceiver(expression2.getSymbol().getOwner()) ? this.receiver.invoke() : (IrExpression)expression2;
        }
        IrFieldSymbol field2 = irFieldSymbol;
        IrGetValue $this$visitGetValue_u24lambda_u240 = expression2;
        boolean bl = false;
        return new IrGetFieldImpl($this$visitGetValue_u24lambda_u240.getStartOffset(), $this$visitGetValue_u24lambda_u240.getEndOffset(), field2, $this$visitGetValue_u24lambda_u240.getType(), this.receiver.invoke(), $this$visitGetValue_u24lambda_u240.getOrigin(), null, 64, null);
    }

    @Override
    @NotNull
    public IrExpression visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFieldSymbol irFieldSymbol = this.localMap.get(expression2.getSymbol());
        if (irFieldSymbol == null) {
            return expression2;
        }
        IrFieldSymbol field2 = irFieldSymbol;
        IrSetValue $this$visitSetValue_u24lambda_u241 = expression2;
        boolean bl = false;
        return new IrSetFieldImpl($this$visitSetValue_u24lambda_u241.getStartOffset(), $this$visitSetValue_u24lambda_u241.getEndOffset(), field2, this.receiver.invoke(), $this$visitSetValue_u24lambda_u241.getValue(), this.unitType, $this$visitSetValue_u24lambda_u241.getOrigin(), null, 128, null);
    }

    @Override
    @NotNull
    public IrStatement visitVariable(@NotNull IrVariable declaration) {
        IrStatement irStatement;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        IrElementTransformerVoidKt.transformChildrenVoid(declaration, this);
        IrFieldSymbol irFieldSymbol = this.localMap.get(declaration.getSymbol());
        if (irFieldSymbol == null) {
            return declaration;
        }
        IrFieldSymbol field2 = irFieldSymbol;
        IrExpression initializer2 = declaration.getInitializer();
        if (initializer2 != null) {
            IrVariable $this$visitVariable_u24lambda_u242 = declaration;
            boolean bl = false;
            irStatement = new IrSetFieldImpl($this$visitVariable_u24lambda_u242.getStartOffset(), $this$visitVariable_u24lambda_u242.getEndOffset(), field2, this.receiver.invoke(), initializer2, this.unitType, null, null, 192, null);
        } else {
            irStatement = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, this.unitType, null, 2, null);
        }
        return irStatement;
    }
}

