/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationAnnotationInfo;
import org.jetbrains.kotlin.fir.declarations.FutureApiDeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationInfo;
import org.jetbrains.kotlin.resolve.deprecation.DeprecationLevelValue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/SinceKotlinInfo;", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationAnnotationInfo;", "sinceVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "(Lorg/jetbrains/kotlin/config/ApiVersion;)V", "getSinceVersion", "()Lorg/jetbrains/kotlin/config/ApiVersion;", "computeDeprecationInfo", "Lorg/jetbrains/kotlin/resolve/deprecation/DeprecationInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "tree"})
@SourceDebugExtension(value={"SMAP\nDeprecationsProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeprecationsProvider.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinInfo\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n*L\n1#1,140:1\n227#2:141\n*S KotlinDebug\n*F\n+ 1 DeprecationsProvider.kt\norg/jetbrains/kotlin/fir/declarations/SinceKotlinInfo\n*L\n97#1:141\n*E\n"})
public final class SinceKotlinInfo
extends DeprecationAnnotationInfo {
    @NotNull
    private final ApiVersion sinceVersion;

    public SinceKotlinInfo(@NotNull ApiVersion sinceVersion) {
        Intrinsics.checkNotNullParameter(sinceVersion, "sinceVersion");
        super(null);
        this.sinceVersion = sinceVersion;
    }

    @NotNull
    public final ApiVersion getSinceVersion() {
        return this.sinceVersion;
    }

    @Override
    @Nullable
    public DeprecationInfo computeDeprecationInfo(@NotNull LanguageVersionSettings languageVersionSettings2) {
        FutureApiDeprecationInfo futureApiDeprecationInfo;
        Intrinsics.checkNotNullParameter(languageVersionSettings2, "languageVersionSettings");
        boolean condition$iv = this.sinceVersion.compareTo(languageVersionSettings2.getApiVersion()) <= 0;
        boolean $i$f$runUnless = false;
        if (condition$iv) {
            futureApiDeprecationInfo = null;
        } else {
            boolean bl = false;
            futureApiDeprecationInfo = new FutureApiDeprecationInfo(DeprecationLevelValue.HIDDEN, true, this.sinceVersion);
        }
        return futureApiDeprecationInfo;
    }
}

