/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.text;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DiffLog;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class BlockSupport {
    public static final Key<Boolean> DO_NOT_REPARSE_INCREMENTALLY = Key.create("DO_NOT_REPARSE_INCREMENTALLY");
    public static final Key<Pair<ASTNode, CharSequence>> TREE_TO_BE_REPARSED = Key.create("TREE_TO_BE_REPARSED");
    public static final int INCREMENTAL_REPARSE_DEPTH_LIMIT = Registry.intValue("psi.incremental.reparse.depth.limit");
    public static final Key<Boolean> TREE_DEPTH_LIMIT_EXCEEDED = Key.create("TREE_IS_TOO_DEEP");

    public static BlockSupport getInstance(Project project) {
        return project.getService(BlockSupport.class);
    }

    public abstract void reparseRange(@NotNull PsiFile var1, int var2, int var3, @NonNls @NotNull CharSequence var4) throws IncorrectOperationException;

    @NotNull
    public abstract DiffLog reparseRange(@NotNull PsiFile var1, @NotNull FileASTNode var2, @NotNull TextRange var3, @NotNull CharSequence var4, @NotNull ProgressIndicator var5, @NotNull CharSequence var6) throws IncorrectOperationException;

    public static boolean isTooDeep(UserDataHolder element) {
        return element != null && Boolean.TRUE.equals(element.getUserData(TREE_DEPTH_LIMIT_EXCEEDED));
    }

    public static class ReparsedSuccessfullyException
    extends RuntimeException
    implements ControlFlowException {
        private final DiffLog myDiffLog;

        public ReparsedSuccessfullyException(@NotNull DiffLog diffLog) {
            if (diffLog == null) {
                ReparsedSuccessfullyException.$$$reportNull$$$0(0);
            }
            this.myDiffLog = diffLog;
        }

        @NotNull
        public DiffLog getDiffLog() {
            DiffLog diffLog = this.myDiffLog;
            if (diffLog == null) {
                ReparsedSuccessfullyException.$$$reportNull$$$0(1);
            }
            return diffLog;
        }

        @Override
        @NotNull
        public synchronized Throwable fillInStackTrace() {
            ReparsedSuccessfullyException reparsedSuccessfullyException = this;
            if (reparsedSuccessfullyException == null) {
                ReparsedSuccessfullyException.$$$reportNull$$$0(2);
            }
            return reparsedSuccessfullyException;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diffLog";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/text/BlockSupport$ReparsedSuccessfullyException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiffLog";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fillInStackTrace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

