/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.kotlin.dsl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.model.kotlin.dsl.EditorPosition;
import org.gradle.tooling.model.kotlin.dsl.EditorReport;
import org.gradle.tooling.model.kotlin.dsl.KotlinDslScriptModel;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.kotlin.dsl.InternalEditorPosition;
import org.jetbrains.plugins.gradle.tooling.serialization.internal.adapter.kotlin.dsl.InternalEditorReport;

public class InternalKotlinDslScriptModel
implements KotlinDslScriptModel,
Serializable {
    private final List<File> myClassPath;
    private final List<File> mySourcePath;
    private final List<String> myImplicitImports;
    private final List<EditorReport> myEditorReports;
    private final List<String> myExceptions;

    public InternalKotlinDslScriptModel(KotlinDslScriptModel dslScriptModel) {
        this(dslScriptModel.getClassPath(), dslScriptModel.getSourcePath(), dslScriptModel.getImplicitImports(), dslScriptModel.getEditorReports(), dslScriptModel.getExceptions());
    }

    public InternalKotlinDslScriptModel(List<File> classPath, List<File> sourcePath, List<String> implicitImports, List<EditorReport> editorReports, List<String> exceptions) {
        this.myClassPath = new ArrayList<File>(classPath);
        this.mySourcePath = new ArrayList<File>(sourcePath);
        this.myImplicitImports = new ArrayList<String>(implicitImports);
        this.myEditorReports = new ArrayList<EditorReport>(editorReports.size());
        for (EditorReport report : editorReports) {
            EditorPosition position = report.getPosition();
            InternalEditorPosition internalEditorPosition = position == null ? null : new InternalEditorPosition(position.getLine(), position.getColumn());
            this.myEditorReports.add(new InternalEditorReport(report.getSeverity(), report.getMessage(), internalEditorPosition));
        }
        this.myExceptions = new ArrayList<String>(exceptions);
    }

    public List<File> getClassPath() {
        return this.myClassPath;
    }

    public List<File> getSourcePath() {
        return this.mySourcePath;
    }

    public List<String> getImplicitImports() {
        return this.myImplicitImports;
    }

    public List<EditorReport> getEditorReports() {
        return this.myEditorReports;
    }

    public List<String> getExceptions() {
        return this.myExceptions;
    }
}

