/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.SelectWordUtil;
import com.intellij.codeInsight.editorActions.wordSelection.AbstractBasicBackBasicSelectioner;
import com.intellij.lang.ASTNode;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.StringLiteralLexer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.BasicLiteralUtil;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LiteralSelectioner
extends AbstractBasicBackBasicSelectioner {
    @Override
    public boolean canSelect(@NotNull PsiElement e) {
        IElementType type;
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(0);
        }
        return BasicElementTypes.BASIC_STRING_LITERALS.contains(type = e.getNode().getElementType()) || BasicElementTypes.BASIC_STRING_TEMPLATE_FRAGMENTS.contains(type);
    }

    public List<TextRange> select(@NotNull PsiElement e, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        List result;
        if (e == null) {
            LiteralSelectioner.$$$reportNull$$$0(1);
        }
        if (editorText == null) {
            LiteralSelectioner.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            LiteralSelectioner.$$$reportNull$$$0(3);
        }
        if ((result = super.select(e, editorText, cursorOffset, editor)) == null) {
            return null;
        }
        ASTNode node = e.getNode();
        StringLiteralLexer lexer = new StringLiteralLexer('\uffff', node.getElementType(), true, "s{");
        SelectWordUtil.addWordHonoringEscapeSequences((CharSequence)editorText, (TextRange)node.getTextRange(), (int)cursorOffset, (Lexer)lexer, (List)result);
        result.add(LiteralSelectioner.getContentRange(node, editorText));
        return result;
    }

    private static TextRange getContentRange(ASTNode node, @NotNull CharSequence text) {
        if (text == null) {
            LiteralSelectioner.$$$reportNull$$$0(4);
        }
        IElementType tokenType = node.getElementType();
        TextRange range = node.getTextRange();
        if (tokenType == JavaTokenType.STRING_TEMPLATE_BEGIN || tokenType == JavaTokenType.STRING_TEMPLATE_MID || tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_MID) {
            return new TextRange(range.getStartOffset() + 1, range.getEndOffset() - 2);
        }
        if (tokenType == JavaTokenType.STRING_TEMPLATE_END || tokenType == JavaTokenType.STRING_LITERAL) {
            int end = text.charAt(range.getEndOffset() - 1) == '\"' ? range.getEndOffset() - 1 : range.getEndOffset();
            return new TextRange(range.getStartOffset() + 1, end);
        }
        if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN || tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END || tokenType == JavaTokenType.TEXT_BLOCK_LITERAL) {
            int end;
            int start;
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_END) {
                start = range.getStartOffset() + 1;
            } else {
                start = range.getStartOffset() + 3;
                while (BasicLiteralUtil.isTextBlockWhiteSpace(text.charAt(start))) {
                    ++start;
                }
                if (text.charAt(start) == '\n') {
                    ++start;
                }
            }
            if (tokenType == JavaTokenType.TEXT_BLOCK_TEMPLATE_BEGIN) {
                end = range.getEndOffset() - 2;
            } else {
                end -= StringUtil.endsWith((CharSequence)text, (int)start, (int)(end = range.getEndOffset()), (CharSequence)"\"\"\"") ? 4 : 1;
                while (end >= start) {
                    char c = text.charAt(end);
                    if (c == '\n' || !Character.isWhitespace(c)) {
                        ++end;
                        break;
                    }
                    --end;
                }
            }
            return new TextRange(start, end);
        }
        throw new IllegalArgumentException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/wordSelection/LiteralSelectioner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canSelect";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getContentRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

