/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MissingIfBranchesFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        if (astNode == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(0);
        }
        if (!BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return;
        }
        Document doc = editor.getDocument();
        ASTNode elseElement = BasicJavaAstTreeUtil.getElseElement(astNode);
        if (elseElement != null) {
            MissingIfBranchesFixer.handleBranch(doc, astNode, elseElement, BasicJavaAstTreeUtil.getElseBranch(astNode));
        }
        ASTNode rParenth = BasicJavaAstTreeUtil.getRParenth(astNode);
        assert (rParenth != null);
        MissingIfBranchesFixer.handleBranch(doc, astNode, rParenth, BasicJavaAstTreeUtil.getThenBranch(astNode));
    }

    private static void handleBranch(@NotNull Document doc, @NotNull ASTNode ifStatement, @NotNull ASTNode beforeBranch, @Nullable ASTNode branch) {
        boolean transformingOneLiner;
        if (doc == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(1);
        }
        if (ifStatement == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(2);
        }
        if (beforeBranch == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(3);
        }
        if (BasicJavaAstTreeUtil.is(branch, BasicJavaElementType.BASIC_BLOCK_STATEMENT) || "else".equals(beforeBranch.getText()) && BasicJavaAstTreeUtil.is(branch, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            return;
        }
        boolean bl = transformingOneLiner = branch != null && (MissingIfBranchesFixer.startLine(doc, beforeBranch) == MissingIfBranchesFixer.startLine(doc, branch) || MissingIfBranchesFixer.startCol(doc, ifStatement) < MissingIfBranchesFixer.startCol(doc, branch));
        if (!transformingOneLiner) {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            doc.insertString(beforeBranch.getTextRange().getEndOffset(), (CharSequence)"{");
            doc.insertString(branch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, @NotNull ASTNode astNode) {
        if (astNode == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(4);
        }
        return doc.getLineNumber(astNode.getTextRange().getStartOffset());
    }

    private static int startCol(Document doc, @NotNull ASTNode astNode) {
        if (astNode == null) {
            MissingIfBranchesFixer.$$$reportNull$$$0(5);
        }
        int offset = astNode.getTextRange().getStartOffset();
        return offset - doc.getLineStartOffset(doc.getLineNumber(offset));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "astNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ifStatement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeBranch";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/editorActions/smartEnter/MissingIfBranchesFixer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "handleBranch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "startLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "startCol";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

