/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.AbstractBasicJavaSmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.BasicElementTypes;
import com.intellij.psi.impl.source.BasicJavaAstTreeUtil;
import com.intellij.psi.impl.source.BasicJavaDocElementType;
import com.intellij.psi.impl.source.BasicJavaElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class IfConditionFixer
implements Fixer {
    @Override
    public void apply(Editor editor, AbstractBasicJavaSmartEnterProcessor processor, @NotNull ASTNode astNode) throws IncorrectOperationException {
        PsiElement prevLeaf;
        PsiElement psi;
        if (astNode == null) {
            IfConditionFixer.$$$reportNull$$$0(0);
        }
        if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.BASIC_IF_STATEMENT)) {
            Document doc = editor.getDocument();
            ASTNode rParen = BasicJavaAstTreeUtil.getRParenth(astNode);
            ASTNode lParen = BasicJavaAstTreeUtil.getLParenth(astNode);
            ASTNode condition = BasicJavaAstTreeUtil.getIfCondition(astNode);
            if (condition == null) {
                if (lParen == null || rParen == null) {
                    int stopOffset = doc.getLineEndOffset(doc.getLineNumber(astNode.getTextRange().getStartOffset()));
                    ASTNode then = BasicJavaAstTreeUtil.getThenBranch(astNode);
                    if (then != null) {
                        stopOffset = Math.min(stopOffset, then.getTextRange().getStartOffset());
                    }
                    stopOffset = Math.min(stopOffset, astNode.getTextRange().getEndOffset());
                    ASTNode lastChild = astNode.getLastChildNode();
                    String innerComment = "";
                    String lastComment = "";
                    if (lParen != null && PsiUtilCore.getElementType((ASTNode)lastChild) == JavaTokenType.C_STYLE_COMMENT) {
                        innerComment = lastChild.getText();
                    } else if (BasicJavaAstTreeUtil.is(lastChild, BasicJavaDocElementType.BASIC_DOC_COMMENT) || BasicJavaAstTreeUtil.is(lastChild, BasicElementTypes.BASIC_JAVA_PLAIN_COMMENT_BIT_SET)) {
                        lastComment = lastChild.getText();
                    }
                    String prefix = "if (" + innerComment;
                    doc.replaceString(astNode.getTextRange().getStartOffset(), stopOffset, (CharSequence)(prefix + ")" + lastComment));
                    processor.registerUnresolvedError(astNode.getTextRange().getStartOffset() + prefix.length());
                } else {
                    processor.registerUnresolvedError(lParen.getTextRange().getEndOffset());
                }
            } else if (rParen == null) {
                doc.insertString(condition.getTextRange().getEndOffset(), (CharSequence)")");
            }
        } else if (BasicJavaAstTreeUtil.is(astNode, BasicJavaElementType.EXPRESSION_SET) && BasicJavaAstTreeUtil.is(astNode.getTreeParent(), BasicJavaElementType.BASIC_EXPRESSION_STATEMENT) && (psi = BasicJavaAstTreeUtil.toPsi(astNode)) != null && (prevLeaf = PsiTreeUtil.prevVisibleLeaf((PsiElement)psi)) != null && prevLeaf.textMatches((CharSequence)"if")) {
            Document doc = editor.getDocument();
            doc.insertString(astNode.getTextRange().getEndOffset(), (CharSequence)")");
            doc.insertString(astNode.getTextRange().getStartOffset(), (CharSequence)"(");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/codeInsight/editorActions/smartEnter/IfConditionFixer", "apply"));
    }
}

