/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.html;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.intellij.plugins.markdown.extensions.CodeFenceGeneratingProvider;
import org.intellij.plugins.markdown.extensions.MarkdownCodeFenceCacheableProvider;
import org.intellij.plugins.markdown.lang.MarkdownFileType;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownCodeFencePluginCacheCollector;
import org.intellij.plugins.markdown.ui.preview.html.MarkdownUtil;
import org.jetbrains.annotations.NotNull;

public final class MarkdownCodeFenceHtmlCache
implements Disposable {
    @NotNull
    public static final String MARKDOWN_FILE_PATH_KEY = "markdown-md5-file-path";
    @NotNull
    private final Alarm myAlarm = new Alarm((Disposable)this);
    @NotNull
    private final Collection<MarkdownCodeFencePluginCacheCollector> myCodeFencePluginCaches = ConcurrentCollectionFactory.createConcurrentSet();
    @NotNull
    private final Collection<File> myAdditionalCacheToDelete = ConcurrentCollectionFactory.createConcurrentSet();

    public static MarkdownCodeFenceHtmlCache getInstance() {
        return (MarkdownCodeFenceHtmlCache)ApplicationManager.getApplication().getService(MarkdownCodeFenceHtmlCache.class);
    }

    public MarkdownCodeFenceHtmlCache() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.scheduleClearCache();
        }
        BulkFileListener listener = new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileTypeRegistry fileTypeRegistry = FileTypeRegistry.getInstance();
                for (VFileEvent vFileEvent : events) {
                    VFileDeleteEvent fileDeleteEvent;
                    VirtualFile file;
                    if (!(vFileEvent instanceof VFileDeleteEvent) || !fileTypeRegistry.isFileOfType(file = (fileDeleteEvent = (VFileDeleteEvent)vFileEvent).getFile(), (FileType)MarkdownFileType.INSTANCE)) continue;
                    MarkdownCodeFenceHtmlCache.this.myAdditionalCacheToDelete.addAll(MarkdownCodeFenceHtmlCache.processSourceFileToDelete(file, ContainerUtil.emptyList()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "org/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFenceHtmlCache$1", "after"));
            }
        };
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)listener);
    }

    private static List<File> getPluginSystemPaths() {
        return CodeFenceGeneratingProvider.collectProviders().stream().filter(MarkdownCodeFenceCacheableProvider.class::isInstance).map(MarkdownCodeFenceCacheableProvider.class::cast).map(provider -> provider.getCacheRootPath().toFile()).collect(Collectors.toList());
    }

    public Collection<File> collectFilesToRemove() {
        return this.myCodeFencePluginCaches.stream().flatMap(cacheProvider -> MarkdownCodeFenceHtmlCache.processSourceFileToDelete(cacheProvider.getFile(), cacheProvider.getAliveCachedFiles()).stream()).collect(Collectors.toList());
    }

    private static Collection<File> processSourceFileToDelete(@NotNull VirtualFile sourceFile, @NotNull Collection<File> aliveCachedFiles2) {
        if (sourceFile == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(0);
        }
        if (aliveCachedFiles2 == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(1);
        }
        HashSet<File> filesToDelete = new HashSet<File>();
        for (File codeFencePluginSystemPath : MarkdownCodeFenceHtmlCache.getPluginSystemPaths()) {
            for (File sourceFileCacheDirectory : MarkdownCodeFenceHtmlCache.getChildren(codeFencePluginSystemPath)) {
                if (MarkdownCodeFenceHtmlCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) && aliveCachedFiles2.isEmpty()) {
                    filesToDelete.add(sourceFileCacheDirectory);
                    continue;
                }
                for (File file : MarkdownCodeFenceHtmlCache.getChildren(sourceFileCacheDirectory)) {
                    if (!MarkdownCodeFenceHtmlCache.isCachedSourceFile(sourceFileCacheDirectory, sourceFile) || aliveCachedFiles2.contains(file)) continue;
                    filesToDelete.add(file);
                }
            }
        }
        return filesToDelete;
    }

    private static File @NotNull [] getChildren(@NotNull File directory) {
        File[] files;
        if (directory == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(2);
        }
        File[] fileArray = (files = directory.listFiles()) != null ? files : ArrayUtilRt.EMPTY_FILE_ARRAY;
        if (fileArray == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(3);
        }
        return fileArray;
    }

    private static boolean isCachedSourceFile(@NotNull File sourceFileDir, @NotNull VirtualFile sourceFile) {
        if (sourceFileDir == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(4);
        }
        if (sourceFile == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(5);
        }
        return sourceFileDir.getName().equals(MarkdownUtil.INSTANCE.md5(sourceFile.getPath(), MARKDOWN_FILE_PATH_KEY));
    }

    public void registerCacheProvider(@NotNull MarkdownCodeFencePluginCacheCollector cacheCollector) {
        if (cacheCollector == null) {
            MarkdownCodeFenceHtmlCache.$$$reportNull$$$0(6);
        }
        this.myCodeFencePluginCaches.add(cacheCollector);
    }

    private void scheduleClearCache() {
        this.myAlarm.addRequest(() -> {
            this.clearCache();
            this.scheduleClearCache();
        }, Registry.intValue((String)"markdown.clear.cache.interval"));
    }

    public synchronized void clearCache() {
        Set filesToDelete = ContainerUtil.union(this.myAdditionalCacheToDelete, this.collectFilesToRemove());
        for (File file : filesToDelete) {
            FileUtil.delete((File)file);
        }
        this.myAdditionalCacheToDelete.clear();
        this.myCodeFencePluginCaches.clear();
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myAlarm);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aliveCachedFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFenceHtmlCache";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFileDir";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/markdown/ui/preview/html/MarkdownCodeFenceHtmlCache";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSourceFileToDelete";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCachedSourceFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "registerCacheProvider";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

