/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.actions.styling;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.util.DocumentUtil;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypeSets;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElementFactory;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.ui.actions.MarkdownActionUtil;
import org.intellij.plugins.markdown.ui.actions.styling.SelectionUtil;
import org.intellij.plugins.markdown.util.MarkdownPsiUtil;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b'\u0018\u0000 \"2\u00020\u0001:\u0005\"#$%&BX\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0011\u0010\u0004\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\u0015\b\u0002\u0010\b\u001a\u000f\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0018\u00010\u0005\u0012\u0013\b\u0002\u0010\t\u001a\r\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u00070\u0005\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\u0018\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\b\u001a\u000f\u0012\t\u0012\u00070\u0006\u00a2\u0006\u0002\b\u0007\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "level", "", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "secondaryText", "description", "icon", "Ljavax/swing/Icon;", "(ILjava/util/function/Supplier;Ljava/util/function/Supplier;Ljava/util/function/Supplier;Ljavax/swing/Icon;)V", "getLevel", "()I", "getSecondaryText", "()Ljava/util/function/Supplier;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "handleExistingHeader", "", "header", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "editor", "Lcom/intellij/openapi/editor/Editor;", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "state", "tryToCreateHeaderFromRawLine", "caret", "Lcom/intellij/openapi/editor/Caret;", "Companion", "Heading", "Normal", "Subtitle", "Title", "intellij.markdown"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSetHeaderLevelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SetHeaderLevelImpl.kt\norg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,177:1\n67#2:178\n*S KotlinDebug\n*F\n+ 1 SetHeaderLevelImpl.kt\norg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl\n*L\n66#1:178\n*E\n"})
public abstract class SetHeaderLevelImpl
extends ToggleAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int level;
    @Nullable
    private final Supplier<String> secondaryText;
    @NotNull
    private static final TokenSet inlineElements;

    public SetHeaderLevelImpl(int level, @NotNull Supplier<String> text2, @Nullable Supplier<String> secondaryText, @NotNull Supplier<String> description, @Nullable Icon icon) {
        Intrinsics.checkNotNullParameter(text2, (String)"text");
        Intrinsics.checkNotNullParameter(description, (String)"description");
        super(text2, description, icon);
        this.level = level;
        this.secondaryText = secondaryText;
    }

    public /* synthetic */ SetHeaderLevelImpl(int n, Supplier supplier, Supplier supplier2, Supplier supplier3, Icon icon, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            supplier2 = null;
        }
        if ((n2 & 8) != 0) {
            supplier3 = supplier;
        }
        if ((n2 & 0x10) != 0) {
            icon = null;
        }
        this(n, supplier, supplier2, supplier3, icon);
    }

    public final int getLevel() {
        return this.level;
    }

    @Nullable
    public final Supplier<String> getSecondaryText() {
        return this.secondaryText;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isSelected(@NotNull AnActionEvent event) {
        boolean bl;
        MarkdownHeader markdownHeader;
        PsiElement element2;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return false;
        }
        PsiFile file = psiFile;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return false;
        }
        Editor editor3 = editor2;
        SelectionUtil.CaretSnapshot caretSnapshot = SelectionUtil.obtainPrimaryCaretSnapshot((AnAction)this, event);
        if (caretSnapshot == null) {
            return false;
        }
        SelectionUtil.CaretSnapshot caret = caretSnapshot;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        PsiElement psiElement = element2 = Companion.findParent$intellij_markdown(file, document, caret.getSelectionStart(), caret.getSelectionEnd());
        if (psiElement != null) {
            void $this$parentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean withSelf$iv = true;
            boolean $i$f$parentOfType = false;
            markdownHeader = (MarkdownHeader)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType$iv, MarkdownHeader.class, (boolean)false);
        } else {
            markdownHeader = null;
        }
        MarkdownHeader header = markdownHeader;
        if (header == null && this.level == 0) {
            bl = true;
        } else {
            MarkdownHeader markdownHeader2 = header;
            bl = markdownHeader2 != null ? markdownHeader2.getLevel() == this.level : false;
        }
        return bl;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!state) {
            return;
        }
        PsiFile psiFile = (PsiFile)event.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Editor editor2 = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return;
        }
        Editor editor3 = editor2;
        Caret caret = (Caret)event.getData(CommonDataKeys.CARET);
        if (caret == null) {
            return;
        }
        Caret caret2 = caret;
        Document document = editor3.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        PsiElement element2 = Companion.findParent$intellij_markdown(file, document, caret2.getSelectionStart(), caret2.getSelectionEnd());
        if (element2 == null) {
            this.tryToCreateHeaderFromRawLine(editor3, caret2);
            return;
        }
        MarkdownHeader header = (MarkdownHeader)PsiTreeUtil.getParentOfType((PsiElement)element2, MarkdownHeader.class, (boolean)false);
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(project2, header, this, editor3, element2){
            final /* synthetic */ Project $project;
            final /* synthetic */ MarkdownHeader $header;
            final /* synthetic */ SetHeaderLevelImpl this$0;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ PsiElement $element;
            {
                this.$project = $project;
                this.$header = $header;
                this.this$0 = $receiver;
                this.$editor = $editor;
                this.$element = $element;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void project$iv;
                Project project = this.$project;
                MarkdownHeader markdownHeader = this.$header;
                SetHeaderLevelImpl setHeaderLevelImpl = this.this$0;
                Editor editor2 = this.$editor;
                PsiElement psiElement = this.$element;
                Project project2 = this.$project;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(markdownHeader, setHeaderLevelImpl, editor2, psiElement, project2){
                    final /* synthetic */ MarkdownHeader $header$inlined;
                    final /* synthetic */ SetHeaderLevelImpl this$0;
                    final /* synthetic */ Editor $editor$inlined;
                    final /* synthetic */ PsiElement $element$inlined;
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$header$inlined = markdownHeader;
                        this.this$0 = setHeaderLevelImpl;
                        this.$editor$inlined = editor2;
                        this.$element$inlined = psiElement;
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        if (this.$header$inlined != null) {
                            SetHeaderLevelImpl.access$handleExistingHeader(this.this$0, this.$header$inlined, this.$editor$inlined);
                        } else if (this.this$0.getLevel() != 0) {
                            this.$element$inlined.replace((PsiElement)MarkdownPsiElementFactory.createHeader(this.$project$inlined, this.this$0.getLevel(), this.$element$inlined.getText()));
                        }
                    }
                }, name$iv, groupId$iv);
            }
        }));
    }

    private final void tryToCreateHeaderFromRawLine(Editor editor2, Caret caret) {
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        int line = document2.getLineNumber(selectionStart);
        if (line != document2.getLineNumber(selectionEnd)) {
            return;
        }
        int lineStartOffset = document2.getLineStartOffset(line);
        ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(editor2, line, document2, lineStartOffset, this){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ int $line;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $lineStartOffset;
            final /* synthetic */ SetHeaderLevelImpl this$0;
            {
                this.$editor = $editor;
                this.$line = $line;
                this.$document = $document;
                this.$lineStartOffset = $lineStartOffset;
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void project$iv;
                Project project = this.$editor.getProject();
                int n = this.$line;
                Document document = this.$document;
                int n2 = this.$lineStartOffset;
                SetHeaderLevelImpl setHeaderLevelImpl = this.this$0;
                String name$iv = null;
                Object groupId$iv = null;
                boolean $i$f$executeCommand = false;
                CommandProcessor.getInstance().executeCommand((Project)project$iv, new Runnable(n, document, n2, setHeaderLevelImpl){
                    final /* synthetic */ int $line$inlined;
                    final /* synthetic */ Document $document$inlined;
                    final /* synthetic */ int $lineStartOffset$inlined;
                    final /* synthetic */ SetHeaderLevelImpl this$0;
                    {
                        this.$line$inlined = n;
                        this.$document$inlined = document;
                        this.$lineStartOffset$inlined = n2;
                        this.this$0 = setHeaderLevelImpl;
                    }

                    public final void run() {
                        boolean bl = false;
                        int nextLine = this.$line$inlined + 1;
                        if (nextLine < this.$document$inlined.getLineCount() && !DocumentUtil.isLineEmpty((Document)this.$document$inlined, (int)nextLine)) {
                            int lineEndOffset = this.$document$inlined.getLineEndOffset(this.$line$inlined);
                            this.$document$inlined.insertString(lineEndOffset, (CharSequence)"\n");
                        }
                        this.$document$inlined.insertString(this.$lineStartOffset$inlined, (CharSequence)(StringsKt.repeat((CharSequence)"#", (int)this.this$0.getLevel()) + " "));
                        int previousLine = this.$line$inlined - 1;
                        if (previousLine >= 0 && !DocumentUtil.isLineEmpty((Document)this.$document$inlined, (int)previousLine)) {
                            this.$document$inlined.insertString(this.$lineStartOffset$inlined, (CharSequence)"\n");
                        }
                    }
                }, name$iv, groupId$iv);
            }
        }));
    }

    private final void handleExistingHeader(MarkdownHeader header, Editor editor2) {
        if (this.level == 0) {
            String string = header.getName();
            if (string == null) {
                return;
            }
            editor2.getDocument().replaceString(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)header)), PsiTreeUtilKt.getEndOffset((PsiElement)((PsiElement)header)), (CharSequence)string);
        } else if (header.getLevel() != this.level) {
            String string = header.getName();
            if (string == null) {
                return;
            }
            header.replace((PsiElement)MarkdownPsiElementFactory.createHeader(header.getProject(), string, this.level));
        }
    }

    @JvmStatic
    @Nullable
    public static final PsiElement findParent$intellij_markdown(@NotNull PsiFile file, @NotNull Document document, int selectionStart, int selectionEnd) {
        return Companion.findParent$intellij_markdown(file, document, selectionStart, selectionEnd);
    }

    public static final /* synthetic */ void access$handleExistingHeader(SetHeaderLevelImpl $this, MarkdownHeader header, Editor editor2) {
        $this.handleExistingHeader(header, editor2);
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[]{MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_TYPES, MarkdownTokenTypeSets.INLINE_HOLDING_ELEMENT_PARENTS_TYPES};
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        inlineElements = tokenSet;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u000fJ \u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Companion;", "", "()V", "inlineElements", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "findParent", "Lcom/intellij/psi/PsiElement;", "file", "Lcom/intellij/psi/PsiFile;", "document", "Lcom/intellij/openapi/editor/Document;", "selectionStart", "", "selectionEnd", "findParent$intellij_markdown", "isSameLine", "", "firstOffset", "secondOffset", "intellij.markdown"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final PsiElement findParent$intellij_markdown(@NotNull PsiFile file, @NotNull Document document, int selectionStart, int selectionEnd) {
            boolean bl;
            PsiElement parent;
            PsiElement endElement;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Pair<PsiElement, PsiElement> pair = MarkdownActionUtil.getElementsUnderCaretOrSelection(file, selectionStart, selectionEnd);
            PsiElement left = (PsiElement)pair.component1();
            PsiElement right = (PsiElement)pair.component2();
            PsiElement startElement = MarkdownPsiUtil.WhiteSpaces.isNewLine(left) ? PsiTreeUtil.nextVisibleLeaf((PsiElement)left) : left;
            PsiElement psiElement = endElement = MarkdownPsiUtil.WhiteSpaces.isNewLine(right) ? PsiTreeUtil.prevVisibleLeaf((PsiElement)right) : right;
            if (startElement == null || endElement == null || startElement.getTextOffset() > endElement.getTextOffset()) {
                return null;
            }
            PsiElement psiElement2 = parent = MarkdownActionUtil.getCommonParentOfTypes(startElement, endElement, inlineElements);
            if (psiElement2 != null) {
                IElementType iElementType = MarkdownElementTypes.PARAGRAPH;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"PARAGRAPH");
                bl = PsiUtilsKt.hasType(psiElement2, iElementType);
            } else {
                bl = false;
            }
            if (!bl) {
                return parent;
            }
            int startOffset = parent.getTextRange().getStartOffset();
            int endOffset = parent.getTextRange().getEndOffset();
            if (startOffset < 0 || endOffset > document.getTextLength()) {
                return null;
            }
            return this.isSameLine(document, startOffset, endOffset) ? parent : null;
        }

        private final boolean isSameLine(Document document, int firstOffset, int secondOffset) {
            return document.getLineNumber(firstOffset) == document.getLineNumber(secondOffset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Heading;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "level", "", "(I)V", "intellij.markdown"})
    public static final class Heading
    extends SetHeaderLevelImpl {
        public Heading(int level) {
            Object[] objectArray = new Object[]{level - 2};
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.text", objectArray);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Object[] objectArray2 = new Object[]{level};
            super(level, supplier, MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", objectArray2), null, null, 24, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Normal;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown"})
    public static final class Normal
    extends SetHeaderLevelImpl {
        public Normal() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.header.level.popup.normal.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            super(0, supplier, null, null, null, 28, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Subtitle;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown"})
    public static final class Subtitle
    extends SetHeaderLevelImpl {
        public Subtitle() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.header.level.popup.subtitle.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Object[] objectArray = new Object[]{2};
            super(2, supplier, MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", objectArray), null, null, 24, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl$Title;", "Lorg/intellij/plugins/markdown/ui/actions/styling/SetHeaderLevelImpl;", "()V", "intellij.markdown"})
    public static final class Title
    extends SetHeaderLevelImpl {
        public Title() {
            Supplier<String> supplier = MarkdownBundle.messagePointer("markdown.header.level.popup.title.action.text", new Object[0]);
            Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
            Object[] objectArray = new Object[]{1};
            super(1, supplier, MarkdownBundle.messagePointer("markdown.header.level.popup.heading.action.secondary.text", objectArray), null, null, 24, null);
        }
    }
}

