/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.externalSystem.action.ExternalSystemActionUtil;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public final class MavenUIUtil {
    public static void executeAction(String actionId, InputEvent e) {
        MavenUIUtil.executeAction(actionId, "", e);
    }

    public static void executeAction(String actionId, String place, InputEvent e) {
        ExternalSystemActionUtil.executeAction((String)actionId, (String)place, (InputEvent)e);
    }

    public static <E> void setElements(ElementsChooser<E> chooser, Collection<? extends E> all, Collection<? extends E> selected, Comparator<? super E> comparator2) {
        List selection = chooser.getSelectedElements();
        chooser.clear();
        TreeSet<? extends E> sorted = new TreeSet<E>(comparator2);
        sorted.addAll(all);
        for (Object e : sorted) {
            chooser.addElement(e, selected.contains(e));
        }
        chooser.selectElements((Collection)selection);
    }

    public static void installCheckboxRenderer(final SimpleTree tree, final CheckboxHandler handler) {
        final JCheckBox checkbox = new JCheckBox();
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)checkbox, "West");
        final TreeCellRenderer baseRenderer = tree.getCellRenderer();
        tree.setCellRenderer(new TreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Component baseComponent = baseRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                Object userObject = ((DefaultMutableTreeNode)value).getUserObject();
                if (!handler.isVisible(userObject)) {
                    return baseComponent;
                }
                Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
                Color background = UIUtil.getTreeBackground((boolean)selected, (boolean)hasFocus);
                panel.add(baseComponent, "Center");
                panel.setBackground(background);
                panel.setForeground(foreground);
                CheckBoxState state2 = handler.getState(userObject);
                checkbox.setSelected(state2 != CheckBoxState.UNCHECKED);
                checkbox.setEnabled(state2 != CheckBoxState.PARTIAL);
                checkbox.setBackground(background);
                checkbox.setForeground(foreground);
                return panel;
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int row = tree.getRowForLocation(e.getX(), e.getY());
                if (row >= 0) {
                    TreePath path2 = tree.getPathForRow(row);
                    if (!MavenUIUtil.isCheckboxEnabledFor(path2, handler)) {
                        return;
                    }
                    Rectangle checkBounds = checkbox.getBounds();
                    checkBounds.setLocation(tree.getRowBounds(row).getLocation());
                    if (checkBounds.contains(e.getPoint())) {
                        tree.setSelectionRow(row);
                        handler.toggle(path2, e);
                        e.consume();
                    }
                }
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TreePath[] treePaths;
                if (e.getKeyCode() == 32 && (treePaths = tree.getSelectionPaths()) != null) {
                    for (TreePath treePath : treePaths) {
                        if (!MavenUIUtil.isCheckboxEnabledFor(treePath, handler)) continue;
                        handler.toggle(treePath, e);
                    }
                    e.consume();
                }
            }
        });
    }

    private static boolean isCheckboxEnabledFor(TreePath path2, CheckboxHandler handler) {
        Object userObject = ((DefaultMutableTreeNode)path2.getLastPathComponent()).getUserObject();
        return handler.isVisible(userObject);
    }

    public static interface CheckboxHandler {
        public void toggle(TreePath var1, InputEvent var2);

        public boolean isVisible(Object var1);

        public CheckBoxState getState(Object var1);
    }

    public static enum CheckBoxState {
        CHECKED,
        UNCHECKED,
        PARTIAL;

    }
}

