/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.projectRoot;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public final class MavenModuleStructureExtension
extends ModuleStructureExtension {
    private final Set<Module> myModulesToRemove = new HashSet<Module>();
    private final List<String> myPomsToIgnore = new ArrayList<String>();
    private MavenProjectsManager myMavenProjectsManager = null;

    public void moduleRemoved(Module module2) {
        this.myModulesToRemove.add(module2);
        if (null == this.myMavenProjectsManager) {
            this.myMavenProjectsManager = MavenProjectsManager.getInstance(module2.getProject());
        }
    }

    public boolean isModified() {
        return !this.myModulesToRemove.isEmpty();
    }

    public void apply() throws ConfigurationException {
        this.myModulesToRemove.forEach(moduleToRemove -> {
            MavenProject mavenProject2 = this.myMavenProjectsManager.findProject((Module)moduleToRemove);
            if (null != mavenProject2) {
                this.myPomsToIgnore.add(mavenProject2.getPath());
            } else {
                String pomPath;
                String imlPath = moduleToRemove.getModuleFilePath();
                if (imlPath.endsWith(".iml") && Files.exists(Path.of(pomPath = imlPath.substring(0, imlPath.length() - ".iml".length()) + "/pom.xml", new String[0]), new LinkOption[0])) {
                    this.myPomsToIgnore.add(pomPath);
                }
            }
        });
        this.myModulesToRemove.clear();
    }

    public void disposeUIResources() {
        if (null != this.myMavenProjectsManager) {
            this.myMavenProjectsManager.setIgnoredStateForPoms(this.myPomsToIgnore, true);
        }
        this.myModulesToRemove.clear();
        this.myPomsToIgnore.clear();
        this.myMavenProjectsManager = null;
    }
}

