/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.build.issue.BuildIssue;
import com.intellij.openapi.project.Project;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.buildtool.MavenSyncConsole;
import org.jetbrains.idea.maven.execution.SyncBundle;
import org.jetbrains.idea.maven.externalSystemIntegration.output.importproject.quickfixes.RepositoryBlockedSyncIssue;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenProjectProblem;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerConsoleIndicator;

@ApiStatus.Internal
public final class MavenResolveResultProblemProcessor {
    public static final String BLOCKED_MIRROR_FOR_REPOSITORIES = "Blocked mirror for repositories:";

    public static void notifySyncForProblem(@NotNull Project project2, @NotNull MavenProjectProblem problem) {
        if (project2 == null) {
            MavenResolveResultProblemProcessor.$$$reportNull$$$0(0);
        }
        if (problem == null) {
            MavenResolveResultProblemProcessor.$$$reportNull$$$0(1);
        }
        MavenSyncConsole syncConsole = MavenProjectsManager.getInstance(project2).getSyncConsole();
        String message = problem.getDescription();
        if (message == null) {
            return;
        }
        if (message.contains(BLOCKED_MIRROR_FOR_REPOSITORIES)) {
            BuildIssue buildIssue2 = RepositoryBlockedSyncIssue.getIssue(project2, problem.getDescription());
            syncConsole.showBuildIssue(buildIssue2);
        } else if (problem.getMavenArtifact() == null) {
            MavenProjectsManager.getInstance(project2).getSyncConsole().addWarning(SyncBundle.message("maven.sync.annotation.processor.problem", new Object[0]), message);
        }
        if (problem.getMavenArtifact() != null) {
            syncConsole.showArtifactBuildIssue(MavenServerConsoleIndicator.ResolveType.DEPENDENCY, problem.getMavenArtifact().getMavenId().getKey(), message);
        }
    }

    public static void notifyMavenProblems(@NotNull Project project2) {
        if (project2 == null) {
            MavenResolveResultProblemProcessor.$$$reportNull$$$0(2);
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project2);
        MavenSyncConsole syncConsole = projectsManager.getSyncConsole();
        for (MavenProject mavenProject2 : projectsManager.getProjects()) {
            for (MavenProjectProblem problem : mavenProject2.getProblems()) {
                syncConsole.showProblem(problem);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenResolveResultProblemProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "notifySyncForProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyMavenProblems";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MavenResolveProblemHolder {
        @NotNull
        public final Set<MavenProjectProblem> repositoryBlockedProblems;
        @NotNull
        public final Set<MavenProjectProblem> unresolvedArtifactProblems;
        @NotNull
        public final Set<MavenArtifact> unresolvedArtifacts;

        public MavenResolveProblemHolder(@NotNull Set<MavenProjectProblem> repositoryBlockedProblems, @NotNull Set<MavenProjectProblem> unresolvedArtifactProblems, @NotNull Set<MavenArtifact> unresolvedArtifacts) {
            if (repositoryBlockedProblems == null) {
                MavenResolveProblemHolder.$$$reportNull$$$0(0);
            }
            if (unresolvedArtifactProblems == null) {
                MavenResolveProblemHolder.$$$reportNull$$$0(1);
            }
            if (unresolvedArtifacts == null) {
                MavenResolveProblemHolder.$$$reportNull$$$0(2);
            }
            this.repositoryBlockedProblems = repositoryBlockedProblems;
            this.unresolvedArtifactProblems = unresolvedArtifactProblems;
            this.unresolvedArtifacts = unresolvedArtifacts;
        }

        public boolean isEmpty() {
            return this.repositoryBlockedProblems.isEmpty() && this.unresolvedArtifactProblems.isEmpty() && this.unresolvedArtifacts.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repositoryBlockedProblems";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unresolvedArtifactProblems";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "unresolvedArtifacts";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/project/MavenResolveResultProblemProcessor$MavenResolveProblemHolder";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

