/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.LibraryRootTypeId;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenProjectImporterUtil;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportDataWithDependencies;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportData;
import org.jetbrains.idea.maven.importing.tree.SplittedMainAndTestModules;
import org.jetbrains.idea.maven.importing.tree.dependency.AttachedJarDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.BaseDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.LibraryDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.MavenImportDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.ModuleDependency;
import org.jetbrains.idea.maven.importing.tree.dependency.SystemDependency;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenLog;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012H\u0002J\"\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0005J\"\u0010\u001e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#H\u0002R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/idea/maven/importing/tree/MavenModuleImportDependencyProvider;", "", "moduleImportDataByMavenId", "", "Lorg/jetbrains/idea/maven/model/MavenId;", "Lorg/jetbrains/idea/maven/importing/tree/MavenProjectImportData;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "myProjectTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "(Ljava/util/Map;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;)V", "dependencyTypesFromSettings", "", "", "addMainDependencyToTestModule", "", "importData", "testDependencies", "", "Lorg/jetbrains/idea/maven/importing/tree/dependency/MavenImportDependency;", "createAttachArtifactDependency", "Lorg/jetbrains/idea/maven/importing/tree/dependency/AttachedJarDependency;", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "scope", "Lcom/intellij/openapi/roots/DependencyScope;", "artifact", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "getDependencies", "Lorg/jetbrains/idea/maven/importing/tree/MavenModuleImportDataWithDependencies;", "getDependency", "", "getModuleName", "data", "isTestJar", "", "intellij.maven"})
public final class MavenModuleImportDependencyProvider {
    @NotNull
    private final Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId;
    @NotNull
    private final MavenProjectsTree myProjectTree;
    @NotNull
    private final Set<String> dependencyTypesFromSettings;

    public MavenModuleImportDependencyProvider(@NotNull Map<MavenId, MavenProjectImportData> moduleImportDataByMavenId, @NotNull MavenImportingSettings importingSettings, @NotNull MavenProjectsTree myProjectTree) {
        Intrinsics.checkNotNullParameter(moduleImportDataByMavenId, (String)"moduleImportDataByMavenId");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter((Object)myProjectTree, (String)"myProjectTree");
        this.moduleImportDataByMavenId = moduleImportDataByMavenId;
        this.myProjectTree = myProjectTree;
        Set<String> set2 = importingSettings.getDependencyTypesAsSet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"getDependencyTypesAsSet(...)");
        this.dependencyTypesFromSettings = set2;
    }

    @NotNull
    public final MavenModuleImportDataWithDependencies getDependencies(@NotNull MavenProjectImportData importData) {
        Intrinsics.checkNotNullParameter((Object)importData, (String)"importData");
        MavenProject mavenProject2 = importData.getMavenProject();
        MavenLog.LOG.debug("Creating dependencies for " + mavenProject2 + ": " + mavenProject2.getDependencies().size());
        List mainDependencies = new ArrayList(mavenProject2.getDependencies().size());
        List testDependencies = new ArrayList(4);
        this.addMainDependencyToTestModule(importData, testDependencies);
        boolean hasSeparateTestModule = importData.getSplittedMainAndTestModules() != null;
        for (MavenArtifact artifact : mavenProject2.getDependencies()) {
            Intrinsics.checkNotNull((Object)artifact);
            for (MavenImportDependency<?> dependency : this.getDependency(artifact, mavenProject2)) {
                if (hasSeparateTestModule && dependency.getScope() == DependencyScope.TEST) {
                    testDependencies.add(dependency);
                    continue;
                }
                mainDependencies.add(dependency);
            }
        }
        return new MavenModuleImportDataWithDependencies(importData, mainDependencies, testDependencies);
    }

    private final List<MavenImportDependency<?>> getDependency(MavenArtifact artifact, MavenProject mavenProject2) {
        String dependencyType = artifact.getType();
        MavenLog.LOG.trace("Creating dependency from " + mavenProject2 + " to " + artifact + ", type " + dependencyType);
        if (!this.dependencyTypesFromSettings.contains(dependencyType) && !mavenProject2.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT).contains(dependencyType)) {
            MavenLog.LOG.trace("Dependency skipped");
            return CollectionsKt.emptyList();
        }
        DependencyScope scope = MavenProjectImporterUtil.selectScope(artifact.getScope());
        MavenProject depProject = this.myProjectTree.findProject(artifact.getMavenId());
        if (depProject != null) {
            MavenLog.LOG.trace("Dependency project " + depProject);
            if (depProject == mavenProject2) {
                MavenLog.LOG.trace("Project depends on itself");
                return CollectionsKt.emptyList();
            }
            MavenProjectImportData mavenProjectImportData = this.moduleImportDataByMavenId.get(depProject.getMavenId());
            boolean depProjectIgnored = this.myProjectTree.isIgnored(depProject);
            if (mavenProjectImportData == null || depProjectIgnored) {
                MavenLog.LOG.trace("Created base dependency, project ignored: " + depProjectIgnored + ", import data: " + mavenProjectImportData);
                return CollectionsKt.listOf((Object)new BaseDependency(MavenProjectImporterUtil.INSTANCE.createCopyForLocalRepo(artifact, mavenProject2), scope));
            }
            ArrayList<MavenImportDependency> result2 = new ArrayList<MavenImportDependency>();
            boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)dependencyType) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
            String moduleName = this.getModuleName(mavenProjectImportData, isTestJar);
            ContainerUtil.addIfNotNull((Collection)result2, (Object)this.createAttachArtifactDependency(depProject, scope, artifact));
            String classifier = artifact.getClassifier();
            if (classifier != null && MavenProjectImporterUtil.INSTANCE.getIMPORTED_CLASSIFIERS().contains(classifier) && !isTestJar && !Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) && !Intrinsics.areEqual((Object)"false", (Object)System.getProperty("idea.maven.classifier.dep"))) {
                MavenLog.LOG.trace("Created library dependency");
                result2.add(new LibraryDependency(MavenProjectImporterUtil.INSTANCE.createCopyForLocalRepo(artifact, mavenProject2), mavenProject2, scope));
            }
            MavenLog.LOG.trace("Created module dependency");
            result2.add(new ModuleDependency(moduleName, scope, isTestJar));
            return result2;
        }
        if (Intrinsics.areEqual((Object)"system", (Object)artifact.getScope())) {
            MavenLog.LOG.trace("Created system dependency");
            return CollectionsKt.listOf((Object)new SystemDependency(artifact, scope));
        }
        boolean isBundle = Intrinsics.areEqual((Object)"bundle", (Object)dependencyType);
        MavenArtifact finalArtifact = isBundle ? new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, mavenProject2.getLocalRepository(), false, false) : artifact;
        MavenLog.LOG.trace("Created base dependency, bundle: " + isBundle);
        return CollectionsKt.listOf((Object)new BaseDependency(finalArtifact, scope));
    }

    private final void addMainDependencyToTestModule(MavenProjectImportData importData, List<MavenImportDependency<?>> testDependencies) {
        if (importData.getSplittedMainAndTestModules() != null) {
            testDependencies.add(new ModuleDependency(importData.getSplittedMainAndTestModules().getMainData().getModuleName(), DependencyScope.COMPILE, false));
        }
    }

    private final String getModuleName(MavenProjectImportData data2, boolean isTestJar) {
        SplittedMainAndTestModules modules = data2.getSplittedMainAndTestModules();
        if (modules == null) {
            return data2.getModuleData().getModuleName();
        }
        return isTestJar ? modules.getTestData().getModuleName() : modules.getMainData().getModuleName();
    }

    private final AttachedJarDependency createAttachArtifactDependency(MavenProject mavenProject2, DependencyScope scope, MavenArtifact artifact) {
        Element buildHelperCfg = mavenProject2.getPluginGoalConfiguration("org.codehaus.mojo", "build-helper-maven-plugin", "attach-artifact");
        if (buildHelperCfg == null) {
            return null;
        }
        ArrayList<Pair> roots = new ArrayList<Pair>();
        boolean create2 = false;
        for (Element artifactsElement : buildHelperCfg.getChildren("artifacts")) {
            for (Element artifactElement : artifactsElement.getChildren("artifact")) {
                String filePath;
                String typeString = artifactElement.getChildTextTrim("type");
                if (typeString != null && !Intrinsics.areEqual((Object)typeString, (Object)"jar") || StringUtil.isEmpty((String)(filePath = artifactElement.getChildTextTrim("file")))) continue;
                String classifier = artifactElement.getChildTextTrim("classifier");
                String string = classifier;
                if (Intrinsics.areEqual((Object)string, (Object)"sources")) {
                    roots.add(new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getSOURCES()));
                } else if (Intrinsics.areEqual((Object)string, (Object)"javadoc")) {
                    roots.add(new Pair((Object)filePath, (Object)WorkspaceModuleImporter.Companion.getJAVADOC_TYPE()));
                } else {
                    roots.add(new Pair((Object)filePath, (Object)LibraryRootTypeId.Companion.getCOMPILED()));
                }
                create2 = true;
            }
        }
        return create2 ? new AttachedJarDependency(MavenProjectImporterUtil.INSTANCE.getAttachedJarsLibName(artifact), (List<Pair<String, LibraryRootTypeId>>)roots, scope) : null;
    }
}

