/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairConsumer;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class MavenImporter {
    public static final ExtensionPointName<MavenImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.importer");
    protected final String myPluginGroupID;
    protected final String myPluginArtifactID;

    public MavenImporter(@NonNls String pluginGroupID, @NonNls String pluginArtifactID) {
        this.myPluginGroupID = pluginGroupID;
        this.myPluginArtifactID = pluginArtifactID;
    }

    public static List<MavenImporter> getSuitableImporters(MavenProject p) {
        return MavenImporter.getSuitableImporters(p, false);
    }

    public static List<MavenImporter> getSuitableImporters(MavenProject p, boolean isWorkspaceImport) {
        ArrayList<MavenImporter> result2 = null;
        HashSet<ModuleType<? extends ModuleBuilder>> moduleTypes = null;
        for (MavenImporter importer2 : (MavenImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (isWorkspaceImport && importer2.isMigratedToConfigurator() || !importer2.isApplicable(p)) continue;
            if (result2 == null) {
                result2 = new ArrayList<MavenImporter>();
                moduleTypes = new HashSet<ModuleType<? extends ModuleBuilder>>();
            }
            result2.add(importer2);
            moduleTypes.add(importer2.getModuleType());
        }
        if (result2 == null) {
            return Collections.emptyList();
        }
        if (moduleTypes.size() <= 1) {
            return result2;
        }
        ModuleType<? extends ModuleBuilder> moduleType = ((MavenImporter)result2.get(0)).getModuleType();
        ArrayList supportedPackagingTypes = new ArrayList();
        for (MavenImporter importer2 : result2) {
            supportedPackagingTypes.clear();
            importer2.getSupportedPackagings(supportedPackagingTypes);
            if (!supportedPackagingTypes.contains(p.getPackaging())) continue;
            moduleType = importer2.getModuleType();
            break;
        }
        ModuleType<? extends ModuleBuilder> finalModuleType = moduleType;
        return ContainerUtil.filter(result2, importer -> importer.getModuleType() == finalModuleType);
    }

    public boolean isApplicable(MavenProject mavenProject2) {
        return mavenProject2.findPlugin(this.myPluginGroupID, this.myPluginArtifactID) != null;
    }

    @Deprecated
    @NotNull
    public ModuleType<? extends ModuleBuilder> getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            MavenImporter.$$$reportNull$$$0(0);
        }
        return moduleType;
    }

    public void getSupportedPackagings(Collection<? super String> result2) {
    }

    public void getSupportedDependencyTypes(Collection<? super String> result2, SupportedRequestType type2) {
    }

    @Deprecated(forRemoval=true)
    public void getSupportedDependencyScopes(Collection<? super String> result2) {
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Pair<String, String> getExtraArtifactClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type2) {
        return null;
    }

    @ApiStatus.Experimental
    @ApiStatus.Internal
    public boolean isMigratedToConfigurator() {
        return false;
    }

    @RequiresWriteLock
    public void preProcess(Module module2, MavenProject mavenProject2, MavenProjectChanges mavenProjectChanges, IdeModifiableModelsProvider ideModifiableModelsProvider) {
        ThreadingAssertions.assertWriteAccess();
    }

    @RequiresWriteLock
    public void process(@NotNull IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module2, @NotNull MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject2, @NotNull MavenProjectChanges changes, @NotNull Map<MavenProject, String> mavenProjectToModuleName, @Deprecated @NotNull List<MavenProjectsProcessorTask> postTasks) {
        if (modifiableModelsProvider == null) {
            MavenImporter.$$$reportNull$$$0(1);
        }
        if (module2 == null) {
            MavenImporter.$$$reportNull$$$0(2);
        }
        if (rootModel == null) {
            MavenImporter.$$$reportNull$$$0(3);
        }
        if (mavenModel == null) {
            MavenImporter.$$$reportNull$$$0(4);
        }
        if (mavenProject2 == null) {
            MavenImporter.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            MavenImporter.$$$reportNull$$$0(6);
        }
        if (mavenProjectToModuleName == null) {
            MavenImporter.$$$reportNull$$$0(7);
        }
        if (postTasks == null) {
            MavenImporter.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertWriteAccess();
    }

    @RequiresWriteLock
    public void postProcess(Module module2, MavenProject mavenProject2, MavenProjectChanges mavenProjectChanges, IdeModifiableModelsProvider ideModifiableModelsProvider) {
        ThreadingAssertions.assertWriteAccess();
    }

    public boolean processChangedModulesOnly() {
        return true;
    }

    public void collectSourceRoots(MavenProject mavenProject2, PairConsumer<String, JpsModuleSourceRootType<?>> result2) {
    }

    public void collectExcludedFolders(MavenProject mavenProject2, List<String> result2) {
    }

    @Nullable
    protected Element getConfig(MavenProject p) {
        return p.getPluginConfiguration(this.myPluginGroupID, this.myPluginArtifactID);
    }

    @Nullable
    protected Element getConfig(MavenProject p, @NonNls String path2) {
        return MavenJDOMUtil.findChildByPath(this.getConfig(p), path2);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, @NonNls String path2) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path2);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, @NonNls String path2, @NonNls String defaultValue) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path2, defaultValue);
    }

    @Nullable
    protected Element getGoalConfig(MavenProject p, @NonNls String goal) {
        return p.getPluginGoalConfiguration(this.myPluginGroupID, this.myPluginArtifactID, goal);
    }

    @Nullable
    protected String findGoalConfigValue(MavenProject p, @NonNls String goal, @NonNls String path2) {
        return MavenJDOMUtil.findChildValueByPath(this.getGoalConfig(p, goal), path2);
    }

    public void customizeUserProperties(@NotNull Project project2, @NotNull MavenProject mavenProject2, @NotNull Properties properties) {
        if (project2 == null) {
            MavenImporter.$$$reportNull$$$0(9);
        }
        if (mavenProject2 == null) {
            MavenImporter.$$$reportNull$$$0(10);
        }
        if (properties == null) {
            MavenImporter.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/MavenImporter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiableModelsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenModel";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectToModuleName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postTasks";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenImporter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "customizeUserProperties";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

