/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.refactorings.introduce;

import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.find.replaceInProject.ReplaceInProjectManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlToken;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.refactorings.introduce.IntroducePropertyDialog;
import org.jetbrains.idea.maven.statistics.MavenActionsUsagesCollector;

public class IntroducePropertyAction
extends BaseRefactoringAction {
    private static final String PREFIX = "${";
    private static final String SUFFIX = "}";

    public IntroducePropertyAction() {
        this.setInjectedContext(true);
    }

    protected boolean isAvailableInEditorOnly() {
        return true;
    }

    protected boolean isEnabledOnElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            IntroducePropertyAction.$$$reportNull$$$0(0);
        }
        return false;
    }

    protected RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            IntroducePropertyAction.$$$reportNull$$$0(1);
        }
        return new MyRefactoringActionHandler();
    }

    protected boolean isAvailableForFile(PsiFile file) {
        VirtualFile virtualFile = file.getVirtualFile();
        return MavenDomUtil.isMavenFile(file) && virtualFile != null && virtualFile.getFileSystem() != JarFileSystem.getInstance();
    }

    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file, @NotNull DataContext context2) {
        if (element == null) {
            IntroducePropertyAction.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            IntroducePropertyAction.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IntroducePropertyAction.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            IntroducePropertyAction.$$$reportNull$$$0(5);
        }
        if (!super.isAvailableOnElementInEditorAndFile(element, editor, file, context2)) {
            return false;
        }
        return IntroducePropertyAction.getSelectedElementAndTextRange(editor, file) != null;
    }

    @Nullable
    static Pair<XmlElement, TextRange> getSelectedElementAndTextRange(Editor editor, PsiFile file) {
        int startOffset = editor.getSelectionModel().getSelectionStart();
        int endOffset = editor.getSelectionModel().getSelectionEnd();
        PsiElement elementAtStart = file.findElementAt(startOffset);
        if (elementAtStart == null) {
            return null;
        }
        PsiElement elementAtEnd = file.findElementAt(endOffset == startOffset ? endOffset : endOffset - 1);
        if (elementAtEnd == null) {
            return null;
        }
        PsiElement elementAt = PsiTreeUtil.findCommonParent((PsiElement)elementAtStart, (PsiElement)elementAtEnd);
        if (elementAt instanceof XmlToken) {
            elementAt = elementAt.getParent();
        }
        if (elementAt instanceof XmlText || elementAt instanceof XmlAttributeValue) {
            TextRange range = editor.getSelectionModel().hasSelection() ? new TextRange(startOffset, endOffset) : elementAt.getTextRange();
            return Pair.create((Object)((XmlElement)elementAt), (Object)range);
        }
        return null;
    }

    private static List<TextRange> getPropertiesTextRanges(String s) {
        int endOffset;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        int startOffset = s.indexOf(PREFIX);
        while (startOffset >= 0 && (endOffset = s.indexOf(SUFFIX, startOffset)) > startOffset) {
            if (s.substring(startOffset + PREFIX.length(), endOffset).contains(PREFIX)) {
                startOffset = s.indexOf(PREFIX, startOffset + 1);
                continue;
            }
            ranges.add(new TextRange(startOffset, endOffset));
            startOffset = s.indexOf(PREFIX, endOffset);
        }
        return ranges;
    }

    private static boolean isIntersectWithRanges(@NotNull Collection<TextRange> ranges, int start, int end) {
        if (ranges == null) {
            IntroducePropertyAction.$$$reportNull$$$0(6);
        }
        for (TextRange range : ranges) {
            if (start <= range.getStartOffset() && end >= range.getEndOffset() || end <= range.getStartOffset() || start >= range.getEndOffset()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledOnElements";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getHandler";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnElementInEditorAndFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isIntersectWithRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyRefactoringActionHandler
    implements RefactoringActionHandler {
        private MyRefactoringActionHandler() {
        }

        public void invoke(@NotNull Project project2, Editor editor, PsiFile file, DataContext dataContext) {
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(0);
            }
            MavenActionsUsagesCollector.trigger(project2, MavenActionsUsagesCollector.INTRODUCE_PROPERTY);
            PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            Pair<XmlElement, TextRange> elementAndRange = IntroducePropertyAction.getSelectedElementAndTextRange(editor, file);
            if (elementAndRange == null) {
                return;
            }
            XmlElement selectedElement = (XmlElement)elementAndRange.first;
            TextRange range = (TextRange)elementAndRange.second;
            String stringValue = selectedElement.getText();
            if (stringValue == null) {
                return;
            }
            MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(file, MavenDomProjectModel.class);
            String selectedString = editor.getDocument().getText(range);
            List<TextRange> ranges = IntroducePropertyAction.getPropertiesTextRanges(stringValue);
            int offsetInElement = range.getStartOffset() - selectedElement.getTextOffset();
            if (model == null || StringUtil.isEmptyOrSpaces((String)selectedString) || IntroducePropertyAction.isIntersectWithRanges(ranges, offsetInElement, offsetInElement + selectedString.length())) {
                return;
            }
            editor.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            IntroducePropertyDialog dialog = new IntroducePropertyDialog(project2, selectedElement, model, selectedString);
            dialog.show();
            if (dialog.getExitCode() != 0) {
                return;
            }
            String propertyName = dialog.getEnteredName();
            MavenDomProjectModel selectedProject = dialog.getSelectedProject();
            if (ReadonlyStatusHandler.getInstance((Project)project2).ensureFilesWritable(MyRefactoringActionHandler.getFiles(file, selectedProject)).hasReadonlyFiles()) {
                return;
            }
            String replaceWith = IntroducePropertyAction.PREFIX + propertyName + IntroducePropertyAction.SUFFIX;
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                editor.getDocument().replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)replaceWith);
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                MyRefactoringActionHandler.createMavenProperty(selectedProject, propertyName, selectedString);
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
            });
            MyRefactoringActionHandler.showFindUsages(project2, propertyName, selectedString, replaceWith, selectedProject);
        }

        @NotNull
        private static List<VirtualFile> getFiles(PsiFile file, MavenDomProjectModel model) {
            VirtualFile vf;
            XmlElement xmlElement;
            HashSet<VirtualFile> virtualFiles = new HashSet<VirtualFile>();
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                virtualFiles.add(virtualFile);
            }
            if ((xmlElement = model.getXmlElement()) != null && (vf = xmlElement.getContainingFile().getVirtualFile()) != null) {
                virtualFiles.add(vf);
            }
            return new ArrayList<VirtualFile>(virtualFiles);
        }

        private static void createMavenProperty(@NotNull MavenDomProjectModel model, @NotNull String enteredName, @NotNull String selectedString) {
            if (model == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(1);
            }
            if (enteredName == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(2);
            }
            if (selectedString == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(3);
            }
            MavenDomProperties mavenDomProperties = model.getProperties();
            XmlTag xmlTag = mavenDomProperties.ensureTagExists();
            XmlTag propertyTag = xmlTag.createChildTag(enteredName, xmlTag.getNamespace(), selectedString, false);
            xmlTag.add((PsiElement)propertyTag);
        }

        private static void showFindUsages(@NotNull Project project2, @NotNull String propertyName, @NotNull String selectedString, @NotNull String replaceWith, @NotNull MavenDomProjectModel model) {
            UsageViewManager manager;
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(4);
            }
            if (propertyName == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(5);
            }
            if (selectedString == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(6);
            }
            if (replaceWith == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(7);
            }
            if (model == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(8);
            }
            if ((manager = UsageViewManager.getInstance((Project)project2)) == null) {
                return;
            }
            MyRefactoringActionHandler.assureFindToolWindowRegistered(project2);
            FindManager findManager = FindManager.getInstance((Project)project2);
            FindModel findModel = MyRefactoringActionHandler.createFindModel(findManager, selectedString, replaceWith);
            UsageViewPresentation presentation = FindInProjectUtil.setupViewPresentation((boolean)true, (FindModel)findModel);
            FindUsagesProcessPresentation processPresentation = FindInProjectUtil.setupProcessPresentation((boolean)true, (UsageViewPresentation)presentation);
            findManager.getFindInProjectModel().copyFrom(findModel);
            FindModel findModelCopy = findModel.clone();
            ReplaceInProjectManager.getInstance((Project)project2).searchAndShowUsages(manager, (Factory)new MyUsageSearcherFactory(model, propertyName, selectedString), findModelCopy, presentation, processPresentation);
        }

        private static void assureFindToolWindowRegistered(@NotNull Project project2) {
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(9);
            }
            UsageViewContentManager uvm = UsageViewContentManager.getInstance((Project)project2);
        }

        private static FindModel createFindModel(FindManager findManager, String selectedString, String replaceWith) {
            FindModel findModel = findManager.getFindInProjectModel().clone();
            findModel.setStringToFind(selectedString);
            findModel.setStringToReplace(replaceWith);
            findModel.setReplaceState(true);
            findModel.setPromptOnReplace(true);
            findModel.setCaseSensitive(true);
            findModel.setRegularExpressions(false);
            return findModel;
        }

        public void invoke(@NotNull Project project2, PsiElement @NotNull [] elements, DataContext dataContext) {
            if (project2 == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(10);
            }
            if (elements == null) {
                MyRefactoringActionHandler.$$$reportNull$$$0(11);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enteredName";
                    break;
                }
                case 3: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "selectedString";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "propertyName";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replaceWith";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elements";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "invoke";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createMavenProperty";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "showFindUsages";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "assureFindToolWindowRegistered";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class MyUsageSearcherFactory
        implements Factory<UsageSearcher> {
            private final MavenDomProjectModel myModel;
            private final String myPropertyName;
            private final String mySelectedString;

            MyUsageSearcherFactory(MavenDomProjectModel model, String propertyName, String selectedString) {
                this.myModel = model;
                this.myPropertyName = propertyName;
                this.mySelectedString = selectedString;
            }

            public UsageSearcher create() {
                return new UsageSearcher(){
                    final Set<UsageInfo> usages = new HashSet<UsageInfo>();

                    public void generate(@NotNull Processor<? super Usage> processor) {
                        if (processor == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().runReadAction(() -> {
                            this.collectUsages(myModel);
                            for (MavenDomProjectModel model : MavenDomProjectProcessorUtils.getChildrenProjects(myModel)) {
                                this.collectUsages(model);
                            }
                            for (UsageInfo usage : this.usages) {
                                processor.process(UsageInfo2UsageAdapter.CONVERTER.fun((Object)usage));
                            }
                        });
                    }

                    private void collectUsages(@NotNull MavenDomProjectModel model) {
                        XmlElement root;
                        if (model == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (model.isValid() && (root = model.getXmlElement()) != null) {
                            root.acceptChildren((PsiElementVisitor)new XmlElementVisitor(){

                                public void visitXmlText(@NotNull XmlText text2) {
                                    XmlTag xmlTag;
                                    if (text2 == null) {
                                        MyRefactoringActionHandler.MyUsageSearcherFactory.1.$$$reportNull$$$0(0);
                                    }
                                    if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)text2, XmlTag.class)) != null && !xmlTag.getName().equals(myPropertyName)) {
                                        usages.addAll(this.getUsages((XmlElement)text2));
                                    }
                                }

                                public void visitXmlAttributeValue(@NotNull XmlAttributeValue value) {
                                    XmlTag xmlTag;
                                    if (value == null) {
                                        MyRefactoringActionHandler.MyUsageSearcherFactory.1.$$$reportNull$$$0(1);
                                    }
                                    if ((xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)value, XmlTag.class)) != null && !xmlTag.equals(root)) {
                                        usages.addAll(this.getUsages((XmlElement)value));
                                    }
                                }

                                public void visitXmlElement(@NotNull XmlElement element) {
                                    if (element == null) {
                                        MyRefactoringActionHandler.MyUsageSearcherFactory.1.$$$reportNull$$$0(2);
                                    }
                                    element.acceptChildren((PsiElementVisitor)this);
                                }

                                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                    Object[] objectArray;
                                    Object[] objectArray2;
                                    Object[] objectArray3 = new Object[3];
                                    switch (n) {
                                        default: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "text";
                                            break;
                                        }
                                        case 1: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "value";
                                            break;
                                        }
                                        case 2: {
                                            objectArray2 = objectArray3;
                                            objectArray3[0] = "element";
                                            break;
                                        }
                                    }
                                    objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1$1";
                                    switch (n) {
                                        default: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitXmlText";
                                            break;
                                        }
                                        case 1: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitXmlAttributeValue";
                                            break;
                                        }
                                        case 2: {
                                            objectArray = objectArray2;
                                            objectArray2[2] = "visitXmlElement";
                                            break;
                                        }
                                    }
                                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                                }
                            });
                        }
                    }

                    @NotNull
                    private Set<UsageInfo> getUsages(@NotNull XmlElement xmlElement) {
                        int end;
                        String s;
                        if (xmlElement == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        if (StringUtil.isEmptyOrSpaces((String)(s = xmlElement.getText()))) {
                            Set<UsageInfo> set2 = Collections.emptySet();
                            if (set2 == null) {
                                1.$$$reportNull$$$0(3);
                            }
                            return set2;
                        }
                        int start = s.indexOf(mySelectedString);
                        if (start == -1) {
                            Set<UsageInfo> set3 = Collections.emptySet();
                            if (set3 == null) {
                                1.$$$reportNull$$$0(4);
                            }
                            return set3;
                        }
                        HashSet<UsageInfo> usages = new HashSet<UsageInfo>();
                        List<TextRange> ranges = IntroducePropertyAction.getPropertiesTextRanges(s);
                        TextRange elementTextRange = xmlElement.getTextRange();
                        PsiFile containingFile = xmlElement.getContainingFile();
                        do {
                            boolean isInsideProperty;
                            if (isInsideProperty = IntroducePropertyAction.isIntersectWithRanges(ranges, start, end = start + mySelectedString.length())) continue;
                            usages.add(new UsageInfo((PsiElement)containingFile, elementTextRange.getStartOffset() + start, elementTextRange.getStartOffset() + end));
                        } while ((start = s.indexOf(mySelectedString, end)) != -1);
                        HashSet<UsageInfo> hashSet = usages;
                        if (hashSet == null) {
                            1.$$$reportNull$$$0(5);
                        }
                        return hashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[switch (n) {
                            default -> 3;
                            case 3, 4, 5 -> 2;
                        }];
                        switch (n) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "processor";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "model";
                                break;
                            }
                            case 2: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "xmlElement";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[1] = "org/jetbrains/idea/maven/dom/refactorings/introduce/IntroducePropertyAction$MyRefactoringActionHandler$MyUsageSearcherFactory$1";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                objectArray = objectArray2;
                                objectArray2[1] = "getUsages";
                                break;
                            }
                        }
                        switch (n) {
                            default: {
                                objectArray = objectArray;
                                objectArray[2] = "generate";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray;
                                objectArray[2] = "collectUsages";
                                break;
                            }
                            case 2: {
                                objectArray = objectArray;
                                objectArray[2] = "getUsages";
                                break;
                            }
                            case 3: 
                            case 4: 
                            case 5: {
                                break;
                            }
                        }
                        String string = String.format(v0, objectArray);
                        throw switch (n) {
                            default -> new IllegalArgumentException(string);
                            case 3, 4, 5 -> new IllegalStateException(string);
                        };
                    }
                };
            }
        }
    }
}

