/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.ConvertContext;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.converters.MavenArtifactCoordinatesConverter;
import org.jetbrains.idea.maven.dom.converters.MavenSmartConverter;
import org.jetbrains.idea.maven.indices.MavenIndicesManager;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.reposearch.DependencySearchService;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesGroupIdConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenArtifactCoordinatesConverter;", "Lorg/jetbrains/idea/maven/dom/converters/MavenSmartConverter;", "", "()V", "doGetVariants", "", "id", "Lorg/jetbrains/idea/maven/model/MavenId;", "searchService", "Lorg/jetbrains/idea/reposearch/DependencySearchService;", "doIsValid", "", "manager", "Lorg/jetbrains/idea/maven/indices/MavenIndicesManager;", "context", "Lcom/intellij/util/xml/ConvertContext;", "getSmartVariants", "", "convertContext", "intellij.maven"})
public final class MavenArtifactCoordinatesGroupIdConverter
extends MavenArtifactCoordinatesConverter
implements MavenSmartConverter<String> {
    @Override
    protected boolean doIsValid(@NotNull MavenId id, @NotNull MavenIndicesManager manager, @NotNull ConvertContext context2) {
        MavenProject mavenProject2;
        VirtualFile projectFile;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (StringUtil.isEmpty((String)id.getGroupId())) {
            return false;
        }
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(context2.getProject());
        if (StringUtil.isNotEmpty((String)id.getArtifactId()) && StringUtil.isNotEmpty((String)id.getVersion())) {
            if (projectsManager.findProject(id) != null) {
                return true;
            }
        } else {
            for (MavenProject project2 : projectsManager.getProjects()) {
                if (!Intrinsics.areEqual((Object)id.getGroupId(), (Object)project2.getMavenId().getGroupId())) continue;
                return true;
            }
        }
        VirtualFile virtualFile = projectFile = this.getMavenProjectFile(context2);
        MavenProject mavenProject3 = mavenProject2 = virtualFile == null ? null : projectsManager.findProject(virtualFile);
        if (mavenProject2 != null) {
            for (MavenArtifact artifact : mavenProject2.findDependencies(id.getGroupId(), id.getArtifactId())) {
                if (!artifact.isResolved()) continue;
                return true;
            }
        }
        boolean hasLocalGroupId = manager.hasLocalGroupId(id.getGroupId());
        MavenLog.LOG.trace("local index group id " + id + ": " + hasLocalGroupId);
        return hasLocalGroupId;
    }

    @Override
    @NotNull
    protected Set<String> doGetVariants(@NotNull MavenId id, @NotNull DependencySearchService searchService) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)searchService, (String)"searchService");
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Collection<String> getSmartVariants(@NotNull ConvertContext convertContext) {
        Intrinsics.checkNotNullParameter((Object)convertContext, (String)"convertContext");
        return SetsKt.emptySet();
    }
}

