/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.util.ListStack;

public class StrongConnectivityHelper {
    private final List<List<Statement>> components;
    private final Set<Statement> setProcessed;
    private final ListStack<Statement> component;
    private final Set<Statement> visited;
    private final Map<Statement, Integer> indices;
    private final Map<Statement, Integer> lowIndices;
    private int nextIndex;

    public StrongConnectivityHelper(@NotNull Statement startStatement) {
        if (startStatement == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(0);
        }
        this.components = new ArrayList<List<Statement>>();
        this.setProcessed = new HashSet<Statement>();
        this.component = new ListStack();
        this.visited = new HashSet<Statement>();
        this.indices = new HashMap<Statement, Integer>();
        this.lowIndices = new HashMap<Statement, Integer>();
        this.visitTree(startStatement.getFirst());
        for (Statement statement : startStatement.getStats()) {
            if (this.setProcessed.contains(statement) || !statement.getPredecessorEdges(StatEdge.EdgeType.DIRECT_ALL).isEmpty()) continue;
            this.visitTree(statement);
        }
        for (Statement statement : startStatement.getStats()) {
            if (this.setProcessed.contains(statement)) continue;
            this.visitTree(statement);
        }
    }

    private void visitTree(@NotNull Statement statement) {
        if (statement == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(1);
        }
        this.component.clear();
        this.visited.clear();
        this.indices.clear();
        this.lowIndices.clear();
        this.nextIndex = 0;
        this.visit(statement);
        this.setProcessed.addAll(this.visited);
        this.setProcessed.add(statement);
    }

    private void visit(@NotNull Statement statement) {
        if (statement == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(2);
        }
        this.component.push(statement);
        this.indices.put(statement, this.nextIndex);
        this.lowIndices.put(statement, this.nextIndex);
        ++this.nextIndex;
        List<Statement> successors = statement.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD);
        successors.removeAll(this.setProcessed);
        for (Statement successor : successors) {
            int successorIndex;
            if (this.visited.contains(successor)) {
                successorIndex = this.indices.get(successor);
            } else {
                this.visited.add(successor);
                this.visit(successor);
                successorIndex = this.lowIndices.get(successor);
            }
            this.lowIndices.put(statement, Math.min(this.lowIndices.get(statement), successorIndex));
        }
        if (this.lowIndices.get(statement).intValue() == this.indices.get(statement).intValue()) {
            Statement statementInComponent;
            ArrayList<Statement> component = new ArrayList<Statement>();
            do {
                statementInComponent = this.component.pop();
                component.add(statementInComponent);
            } while (statementInComponent != statement);
            this.components.add(component);
        }
    }

    public static boolean isExitComponent(@NotNull List<? extends Statement> component) {
        if (component == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(3);
        }
        HashSet<Statement> statements = new HashSet<Statement>();
        for (Statement statement : component) {
            statements.addAll(statement.getNeighbours(StatEdge.EdgeType.REGULAR, StatEdge.EdgeDirection.FORWARD));
        }
        for (Statement statement : component) {
            statements.remove(statement);
        }
        return statements.size() == 0;
    }

    @NotNull
    public List<Statement> getExitReps() {
        ArrayList<Statement> result = new ArrayList<Statement>();
        for (List<Statement> component : this.components) {
            if (!StrongConnectivityHelper.isExitComponent(component)) continue;
            result.add(component.get(0));
        }
        ArrayList<Statement> arrayList = result;
        if (arrayList == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public @NotNull List<@NotNull List<Statement>> getComponents() {
        List<List<Statement>> list = this.components;
        if (list == null) {
            StrongConnectivityHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startStatement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/java/decompiler/modules/decompiler/StrongConnectivityHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/java/decompiler/modules/decompiler/StrongConnectivityHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitReps";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "visitTree";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visit";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isExitComponent";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5 -> new IllegalStateException(string);
        };
    }
}

