/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcs.log.visible.filters.VcsLogTextFilterWithMatches;
import com.intellij.vcs.log.visible.filters.VcsLogTextFiltersKt;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010\u0012\u001a\u00020\u0005H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0005H\u0017R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001b"}, d2={"Lcom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter;", "Lcom/intellij/vcs/log/VcsLogDetailsFilter;", "Lcom/intellij/vcs/log/visible/filters/VcsLogTextFilterWithMatches;", "patterns", "", "", "isMatchCase", "", "(Ljava/util/List;Z)V", "getPatterns", "()Ljava/util/List;", "equals", "other", "", "findNextMatch", "Lcom/intellij/openapi/util/TextRange;", "message", "previousRange", "getText", "hashCode", "", "isRegex", "matches", "matchesCase", "matchingRanges", "", "toString", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nVcsLogTextFilters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogTextFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n1747#2,3:105\n*S KotlinDebug\n*F\n+ 1 VcsLogTextFilters.kt\ncom/intellij/vcs/log/visible/filters/VcsLogMultiplePatternsTextFilter\n*L\n61#1:105,3\n*E\n"})
public final class VcsLogMultiplePatternsTextFilter
implements VcsLogDetailsFilter,
VcsLogTextFilterWithMatches {
    @NotNull
    private final List<String> patterns;
    private final boolean isMatchCase;

    public VcsLogMultiplePatternsTextFilter(@NotNull List<String> patterns, boolean isMatchCase) {
        Intrinsics.checkNotNullParameter(patterns, (String)"patterns");
        this.patterns = patterns;
        this.isMatchCase = isMatchCase;
    }

    @NotNull
    public final List<String> getPatterns() {
        return this.patterns;
    }

    @NotNull
    public String getText() {
        return this.patterns.size() == 1 ? (String)CollectionsKt.single(this.patterns) : CollectionsKt.joinToString$default((Iterable)this.patterns, (CharSequence)"|", null, null, (int)0, null, (Function1)getText.1.INSTANCE, (int)30, null);
    }

    public boolean isRegex() {
        return this.patterns.size() > 1;
    }

    public boolean matchesCase() {
        return this.isMatchCase;
    }

    @Override
    public boolean matches(@NotNull String message) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Iterable $this$any$iv = this.patterns;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.contains((CharSequence)message, (CharSequence)it, (!this.isMatchCase ? 1 : 0) != 0)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Iterable<TextRange> matchingRanges(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        return SequencesKt.asIterable((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<TextRange>(this, message){
            final /* synthetic */ VcsLogMultiplePatternsTextFilter this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(0);
            }

            @Nullable
            public final TextRange invoke() {
                return VcsLogMultiplePatternsTextFilter.access$findNextMatch(this.this$0, this.$message, null);
            }
        }), (Function1)((Function1)new Function1<TextRange, TextRange>(this, message){
            final /* synthetic */ VcsLogMultiplePatternsTextFilter this$0;
            final /* synthetic */ String $message;
            {
                this.this$0 = $receiver;
                this.$message = $message;
                super(1);
            }

            @Nullable
            public final TextRange invoke(@NotNull TextRange previousRange) {
                Intrinsics.checkNotNullParameter((Object)previousRange, (String)"previousRange");
                return VcsLogMultiplePatternsTextFilter.access$findNextMatch(this.this$0, this.$message, previousRange);
            }
        })));
    }

    private final TextRange findNextMatch(String message, TextRange previousRange) {
        TextRange textRange = previousRange;
        int startIndex = textRange != null ? textRange.getEndOffset() : 0;
        TextRange match = null;
        for (String pattern : this.patterns) {
            int patternIndex = StringsKt.indexOf((CharSequence)message, (String)pattern, (int)startIndex, (!this.isMatchCase ? 1 : 0) != 0);
            if (patternIndex < 0 || match != null && patternIndex > match.getStartOffset()) continue;
            match = new TextRange(patternIndex, patternIndex + pattern.length());
        }
        return match;
    }

    @NonNls
    @NotNull
    public String toString() {
        return "containing at least one of the " + CollectionsKt.joinToString$default((Iterable)this.patterns, (CharSequence)", ", null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)30, null) + " " + VcsLogTextFiltersKt.caseSensitiveText(this);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.vcs.log.visible.filters.VcsLogMultiplePatternsTextFilter");
        VcsLogMultiplePatternsTextFilter cfr_ignored_0 = (VcsLogMultiplePatternsTextFilter)other;
        return Comparing.haveEqualElements((Collection)this.patterns, (Collection)((VcsLogMultiplePatternsTextFilter)other).patterns) && this.isMatchCase == ((VcsLogMultiplePatternsTextFilter)other).isMatchCase;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{Comparing.unorderedHashcode((Collection)this.patterns), this.isMatchCase};
        return Objects.hash(objectArray);
    }

    public static final /* synthetic */ TextRange access$findNextMatch(VcsLogMultiplePatternsTextFilter $this, String message, TextRange previousRange) {
        return $this.findNextMatch(message, previousRange);
    }
}

