/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.IOUtil;
import com.intellij.vcs.log.util.PersistentUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u001b\b\u0004\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0011\u001a\u00020\u0012R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0012\u0010\u000f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\t\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/util/StorageId;", "", "projectName", "", "logId", "(Ljava/lang/String;Ljava/lang/String;)V", "baseDir", "Ljava/nio/file/Path;", "getBaseDir", "()Ljava/nio/file/Path;", "baseDir$delegate", "Lkotlin/Lazy;", "getLogId", "()Ljava/lang/String;", "getProjectName", "storagePath", "getStoragePath", "cleanupAllStorageFiles", "", "Directory", "File", "Lcom/intellij/vcs/log/util/StorageId$Directory;", "Lcom/intellij/vcs/log/util/StorageId$File;", "intellij.platform.vcs.log.impl"})
public abstract class StorageId {
    @NotNull
    private final String projectName;
    @NotNull
    private final String logId;
    @NotNull
    private final Lazy baseDir$delegate;

    private StorageId(@NonNls String projectName, @NonNls String logId) {
        this.projectName = projectName;
        this.logId = logId;
        this.baseDir$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
            final /* synthetic */ StorageId this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Path invoke() {
                return PersistentUtil.getPersistenceLogCacheDir$intellij_platform_vcs_log_impl(this.this$0.getProjectName(), this.this$0.getLogId());
            }
        }));
    }

    @NotNull
    protected final String getProjectName() {
        return this.projectName;
    }

    @NotNull
    protected final String getLogId() {
        return this.logId;
    }

    @NotNull
    public final Path getBaseDir() {
        Lazy lazy = this.baseDir$delegate;
        return (Path)lazy.getValue();
    }

    @NotNull
    public abstract Path getStoragePath();

    public final boolean cleanupAllStorageFiles() {
        return FileUtil.deleteWithRenaming((Path)this.getStoragePath());
    }

    public /* synthetic */ StorageId(String projectName, String logId, DefaultConstructorMarker $constructor_marker) {
        this(projectName, logId);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u001a\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00032\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007R\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lcom/intellij/vcs/log/util/StorageId$Directory;", "Lcom/intellij/vcs/log/util/StorageId;", "projectName", "", "subdirName", "logId", "version", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;I)V", "storagePath", "Ljava/nio/file/Path;", "getStoragePath", "()Ljava/nio/file/Path;", "storagePath$delegate", "Lkotlin/Lazy;", "getVersion", "()I", "doGetRealStorageFile", "kind", "forMapIndexStorage", "", "doGetStorageFile", "getStorageFile", "intellij.platform.vcs.log.impl"})
    public static final class Directory
    extends StorageId {
        @NotNull
        private final String subdirName;
        private final int version;
        @NotNull
        private final Lazy storagePath$delegate;

        public Directory(@NotNull String projectName, @NonNls @NotNull String subdirName, @NotNull String logId, int version) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)subdirName, (String)"subdirName");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            super(projectName, logId, null);
            this.subdirName = subdirName;
            this.version = version;
            this.storagePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
                final /* synthetic */ Directory this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final Path invoke() {
                    return this.this$0.getBaseDir().resolve(Directory.access$getSubdirName$p(this.this$0));
                }
            }));
        }

        public final int getVersion() {
            return this.version;
        }

        @Override
        @NotNull
        public Path getStoragePath() {
            Lazy lazy = this.storagePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Path)object;
        }

        @JvmOverloads
        @NotNull
        public final Path getStorageFile(@NotNull String kind, boolean forMapIndexStorage) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            Path storageFile = this.doGetRealStorageFile(kind, forMapIndexStorage);
            if (!Files.exists(storageFile, new LinkOption[0])) {
                int n = this.version;
                for (int oldVersion = 0; oldVersion < n; ++oldVersion) {
                    Path oldStorageFile = new Directory(this.getProjectName(), this.subdirName, this.getLogId(), oldVersion).doGetRealStorageFile(kind, forMapIndexStorage);
                    IOUtil.deleteAllFilesStartingWith((Path)oldStorageFile);
                }
            }
            return this.doGetStorageFile(kind);
        }

        public static /* synthetic */ Path getStorageFile$default(Directory directory, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return directory.getStorageFile(string, bl);
        }

        private final Path doGetRealStorageFile(String kind, boolean forMapIndexStorage) {
            Path storageFile = this.doGetStorageFile(kind);
            if (!forMapIndexStorage) {
                return storageFile;
            }
            Path path = MapIndexStorage.getIndexStorageFile((Path)storageFile);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getIndexStorageFile(...)");
            return path;
        }

        private final Path doGetStorageFile(String kind) {
            Path path = this.getStoragePath().resolve(kind + "." + this.version);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            return path;
        }

        @JvmOverloads
        @NotNull
        public final Path getStorageFile(@NotNull String kind) {
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            return Directory.getStorageFile$default(this, kind, false, 2, null);
        }

        public static final /* synthetic */ String access$getSubdirName$p(Directory $this) {
            return $this.subdirName;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/intellij/vcs/log/util/StorageId$File;", "Lcom/intellij/vcs/log/util/StorageId;", "projectName", "", "logId", "fileName", "extension", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "storagePath", "Ljava/nio/file/Path;", "getStoragePath", "()Ljava/nio/file/Path;", "storagePath$delegate", "Lkotlin/Lazy;", "intellij.platform.vcs.log.impl"})
    public static final class File
    extends StorageId {
        @NotNull
        private final Lazy storagePath$delegate;

        public File(@NotNull String projectName, @NotNull String logId, @NotNull String fileName, @NotNull String extension) {
            Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
            Intrinsics.checkNotNullParameter((Object)logId, (String)"logId");
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            super(projectName, logId, null);
            this.storagePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this, fileName, extension){
                final /* synthetic */ File this$0;
                final /* synthetic */ String $fileName;
                final /* synthetic */ String $extension;
                {
                    this.this$0 = $receiver;
                    this.$fileName = $fileName;
                    this.$extension = $extension;
                    super(0);
                }

                public final Path invoke() {
                    return this.this$0.getBaseDir().resolve(this.$fileName + "." + this.$extension);
                }
            }));
        }

        @Override
        @NotNull
        public Path getStoragePath() {
            Lazy lazy = this.storagePath$delegate;
            Object object = lazy.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
            return (Path)object;
        }
    }
}

