/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.Consumer;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogCommitSelection;
import com.intellij.vcs.log.data.CommitDetailsGetter;
import com.intellij.vcs.log.data.MiniDetailsGetter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.ui.table.CommitSelectionImpl;
import com.intellij.vcs.log.ui.table.VcsLogCommitSelectionUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.AbstractList;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\u0019\u001a\u00070\u0006\u00a2\u0006\u0002\b\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\u001e\u0010\u001c\u001a\u00020\u001d2\u0014\u0010\u001e\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u001fH\u0016R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionImpl;", "Lcom/intellij/vcs/log/VcsLogCommitSelection;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "visibleGraph", "Lcom/intellij/vcs/log/graph/VisibleGraph;", "", "rows", "", "(Lcom/intellij/vcs/log/data/VcsLogData;Lcom/intellij/vcs/log/graph/VisibleGraph;[I)V", "cachedFullDetails", "", "Lcom/intellij/vcs/log/VcsFullCommitDetails;", "getCachedFullDetails", "()Ljava/util/List;", "cachedMetadata", "Lcom/intellij/vcs/log/VcsCommitMetadata;", "getCachedMetadata", "commits", "Lcom/intellij/vcs/log/CommitId;", "getCommits", "ids", "getIds", "getRows", "()[I", "getIdAtRow", "Lorg/jetbrains/annotations/NotNull;", "row", "requestFullDetails", "", "consumer", "Ljava/util/function/Consumer;", "Companion", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
public final class CommitSelectionImpl
implements VcsLogCommitSelection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VcsLogData logData;
    @NotNull
    private final VisibleGraph<Integer> visibleGraph;
    @NotNull
    private final int[] rows;

    public CommitSelectionImpl(@NotNull VcsLogData logData, @NotNull VisibleGraph<Integer> visibleGraph, @NotNull int[] rows) {
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Intrinsics.checkNotNullParameter(visibleGraph, (String)"visibleGraph");
        Intrinsics.checkNotNullParameter((Object)rows, (String)"rows");
        this.logData = logData;
        this.visibleGraph = visibleGraph;
        this.rows = rows;
    }

    @NotNull
    public int[] getRows() {
        return this.rows;
    }

    @NotNull
    public List<Integer> getIds() {
        return CommitSelectionImpl.Companion.lazyMap(this.getRows(), (Function1)new Function1<Integer, Integer>((Object)this){

            @NotNull
            public final Integer invoke(int p0) {
                return CommitSelectionImpl.access$getIdAtRow((CommitSelectionImpl)this.receiver, p0);
            }
        });
    }

    @NotNull
    public List<CommitId> getCommits() {
        return VcsLogCommitSelectionUtils.lazyMap(this, (Function1)new Function1<Integer, CommitId>(this){
            final /* synthetic */ CommitSelectionImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CommitId invoke(int id) {
                CommitId commitId2 = CommitSelectionImpl.access$getLogData$p(this.this$0).getCommitId(id);
                Intrinsics.checkNotNull((Object)commitId2);
                return commitId2;
            }
        });
    }

    @NotNull
    public List<VcsCommitMetadata> getCachedMetadata() {
        VcsLogCommitSelection vcsLogCommitSelection = this;
        MiniDetailsGetter miniDetailsGetter = this.logData.getMiniDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)miniDetailsGetter, (String)"getMiniDetailsGetter(...)");
        return VcsLogCommitSelectionUtils.lazyMap(vcsLogCommitSelection, (Function1)new Function1<Integer, VcsCommitMetadata>((Object)miniDetailsGetter){

            @NotNull
            public final VcsCommitMetadata invoke(int p0) {
                return ((MiniDetailsGetter)this.receiver).getCachedDataOrPlaceholder(p0);
            }
        });
    }

    @NotNull
    public List<VcsFullCommitDetails> getCachedFullDetails() {
        VcsLogCommitSelection vcsLogCommitSelection = this;
        CommitDetailsGetter commitDetailsGetter = this.logData.getCommitDetailsGetter();
        Intrinsics.checkNotNullExpressionValue((Object)commitDetailsGetter, (String)"getCommitDetailsGetter(...)");
        return VcsLogCommitSelectionUtils.lazyMap(vcsLogCommitSelection, (Function1)new Function1<Integer, VcsFullCommitDetails>((Object)commitDetailsGetter){

            @NotNull
            public final VcsFullCommitDetails invoke(int p0) {
                return ((CommitDetailsGetter)this.receiver).getCachedDataOrPlaceholder(p0);
            }
        });
    }

    public void requestFullDetails(@NotNull java.util.function.Consumer<? super List<? extends VcsFullCommitDetails>> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        this.logData.getCommitDetailsGetter().loadCommitsData(this.getIds(), arg_0 -> CommitSelectionImpl.requestFullDetails$lambda$0((Function1)new Function1<List<? extends VcsFullCommitDetails>, Unit>(consumer){

            public final void invoke(@NotNull List<? extends VcsFullCommitDetails> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                ((java.util.function.Consumer)this.receiver).accept(p0);
            }
        }, arg_0), (Consumer<? super Throwable>)((Consumer<Throwable>)((Consumer)arg_0 -> CommitSelectionImpl.requestFullDetails$lambda$1(requestFullDetails.2.INSTANCE, arg_0))), (ProgressIndicator)null);
    }

    private final int getIdAtRow(int row2) {
        Object object = this.visibleGraph.getRowInfo(row2).getCommit();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCommit(...)");
        return ((Number)object).intValue();
    }

    private static final void requestFullDetails$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void requestFullDetails$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ int access$getIdAtRow(CommitSelectionImpl $this, int row2) {
        return $this.getIdAtRow(row2);
    }

    public static final /* synthetic */ VcsLogData access$getLogData$p(CommitSelectionImpl $this) {
        return $this.logData;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0000\u0010\u0005*\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002H\u00050\bH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/vcs/log/ui/table/CommitSelectionImpl$Companion;", "", "()V", "lazyMap", "", "T", "", "transform", "Lkotlin/Function1;", "", "intellij.platform.vcs.log.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final <T> List<T> lazyMap(int[] $this$lazyMap, Function1<? super Integer, ? extends T> transform) {
            return (List)new AbstractList<T>(transform, $this$lazyMap){
                final /* synthetic */ Function1<Integer, T> $transform;
                final /* synthetic */ int[] $this_lazyMap;
                {
                    this.$transform = $transform;
                    this.$this_lazyMap = $receiver;
                }

                public T get(int index) {
                    return (T)this.$transform.invoke((Object)this.$this_lazyMap[index]);
                }

                public int getSize() {
                    return this.$this_lazyMap.length;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

