/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogParentFilter;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001BC\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u0012\u0016\b\u0002\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b0\n\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00022\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u0016\u0010\u001a\u001a\u00020\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bH\u0002R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/vcs/log/ui/filter/ParentFilterModel;", "Lcom/intellij/vcs/log/ui/filter/FilterModel$SingleFilterModel;", "Lcom/intellij/vcs/log/VcsLogParentFilter;", "uiProperties", "Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "visibleRootsProvider", "Lkotlin/Function0;", "", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "(Lcom/intellij/vcs/log/impl/MainVcsLogUiProperties;Ljava/util/Map;Lkotlin/jvm/functions/Function0;Lcom/intellij/vcs/log/VcsLogFilterCollection;)V", "isEnabled", "", "()Z", "isVisible", "createFilter", "values", "", "", "createParentFilter", "getFilterValues", "filter", "isSupported", "roots", "intellij.platform.vcs.log.impl"})
@SourceDebugExtension(value={"SMAP\nParentFilterModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParentFilterModel.kt\ncom/intellij/vcs/log/ui/filter/ParentFilterModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1747#2,3:39\n*S KotlinDebug\n*F\n+ 1 ParentFilterModel.kt\ncom/intellij/vcs/log/ui/filter/ParentFilterModel\n*L\n37#1:39,3\n*E\n"})
public final class ParentFilterModel
extends FilterModel.SingleFilterModel<VcsLogParentFilter> {
    @NotNull
    private final Map<VirtualFile, VcsLogProvider> logProviders;
    @NotNull
    private final Function0<Collection<VirtualFile>> visibleRootsProvider;

    public ParentFilterModel(@NotNull MainVcsLogUiProperties uiProperties, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Function0<? extends Collection<? extends VirtualFile>> visibleRootsProvider, @Nullable VcsLogFilterCollection filters) {
        Intrinsics.checkNotNullParameter((Object)uiProperties, (String)"uiProperties");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(visibleRootsProvider, (String)"visibleRootsProvider");
        VcsLogFilterCollection.FilterKey filterKey = VcsLogFilterCollection.PARENT_FILTER;
        Intrinsics.checkNotNullExpressionValue((Object)filterKey, (String)"PARENT_FILTER");
        super(filterKey, uiProperties, filters);
        this.logProviders = logProviders;
        this.visibleRootsProvider = visibleRootsProvider;
    }

    public /* synthetic */ ParentFilterModel(MainVcsLogUiProperties mainVcsLogUiProperties, Map map, Function0 function0, VcsLogFilterCollection vcsLogFilterCollection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function0 = 1.INSTANCE;
        }
        this(mainVcsLogUiProperties, map, (Function0<? extends Collection<? extends VirtualFile>>)function0, vcsLogFilterCollection);
    }

    private final VcsLogParentFilter createParentFilter(List<String> values) {
        if (values.size() != 2) {
            return null;
        }
        return VcsLogFilterObject.fromParentCount(StringsKt.toIntOrNull((String)values.get(0)), StringsKt.toIntOrNull((String)values.get(1)));
    }

    @Override
    @Nullable
    protected VcsLogParentFilter createFilter(@NotNull List<String> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        return this.createParentFilter(values);
    }

    @Override
    @NotNull
    protected List<String> getFilterValues(@NotNull VcsLogParentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        Object[] objectArray = new String[]{String.valueOf(filter.getMinParents()), String.valueOf(filter.getMaxParents())};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final boolean isVisible() {
        return this.isSupported((Collection<? extends VirtualFile>)this.logProviders.keySet());
    }

    public final boolean isEnabled() {
        Collection collection = (Collection)this.visibleRootsProvider.invoke();
        if (collection == null) {
            collection = this.logProviders.keySet();
        }
        return this.isSupported(collection);
    }

    private final boolean isSupported(Collection<? extends VirtualFile> roots) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = roots;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    Object object = VcsLogProperties.SUPPORTS_PARENTS_FILTER.getOrDefault(this.logProviders.get(it));
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getOrDefault(...)");
                    if (!((Boolean)object).booleanValue()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

