/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.details.commit;

import com.intellij.openapi.vcs.ui.FontUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.VcsLogBundle;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.ui.VcsBookmarkRef;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanelKt;
import com.intellij.vcs.log.ui.frame.WrappedFlowLayout;
import com.intellij.vcs.log.ui.render.BookmarkIcon;
import com.intellij.vcs.log.ui.render.LabelIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencesPanel
extends JPanel {
    public static final int H_GAP = 4;
    protected static final int V_GAP = 0;
    private final int myRefsLimit;
    @NotNull
    private List<VcsRef> myReferences;
    @NotNull
    protected MultiMap<VcsRefType, VcsRef> myGroupedVisibleReferences;
    @NotNull
    protected List<VcsBookmarkRef> myBookmarks;

    public ReferencesPanel(int limit) {
        this((LayoutManager)new WrappedFlowLayout(JBUIScale.scale((int)4), JBUIScale.scale((int)0)), limit);
    }

    public ReferencesPanel(LayoutManager layout, int limit) {
        super(layout);
        this.myRefsLimit = limit;
        this.myReferences = Collections.emptyList();
        this.myGroupedVisibleReferences = MultiMap.create();
        this.myBookmarks = Collections.emptyList();
        this.setOpaque(false);
    }

    public void setReferences(@NotNull List<VcsRef> references) {
        if (references == null) {
            ReferencesPanel.$$$reportNull$$$0(0);
        }
        this.setReferences(references, Collections.emptyList());
    }

    public void setReferences(@NotNull List<VcsRef> references, @NotNull List<VcsBookmarkRef> bookmarks) {
        if (references == null) {
            ReferencesPanel.$$$reportNull$$$0(1);
        }
        if (bookmarks == null) {
            ReferencesPanel.$$$reportNull$$$0(2);
        }
        if (this.myReferences.equals(references) && this.myBookmarks.equals(bookmarks)) {
            return;
        }
        this.myReferences = references;
        this.myBookmarks = bookmarks;
        List visibleReferences = this.myRefsLimit > 0 ? ContainerUtil.getFirstItems(this.myReferences, (int)this.myRefsLimit) : this.myReferences;
        this.myGroupedVisibleReferences = ContainerUtil.groupBy((Iterable)visibleReferences, VcsRef::getType);
        this.update();
    }

    public void update() {
        this.removeAll();
        int height = this.getIconHeight();
        JBLabel firstLabel = null;
        for (VcsBookmarkRef bookmark : this.myBookmarks) {
            BookmarkIcon icon = new BookmarkIcon(this, height, this.getBackground(), bookmark);
            JBLabel label = this.createLabel(bookmark.getText(), icon);
            label.setIconTextGap(JBUI.scale((int)2));
            this.addWrapped(label, firstLabel);
            if (firstLabel != null) continue;
            firstLabel = label;
        }
        for (Map.Entry typeAndRefs : this.myGroupedVisibleReferences.entrySet()) {
            VcsRefType type = (VcsRefType)typeAndRefs.getKey();
            Collection refs = (Collection)typeAndRefs.getValue();
            int refIndex = 0;
            for (VcsRef reference : refs) {
                Icon icon = this.createIcon(type, refs, refIndex, height);
                String ending = refIndex != refs.size() - 1 ? "," : "";
                String text = reference.getName() + ending;
                JBLabel label = this.createLabel(text, icon);
                this.addWrapped(label, firstLabel);
                if (firstLabel == null) {
                    firstLabel = label;
                }
                ++refIndex;
            }
        }
        if (this.getHiddenReferencesSize() > 0) {
            JBLabel label = this.createRestLabel(this.getHiddenReferencesSize());
            this.addWrapped(label, Objects.requireNonNull(firstLabel));
        }
        this.setVisible(!this.myGroupedVisibleReferences.isEmpty() || !this.myBookmarks.isEmpty());
        this.revalidate();
        this.repaint();
    }

    private int getHiddenReferencesSize() {
        return this.myRefsLimit > 0 ? this.myReferences.size() - Math.min(this.myReferences.size(), this.myRefsLimit) : 0;
    }

    protected int getIconHeight() {
        return this.getFontMetrics(this.getLabelsFont()).getHeight();
    }

    @NotNull
    protected JBLabel createRestLabel(int restSize) {
        JBLabel jBLabel = this.createLabel(VcsLogBundle.message("vcs.log.details.references.more.label", restSize), null);
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(3);
        }
        return jBLabel;
    }

    @Nullable
    protected Icon createIcon(@NotNull VcsRefType type, @NotNull Collection<VcsRef> refs, int refIndex, int height) {
        if (type == null) {
            ReferencesPanel.$$$reportNull$$$0(4);
        }
        if (refs == null) {
            ReferencesPanel.$$$reportNull$$$0(5);
        }
        if (refIndex == 0) {
            Color color = type.getBackgroundColor();
            return new LabelIcon(this, height, this.getBackground(), refs.size() > 1 ? List.of(color, color) : Collections.singletonList(color));
        }
        return null;
    }

    private void addWrapped(@NotNull JBLabel label, @Nullable JBLabel referent) {
        if (label == null) {
            ReferencesPanel.$$$reportNull$$$0(6);
        }
        if (referent == null) {
            this.add((Component)label);
        } else {
            Wrapper wrapper = new Wrapper((JComponent)label);
            wrapper.setVerticalSizeReferent((JComponent)referent);
            this.add((Component)wrapper);
        }
    }

    @NotNull
    protected JBLabel createLabel(@Nls @NotNull String text, @Nullable Icon icon) {
        if (text == null) {
            ReferencesPanel.$$$reportNull$$$0(7);
        }
        JBLabel label = new JBLabel(text, icon, 2);
        label.setFont(this.getLabelsFont());
        label.setIconTextGap(0);
        label.setHorizontalAlignment(2);
        label.setVerticalTextPosition(0);
        label.setCopyable(true);
        JBLabel jBLabel = label;
        if (jBLabel == null) {
            ReferencesPanel.$$$reportNull$$$0(8);
        }
        return jBLabel;
    }

    @NotNull
    protected Font getLabelsFont() {
        Font font = FontUtil.getCommitMetadataFont();
        if (font == null) {
            ReferencesPanel.$$$reportNull$$$0(9);
        }
        return font;
    }

    @Override
    public Dimension getMaximumSize() {
        return new Dimension(super.getMaximumSize().width, super.getPreferredSize().height);
    }

    @Override
    public Color getBackground() {
        return CommitDetailsPanelKt.getCommitDetailsBackground();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bookmarks";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/details/commit/ReferencesPanel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refs";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/details/commit/ReferencesPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createRestLabel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLabel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabelsFont";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setReferences";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createIcon";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addWrapped";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLabel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 8, 9 -> new IllegalStateException(string);
        };
    }
}

