/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProperties;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryLogUiProvider;
import com.intellij.vcs.log.history.VcsLogFileHistoryProviderImplKt;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsLogTabLocation;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.MainVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiEx;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u001a\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J2\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0002J2\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001d\u001a\u00020\u0004H\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider;", "Lcom/intellij/vcs/log/history/FileHistoryLogUiProvider;", "()V", "canShowFileHistory", "", "project", "Lcom/intellij/openapi/project/Project;", "paths", "", "Lcom/intellij/openapi/vcs/FilePath;", "revisionNumber", "", "createHashFilter", "Lcom/intellij/vcs/log/VcsLogFilter;", "hash", "Lcom/intellij/vcs/log/Hash;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "createPathsFilter", "logProviders", "", "Lcom/intellij/vcs/log/VcsLogProvider;", "matches", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "pathsFilter", "hashFilter", "showFileHistoryUi", "Lcom/intellij/vcs/log/ui/VcsLogUiEx;", "selectRow", "intellij.platform.vcs.log.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsLogFileHistoryProviderImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsLogFileHistoryProviderImpl.kt\ncom/intellij/vcs/log/history/VcsLogDirectoryHistoryProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public final class VcsLogDirectoryHistoryProvider
implements FileHistoryLogUiProvider {
    @NotNull
    public static final VcsLogDirectoryHistoryProvider INSTANCE = new VcsLogDirectoryHistoryProvider();

    private VcsLogDirectoryHistoryProvider() {
    }

    @Override
    public boolean canShowFileHistory(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        if (paths.isEmpty()) {
            return false;
        }
        VcsLogData vcsLogData = VcsProjectLog.Companion.getInstance(project).getDataManager();
        if (vcsLogData == null) {
            return false;
        }
        VcsLogData dataManager = vcsLogData;
        Map<VirtualFile, VcsLogProvider> map = dataManager.getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        return this.createPathsFilter(project, map, paths) != null;
    }

    @Override
    @Nullable
    public VcsLogUiEx showFileHistoryUi(@NotNull Project project, @NotNull Collection<? extends FilePath> paths, @Nullable String revisionNumber, boolean selectRow) {
        boolean firstTime;
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        String string = revisionNumber;
        if (string != null) {
            String it = string;
            boolean bl = false;
            hash = HashImpl.build(it);
        } else {
            hash = null;
        }
        Hash hash2 = hash;
        VirtualFile virtualFile = VcsLogUtil.getActualRoot(project, (FilePath)CollectionsKt.first((Iterable)paths));
        Intrinsics.checkNotNull((Object)virtualFile);
        VirtualFile root = virtualFile;
        VcsLogFileHistoryProviderImplKt.access$triggerFileHistoryUsage(project, paths, hash2);
        VcsLogManager vcsLogManager = VcsProjectLog.Companion.getInstance(project).getLogManager();
        Intrinsics.checkNotNull((Object)vcsLogManager);
        VcsLogManager logManager2 = vcsLogManager;
        Map<VirtualFile, VcsLogProvider> map = logManager2.getDataManager().getLogProviders();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getLogProviders(...)");
        VcsLogFilter vcsLogFilter = this.createPathsFilter(project, map, paths);
        Intrinsics.checkNotNull((Object)vcsLogFilter);
        VcsLogFilter pathsFilter = vcsLogFilter;
        VcsLogFilter hashFilter = this.createHashFilter(hash2, root);
        MainVcsLogUi ui2 = VcsLogTabLocation.Companion.findLogUi(logManager2, VcsLogTabLocation.TOOL_WINDOW, MainVcsLogUi.class, true, (Function1)new Function1<MainVcsLogUi, Boolean>(pathsFilter, hashFilter){
            final /* synthetic */ VcsLogFilter $pathsFilter;
            final /* synthetic */ VcsLogFilter $hashFilter;
            {
                this.$pathsFilter = $pathsFilter;
                this.$hashFilter = $hashFilter;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull MainVcsLogUi logUi2) {
                Intrinsics.checkNotNullParameter((Object)logUi2, (String)"logUi");
                VcsLogFilterCollection vcsLogFilterCollection = logUi2.getFilterUi().getFilters();
                Intrinsics.checkNotNullExpressionValue((Object)vcsLogFilterCollection, (String)"getFilters(...)");
                return VcsLogDirectoryHistoryProvider.access$matches(VcsLogDirectoryHistoryProvider.INSTANCE, vcsLogFilterCollection, this.$pathsFilter, this.$hashFilter);
            }
        });
        boolean bl = firstTime = ui2 == null;
        if (firstTime) {
            VcsLogFilter[] vcsLogFilterArray = new VcsLogFilter[]{pathsFilter, hashFilter};
            VcsLogFilterCollection filters = VcsLogFilterObject.collection(vcsLogFilterArray);
            MainVcsLogUi mainVcsLogUi = VcsProjectLog.Companion.getInstance(project).openLogTab(filters);
            if (mainVcsLogUi == null) {
                return null;
            }
            ui2 = mainVcsLogUi;
            MainVcsLogUiProperties mainVcsLogUiProperties = ui2.getProperties();
            VcsLogUiProperties.VcsLogUiProperty<Boolean> vcsLogUiProperty = MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES;
            Intrinsics.checkNotNullExpressionValue(vcsLogUiProperty, (String)"SHOW_ONLY_AFFECTED_CHANGES");
            mainVcsLogUiProperties.set(vcsLogUiProperty, true);
        }
        if (selectRow) {
            MainVcsLogUi mainVcsLogUi = ui2;
            Intrinsics.checkNotNull((Object)mainVcsLogUi);
            VcsLogFileHistoryProviderImplKt.access$selectRowWhenOpen(logManager2, hash2, root, mainVcsLogUi, firstTime);
        }
        return ui2;
    }

    @Nullable
    public final VcsLogFilter createPathsFilter(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders, @NotNull Collection<? extends FilePath> paths) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(logProviders, (String)"logProviders");
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        Set forRootFilter = new LinkedHashSet();
        List forPathsFilter = new ArrayList();
        for (FilePath filePath : paths) {
            VirtualFile root = VcsLogUtil.getActualRoot(project, filePath);
            if (root == null) {
                return null;
            }
            if (!logProviders.keySet().contains(root) || !((Boolean)VcsLogProperties.SUPPORTS_LOG_DIRECTORY_HISTORY.getOrDefault(logProviders.get(root))).booleanValue()) {
                return null;
            }
            FilePath correctedPath = VcsLogFileHistoryProviderImplKt.access$getCorrectedPath(project, filePath, false);
            if (!correctedPath.isDirectory()) {
                return null;
            }
            if (Intrinsics.areEqual((Object)filePath.getVirtualFile(), (Object)root)) {
                forRootFilter.add(root);
            } else {
                forPathsFilter.add(correctedPath);
            }
            if (!(!((Collection)forPathsFilter).isEmpty()) || !(!((Collection)forRootFilter).isEmpty())) continue;
            return null;
        }
        if (!((Collection)forPathsFilter).isEmpty()) {
            return (VcsLogFilter)VcsLogFilterObject.fromPaths(forPathsFilter);
        }
        return (VcsLogFilter)VcsLogFilterObject.fromRoots(forRootFilter);
    }

    private final VcsLogFilter createHashFilter(Hash hash, VirtualFile root) {
        if (hash == null) {
            return (VcsLogFilter)VcsLogFilterObject.fromBranch("HEAD");
        }
        return (VcsLogFilter)VcsLogFilterObject.fromCommit(new CommitId(hash, root));
    }

    private final boolean matches(VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        VcsLogFilterCollection.FilterKey[] filterKeyArray = new VcsLogFilterCollection.FilterKey[2];
        Intrinsics.checkNotNullExpressionValue((Object)hashFilter.getKey(), (String)"getKey(...)");
        Intrinsics.checkNotNullExpressionValue((Object)pathsFilter.getKey(), (String)"getKey(...)");
        if (!VcsLogFiltersKt.matches(filters, filterKeyArray)) {
            return false;
        }
        return Intrinsics.areEqual((Object)filters.get(pathsFilter.getKey()), (Object)pathsFilter) && Intrinsics.areEqual((Object)filters.get(hashFilter.getKey()), (Object)hashFilter);
    }

    public static final /* synthetic */ boolean access$matches(VcsLogDirectoryHistoryProvider $this, VcsLogFilterCollection filters, VcsLogFilter pathsFilter, VcsLogFilter hashFilter) {
        return $this.matches(filters, pathsFilter, hashFilter);
    }
}

