/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.linearBek;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.EdgeFilter;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.impl.facade.LinearGraphWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class LinearBekGraph
extends LinearGraphWrapper {
    public LinearBekGraph(@NotNull LinearGraph graph) {
        if (graph == null) {
            LinearBekGraph.$$$reportNull$$$0(0);
        }
        super(graph);
    }

    public Collection<GraphEdge> expandEdge(@NotNull GraphEdge edge) {
        if (edge == null) {
            LinearBekGraph.$$$reportNull$$$0(1);
        }
        HashSet<GraphEdge> result2 = new HashSet<GraphEdge>();
        assert (edge.getType() == GraphEdgeType.DOTTED);
        this.getDottedEdges().removeEdge(edge);
        Integer tail = edge.getUpNodeIndex();
        Integer firstChild = edge.getDownNodeIndex();
        assert (tail != null) : "Collapsed from to an unloaded node";
        assert (firstChild != null) : "Collapsed edge to an unloaded node";
        List<GraphEdge> downDottedEdges = this.getHiddenEdges().getAdjacentEdges(tail, EdgeFilter.NORMAL_DOWN);
        List<GraphEdge> upDottedEdges = this.getHiddenEdges().getAdjacentEdges(firstChild, EdgeFilter.NORMAL_UP);
        for (GraphEdge e : ContainerUtil.concat(downDottedEdges, upDottedEdges)) {
            this.getHiddenEdges().removeEdge(e);
            if (e.getType() == GraphEdgeType.DOTTED) {
                result2.addAll(this.expandEdge(e));
                continue;
            }
            result2.add(e);
        }
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/graph/linearBek/LinearBekGraph";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "expandEdge";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class WorkingLinearBekGraph
    extends LinearBekGraph {
        private final LinearBekGraph myLinearGraph;

        public WorkingLinearBekGraph(@NotNull LinearBekGraph graph) {
            if (graph == null) {
                WorkingLinearBekGraph.$$$reportNull$$$0(0);
            }
            super(graph.getGraph());
            this.myLinearGraph = graph;
        }

        public Collection<GraphEdge> getAddedEdges() {
            Set<GraphEdge> result2 = this.getDottedEdges().getEdges();
            result2.removeAll(ContainerUtil.filter(this.getHiddenEdges().getEdges(), graphEdge -> graphEdge.getType() == GraphEdgeType.DOTTED));
            result2.removeAll(this.myLinearGraph.getDottedEdges().getEdges());
            return result2;
        }

        public Collection<GraphEdge> getRemovedEdges() {
            HashSet<GraphEdge> result2 = new HashSet<GraphEdge>();
            Set<GraphEdge> hidden = this.getHiddenEdges().getEdges();
            result2.addAll(ContainerUtil.filter(hidden, graphEdge -> graphEdge.getType() != GraphEdgeType.DOTTED));
            result2.addAll(ContainerUtil.intersection(hidden, this.myLinearGraph.getDottedEdges().getEdges()));
            result2.removeAll(this.myLinearGraph.getHiddenEdges().getEdges());
            return result2;
        }

        public void applyChanges() {
            this.myLinearGraph.getDottedEdges().removeAll();
            this.myLinearGraph.getHiddenEdges().removeAll();
            for (GraphEdge e : this.getDottedEdges().getEdges()) {
                this.myLinearGraph.getDottedEdges().createEdge(e);
            }
            for (GraphEdge e : this.getHiddenEdges().getEdges()) {
                this.myLinearGraph.getHiddenEdges().createEdge(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graph", "com/intellij/vcs/log/graph/linearBek/LinearBekGraph$WorkingLinearBekGraph", "<init>"));
        }
    }
}

