/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.facade.sort;

import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public interface SortIndexMap {
    public int size();

    public int getSortedIndex(int var1);

    public int getUsualIndex(int var1);

    @NotNull
    public static SortIndexMap createFromSortedList(@NotNull List<Integer> list) {
        if (list == null) {
            SortIndexMap.$$$reportNull$$$0(0);
        }
        int[] reverseMap = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            reverseMap[list.get((int)i).intValue()] = i;
        }
        final IntList compressedMap = CompressedIntList.newInstance(list);
        final IntList compressedReverseMap = CompressedIntList.newInstance(reverseMap);
        return new SortIndexMap(){

            @Override
            public int size() {
                return compressedMap.size();
            }

            @Override
            public int getSortedIndex(int usualIndex) {
                return compressedReverseMap.get(usualIndex);
            }

            @Override
            public int getUsualIndex(int sortedIndex) {
                return compressedMap.get(sortedIndex);
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/vcs/log/graph/impl/facade/sort/SortIndexMap", "createFromSortedList"));
    }
}

