/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineFileEditor;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.model.GHPRToolWindowProjectViewModel;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPREditorProviderService;", "", "parentCs", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;)V", "cs", "createTimelineEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "intellij.vcs.github"})
final class GHPREditorProviderService {
    @NotNull
    private final CoroutineScope cs;

    public GHPREditorProviderService(@NotNull CoroutineScope parentCs) {
        Intrinsics.checkNotNullParameter((Object)parentCs, (String)"parentCs");
        this.cs = CoroutineScopeKt.childScope$default((CoroutineScope)parentCs, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), (boolean)false, (int)2, null);
    }

    @NotNull
    public final FileEditor createTimelineEditor(@NotNull GHPRTimelineVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        GHPRToolWindowProjectViewModel gHPRToolWindowProjectViewModel = file.findProjectVm();
        if (gHPRToolWindowProjectViewModel == null) {
            throw new ProcessCanceledException();
        }
        GHPRToolWindowProjectViewModel projectVm2 = gHPRToolWindowProjectViewModel;
        return (FileEditor)new GHPRTimelineFileEditor(this.cs, projectVm2, file);
    }
}

