/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0010\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"isGithubActionsActionFile", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isGithubActionsFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "isGithubWorkflowFile", "intellij.vcs.github"})
public final class GithubYamlFileDetectionKt {
    public static final boolean isGithubActionsFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2 != null && (psiFile2 = psiFile2.getOriginalFile()) != null ? psiFile2.getVirtualFile() : null;
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return GithubYamlFileDetectionKt.isGithubActionsFile(virtualFile2);
    }

    public static final boolean isGithubActionsFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return GithubYamlFileDetectionKt.isGithubActionsActionFile(virtualFile) || GithubYamlFileDetectionKt.isGithubWorkflowFile(virtualFile);
    }

    public static final boolean isGithubWorkflowFile(@Nullable PsiFile psiFile) {
        PsiFile psiFile2 = psiFile;
        VirtualFile virtualFile = psiFile2 != null && (psiFile2 = psiFile2.getOriginalFile()) != null ? psiFile2.getVirtualFile() : null;
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        return GithubYamlFileDetectionKt.isGithubWorkflowFile(virtualFile2);
    }

    private static final boolean isGithubActionsActionFile(VirtualFile virtualFile) {
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        return VirtualFileUtil.isFile((VirtualFile)virtualFile) && (StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".yaml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".yml", (boolean)false, (int)2, null)) && Intrinsics.areEqual((Object)virtualFile.getNameWithoutExtension(), (Object)"action");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isGithubWorkflowFile(VirtualFile virtualFile) {
        CharSequence charSequence = virtualFile.getNameSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNameSequence(...)");
        CharSequence nameSequence = charSequence;
        if (!VirtualFileUtil.isFile((VirtualFile)virtualFile)) return false;
        if (!StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".yaml", (boolean)false, (int)2, null)) {
            if (!StringsKt.endsWith$default((CharSequence)nameSequence, (CharSequence)".yml", (boolean)false, (int)2, null)) return false;
        }
        VirtualFile virtualFile2 = virtualFile.getParent();
        if (!Intrinsics.areEqual((Object)(virtualFile2 != null ? virtualFile2.getName() : null), (Object)"workflows")) return false;
        VirtualFile virtualFile3 = virtualFile.getParent();
        if (!Intrinsics.areEqual((Object)(virtualFile3 != null && (virtualFile3 = virtualFile3.getParent()) != null ? virtualFile3.getName() : null), (Object)".github")) return false;
        return true;
    }
}

