/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.async.CoroutineUtilKt;
import com.intellij.collaboration.messages.CollaborationToolsBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import git4idea.DialogManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GHLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.util.GHPluginProjectScopeProvider;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a:\u0010\f\u001a\u0002H\r\"\b\b\u0000\u0010\r*\u00020\u000e2\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0017\u0010\u000f\u001a\u0013\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u0002H\r0\u0010\u00a2\u0006\u0002\b\u0012H\u0002\u00a2\u0006\u0002\u0010\u0013\u001a\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u000eH\u0002\u001a(\u0010\u0017\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a(\u0010\u001a\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a(\u0010\u001b\u001a\u00020\u0015*\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u001c"}, d2={"accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "promptOAuthLogin", "", "request", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "scopedDialog", "D", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "dialogConstructor", "Lkotlin/Function1;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "configure", "", "dialog", "loginWithOAuth", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "loginWithOAuthOrToken", "loginWithToken", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGHAccountsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHAccountsUtil.kt\norg/jetbrains/plugins/github/authentication/GHAccountsUtilKt\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,298:1\n40#2,3:299\n1#3:302\n31#4,2:303\n*S KotlinDebug\n*F\n+ 1 GHAccountsUtil.kt\norg/jetbrains/plugins/github/authentication/GHAccountsUtilKt\n*L\n39#1:299,3\n216#1:303,2\n*E\n"})
public final class GHAccountsUtilKt {
    private static final GHAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (GHAccountManager)((Object)object);
    }

    private static final void configure(GHLoginRequest $this$configure, GHLoginDialog dialog2) {
        block2: {
            Object it;
            Throwable throwable = $this$configure.getError();
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                dialog2.setError((Throwable)it);
            }
            GithubServerPath githubServerPath = $this$configure.getServer();
            if (githubServerPath != null) {
                it = githubServerPath;
                boolean bl = false;
                String string = ((GithubServerPath)it).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                dialog2.setServer(string, $this$configure.isServerEditable());
            }
            String string = $this$configure.getLogin();
            if (string == null) break block2;
            it = string;
            boolean bl = false;
            dialog2.setLogin((String)it, $this$configure.isLoginEditable());
        }
    }

    private static final <D extends GHLoginDialog> D scopedDialog(Project project, Function1<? super CoroutineScope, ? extends D> dialogConstructor) {
        if (project != null) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GHPluginProjectScopeProvider> serviceClass$iv = GHPluginProjectScopeProvider.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (D)((Object)((GHLoginDialog)((GHPluginProjectScopeProvider)((Object)object)).constructDialog("GitHub login dialog", dialogConstructor)));
        }
        CoroutineScope coroutineScope = (CoroutineScope)GlobalScope.INSTANCE;
        String string = GHLoginDialog.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        CoroutineScope cs = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)string, null, (boolean)false, (int)6, null);
        GHLoginDialog dialog2 = (GHLoginDialog)((Object)dialogConstructor.invoke((Object)cs));
        Disposable disposable = dialog2.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        CoroutineUtilKt.cancelledWith((CoroutineScope)cs, (Disposable)disposable);
        return (D)((Object)dialog2);
    }

    private static final void loginWithToken(GHLoginRequest $this$loginWithToken, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.Token dialog2 = (GHLoginDialog.Token)((Object)GHAccountsUtilKt.scopedDialog(project, (Function1)new Function1<CoroutineScope, GHLoginDialog.Token>(model2, project, parentComponent, $this$loginWithToken){
            final /* synthetic */ GHLoginModel $model;
            final /* synthetic */ Project $project;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ GHLoginRequest $this_loginWithToken;
            {
                this.$model = $model;
                this.$project = $project;
                this.$parentComponent = $parentComponent;
                this.$this_loginWithToken = $receiver;
                super(1);
            }

            @NotNull
            public final GHLoginDialog.Token invoke(@NotNull CoroutineScope $this$scopedDialog) {
                Intrinsics.checkNotNullParameter((Object)$this$scopedDialog, (String)"$this$scopedDialog");
                GHLoginDialog.Token token2 = new GHLoginDialog.Token(this.$model, this.$project, $this$scopedDialog, this.$parentComponent);
                GHLoginRequest gHLoginRequest = this.$this_loginWithToken;
                GHLoginDialog.Token it = token2;
                boolean bl = false;
                GHAccountsUtilKt.access$configure(gHLoginRequest, it);
                return token2;
            }
        }));
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static final void loginWithOAuth(GHLoginRequest $this$loginWithOAuth, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.OAuth dialog2 = (GHLoginDialog.OAuth)((Object)GHAccountsUtilKt.scopedDialog(project, (Function1)new Function1<CoroutineScope, GHLoginDialog.OAuth>(model2, project, parentComponent, $this$loginWithOAuth){
            final /* synthetic */ GHLoginModel $model;
            final /* synthetic */ Project $project;
            final /* synthetic */ Component $parentComponent;
            final /* synthetic */ GHLoginRequest $this_loginWithOAuth;
            {
                this.$model = $model;
                this.$project = $project;
                this.$parentComponent = $parentComponent;
                this.$this_loginWithOAuth = $receiver;
                super(1);
            }

            @NotNull
            public final GHLoginDialog.OAuth invoke(@NotNull CoroutineScope $this$scopedDialog) {
                Intrinsics.checkNotNullParameter((Object)$this$scopedDialog, (String)"$this$scopedDialog");
                GHLoginDialog.OAuth oAuth = new GHLoginDialog.OAuth(this.$model, this.$project, $this$scopedDialog, this.$parentComponent);
                GHLoginRequest gHLoginRequest = this.$this_loginWithOAuth;
                GHLoginDialog.OAuth it = oAuth;
                boolean bl = false;
                GHAccountsUtilKt.access$configure(gHLoginRequest, it);
                return oAuth;
            }
        }));
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static final void loginWithOAuthOrToken(GHLoginRequest $this$loginWithOAuthOrToken, GHLoginModel model2, Project project, Component parentComponent) {
        switch (GHAccountsUtilKt.promptOAuthLogin($this$loginWithOAuthOrToken, project, parentComponent)) {
            case 0: {
                GHAccountsUtilKt.loginWithOAuth($this$loginWithOAuthOrToken, model2, project, parentComponent);
                break;
            }
            case 1: {
                GHAccountsUtilKt.loginWithToken($this$loginWithOAuthOrToken, model2, project, parentComponent);
            }
        }
    }

    private static final int promptOAuthLogin(GHLoginRequest request2, Project project, Component parentComponent) {
        String string;
        if (PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            string = new HtmlBuilder().append((HtmlChunk)HtmlChunk.p().addText(CollaborationToolsBundle.message((String)"accounts.error.password-not-saved", (Object[])new Object[0]))).append((HtmlChunk)HtmlChunk.br()).append((HtmlChunk)HtmlChunk.p().addText(CollaborationToolsBundle.message((String)"accounts.error.password-not-saved.solution", (Object[])new Object[0]))).toString();
        } else {
            string = request2.getText();
            if (string == null) {
                String string2 = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            }
        }
        String string3 = string;
        Intrinsics.checkNotNull((Object)string3);
        String message2 = string3;
        String string4 = GithubBundle.message("login.to.github", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel yesNoCancel = MessageDialogBuilder.Companion.yesNoCancel(string4, message2);
        String string5 = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string5);
        String string6 = GithubBundle.message("button.use.token", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        MessageDialogBuilder.YesNoCancel builder = (MessageDialogBuilder.YesNoCancel)yesNoCancel2.noText(string6);
        if (PasswordSafe.Companion.getInstance().isMemoryOnly()) {
            builder.asWarning();
        }
        if (parentComponent != null) {
            return builder.show(parentComponent);
        }
        return builder.show(project);
    }

    public static final /* synthetic */ GHAccountManager access$getAccountManager() {
        return GHAccountsUtilKt.getAccountManager();
    }

    public static final /* synthetic */ GHLoginDialog access$scopedDialog(Project project, Function1 dialogConstructor) {
        return GHAccountsUtilKt.scopedDialog(project, dialogConstructor);
    }

    public static final /* synthetic */ void access$loginWithToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithToken($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuth(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuth($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuthOrToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuthOrToken($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$configure(GHLoginRequest $receiver, GHLoginDialog dialog2) {
        GHAccountsUtilKt.configure($receiver, dialog2);
    }
}

