/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.serviceView;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.services.ServiceViewActionUtils;
import com.intellij.execution.services.ServiceViewUIUtils;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Key;
import com.intellij.platform.execution.serviceView.ServiceViewActionProvider;
import com.intellij.platform.execution.serviceView.ServiceViewState;
import com.intellij.platform.execution.serviceView.ServiceViewUi;
import com.intellij.platform.navbar.frontend.ui.NavBarBorder;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollableContentBorder;
import com.intellij.ui.Side;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ServiceViewTreeUi
implements ServiceViewUi {
    private final JPanel myMainPanel;
    private final SimpleToolWindowPanel myContentPanel;
    private final Splitter mySplitter;
    private final JPanel myMasterPanel;
    private final JPanel myDetailsPanel;
    private final JPanel myContentComponentPanel;
    private final JPanel myNavBarPanel;
    private final JBPanelWithEmptyText myMessagePanel;
    private final Set<JComponent> myDetailsComponents;
    private ActionToolbar myServiceActionToolbar;
    private JComponent myServiceActionToolbarWrapper;
    private ActionToolbar myMasterActionToolbar;
    private NavBarWrapper myNavBarWrapper;

    ServiceViewTreeUi(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(0);
        }
        this.myContentPanel = new SimpleToolWindowPanel(false);
        this.myMessagePanel = new JBPanelWithEmptyText().withEmptyText(ExecutionBundle.message((String)"service.view.empty.selection.text", (Object[])new Object[0]));
        this.myDetailsComponents = ContainerUtil.createWeakSet();
        this.myMainPanel = new SimpleToolWindowPanel(false);
        this.myNavBarPanel = new JPanel(new BorderLayout());
        this.myNavBarPanel.setBorder(IdeBorderFactory.createBorder((int)8));
        this.myMainPanel.add((Component)this.myNavBarPanel, "North");
        this.mySplitter = new OnePixelSplitter(false, state.contentProportion);
        this.myMainPanel.add((Component)this.myContentPanel, "Center");
        this.myContentPanel.setContent((JComponent)this.mySplitter);
        this.myMasterPanel = new MyPanel();
        this.mySplitter.setFirstComponent((JComponent)this.myMasterPanel);
        this.myDetailsPanel = new JPanel(new BorderLayout());
        this.myContentComponentPanel = new JPanel(new BorderLayout());
        this.myMessagePanel.setFocusable(true);
        this.myContentComponentPanel.add((Component)this.myMessagePanel, "Center");
        this.myDetailsPanel.add((Component)this.myContentComponentPanel, "Center");
        this.mySplitter.setSecondComponent((JComponent)this.myDetailsPanel);
        if (state.showServicesTree) {
            this.myNavBarPanel.setVisible(false);
        } else {
            this.myMasterPanel.setVisible(false);
        }
        ComponentUtil.putClientProperty((JComponent)this.myMainPanel, (Key)UIUtil.NOT_IN_HIERARCHY_COMPONENTS, () -> JBIterable.from(this.myDetailsComponents).append((Object)this.myMessagePanel).filter(component -> this.myContentComponentPanel != component.getParent()).iterator());
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public void saveState(@NotNull ServiceViewState state) {
        if (state == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(2);
        }
        state.contentProportion = this.mySplitter.getProportion();
    }

    @Override
    public void setServiceToolbar(@NotNull ServiceViewActionProvider actionProvider) {
        if (actionProvider == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(3);
        }
        boolean inDetails = ServiceViewUIUtils.isNewServicesUIEnabled();
        this.myServiceActionToolbar = actionProvider.createServiceToolbar(this.myMainPanel, inDetails);
        if (inDetails) {
            JComponent wrapper = ServiceViewUIUtils.wrapServicesAligned((ActionToolbar)this.myServiceActionToolbar);
            this.myServiceActionToolbarWrapper = actionProvider.wrapServiceToolbar(wrapper, inDetails);
            this.myDetailsPanel.add((Component)this.myServiceActionToolbarWrapper, "North");
        } else {
            this.myContentPanel.setToolbar(actionProvider.wrapServiceToolbar(this.myServiceActionToolbar.getComponent(), inDetails));
        }
    }

    @Override
    public void setMasterComponent(@NotNull JComponent component, @NotNull ServiceViewActionProvider actionProvider) {
        if (component == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(4);
        }
        if (actionProvider == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(5);
        }
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)component, (boolean)true);
        ScrollableContentBorder.setup((JScrollPane)scrollPane, (Side)Side.TOP);
        this.myMasterPanel.add((Component)scrollPane, "Center");
        this.myMasterActionToolbar = actionProvider.createMasterComponentToolbar(component);
        this.myMasterPanel.add((Component)ServiceViewUIUtils.wrapServicesAligned((ActionToolbar)this.myMasterActionToolbar), "North");
        this.myMasterPanel.updateUI();
        actionProvider.installPopupHandler(component);
    }

    @Override
    public void setNavBar(@NotNull JComponent component) {
        if (component == null) {
            ServiceViewTreeUi.$$$reportNull$$$0(6);
        }
        this.myNavBarWrapper = new NavBarWrapper(component);
        this.myNavBarWrapper.setVisible(this.myNavBarPanel.isVisible());
        this.myNavBarPanel.add((Component)this.myNavBarWrapper, "Center");
    }

    @Override
    @Nullable
    public JComponent updateNavBar(boolean isSideComponent) {
        if (this.myNavBarWrapper != null) {
            if (isSideComponent) {
                if (this.myNavBarWrapper.getParent() == this.myNavBarPanel) {
                    this.myNavBarPanel.remove(this.myNavBarWrapper);
                }
            } else if (this.myNavBarWrapper.getParent() != this.myNavBarPanel) {
                this.myNavBarPanel.add((Component)this.myNavBarWrapper, "Center");
            }
            this.myNavBarWrapper.updateScrollPaneBorder(isSideComponent);
            this.setNavBarPanelVisible();
        }
        return this.myNavBarWrapper;
    }

    @Override
    public void setMasterComponentVisible(boolean visible) {
        this.myMasterPanel.setVisible(visible);
        if (this.myNavBarWrapper != null) {
            this.myNavBarWrapper.setVisible(!visible);
        }
        this.setNavBarPanelVisible();
    }

    private void setNavBarPanelVisible() {
        if (this.myNavBarWrapper != null) {
            this.myNavBarPanel.setVisible(this.myNavBarWrapper.isVisible() && this.myNavBarWrapper.getParent() == this.myNavBarPanel);
        }
    }

    @Override
    public void setDetailsComponent(@Nullable JComponent component) {
        ActionToolbar serviceActionToolbar;
        if (component == null) {
            component = this.myMessagePanel;
        }
        if (component.getParent() != this.myContentComponentPanel) {
            if (ServiceViewUIUtils.isNewServicesUIEnabled()) {
                boolean visible = ServiceViewActionProvider.isActionToolBarRequired(component);
                this.myServiceActionToolbarWrapper.setVisible(visible);
                if (visible) {
                    this.myContentComponentPanel.setBorder(IdeBorderFactory.createBorder((int)2));
                } else {
                    this.myContentComponentPanel.setBorder(null);
                }
            }
            this.myDetailsComponents.add(component);
            this.myContentComponentPanel.removeAll();
            this.myContentComponentPanel.add((Component)component, "Center");
            this.myContentComponentPanel.revalidate();
            this.myContentComponentPanel.repaint();
        }
        if ((serviceActionToolbar = this.myServiceActionToolbar) != null) {
            ((ActionToolbarImpl)serviceActionToolbar).reset();
            serviceActionToolbar.updateActionsImmediately();
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ActionToolbar masterActionToolbar = this.myMasterActionToolbar;
            if (masterActionToolbar != null) {
                masterActionToolbar.updateActionsImmediately();
            }
        });
    }

    @Override
    public void setDetailsComponentVisible(boolean visible) {
        this.myDetailsPanel.setVisible(visible);
    }

    @Override
    @Nullable
    public JComponent getDetailsComponent() {
        int count = this.myContentComponentPanel.getComponentCount();
        if (count == 0) {
            return null;
        }
        Component component = this.myContentComponentPanel.getComponent(0);
        return component == this.myMessagePanel ? null : (JComponent)component;
    }

    @Override
    public void setSplitOrientation(boolean verticalSplit) {
        this.mySplitter.setOrientation(verticalSplit);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/execution/serviceView/ServiceViewTreeUi";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionProvider";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/execution/serviceView/ServiceViewTreeUi";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setServiceToolbar";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setMasterComponent";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setNavBar";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static class MyPanel
    extends JPanel
    implements UiDataProvider {
        MyPanel() {
            super(new BorderLayout());
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            if (sink == null) {
                MyPanel.$$$reportNull$$$0(0);
            }
            sink.set(ServiceViewActionUtils.IS_FROM_TREE_KEY, (Object)true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/platform/execution/serviceView/ServiceViewTreeUi$MyPanel", "uiDataSnapshot"));
        }
    }

    private static class NavBarWrapper
    extends JPanel {
        private final JScrollPane myScrollPane;
        private final Border mySideBorder;
        private final Border myNavBarBorder;

        NavBarWrapper(JComponent component) {
            super(new BorderLayout());
            this.myScrollPane = ScrollPaneFactory.createScrollPane((Component)component);
            this.myScrollPane.setVerticalScrollBarPolicy(21);
            this.myScrollPane.setHorizontalScrollBar(null);
            this.mySideBorder = JBUI.Borders.empty();
            this.myNavBarBorder = new NavBarBorder();
            this.myScrollPane.setBorder(this.mySideBorder);
            this.add((Component)this.myScrollPane, "Center");
        }

        @Override
        public void doLayout() {
            Rectangle r = this.getBounds();
            Insets insets = this.getInsets();
            int x = insets.left;
            Dimension preferredSize = this.myScrollPane.getPreferredSize();
            this.myScrollPane.setBounds(x, (r.height - preferredSize.height) / 2, r.width - insets.left - insets.right, preferredSize.height);
        }

        void updateScrollPaneBorder(boolean isSideComponent) {
            Border border;
            Border border2 = border = isSideComponent ? this.mySideBorder : this.myNavBarBorder;
            if (this.myScrollPane.getBorder() != border) {
                this.myScrollPane.setBorder(border);
            }
        }
    }
}

