/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.artifact.resolve.internal;

import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.transfer.artifact.resolve.ArtifactResult;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Invoker;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Maven30ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.internal.Maven31ArtifactResolver;
import org.apache.maven.shared.transfer.artifact.resolve.internal.MavenArtifactResolver;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.sonatype.aether.RepositorySystem;
import org.sonatype.aether.RepositorySystemSession;

@Component(role=ArtifactResolver.class, hint="default")
class DefaultArtifactResolver
implements ArtifactResolver,
Contextualizable {
    private PlexusContainer container;

    DefaultArtifactResolver() {
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, Artifact mavenArtifact) throws ArtifactResolverException, IllegalArgumentException {
        this.validateParameters(buildingRequest, mavenArtifact);
        try {
            return this.getMavenArtifactResolver(buildingRequest).resolveArtifact(mavenArtifact);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }

    @Override
    public ArtifactResult resolveArtifact(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) throws ArtifactResolverException, IllegalArgumentException {
        this.validateParameters(buildingRequest, coordinate);
        try {
            return this.getMavenArtifactResolver(buildingRequest).resolveArtifact(coordinate);
        }
        catch (ComponentLookupException e) {
            throw new ArtifactResolverException(e.getMessage(), e);
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Artifact mavenArtifact) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (mavenArtifact == null) {
            throw new IllegalArgumentException("The parameter mavenArtifact is not allowed to be null.");
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, ArtifactCoordinate coordinate) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (coordinate == null) {
            throw new IllegalArgumentException("The parameter coordinate is not allowed to be null.");
        }
    }

    private boolean isMaven31() {
        try {
            Thread.currentThread().getContextClassLoader().loadClass("org.eclipse.aether.artifact.Artifact");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    @Override
    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get("plexus");
    }

    private MavenArtifactResolver getMavenArtifactResolver(ProjectBuildingRequest buildingRequest) throws ComponentLookupException, ArtifactResolverException {
        if (this.isMaven31()) {
            org.eclipse.aether.RepositorySystem repositorySystem = this.container.lookup(org.eclipse.aether.RepositorySystem.class);
            List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
            org.eclipse.aether.RepositorySystemSession session = (org.eclipse.aether.RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
            return new Maven31ArtifactResolver(repositorySystem, aetherRepositories, session);
        }
        RepositorySystem repositorySystem = this.container.lookup(RepositorySystem.class);
        List aetherRepositories = (List)Invoker.invoke(RepositoryUtils.class, "toRepos", List.class, buildingRequest.getRemoteRepositories());
        RepositorySystemSession session = (RepositorySystemSession)Invoker.invoke(buildingRequest, "getRepositorySession");
        return new Maven30ArtifactResolver(repositorySystem, aetherRepositories, session);
    }
}

