/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.core.nio.fs;

import com.intellij.platform.core.nio.fs.MultiRoutingFileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

final class MultiRoutingFsPath
implements Path {
    private final Path myDelegate;
    private final MultiRoutingFileSystem myFileSystem;

    MultiRoutingFsPath(MultiRoutingFileSystem fileSystem, Path delegate) {
        this.myDelegate = delegate;
        this.myFileSystem = fileSystem;
    }

    public Path getDelegate() {
        return this.myDelegate;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.myFileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.myDelegate.isAbsolute();
    }

    @Override
    public Path getRoot() {
        return this.wrap(this.myDelegate.getRoot());
    }

    @Override
    public Path getFileName() {
        return this.wrap(this.myDelegate.getFileName());
    }

    @Override
    public Path getParent() {
        return this.wrap(this.myDelegate.getParent());
    }

    @Override
    public int getNameCount() {
        return this.myDelegate.getNameCount();
    }

    @Override
    public Path getName(int index) {
        return this.wrap(this.myDelegate.getName(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return this.wrap(this.myDelegate.subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof MultiRoutingFsPath)) {
            return false;
        }
        return this.myDelegate.startsWith(MultiRoutingFsPath.unwrap(other));
    }

    @Override
    public boolean startsWith(String other) {
        return this.myDelegate.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(other instanceof MultiRoutingFsPath)) {
            return false;
        }
        return this.myDelegate.endsWith(MultiRoutingFsPath.unwrap(other));
    }

    @Override
    public boolean endsWith(String other) {
        return this.myDelegate.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this.wrap(this.myDelegate.normalize());
    }

    @Override
    public Path resolve(Path other) {
        return this.wrap(this.myDelegate.resolve(MultiRoutingFsPath.unwrap(other)));
    }

    @Override
    public Path resolve(String other) {
        return this.wrap(this.myDelegate.resolve(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.wrap(this.myDelegate.resolveSibling(MultiRoutingFsPath.unwrap(other)));
    }

    @Override
    public Path resolveSibling(String other) {
        return this.wrap(this.myDelegate.resolveSibling(other));
    }

    @Override
    public Path relativize(Path other) {
        return this.wrap(this.myDelegate.relativize(MultiRoutingFsPath.unwrap(other)));
    }

    @Override
    public URI toUri() {
        return this.myDelegate.toUri();
    }

    @Override
    public Path toAbsolutePath() {
        return this.wrap(this.myDelegate.toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return this.wrap(this.myDelegate.toRealPath(options));
    }

    @Override
    public File toFile() {
        if (this.getFileSystem().provider().getScheme().equals("file")) {
            return new File(this.myDelegate.toString());
        }
        return this.myDelegate.toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return this.myDelegate.register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return this.myDelegate.register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        final Iterator<Path> iterator = this.myDelegate.iterator();
        return new Iterator<Path>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Path next() {
                return MultiRoutingFsPath.this.wrap((Path)iterator.next());
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        return this.myDelegate.compareTo(MultiRoutingFsPath.unwrap(other));
    }

    @Override
    public String toString() {
        return this.myDelegate.toString();
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private MultiRoutingFsPath wrap(@Nullable Path path) {
        if (path == null) {
            return null;
        }
        if (path instanceof MultiRoutingFsPath) {
            return (MultiRoutingFsPath)path;
        }
        return new MultiRoutingFsPath(this.myFileSystem, path);
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private static Path unwrap(@Nullable Path path) {
        return path == null ? null : ((MultiRoutingFsPath)path).getDelegate();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultiRoutingFsPath paths = (MultiRoutingFsPath)o;
        return Objects.equals(this.myDelegate, paths.myDelegate) && Objects.equals(this.myFileSystem, paths.myFileSystem);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.myDelegate, this.myFileSystem);
    }
}

