/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.java.ui;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntRef;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.plugin.ui.StructuralSearchTemplateBuilder;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JavaStructuralSearchTemplateBuilder
extends StructuralSearchTemplateBuilder {
    JavaStructuralSearchTemplateBuilder() {
    }

    public TemplateBuilder buildTemplate(@NotNull PsiFile psiFile) {
        int textOffset;
        if (psiFile == null) {
            JavaStructuralSearchTemplateBuilder.$$$reportNull$$$0(0);
        }
        final TemplateBuilder builder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)psiFile);
        final PlaceholderCount classCount = new PlaceholderCount("Class");
        final PlaceholderCount varCount = new PlaceholderCount("Var");
        final PlaceholderCount funCount = new PlaceholderCount("Fun");
        final IntRef shift = new IntRef();
        JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

            public void visitIdentifier(@NotNull PsiIdentifier identifier) {
                PsiElement parent;
                if (identifier == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((parent = identifier.getParent()) instanceof PsiClass) {
                    JavaStructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, classCount, true, builder, shift.get());
                } else if (parent instanceof PsiReferenceExpression) {
                    if (parent.getParent() instanceof PsiMethodCallExpression) {
                        JavaStructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, funCount, true, builder, shift.get());
                    } else {
                        JavaStructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, varCount, false, builder, shift.get());
                    }
                } else if (parent instanceof PsiJavaCodeReferenceElement) {
                    JavaStructuralSearchTemplateBuilder.this.replaceElement((PsiElement)identifier, classCount, false, builder, shift.get());
                }
            }

            public void visitReferenceList(@NotNull PsiReferenceList list) {
                PsiJavaCodeReferenceElement[] elements;
                if (list == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (PsiJavaCodeReferenceElement element : elements = list.getReferenceElements()) {
                    JavaStructuralSearchTemplateBuilder.this.replaceElement(element.getReferenceNameElement(), classCount, false, builder, shift.get());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "identifier";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "list";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/structuralsearch/java/ui/JavaStructuralSearchTemplateBuilder$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitIdentifier";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceList";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        String text = psiFile.getText();
        for (textOffset = 0; textOffset < text.length() && StringUtil.isWhiteSpace((char)text.charAt(textOffset)); ++textOffset) {
        }
        shift.set(shift.get() - textOffset);
        PsiElement[] elements = MatcherImplUtil.createTreeFromText((String)text, (PatternTreeContext)PatternTreeContext.Block, (LanguageFileType)((LanguageFileType)psiFile.getFileType()), (Project)psiFile.getProject());
        if (elements.length > 0) {
            PsiElement element = elements[0];
            shift.set(shift.get() + element.getTextRange().getStartOffset());
            element.accept((PsiElementVisitor)visitor);
        }
        return builder;
    }

    void replaceElement(@Nullable PsiElement element, PlaceholderCount count, boolean preferOriginal, TemplateBuilder builder, int shift) {
        if (element == null) {
            return;
        }
        String placeholder = count.getPlaceholder();
        String originalText = element.getText();
        Object[] elements = new LookupElement[]{LookupElementBuilder.create((String)placeholder), LookupElementBuilder.create((String)originalText)};
        builder.replaceRange(element.getTextRange().shiftLeft(shift), (Expression)new ConstantNode(preferOriginal ? originalText : placeholder).withLookupItems((LookupElement[])(preferOriginal ? (LookupElement[])ArrayUtil.reverseArray((Object[])elements) : elements)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/structuralsearch/java/ui/JavaStructuralSearchTemplateBuilder", "buildTemplate"));
    }

    private static final class PlaceholderCount {
        private final String myName;
        private int myCount;

        private PlaceholderCount(String name) {
            this.myName = name;
        }

        public String getPlaceholder() {
            return "$" + this.myName + ++this.myCount + "$";
        }
    }
}

