/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperator;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.TopLevelFIF;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\nB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/StringPlusCharFIF;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/FunctionIntrinsicFactory;", "<init>", "()V", "getIntrinsic", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "StringPlusAnyIntrinsic", "js.translator"})
public final class StringPlusCharFIF
implements FunctionIntrinsicFactory {
    @NotNull
    public static final StringPlusCharFIF INSTANCE = new StringPlusCharFIF();

    private StringPlusCharFIF() {
    }

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor, @NotNull TranslationContext context) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = DescriptorUtilsKt.getFqNameUnsafe(descriptor).asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String fqName = string;
        if (!Intrinsics.areEqual((Object)fqName, (Object)"kotlin.String.plus") && !Intrinsics.areEqual((Object)fqName, (Object)"kotlin.plus")) {
            return null;
        }
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor.getDispatchReceiverParameter();
        if (receiverParameterDescriptor == null && (receiverParameterDescriptor = descriptor.getExtensionReceiverParameter()) == null) {
            return null;
        }
        KotlinType kotlinType = receiverParameterDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType leftType = kotlinType;
        return KotlinBuiltIns.isStringOrNullableString(leftType) ? (FunctionIntrinsic)new StringPlusAnyIntrinsic(TypeUtils.isNullableType(leftType)) : null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/factories/StringPlusCharFIF$StringPlusAnyIntrinsic;", "Lorg/jetbrains/kotlin/js/translate/intrinsic/functions/basic/FunctionIntrinsic;", "leftTypeNullable", "", "<init>", "(Z)V", "apply", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "callInfo", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "arguments", "", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "js.translator"})
    private static final class StringPlusAnyIntrinsic
    extends FunctionIntrinsic {
        private final boolean leftTypeNullable;

        public StringPlusAnyIntrinsic(boolean leftTypeNullable) {
            this.leftTypeNullable = leftTypeNullable;
        }

        @Override
        @NotNull
        public JsExpression apply(@NotNull CallInfo callInfo, @NotNull List<? extends JsExpression> arguments, @NotNull TranslationContext context) {
            Intrinsics.checkNotNullParameter((Object)callInfo, (String)"callInfo");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            JsExpression jsExpression = callInfo.getDispatchReceiver();
            if (jsExpression == null) {
                JsExpression jsExpression2 = callInfo.getExtensionReceiver();
                jsExpression = jsExpression2;
                Intrinsics.checkNotNull((Object)jsExpression2);
            }
            JsExpression receiver = jsExpression;
            BindingContext bindingContext = context.bindingContext();
            KtExpression ktExpression = callInfo.getResolvedCall().getCall().getValueArguments().get(0).getArgumentExpression();
            Intrinsics.checkNotNull((Object)ktExpression);
            KotlinType kotlinType = bindingContext.getType(ktExpression);
            if (kotlinType == null) {
                KotlinType kotlinType2 = callInfo.getResolvedCall().getResultingDescriptor().getValueParameters().get(0).getType();
                kotlinType = kotlinType2;
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            }
            KotlinType rightType = kotlinType;
            boolean rightTypeNullable = TypeUtils.isNullableType(rightType);
            boolean hasNonNullArg = !this.leftTypeNullable || !rightTypeNullable;
            JsExpression jsExpression3 = KotlinBuiltIns.isChar(rightType) ? JsAstUtils.charToString(arguments.get(0)) : (KotlinBuiltIns.isStringOrNullableString(rightType) && hasNonNullArg ? arguments.get(0) : TopLevelFIF.TO_STRING.apply(arguments.get(0), (List<? extends JsExpression>)CollectionsKt.emptyList(), context));
            Intrinsics.checkNotNull((Object)jsExpression3);
            JsExpression rightExpr = jsExpression3;
            return new JsBinaryOperation(JsBinaryOperator.ADD, receiver, rightExpr);
        }
    }
}

