/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.clean;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsPropertyInitializer;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.clean.ReferenceTracker;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.CollectionUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00052\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00052\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u001c\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00192\n\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\u0018\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0010\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0012\u0010\u001e\u001a\u00020\u00132\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0012\u0010!\u001a\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/JsVisitorWithContextImpl;", "functions", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "<init>", "(Ljava/util/Map;)V", "tracker", "Lorg/jetbrains/kotlin/js/inline/clean/ReferenceTracker;", "processed", "", "removableFunctions", "", "getRemovableFunctions", "()Ljava/util/List;", "process", "", "visit", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsPropertyInitializer;", "ctx", "Lorg/jetbrains/kotlin/js/backend/ast/JsContext;", "endVisit", "Lorg/jetbrains/kotlin/js/backend/ast/JsNameRef;", "processLocalFunction", "name", "function", "processNonLocalFunction", "isFunctionReference", "nameRef", "Lorg/jetbrains/kotlin/js/backend/ast/HasName;", "wasProcessed", "js.translator"})
@SourceDebugExtension(value={"SMAP\nremoveUnusedFunctionDefinitions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 removeUnusedFunctionDefinitions.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,114:1\n535#2:115\n520#2,6:116\n216#3,2:122\n*S KotlinDebug\n*F\n+ 1 removeUnusedFunctionDefinitions.kt\norg/jetbrains/kotlin/js/inline/clean/UnusedLocalFunctionsCollector\n*L\n59#1:115\n59#1:116,6\n60#1:122,2\n*E\n"})
final class UnusedLocalFunctionsCollector
extends JsVisitorWithContextImpl {
    @NotNull
    private final Map<JsName, JsFunction> functions;
    @NotNull
    private final ReferenceTracker<JsName, JsFunction> tracker;
    @NotNull
    private final Set<JsFunction> processed;

    public UnusedLocalFunctionsCollector(@NotNull Map<JsName, JsFunction> functions) {
        Intrinsics.checkNotNullParameter(functions, (String)"functions");
        this.functions = functions;
        this.tracker = new ReferenceTracker();
        this.processed = CollectionUtilsKt.IdentitySet();
    }

    @NotNull
    public final List<JsFunction> getRemovableFunctions() {
        return this.tracker.getRemovable();
    }

    public final void process() {
        Iterator $this$filterTo$iv$iv;
        Map<JsName, JsFunction> $this$filter$iv = this.functions;
        boolean $i$f$filter = false;
        Map<JsName, JsFunction> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator2.next();
            boolean bl = false;
            if (!MetadataProperties.isLocal((JsFunction)it.getValue())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$forEach$iv = destination$iv$iv;
        boolean $i$f$forEach = false;
        $this$filterTo$iv$iv = $this$forEach$iv.entrySet().iterator();
        while ($this$filterTo$iv$iv.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = $this$filterTo$iv$iv.next();
            boolean bl = false;
            this.tracker.addCandidateForRemoval((JsName)it.getKey(), (JsFunction)((JsNode)it.getValue()));
        }
        for (Map.Entry<JsName, JsFunction> entry : this.functions.entrySet()) {
            JsName name = entry.getKey();
            JsFunction function2 = entry.getValue();
            if (MetadataProperties.isLocal(function2)) {
                this.processLocalFunction(name, function2);
            } else {
                this.processNonLocalFunction(function2);
            }
            this.processed.add(function2);
        }
    }

    public boolean visit(@NotNull JsPropertyInitializer x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsExpression jsExpression = x.getValueExpr();
        Intrinsics.checkNotNullExpressionValue((Object)jsExpression, (String)"getValueExpr(...)");
        JsExpression value = jsExpression;
        return value instanceof JsFunction ? !this.wasProcessed((JsFunction)value) : super.visit(x, ctx);
    }

    public boolean visit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        return !this.wasProcessed(x);
    }

    public void endVisit(@NotNull JsFunction x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.processed.add(x);
    }

    public void endVisit(@NotNull JsNameRef x, @NotNull JsContext<?> ctx) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        JsName name = x.getName();
        if (this.isFunctionReference(x) && name != null) {
            this.tracker.markReachable(name);
        }
    }

    private final void processLocalFunction(JsName name, JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.addRemovableReference(name, referenced);
        }
    }

    private final void processNonLocalFunction(JsFunction function2) {
        for (JsName referenced : CollectUtilsKt.collectReferencedNames(function2)) {
            this.tracker.markReachable(referenced);
        }
    }

    private final boolean isFunctionReference(HasName nameRef) {
        Object object = nameRef;
        return (object != null && (object = object.getName()) != null ? MetadataProperties.getStaticRef((JsName)object) : null) instanceof JsFunction;
    }

    private final boolean wasProcessed(JsFunction function2) {
        return function2 != null && this.processed.contains(function2);
    }
}

