/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.wasm.ir2wasm;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmBackendContext;
import org.jetbrains.kotlin.backend.wasm.WasmSymbols;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassInfoKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.ClassMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.DeclarationGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LocationUtilsKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.LoopLabelType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.OptimisedWhenGeneratorKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.SyntheticLocalType;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.TypeTransformerKt;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.VirtualMethodMetadata;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmFunctionCodegenContext;
import org.jetbrains.kotlin.backend.wasm.ir2wasm.WasmModuleCodegenContext;
import org.jetbrains.kotlin.backend.wasm.lower.JsExceptionRevealOrigin;
import org.jetbrains.kotlin.backend.wasm.utils.AnnotationsKt;
import org.jetbrains.kotlin.backend.wasm.utils.DisjointUnions;
import org.jetbrains.kotlin.backend.wasm.utils.UtilsKt;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.PrimaryConstructorLowering;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.TypeTranformerKt;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DumpKotlinLikeKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.wasm.config.WasmConfigurationKeys;
import org.jetbrains.kotlin.wasm.ir.WasmAnyRef;
import org.jetbrains.kotlin.wasm.ir.WasmExpressionBuilder;
import org.jetbrains.kotlin.wasm.ir.WasmHeapType;
import org.jetbrains.kotlin.wasm.ir.WasmI16;
import org.jetbrains.kotlin.wasm.ir.WasmI32;
import org.jetbrains.kotlin.wasm.ir.WasmI64;
import org.jetbrains.kotlin.wasm.ir.WasmI8;
import org.jetbrains.kotlin.wasm.ir.WasmImmediate;
import org.jetbrains.kotlin.wasm.ir.WasmImmediateKind;
import org.jetbrains.kotlin.wasm.ir.WasmLocal;
import org.jetbrains.kotlin.wasm.ir.WasmOp;
import org.jetbrains.kotlin.wasm.ir.WasmRefNullType;
import org.jetbrains.kotlin.wasm.ir.WasmSymbol;
import org.jetbrains.kotlin.wasm.ir.WasmSymbolReadOnly;
import org.jetbrains.kotlin.wasm.ir.WasmType;
import org.jetbrains.kotlin.wasm.ir.WasmTypeDeclaration;
import org.jetbrains.kotlin.wasm.ir.source.location.SourceLocation;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\n\u0010$\u001a\u00020%*\u00020\u0010J\u0015\u0010&\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020%2\u0006\u0010+\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020%2\u0006\u0010/\u001a\u000200H\u0016J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0018\u00107\u001a\u00020%2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u000206H\u0002J\u0010\u00108\u001a\u00020%2\u0006\u0010'\u001a\u000204H\u0016J\u0010\u00109\u001a\u00020%2\u0006\u0010'\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020%2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020%2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010?\u001a\u00020%2\u0006\u0010<\u001a\u00020=H\u0002J\u0010\u0010@\u001a\u00020%2\u0006\u0010'\u001a\u00020AH\u0016J\u0014\u0010B\u001a\u00020%2\n\u0010'\u001a\u0006\u0012\u0002\b\u00030CH\u0016J\u0010\u0010D\u001a\u00020%2\u0006\u0010'\u001a\u00020EH\u0016J\u0018\u0010F\u001a\u00020%2\u0006\u0010G\u001a\u00020 2\u0006\u0010H\u001a\u00020IH\u0002J\u0010\u0010J\u001a\u00020%2\u0006\u0010'\u001a\u00020KH\u0016J\u0010\u0010L\u001a\u00020%2\u0006\u0010'\u001a\u00020MH\u0016J\u0010\u0010N\u001a\u00020%2\u0006\u0010'\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020%2\u0006\u0010'\u001a\u00020QH\u0016J\u0010\u0010R\u001a\u00020%2\u0006\u0010'\u001a\u00020SH\u0016J\u0018\u0010T\u001a\u00020%2\u0006\u0010U\u001a\u00020\b2\u0006\u0010H\u001a\u00020IH\u0002J\u000e\u0010V\u001a\u00020%2\u0006\u0010W\u001a\u00020XJ\u0010\u0010Y\u001a\u00020%2\u0006\u0010'\u001a\u00020ZH\u0016J\u0018\u0010[\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010\\\u001a\u00020]H\u0002J\u0010\u0010^\u001a\u00020%2\u0006\u0010_\u001a\u00020`H\u0002J \u0010a\u001a\u00020%2\u0006\u0010b\u001a\u00020]2\u0006\u0010c\u001a\u00020]2\u0006\u0010H\u001a\u00020IH\u0002J \u0010d\u001a\u00020%2\u0006\u0010b\u001a\u00020]2\u0006\u0010c\u001a\u00020]2\u0006\u0010H\u001a\u00020IH\u0002J \u0010e\u001a\u00020%2\u0006\u0010b\u001a\u00020]2\u0006\u0010c\u001a\u00020]2\u0006\u0010H\u001a\u00020IH\u0002J\u0018\u0010f\u001a\u0002022\u0006\u0010b\u001a\u00020]2\u0006\u0010c\u001a\u00020]H\u0002J\u0018\u0010g\u001a\u0002022\u0006\u0010_\u001a\u00020`2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020%2\u0006\u0010\u000f\u001a\u00020kH\u0016J\u0010\u0010l\u001a\u00020%2\u0006\u0010m\u001a\u00020nH\u0016J\u0010\u0010o\u001a\u00020%2\u0006\u0010'\u001a\u00020pH\u0002J\u0010\u0010q\u001a\u00020%2\u0006\u0010'\u001a\u00020pH\u0016J\u0010\u0010r\u001a\u00020%2\u0006\u0010'\u001a\u00020pH\u0002J\u0010\u0010s\u001a\u00020%2\u0006\u0010'\u001a\u00020pH\u0002J\u0010\u0010t\u001a\u00020%2\u0006\u0010u\u001a\u00020vH\u0016J\u0010\u0010w\u001a\u00020%2\u0006\u0010u\u001a\u00020xH\u0016J\u0010\u0010y\u001a\u00020%2\u0006\u0010'\u001a\u00020zH\u0002J\u001d\u0010{\u001a\u00020%2\u0006\u0010'\u001a\u00020(2\u0006\u0010|\u001a\u00020]H\u0000\u00a2\u0006\u0002\b}J \u0010~\u001a\u00020%2\u0006\u0010\u007f\u001a\u00020]2\u0006\u0010|\u001a\u00020]2\u0006\u0010H\u001a\u00020IH\u0002J\u0011\u0010\u0080\u0001\u001a\u00020%2\u0006\u0010'\u001a\u00020zH\u0016J\u0012\u0010\u0081\u0001\u001a\u00020%2\u0007\u0010'\u001a\u00030\u0082\u0001H\u0016J\u0013\u0010\u0083\u0001\u001a\u00020%2\b\u0010\u0084\u0001\u001a\u00030\u0085\u0001H\u0016J\u0013\u0010\u0086\u0001\u001a\u00020%2\b\u0010\u0084\u0001\u001a\u00030\u0087\u0001H\u0016J\u0013\u0010\u0088\u0001\u001a\u00020%2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u0019\u0010\u008b\u0001\u001a\u0002022\u0006\u0010_\u001a\u00020`2\u0006\u0010h\u001a\u00020iH\u0002J\r\u0010\u008c\u0001\u001a\u00020I*\u000200H\u0002J\r\u0010\u008d\u0001\u001a\u00020I*\u000200H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u001b\u0010\u001cR\u001b\u0010\u001f\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b#\u0010\u001e\u001a\u0004\b!\u0010\"\u00a8\u0006\u008e\u0001"}, d2={"Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitorVoid;", "context", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "functionContext", "Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "hierarchyDisjointUnions", "Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "<init>", "(Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;Lorg/jetbrains/kotlin/backend/wasm/utils/DisjointUnions;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmModuleCodegenContext;", "getFunctionContext", "()Lorg/jetbrains/kotlin/backend/wasm/ir2wasm/WasmFunctionCodegenContext;", "body", "Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "getBody", "()Lorg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder;", "backendContext", "Lorg/jetbrains/kotlin/backend/wasm/WasmBackendContext;", "wasmSymbols", "Lorg/jetbrains/kotlin/backend/wasm/WasmSymbols;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "unitGetInstance", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getUnitGetInstance", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "unitGetInstance$delegate", "Lkotlin/Lazy;", "unitInstanceField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "getUnitInstanceField", "()Lorg/jetbrains/kotlin/ir/declarations/IrField;", "unitInstanceField$delegate", "buildGetUnit", "", "generateExpression", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "generateExpression$backend_wasm", "generateAsStatement", "statement", "generateStatement", "Lorg/jetbrains/kotlin/ir/IrStatement;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "tryGenerateConstVarargArray", "", "irVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "wasmArrayType", "Lorg/jetbrains/kotlin/wasm/ir/WasmImmediate$GcType;", "tryGenerateVarargArray", "visitVararg", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "generateTryFollowingNewProposal", "generateTryFollowingOldProposal", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitConst", "Lorg/jetbrains/kotlin/ir/expressions/IrConst;", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "generateInstanceFieldAccess", "field", "location", "Lorg/jetbrains/kotlin/wasm/ir/source/location/SourceLocation;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "generateAnyParameters", "klassSymbol", "generateObjectCreationPrefixIfNeeded", "constructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitDelegatingConstructorCall", "Lorg/jetbrains/kotlin/ir/expressions/IrDelegatingConstructorCall;", "generateBox", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "generateCall", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "generateRefNullCast", "fromType", "toType", "generateRefCast", "generateRefTest", "isDownCastAlwaysSuccessInRuntime", "tryToGenerateIntrinsicCall", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "visitBlockBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBlockBody;", "visitInlinedFunctionBlock", "inlinedBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrInlinedFunctionBlock;", "processContainerExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "visitContainerExpression", "generateTryCatchAllFollowingNewProposal", "generateTryCatchAllFollowingOldProposal", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "visitFunctionReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "generateWithExpectedType", "expectedType", "generateWithExpectedType$backend_wasm", "recoverToExpectedType", "actualType", "visitReturn", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitDoWhileLoop", "loop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitVariable", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "tryToGenerateWasmOpIntrinsicCall", "getSourceLocation", "getSourceEndLocation", "backend.wasm"})
@SourceDebugExtension(value={"SMAP\nBodyGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 WasmExpressionBuilder.kt\norg/jetbrains/kotlin/wasm/ir/WasmExpressionBuilder\n*L\n1#1,1175:1\n1755#2,3:1176\n1557#2:1179\n1628#2,3:1180\n1557#2:1183\n1628#2,3:1184\n1557#2:1187\n1628#2,3:1188\n1557#2:1191\n1628#2,3:1192\n1557#2:1195\n1628#2,3:1196\n1557#2:1199\n1628#2,3:1200\n1863#2,2:1203\n1872#2,3:1238\n360#2,7:1243\n360#2,7:1254\n1863#2,2:1276\n1872#2,3:1280\n183#3,2:1205\n1#4:1207\n52#5,3:1208\n52#5,5:1211\n55#5,2:1216\n267#5,2:1218\n267#5,2:1220\n267#5,2:1222\n267#5,2:1224\n267#5,2:1226\n267#5,2:1228\n267#5,2:1230\n267#5,2:1232\n271#5,2:1234\n271#5,2:1236\n267#5,2:1241\n271#5,2:1250\n271#5,2:1252\n52#5,3:1261\n52#5,5:1264\n55#5,2:1269\n52#5,5:1271\n271#5,2:1278\n52#5,3:1283\n52#5,3:1286\n50#5,7:1289\n55#5,2:1296\n55#5,2:1298\n267#5,2:1300\n58#5,5:1302\n50#5,5:1307\n50#5,7:1312\n55#5,2:1319\n63#5,2:1321\n58#5,5:1323\n50#5,7:1328\n63#5,2:1335\n*S KotlinDebug\n*F\n+ 1 BodyGenerator.kt\norg/jetbrains/kotlin/backend/wasm/ir2wasm/BodyGenerator\n*L\n87#1:1176,3\n89#1:1179\n89#1:1180,3\n92#1:1183\n92#1:1184,3\n93#1:1187\n93#1:1188,3\n94#1:1191\n94#1:1192,3\n95#1:1195\n95#1:1196,3\n96#1:1199\n96#1:1200,3\n111#1:1203,2\n425#1:1238,3\n516#1:1243,7\n544#1:1254,7\n746#1:1276,2\n772#1:1280,3\n125#1:1205,2\n195#1:1208,3\n196#1:1211,5\n195#1:1216,2\n285#1:1218,2\n308#1:1220,2\n325#1:1222,2\n329#1:1224,2\n347#1:1226,2\n353#1:1228,2\n380#1:1230,2\n390#1:1232,2\n400#1:1234,2\n418#1:1236,2\n456#1:1241,2\n522#1:1250,2\n536#1:1252,2\n633#1:1261,3\n634#1:1264,5\n633#1:1269,2\n700#1:1271,5\n764#1:1278,2\n835#1:1283,3\n836#1:1286,3\n837#1:1289,7\n836#1:1296,2\n835#1:1298,2\n1008#1:1300,2\n1070#1:1302,5\n1071#1:1307,5\n1072#1:1312,7\n1071#1:1319,2\n1070#1:1321,2\n1094#1:1323,5\n1095#1:1328,7\n1094#1:1335,2\n*E\n"})
public final class BodyGenerator
implements IrElementVisitorVoid {
    @NotNull
    private final WasmModuleCodegenContext context;
    @NotNull
    private final WasmFunctionCodegenContext functionContext;
    @NotNull
    private final DisjointUnions<IrClassSymbol> hierarchyDisjointUnions;
    @NotNull
    private final WasmExpressionBuilder body;
    @NotNull
    private final WasmBackendContext backendContext;
    @NotNull
    private final WasmSymbols wasmSymbols;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final Lazy unitGetInstance$delegate;
    @NotNull
    private final Lazy unitInstanceField$delegate;

    public BodyGenerator(@NotNull WasmModuleCodegenContext context, @NotNull WasmFunctionCodegenContext functionContext, @NotNull DisjointUnions<IrClassSymbol> hierarchyDisjointUnions) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)functionContext, (String)"functionContext");
        Intrinsics.checkNotNullParameter(hierarchyDisjointUnions, (String)"hierarchyDisjointUnions");
        this.context = context;
        this.functionContext = functionContext;
        this.hierarchyDisjointUnions = hierarchyDisjointUnions;
        this.body = this.functionContext.getBodyGen();
        this.backendContext = this.context.getBackendContext();
        this.wasmSymbols = this.backendContext.getWasmSymbols();
        this.irBuiltIns = this.backendContext.getIrBuiltIns();
        this.unitGetInstance$delegate = LazyKt.lazy(() -> BodyGenerator.unitGetInstance_delegate$lambda$0(this));
        this.unitInstanceField$delegate = LazyKt.lazy(() -> BodyGenerator.unitInstanceField_delegate$lambda$1(this));
    }

    @NotNull
    public final WasmModuleCodegenContext getContext() {
        return this.context;
    }

    @NotNull
    public final WasmFunctionCodegenContext getFunctionContext() {
        return this.functionContext;
    }

    @NotNull
    public final WasmExpressionBuilder getBody() {
        return this.body;
    }

    private final IrSimpleFunction getUnitGetInstance() {
        Lazy lazy = this.unitGetInstance$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    private final IrField getUnitInstanceField() {
        Lazy lazy = this.unitInstanceField$delegate;
        return (IrField)lazy.getValue();
    }

    public final void buildGetUnit(@NotNull WasmExpressionBuilder $this$buildGetUnit) {
        Intrinsics.checkNotNullParameter((Object)$this$buildGetUnit, (String)"<this>");
        $this$buildGetUnit.buildGetGlobal(this.context.referenceGlobalField(this.getUnitInstanceField().getSymbol()), SourceLocation.Companion.NoLocation("GET_UNIT"));
    }

    public final void generateExpression$backend_wasm(@NotNull IrExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)expression2), (IrElementVisitorVoid)this);
        if (IrTypePredicatesKt.isNothing((IrType)expression2.getType())) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
        }
    }

    private final void generateAsStatement(IrExpression statement) {
        this.generateExpression$backend_wasm(statement);
        if (!Intrinsics.areEqual((Object)statement.getType(), (Object)this.wasmSymbols.getVoidType())) {
            this.body.buildDrop(SourceLocation.Companion.NoLocation("DROP"));
        }
    }

    private final void generateStatement(IrStatement statement) {
        IrStatement irStatement = statement;
        if (irStatement instanceof IrExpression) {
            this.generateAsStatement((IrExpression)statement);
        } else if (irStatement instanceof IrVariable) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)statement), (IrElementVisitorVoid)this);
        } else {
            throw new IllegalStateException(("Unsupported node type: " + Reflection.getOrCreateKotlinClass(statement.getClass()).getSimpleName()).toString());
        }
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        throw new IllegalStateException(("Unexpected element of type " + Reflection.getOrCreateKotlinClass(element.getClass())).toString());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryGenerateConstVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType) {
        Pair pair;
        Object it;
        Iterable $this$mapTo$iv$iv;
        boolean $i$f$mapTo;
        Collection destination$iv$iv;
        boolean $i$f$map;
        Iterable $this$map$iv;
        Collection collection;
        Object object;
        void $this$mapTo$iv$iv2;
        Object element$iv2;
        boolean bl;
        block23: {
            if (irVararg.getElements().isEmpty()) {
                return false;
            }
            Object e = irVararg.getElements().get(0);
            IrConst irConst = e instanceof IrConst ? (IrConst)e : null;
            if (irConst == null || (irConst = irConst.getKind()) == null) {
                return false;
            }
            IrConst kind = irConst;
            if (Intrinsics.areEqual((Object)kind, (Object)IrConstKind.String.INSTANCE) || Intrinsics.areEqual((Object)kind, (Object)IrConstKind.Null.INSTANCE)) {
                return false;
            }
            Iterable $this$any$iv = irVararg.getElements();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $this$any$iv) {
                    IrVarargElement it2 = (IrVarargElement)element$iv2;
                    boolean bl2 = false;
                    if (!(!(it2 instanceof IrConst) || !Intrinsics.areEqual((Object)((IrConst)it2).getKind(), (Object)kind))) continue;
                    bl = true;
                    break block23;
                }
                bl = false;
            }
        }
        if (bl) {
            return false;
        }
        Iterable $this$map$iv2 = irVararg.getElements();
        boolean $i$f$map22 = false;
        element$iv2 = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it3;
            object = (IrVarargElement)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConst<*>");
            Object object2 = ((IrConst)it3).getValue();
            Intrinsics.checkNotNull((Object)object2);
            collection.add(object2);
        }
        List elementConstValues = (List)destination$iv$iv2;
        IrType $i$f$map22 = irVararg.getVarargElementType();
        if (Intrinsics.areEqual((Object)$i$f$map22, (Object)this.irBuiltIns.getByteType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            Iterable $i$f$mapTo22 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv;
                Object e = item$iv$iv = object.next();
                collection = destination$iv$iv;
                boolean bl4 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.Byte");
                collection.add(Long.valueOf(((Byte)it).byteValue()));
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual((Object)$i$f$map22, (Object)this.irBuiltIns.getBooleanType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = object.next();
                collection = destination$iv$iv;
                boolean bl5 = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.Boolean");
                collection.add((Boolean)it != false ? 1L : 0L);
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)WasmI8.INSTANCE);
        } else if (Intrinsics.areEqual((Object)$i$f$map22, (Object)this.irBuiltIns.getIntType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = object.next();
                collection = destination$iv$iv;
                boolean bl6 = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.Int");
                collection.add(Long.valueOf(((Integer)it).intValue()));
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)WasmI32.INSTANCE);
        } else if (Intrinsics.areEqual((Object)$i$f$map22, (Object)this.irBuiltIns.getShortType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = object.next();
                collection = destination$iv$iv;
                boolean bl7 = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.Short");
                collection.add(Long.valueOf(((Short)it).shortValue()));
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)WasmI16.INSTANCE);
        } else if (Intrinsics.areEqual((Object)$i$f$map22, (Object)this.irBuiltIns.getLongType())) {
            $this$map$iv = elementConstValues;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.iterator();
            while (object.hasNext()) {
                Object item$iv$iv;
                it = item$iv$iv = object.next();
                collection = destination$iv$iv;
                boolean bl8 = false;
                Intrinsics.checkNotNull(it, (String)"null cannot be cast to non-null type kotlin.Long");
                collection.add(Long.valueOf((Long)it));
            }
            pair = TuplesKt.to((Object)((List)destination$iv$iv), (Object)WasmI64.INSTANCE);
        } else {
            return false;
        }
        Pair resource = pair;
        WasmSymbol<Integer> constantArrayId = this.context.referenceConstantArray((Pair<? extends List<Long>, ? extends WasmType>)resource);
        SourceLocation location = this.getSourceLocation((IrElement)irVararg);
        boolean bl9 = false;
        this.body.buildConstI32(0, location);
        this.body.buildConstI32(irVararg.getElements().size(), location);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType, new WasmImmediate.DataIdx(constantArrayId)};
        this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        return true;
    }

    private final void tryGenerateVarargArray(IrVararg irVararg, WasmImmediate.GcType wasmArrayType) {
        Iterable $this$forEach$iv = irVararg.getElements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrVarargElement it = (IrVarargElement)element$iv;
            boolean bl = false;
            if (!(it instanceof IrExpression)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            this.generateExpression$backend_wasm((IrExpression)it);
        }
        WasmImmediate.ConstI32 length = new WasmImmediate.ConstI32(irVararg.getElements().size());
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{wasmArrayType, length};
        this.body.buildInstr(WasmOp.ARRAY_NEW_FIXED, this.getSourceLocation((IrElement)irVararg), wasmImmediateArray);
    }

    /*
     * Unable to fully structure code
     */
    public void visitVararg(@NotNull IrVararg expression) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            v0 = IrTypesKt.getClass((IrType)expression.getType());
            Intrinsics.checkNotNull((Object)v0);
            arrayClass = v0;
            var5_3 = SequencesKt.mapNotNull((Sequence)IrUtilsKt.getConstructors((IrClass)arrayClass), (Function1)(Function1)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, visitVararg$lambda$11(org.jetbrains.kotlin.ir.declarations.IrConstructor ), (Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;)Lorg/jetbrains/kotlin/ir/types/IrType;)());
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (IrType)element$iv;
                $i$a$-firstOrNull-BodyGenerator$visitVararg$wasmArrayType$2 = false;
                v1 = IrTypesKt.getClass((IrType)it);
                if (!((v1 != null ? AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)v1) : null) != null)) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        var4_11 = v2;
        if (var4_11 == null || (var5_3 = TypeTransformerKt.getRuntimeClass(var4_11, this.irBuiltIns)) == null || (var6_5 = var5_3.getSymbol()) == null) ** GOTO lbl-1000
        var8_7 = var6_5;
        it = this.context;
        p0 = var8_7;
        $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$3 = false;
        var7_6 = it.referenceGcType(p0);
        if (var7_6 != null) {
            p0 = var7_6;
            $i$a$-let-BodyGenerator$visitVararg$wasmArrayType$4 = false;
            v3 = new WasmImmediate.GcType(p0);
        } else lbl-1000:
        // 2 sources

        {
            v3 = wasmArrayType = null;
        }
        if (!(wasmArrayType != null)) {
            var5_3 = "Check failed.";
            throw new IllegalStateException(var5_3.toString());
        }
        location = this.getSourceLocation((IrElement)expression);
        this.generateAnyParameters(arrayClass.getSymbol(), location);
        if (!this.tryGenerateConstVarargArray(expression, wasmArrayType)) {
            this.tryGenerateVarargArray(expression, wasmArrayType);
        }
        this.body.buildStructNew(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(expression.getType(), this.irBuiltIns).getSymbol()), location);
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        if (this.context.getBackendContext().getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.body.buildUnreachable(SourceLocation.Companion.NoLocation("Unreachable is inserted instead of a `throw` instruction"));
            return;
        }
        this.body.buildThrow(this.functionContext.getTagIdx(), this.getSourceLocation((IrElement)expression2));
    }

    public void visitTry(@NotNull IrTry aTry) {
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        boolean bl = UtilsKt.isCanonical(aTry, this.irBuiltIns);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "expected canonical try/catch";
            throw new AssertionError((Object)string);
        }
        if (this.context.getBackendContext().getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_TRAPS_INSTEAD_OF_EXCEPTIONS)) {
            this.generateExpression$backend_wasm(aTry.getTryResult());
            return;
        }
        if (this.context.getBackendContext().getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_NEW_EXCEPTION_PROPOSAL)) {
            this.generateTryFollowingNewProposal(aTry);
        } else {
            this.generateTryFollowingOldProposal(aTry);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTryFollowingNewProposal(IrTry aTry) {
        void this_$iv;
        void this_$iv2;
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        IrCatch catchBlock = (IrCatch)CollectionsKt.single((List)aTry.getCatches());
        WasmType exceptionType = this.context.transformBlockResultType(catchBlock.getCatchParameter().getType());
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "CATCH_BLOCK";
        boolean $i$f$buildBlock = false;
        int n = this_$iv2.getNumberOfNestedBlocks();
        this_$iv2.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this_$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        int catchBlockLabel = this_$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "TRY_BLOCK";
        boolean $i$f$buildBlock2 = false;
        int n2 = this_$iv.getNumberOfNestedBlocks();
        this_$iv.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(exceptionType)};
        this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int tryBlockLabel = this_$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        this.body.buildTryTable(null, CollectionsKt.listOf((Object)this.body.createNewCatch(this.functionContext.getTagIdx(), tryBlockLabel)), exceptionType);
        this.generateExpression$backend_wasm(aTry.getTryResult());
        this.body.buildBr(catchBlockLabel, SourceLocation.Companion.NoLocation(""));
        this.body.buildEnd();
        this_$iv.buildEnd();
        IrVariableSymbol $this$generateTryFollowingNewProposal_u24lambda_u2417_u24lambda_u2416 = catchBlock.getCatchParameter().getSymbol();
        boolean bl3 = false;
        this.functionContext.defineLocal((IrValueSymbol)$this$generateTryFollowingNewProposal_u24lambda_u2417_u24lambda_u2416);
        this.body.buildSetLocal(this.functionContext.referenceLocal((IrValueSymbol)$this$generateTryFollowingNewProposal_u24lambda_u2417_u24lambda_u2416), this.getSourceLocation((IrElement)$this$generateTryFollowingNewProposal_u24lambda_u2417_u24lambda_u2416.getOwner()));
        this.generateExpression$backend_wasm(catchBlock.getResult());
        this_$iv2.buildEnd();
    }

    private final void generateTryFollowingOldProposal(IrTry aTry) {
        WasmType resultType = this.context.transformBlockResultType(aTry.getType());
        this.body.buildTry(null, resultType);
        this.generateExpression$backend_wasm(aTry.getTryResult());
        this.body.buildCatch(this.functionContext.getTagIdx());
        IrVariableSymbol it = ((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getCatchParameter().getSymbol();
        boolean bl = false;
        this.functionContext.defineLocal((IrValueSymbol)it);
        this.body.buildSetLocal(this.functionContext.referenceLocal((IrValueSymbol)it), this.getSourceLocation((IrElement)it.getOwner()));
        this.generateExpression$backend_wasm(((IrCatch)CollectionsKt.single((List)aTry.getCatches())).getResult());
        this.body.buildEnd();
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        switch (WhenMappings.$EnumSwitchMapping$0[expression2.getOperator().ordinal()]) {
            case 1: {
                this.generateExpression$backend_wasm(expression2.getArgument());
                break;
            }
            case 2: {
                this.generateAsStatement(expression2.getArgument());
                this.buildGetUnit(this.body);
                break;
            }
            default: {
                if (!_Assertions.ENABLED) break;
                boolean bl = false;
                String string = "Other types of casts must be lowered";
                throw new AssertionError((Object)string);
            }
        }
    }

    public void visitConst(@NotNull IrConst<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        DeclarationGeneratorKt.generateConstExpression(expression2, this.body, this.context, this.getSourceLocation((IrElement)expression2));
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation((IrElement)expression2);
        if (receiver != null) {
            this.generateExpression$backend_wasm(receiver);
            if (!this.backendContext.getInlineClassesUtils().isClassInlineLike(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)))) {
                this.generateInstanceFieldAccess(field, location);
            }
        } else {
            String string;
            this.body.buildGetGlobal(this.context.referenceGlobalField(field.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string2 = string = "type: " + RenderIrElementKt.render$default((IrType)field.getType(), null, (int)1, null);
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
    }

    private final void generateInstanceFieldAccess(IrField field, SourceLocation location) {
        String string;
        WasmImmediate[] wasmImmediateArray = field.getType();
        WasmOp opcode = Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getCharType()) ? WasmOp.STRUCT_GET_U : (Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getBooleanType()) || Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getByteType()) || Intrinsics.areEqual((Object)wasmImmediateArray, (Object)this.irBuiltIns.getShortType()) ? WasmOp.STRUCT_GET_S : WasmOp.STRUCT_GET);
        wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol())), new WasmImmediate.StructFieldIdx(this.context.getStructFieldRef(field))};
        this.body.buildInstr(opcode, location, wasmImmediateArray);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "name: " + field.getName().asString() + ", type: " + RenderIrElementKt.render$default((IrType)field.getType(), null, (int)1, null);
        wasmImmediateArray3[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
    }

    public void visitSetField(@NotNull IrSetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrField field = (IrField)expression2.getSymbol().getOwner();
        IrExpression receiver = expression2.getReceiver();
        SourceLocation location = this.getSourceLocation((IrElement)expression2);
        if (receiver != null) {
            String string;
            this.generateExpression$backend_wasm(receiver);
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildStructSet(this.context.referenceGcType(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)field)).getSymbol()), this.context.getStructFieldRef(field), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string2 = string = "name: " + field.getName() + ", type: " + RenderIrElementKt.render$default((IrType)field.getType(), null, (int)1, null);
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        } else {
            String string;
            this.generateExpression$backend_wasm(expression2.getValue());
            this.body.buildSetGlobal(this.context.referenceGlobalField(expression2.getSymbol()), location);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string = "type: " + RenderIrElementKt.render$default((IrType)field.getType(), null, (int)1, null);
            wasmImmediateArray3[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        }
        this.buildGetUnit(this.body);
    }

    public void visitGetValue(@NotNull IrGetValue expression2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrValueSymbol valueSymbol = expression2.getSymbol();
        IrValueDeclaration valueDeclaration = valueSymbol.getOwner();
        this.body.buildGetLocal(MiscKt.isDispatchReceiver(valueDeclaration) ? this.functionContext.referenceLocal(0) : this.functionContext.referenceLocal(valueSymbol), this.getSourceLocation((IrElement)expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "type: " + RenderIrElementKt.render$default((IrType)valueDeclaration.getType(), null, (int)1, null);
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateExpression$backend_wasm(expression2.getValue());
        this.body.buildSetLocal(this.functionContext.referenceLocal(expression2.getSymbol()), this.getSourceLocation((IrElement)expression2));
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "type: " + RenderIrElementKt.render$default((IrType)expression2.getSymbol().getOwner().getType(), null, (int)1, null);
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        this.buildGetUnit(this.body);
    }

    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)expression2.getSymbol().getOwner()));
        IrClassSymbol klassSymbol = klass.getSymbol();
        if (!(!this.backendContext.getInlineClassesUtils().isClassInlineLike(klass))) {
            boolean $i$a$-require-BodyGenerator$visitConstructorCall$32 = false;
            String $i$a$-require-BodyGenerator$visitConstructorCall$32 = "All inline class constructor calls must be lowered to static function calls";
            throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$32.toString());
        }
        WasmSymbol<WasmTypeDeclaration> wasmGcType = this.context.referenceGcType(klassSymbol);
        SourceLocation location = this.getSourceLocation((IrElement)expression2);
        if (AnnotationsKt.getWasmArrayAnnotation((IrAnnotationContainer)klass) != null) {
            String string;
            if (!(expression2.getValueArgumentsCount() == 1)) {
                boolean $i$a$-require-BodyGenerator$visitConstructorCall$42 = false;
                String $i$a$-require-BodyGenerator$visitConstructorCall$42 = "@WasmArrayOf constructs must have exactly one argument";
                throw new IllegalArgumentException($i$a$-require-BodyGenerator$visitConstructorCall$42.toString());
            }
            IrExpression irExpression = expression2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateExpression$backend_wasm(irExpression);
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.GcType(wasmGcType)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DEFAULT, location, wasmImmediateArray);
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentPreviousInstr = false;
            WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray3 = wasmImmediateArray2;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string2 = string = "@WasmArrayOf ctor call: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
            wasmImmediateArray3[n] = new WasmImmediate.ConstString(string2);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray2);
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)expression2.getSymbol().getOwner())) {
            String string;
            this.generateAnyParameters(klassSymbol, location);
            int $i$f$commentPreviousInstr = expression2.getValueArgumentsCount();
            for (int i = 0; i < $i$f$commentPreviousInstr; ++i) {
                IrExpression irExpression = expression2.getValueArgument(i);
                Intrinsics.checkNotNull((Object)irExpression);
                this.generateExpression$backend_wasm(irExpression);
            }
            this.body.buildStructNew(wasmGcType, location);
            WasmExpressionBuilder this_$iv = this.body;
            $i$f$commentPreviousInstr = 0;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray4 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string3 = string = "@WasmPrimitiveConstructor ctor call: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)klass));
            wasmImmediateArray4[n] = new WasmImmediate.ConstString(string3);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            return;
        }
        this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.None.INSTANCE, location);
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    private final void generateAnyParameters(IrClassSymbol klassSymbol, SourceLocation location) {
        String string;
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "Any parameters";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        this.body.buildGetGlobal(this.context.referenceGlobalVTable(klassSymbol), location);
        if (ClassInfoKt.hasInterfaceSuperClass((IrClass)klassSymbol.getOwner())) {
            this.body.buildGetGlobal(this.context.referenceGlobalClassITable(klassSymbol), location);
        } else {
            this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.Struct.INSTANCE, location);
        }
        this.body.buildConstI32Symbol(this.context.referenceTypeId(klassSymbol), location);
        this.body.buildConstI32(0, location);
        this.body.commentGroupEnd();
    }

    /*
     * WARNING - void declaration
     */
    public final void generateObjectCreationPrefixIfNeeded(@NotNull IrConstructor constructor) {
        String string;
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        IrClass parentClass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)constructor));
        if (Intrinsics.areEqual((Object)constructor.getOrigin(), (Object)PrimaryConstructorLowering.Companion.getSYNTHETIC_PRIMARY_CONSTRUCTOR())) {
            return;
        }
        if (UtilsKt.isAbstractOrSealed(parentClass)) {
            return;
        }
        IrValueParameter irValueParameter = parentClass.getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        WasmLocal thisParameter = this.functionContext.referenceLocal((IrValueSymbol)irValueParameter.getSymbol());
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentGroupStart = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "Object creation prefix";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
        SourceLocation location = SourceLocation.Companion.NoLocation("Constructor preamble");
        boolean bl2 = false;
        this.body.buildGetLocal(thisParameter, location);
        this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
        WasmExpressionBuilder.buildIf$default((WasmExpressionBuilder)this.body, (String)"this_init", null, (int)2, null);
        this.generateAnyParameters(parentClass.getSymbol(), location);
        List<IrField> irFields = ClassInfoKt.allFields(parentClass, this.backendContext.getIrBuiltIns());
        Iterable $this$forEachIndexed$iv = irFields;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void field;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrField irField = (IrField)item$iv;
            int index = n2;
            boolean bl3 = false;
            if (index <= 1) continue;
            DeclarationGeneratorKt.generateDefaultInitializerForType(this.context.transformType(field.getType()), this.body);
        }
        this.body.buildStructNew(this.context.referenceGcType(parentClass.getSymbol()), location);
        this.body.buildSetLocal(thisParameter, location);
        this.body.buildEnd();
        this.body.commentGroupEnd();
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.functionContext.getIrFunction()));
        if (IrTypePredicatesKt.isAny((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)klass)))) {
            this.buildGetUnit(this.body);
            return;
        }
        this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        this.generateCall((IrFunctionAccessExpression)expression2);
    }

    private final void generateBox(IrExpression expression2, IrType type) {
        String string;
        IrClassSymbol klassSymbol = TypeTransformerKt.getRuntimeClass(type, this.irBuiltIns).getSymbol();
        SourceLocation location = this.getSourceLocation((IrElement)expression2);
        this.generateAnyParameters(klassSymbol, location);
        this.generateExpression$backend_wasm(expression2);
        this.body.buildStructNew(this.context.referenceGcType(klassSymbol), location);
        WasmExpressionBuilder this_$iv = this.body;
        boolean $i$f$commentPreviousInstr = false;
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
        int n = 0;
        WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
        boolean bl = false;
        String string2 = string = "box";
        wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
    }

    /*
     * WARNING - void declaration
     */
    private final void generateCall(IrFunctionAccessExpression call2) {
        boolean isSuperCall;
        IrExpression it;
        SourceLocation location = this.getSourceLocation((IrElement)call2);
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getBoxBoolean())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            this.generateBox(irExpression, this.irBuiltIns.getBooleanType());
            return;
        }
        if (Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getBoxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType type = irType;
            if (Intrinsics.areEqual((Object)type, (Object)this.irBuiltIns.getBooleanType())) {
                IrExpression irExpression = call2.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                this.generateExpression$backend_wasm(irExpression);
                this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.context.getBackendContext().getWasmSymbols().getGetBoxedBoolean()), location);
            } else {
                IrExpression irExpression = call2.getValueArgument(0);
                Intrinsics.checkNotNull((Object)irExpression);
                this.generateBox(irExpression, type);
            }
            return;
        }
        if (!((Boolean)this.backendContext.getConfiguration().getNotNull(WasmConfigurationKeys.WASM_ENABLE_ARRAY_RANGE_CHECKS)).booleanValue() && Intrinsics.areEqual((Object)call2.getSymbol(), (Object)this.wasmSymbols.getRangeCheck())) {
            this.buildGetUnit(this.body);
            return;
        }
        if (!((Boolean)this.backendContext.getConfiguration().getNotNull(WasmConfigurationKeys.WASM_ENABLE_ASSERTS)).booleanValue() && CollectionsKt.contains((Iterable)this.wasmSymbols.getAssertFuncs(), (Object)call2.getSymbol())) {
            this.buildGetUnit(this.body);
            return;
        }
        IrFunction function2 = IrResolveUtilsKt.getRealOverrideTarget(((IrFunctionSymbol)call2.getSymbol()).getOwner());
        IrExpression irExpression = call2.getDispatchReceiver();
        if (irExpression != null) {
            it = irExpression;
            boolean bl = false;
            this.generateExpression$backend_wasm(it);
        }
        IrExpression irExpression2 = call2.getExtensionReceiver();
        if (irExpression2 != null) {
            it = irExpression2;
            boolean bl = false;
            this.generateExpression$backend_wasm(it);
        }
        int n = call2.getValueArgumentsCount();
        for (int i = 0; i < n; ++i) {
            IrExpression irExpression3 = call2.getValueArgument(i);
            Intrinsics.checkNotNull((Object)irExpression3);
            this.generateExpression$backend_wasm(irExpression3);
        }
        if (this.tryToGenerateIntrinsicCall(call2, function2)) {
            if (IrTypePredicatesKt.isUnit((IrType)function2.getReturnType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (AnnotationsKt.hasWasmPrimitiveConstructorAnnotation((IrAnnotationContainer)function2.getSymbol().getOwner())) {
            return;
        }
        boolean bl = isSuperCall = call2 instanceof IrCall && ((IrCall)call2).getSuperQualifierSymbol() != null;
        if (function2 instanceof IrSimpleFunction && IrUtilsKt.isOverridable((IrSimpleFunction)((IrSimpleFunction)function2)) && !isSuperCall) {
            IrClass klass = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2));
            if (!IrUtilsKt.isInterface((IrClass)klass)) {
                String string;
                int n2;
                WasmImmediate[] wasmImmediateArray;
                block23: {
                    ClassMetadata classMetadata = this.context.getClassMetadata(klass.getSymbol());
                    List<VirtualMethodMetadata> $this$indexOfFirst$iv = classMetadata.getVirtualMethods();
                    boolean $i$f$indexOfFirst = false;
                    int index$iv = 0;
                    wasmImmediateArray = $this$indexOfFirst$iv.iterator();
                    while (wasmImmediateArray.hasNext()) {
                        VirtualMethodMetadata item$iv;
                        VirtualMethodMetadata it2 = item$iv = wasmImmediateArray.next();
                        boolean bl2 = false;
                        if (Intrinsics.areEqual((Object)it2.getFunction(), (Object)function2)) {
                            n2 = index$iv;
                            break block23;
                        }
                        ++index$iv;
                    }
                    n2 = -1;
                }
                int vfSlot = n2;
                IrExpression irExpression4 = call2.getDispatchReceiver();
                Intrinsics.checkNotNull((Object)irExpression4);
                IrExpression receiver = irExpression4;
                this.generateExpression$backend_wasm(receiver);
                WasmImmediate[] this_$iv2 = this.body;
                boolean $i$f$commentGroupStart = false;
                wasmImmediateArray = new WasmImmediate[1];
                int n3 = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                WasmImmediate[] wasmImmediateArray3 = this_$iv2;
                boolean bl3 = false;
                String string2 = string = "virtual call: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)function2));
                wasmImmediateArray2[n3] = new WasmImmediate.ConstString(string2);
                wasmImmediateArray3.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
                this.generateRefCast(receiver.getType(), (IrType)IrUtilsKt.getDefaultType((IrClass)klass), location);
                this.body.buildStructGet(this.context.referenceGcType(klass.getSymbol()), new WasmSymbol((Object)0), location);
                this.body.buildStructGet(this.context.referenceVTableGcType(klass.getSymbol()), new WasmSymbol((Object)vfSlot), location);
                this_$iv2 = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly)this.context.referenceFunctionType((IrFunctionSymbol)((IrSimpleFunction)function2).getSymbol()))};
                this.body.buildInstr(WasmOp.CALL_REF, location, this_$iv2);
                this.body.commentGroupEnd();
            } else {
                IrClassSymbol symbol = klass.getSymbol();
                if (this.hierarchyDisjointUnions.contains(symbol)) {
                    int n4;
                    block24: {
                        void $this$indexOfFirst$iv;
                        String string;
                        IrExpression irExpression5 = call2.getDispatchReceiver();
                        Intrinsics.checkNotNull((Object)irExpression5);
                        this.generateExpression$backend_wasm(irExpression5);
                        WasmExpressionBuilder this_$iv = this.body;
                        boolean $i$f$commentGroupStart = false;
                        Object this_$iv2 = new WasmImmediate[1];
                        int n5 = 0;
                        WasmImmediate[] wasmImmediateArray = this_$iv2;
                        SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                        WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
                        WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                        boolean bl4 = false;
                        String string3 = string = "interface call: " + IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)function2));
                        wasmImmediateArray[n5] = new WasmImmediate.ConstString(string3);
                        wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, this_$iv2);
                        this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol((Object)1), location);
                        WasmSymbol<WasmTypeDeclaration> classITableReference = this.context.referenceClassITableGcType(symbol);
                        this.body.buildRefCastStatic((WasmSymbolReadOnly)classITableReference, location);
                        this.body.buildStructGet(classITableReference, this.context.referenceClassITableInterfaceSlot(symbol), location);
                        this_$iv2 = this.context.getInterfaceMetadata(symbol).getMethods();
                        boolean $i$f$indexOfFirst = false;
                        int index$iv = 0;
                        for (Object item$iv : $this$indexOfFirst$iv) {
                            VirtualMethodMetadata it3 = (VirtualMethodMetadata)item$iv;
                            boolean bl5 = false;
                            if (Intrinsics.areEqual((Object)it3.getFunction(), (Object)function2)) {
                                n4 = index$iv;
                                break block24;
                            }
                            ++index$iv;
                        }
                        n4 = -1;
                    }
                    int vfSlot = n4;
                    this.body.buildStructGet(this.context.referenceVTableGcType(symbol), new WasmSymbol((Object)vfSlot), location);
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.TypeIdx((WasmSymbolReadOnly)this.context.referenceFunctionType((IrFunctionSymbol)((IrSimpleFunction)function2).getSymbol()))};
                    this.body.buildInstr(WasmOp.CALL_REF, location, wasmImmediateArray);
                    this.body.commentGroupEnd();
                } else {
                    LocationUtilsKt.buildUnreachableForVerifier(this.body);
                }
            }
        } else {
            this.body.buildCall(this.context.referenceFunction(function2.getSymbol()), location);
        }
        if (IrTypePredicatesKt.isUnit((IrType)function2.getReturnType()) && !(function2 instanceof IrConstructor)) {
            this.buildGetUnit(this.body);
        }
    }

    private final void generateRefNullCast(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefCastNullStatic((WasmSymbolReadOnly)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        }
    }

    private final void generateRefCast(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefCastStatic((WasmSymbolReadOnly)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        }
    }

    private final void generateRefTest(IrType fromType, IrType toType, SourceLocation location) {
        if (!this.isDownCastAlwaysSuccessInRuntime(fromType, toType)) {
            this.body.buildRefTestStatic((WasmSymbolReadOnly)this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns).getSymbol()), location);
        } else {
            this.body.buildDrop(location);
            this.body.buildConstI32(1, location);
        }
    }

    private final boolean isDownCastAlwaysSuccessInRuntime(IrType fromType, IrType toType) {
        IrClass upperBound = TypeTranformerKt.getErasedUpperBound(fromType);
        if (upperBound != null && IrTypeUtilsKt.isSubtypeOfClass((IrClassifierSymbol)((IrClassifierSymbol)upperBound.getSymbol()), (IrClassSymbol)this.backendContext.getWasmSymbols().getWasmAnyRefClass())) {
            return false;
        }
        return IrUtilsKt.isSubclassOf((IrClass)TypeTransformerKt.getRuntimeClass(fromType, this.irBuiltIns), (IrClass)TypeTransformerKt.getRuntimeClass(toType, this.irBuiltIns));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToGenerateIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (this.tryToGenerateWasmOpIntrinsicCall(call2, function2)) {
            return true;
        }
        SourceLocation location = this.getSourceLocation((IrElement)call2);
        IrFunctionSymbol irFunctionSymbol = function2.getSymbol();
        if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmTypeId())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No class given for wasmTypeId intrinsic".toString());
            }
            IrClass klass = irClass;
            this.body.buildConstI32Symbol(this.context.referenceTypeId(klass.getSymbol()), location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmIsInterface())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrClass irClass = IrTypesKt.getClass((IrType)irType);
            if (irClass == null) {
                throw new IllegalStateException("No interface given for wasmIsInterface intrinsic".toString());
            }
            IrClass irInterface = irClass;
            boolean bl = IrUtilsKt.isInterface((IrClass)irInterface);
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            if (this.hierarchyDisjointUnions.contains(irInterface.getSymbol())) {
                void this_$iv;
                void this_$iv2;
                WasmSymbol<WasmTypeDeclaration> classITable = this.context.referenceClassITableGcType(irInterface.getSymbol());
                WasmLocal parameterLocal = this.functionContext.referenceLocal(SyntheticLocalType.IS_INTERFACE_PARAMETER);
                this.body.buildSetLocal(parameterLocal, location);
                WasmExpressionBuilder wasmExpressionBuilder = this.body;
                String string = "isInterface";
                WasmType resultType$iv = (WasmType)WasmI32.INSTANCE;
                boolean $i$f$buildBlock = false;
                int n = this_$iv2.getNumberOfNestedBlocks();
                this_$iv2.setNumberOfNestedBlocks(n + 1);
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
                this_$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
                int outerLabel = this_$iv2.getNumberOfNestedBlocks();
                boolean bl2 = false;
                WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
                String string2 = "isInterface";
                WasmType resultType$iv2 = (WasmType)new WasmRefNullType((WasmHeapType)WasmHeapType.Simple.Struct.INSTANCE);
                boolean $i$f$buildBlock2 = false;
                int n2 = this_$iv.getNumberOfNestedBlocks();
                this_$iv.setNumberOfNestedBlocks(n2 + 1);
                WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
                this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
                int innerLabel = this_$iv.getNumberOfNestedBlocks();
                boolean bl3 = false;
                this.body.buildGetLocal(parameterLocal, location);
                this.body.buildStructGet(this.context.referenceGcType(this.irBuiltIns.getAnyClass()), new WasmSymbol((Object)1), location);
                this.body.buildBrOnCastInstr(WasmOp.BR_ON_CAST_FAIL, innerLabel, true, false, (WasmHeapType)WasmHeapType.Simple.Struct.INSTANCE, (WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)classITable), location);
                this.body.buildStructGet(classITable, this.context.referenceClassITableInterfaceSlot(irInterface.getSymbol()), location);
                this.body.buildInstr(WasmOp.REF_IS_NULL, location, new WasmImmediate[0]);
                this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
                this.body.buildBr(outerLabel, location);
                this_$iv.buildEnd();
                this.body.buildDrop(location);
                this.body.buildConstI32(0, location);
                this_$iv2.buildEnd();
            } else {
                this.body.buildDrop(location);
                this.body.buildConstI32(0, location);
            }
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getRefCastNull())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType irType = irExpression.getType();
            IrType irType2 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType2);
            this.generateRefNullCast(irType, irType2, location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getRefTest())) {
            IrExpression irExpression = call2.getValueArgument(0);
            Intrinsics.checkNotNull((Object)irExpression);
            IrType irType = irExpression.getType();
            IrType irType3 = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType3);
            this.generateRefTest(irType, irType3, location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnboxIntrinsic())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            IrType fromType = irType;
            if (IrTypePredicatesKt.isNothing((IrType)fromType)) {
                LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
                return true;
            }
            IrType irType4 = call2.getTypeArgument(1);
            Intrinsics.checkNotNull((Object)irType4);
            IrType toType = irType4;
            IrClass irClass = this.backendContext.getInlineClassesUtils().getInlinedClass(toType);
            Intrinsics.checkNotNull((Object)irClass);
            IrClass klass = irClass;
            IrField field = InlineClassesKt.getInlineClassBackingField((IrClass)klass);
            this.generateRefCast(fromType, toType, location);
            this.generateInstanceFieldAccess(field, location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getUnsafeGetScratchRawMemory())) {
            this.body.buildConstI32Symbol(this.context.getScratchMemAddr(), location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getReturnArgumentIfItIsKotlinAny())) {
            void this_$iv;
            WasmExpressionBuilder fromType = this.body;
            String toType = "returnIfAny";
            WasmType resultType$iv = (WasmType)WasmAnyRef.INSTANCE;
            boolean $i$f$buildBlock = false;
            int n = this_$iv.getNumberOfNestedBlocks();
            this_$iv.setNumberOfNestedBlocks(n + 1);
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
            this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
            int innerLabel = this_$iv.getNumberOfNestedBlocks();
            boolean bl = false;
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), location);
            this.body.buildInstr(WasmOp.EXTERN_INTERNALIZE, location, new WasmImmediate[0]);
            this.body.buildBrOnCastInstr(WasmOp.BR_ON_CAST_FAIL, innerLabel, true, true, (WasmHeapType)WasmHeapType.Simple.Any.INSTANCE, (WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)this.context.referenceGcType(this.backendContext.getIrBuiltIns().getAnyClass())), location);
            this.body.buildInstr(WasmOp.RETURN, location, new WasmImmediate[0]);
            this_$iv.buildEnd();
            this.body.buildDrop(location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmArrayCopy())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            WasmImmediate.GcType immediate = new WasmImmediate.GcType(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{immediate, immediate};
            this.body.buildInstr(WasmOp.ARRAY_COPY, location, wasmImmediateArray);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getStringGetPoolSize())) {
            this.body.buildConstI32Symbol(this.context.getStringPoolSize(), location);
        } else if (Intrinsics.areEqual((Object)irFunctionSymbol, (Object)this.wasmSymbols.getWasmArrayNewData0())) {
            IrType irType = call2.getTypeArgument(0);
            Intrinsics.checkNotNull((Object)irType);
            WasmImmediate.GcType arrayGcType = new WasmImmediate.GcType(this.context.referenceGcType(TypeTransformerKt.getRuntimeClass(irType, this.irBuiltIns).getSymbol()));
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{arrayGcType, new WasmImmediate.DataIdx(0)};
            this.body.buildInstr(WasmOp.ARRAY_NEW_DATA, location, wasmImmediateArray);
        } else {
            return false;
        }
        return true;
    }

    public void visitBlockBody(@NotNull IrBlockBody body) {
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        Iterable $this$forEach$iv = body.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement p0 = (IrStatement)element$iv;
            boolean bl = false;
            this.generateStatement(p0);
        }
        this.body.buildNop(this.getSourceEndLocation((IrElement)body));
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock) {
        Intrinsics.checkNotNullParameter((Object)inlinedBlock, (String)"inlinedBlock");
        this.body.buildNop(this.getSourceLocation((IrElement)inlinedBlock.getInlineCall()));
        this.functionContext.stepIntoInlinedFunction(((IrFunctionSymbol)inlinedBlock.getInlineCall().getSymbol()).getOwner());
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock);
        this.functionContext.stepOutLastInlinedFunction();
    }

    /*
     * WARNING - void declaration
     */
    private final void processContainerExpression(IrContainerExpression expression2) {
        if (expression2 instanceof IrReturnableBlock) {
            String string;
            IrElement irElement;
            IrFunction inlineFunction = IrInlineUtilsKt.getInlineFunction((IrReturnableBlock)((IrReturnableBlock)((IrReturnableBlock)expression2).getSymbol().getOwner()));
            IrSimpleFunction irSimpleFunction = inlineFunction instanceof IrSimpleFunction ? (IrSimpleFunction)inlineFunction : null;
            Object correspondingProperty = irSimpleFunction != null ? irSimpleFunction.getCorrespondingPropertySymbol() : null;
            IrPropertySymbol irPropertySymbol = correspondingProperty;
            IrElement owner = irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? (IrElement)irPropertySymbol : (IrElement)inlineFunction;
            Object object = owner;
            if ((object == null || (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)object))) == null || (object = object.asString()) == null) && ((irElement = owner) != null && (irElement = ((IrDeclarationWithName)irElement).getName()) != null ? irElement.asString() : (object = null)) == null) {
                object = "<UNKNOWN>";
            }
            Object name = object;
            WasmExpressionBuilder this_$iv = this.body;
            boolean $i$f$commentGroupStart = false;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
            int n = 0;
            WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
            SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
            WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_GROUP_START;
            WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
            boolean bl = false;
            String string2 = string = "Inlined call of `" + (String)name + '`';
            wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
            wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            this.functionContext.defineNonLocalReturnLevel(((IrReturnableBlock)expression2).getSymbol(), this.body.buildBlock(this.context.transformBlockResultType(expression2.getType())));
        }
        List statements = expression2.getStatements();
        Iterable $this$forEachIndexed$iv = statements;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void statement;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrStatement bl = (IrStatement)item$iv;
            int i = n;
            boolean bl2 = false;
            if (i != CollectionsKt.getLastIndex((List)statements)) {
                this.generateStatement((IrStatement)statement);
                continue;
            }
            if (statement instanceof IrExpression) {
                this.generateWithExpectedType$backend_wasm((IrExpression)statement, expression2.getType());
                continue;
            }
            this.generateStatement((IrStatement)statement);
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.wasmSymbols.getVoidType())) continue;
            this.buildGetUnit(this.body);
        }
        if (expression2 instanceof IrReturnableBlock) {
            this.body.buildEnd();
            this.body.commentGroupEnd();
        }
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (expression2.getStatements().isEmpty()) {
            if (Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getUnitType())) {
                this.buildGetUnit(this.body);
            }
            return;
        }
        if (this.context.getBackendContext().isWasmJsTarget() && Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)JsExceptionRevealOrigin.Companion.getJS_EXCEPTION_REVEAL())) {
            if (this.context.getBackendContext().getConfiguration().getBoolean(WasmConfigurationKeys.WASM_USE_NEW_EXCEPTION_PROPOSAL)) {
                this.generateTryCatchAllFollowingNewProposal(expression2);
            } else {
                this.generateTryCatchAllFollowingOldProposal(expression2);
            }
        } else {
            this.processContainerExpression(expression2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void generateTryCatchAllFollowingNewProposal(IrContainerExpression expression2) {
        void $this$iv;
        void this_$iv;
        void this_$iv2;
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        WasmType throwableType = this.context.transformBlockResultType(this.context.getBackendContext().getIrBuiltIns().getThrowableType());
        SourceLocation revealLocation = SourceLocation.Companion.NoLocation("JS exception reveal");
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "CATCH_BLOCK";
        boolean $i$f$buildBlock = false;
        int n = this_$iv2.getNumberOfNestedBlocks();
        this_$iv2.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType)};
        this_$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray);
        int catchBlockLabel = this_$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "CATCH_ALL_BLOCK";
        boolean $i$f$buildBlock2 = false;
        int n2 = this_$iv.getNumberOfNestedBlocks();
        this_$iv.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(throwableType)};
        this_$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int catchAllBlockLabel = this_$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        WasmExpressionBuilder wasmExpressionBuilder3 = this.body;
        String label$iv3 = "TRY_BLOCK";
        WasmType resultType$iv = null;
        boolean $i$f$buildBlock3 = false;
        int n3 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n3 + 1);
        WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray3);
        int tryBlockLabel = $this$iv.getNumberOfNestedBlocks();
        boolean bl3 = false;
        Object[] objectArray = new WasmImmediate.Catch[]{this.body.createNewCatch(this.functionContext.getTagIdx(), catchAllBlockLabel), this.body.createNewCatchAll(tryBlockLabel)};
        WasmExpressionBuilder.buildTryTable$default((WasmExpressionBuilder)this.body, null, (List)CollectionsKt.listOf((Object[])objectArray), null, (int)4, null);
        this.processContainerExpression(expression2);
        this.body.buildBr(catchBlockLabel, SourceLocation.Companion.NoLocation(""));
        this.body.buildEnd();
        $this$iv.buildEnd();
        this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.context.getBackendContext().getWasmSymbols().getJsRelatedSymbols().getThrowJsException()), revealLocation);
        this.body.buildUnreachable(revealLocation);
        this_$iv.buildEnd();
        this.body.buildThrow(this.functionContext.getTagIdx(), revealLocation);
        this_$iv2.buildEnd();
    }

    private final void generateTryCatchAllFollowingOldProposal(IrContainerExpression expression2) {
        this.body.buildTry(null, this.context.transformBlockResultType(expression2.getType()));
        this.processContainerExpression(expression2);
        SourceLocation revealLocation = SourceLocation.Companion.NoLocation("JS exception reveal");
        this.body.buildCatch(this.functionContext.getTagIdx());
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.LabelIdx(0)};
        this.body.buildInstr(WasmOp.RETHROW, revealLocation, wasmImmediateArray);
        this.body.buildCatchAll();
        this.body.buildCall(this.context.referenceFunction((IrFunctionSymbol)this.context.getBackendContext().getWasmSymbols().getJsRelatedSymbols().getThrowJsException()), revealLocation);
        this.body.buildUnreachable(revealLocation);
        this.body.buildEnd();
    }

    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.BREAK), this.getSourceLocation((IrElement)jump));
    }

    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        boolean bl = Intrinsics.areEqual((Object)jump.getType(), (Object)this.irBuiltIns.getNothingType());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.body.buildBr(this.functionContext.referenceLoopLevel(jump.getLoop(), LoopLabelType.CONTINUE), this.getSourceLocation((IrElement)jump));
    }

    private final void visitFunctionReturn(IrReturn expression2) {
        IrType returnType = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.returnType((IrReturnTarget)expression2.getReturnTargetSymbol().getOwner(), (CommonBackendContext)this.backendContext);
        boolean isGetUnitFunction = Intrinsics.areEqual((Object)expression2.getReturnTargetSymbol().getOwner(), (Object)this.getUnitGetInstance());
        if (isGetUnitFunction) {
            this.generateExpression$backend_wasm(expression2.getValue());
        } else if (Intrinsics.areEqual((Object)returnType, (Object)this.irBuiltIns.getUnitType())) {
            this.generateAsStatement(expression2.getValue());
        } else {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), returnType);
        }
        if (this.functionContext.getIrFunction() instanceof IrConstructor) {
            this.body.buildGetLocal(this.functionContext.referenceLocal(0), SourceLocation.Companion.NoLocation("Get implicit dispatch receiver"));
        }
        this.body.buildInstr(WasmOp.RETURN, this.getSourceLocation((IrElement)expression2), new WasmImmediate[0]);
    }

    public final void generateWithExpectedType$backend_wasm(@NotNull IrExpression expression2, @NotNull IrType expectedType) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        IrType actualType = expression2.getType();
        if (Intrinsics.areEqual((Object)expectedType, (Object)this.wasmSymbols.getVoidType())) {
            this.generateAsStatement(expression2);
            return;
        }
        if (IrTypePredicatesKt.isUnit((IrType)expectedType) && !IrTypePredicatesKt.isUnit((IrType)actualType)) {
            this.generateAsStatement(expression2);
            this.buildGetUnit(this.body);
            return;
        }
        this.generateExpression$backend_wasm(expression2);
        this.recoverToExpectedType(actualType, expectedType, this.getSourceLocation((IrElement)expression2));
    }

    private final void recoverToExpectedType(IrType actualType, IrType expectedType, SourceLocation location) {
        boolean actualIsPrimitive;
        IrSimpleType actualTypeErased;
        if (IrTypePredicatesKt.isNothing((IrType)expectedType)) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrTypePredicatesKt.isNothing((IrType)actualType)) {
            return;
        }
        if (IrTypePredicatesKt.isNullableNothing((IrType)actualType) && IrTypeUtilsKt.isNullable((IrType)expectedType)) {
            IrClass irClass = IrTypesKt.getClass((IrType)expectedType);
            boolean bl = irClass != null ? irClass.isExternal() : false;
            if (bl) {
                this.body.buildDrop(location);
                this.body.buildRefNull((WasmHeapType)WasmHeapType.Simple.NoExtern.INSTANCE, location);
            }
            return;
        }
        if (IrTypeUtilsKt.isNullable((IrType)actualType) && IrTypePredicatesKt.isNullableNothing((IrType)expectedType)) {
            IrClass irClass = IrTypesKt.getClass((IrType)expectedType);
            WasmHeapType.Simple type = (irClass != null ? irClass.isExternal() : false) ? (WasmHeapType.Simple)WasmHeapType.Simple.NoExtern.INSTANCE : (WasmHeapType.Simple)WasmHeapType.Simple.None.INSTANCE;
            WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.HeapType((WasmHeapType)type)};
            this.body.buildInstr(WasmOp.REF_CAST_NULL, location, wasmImmediateArray);
            return;
        }
        IrClass expectedClassErased = TypeTransformerKt.getRuntimeClass(expectedType, this.irBuiltIns);
        if (expectedClassErased.isExternal()) {
            return;
        }
        IrClass actualClassErased = TypeTransformerKt.getRuntimeClass(actualType, this.irBuiltIns);
        IrSimpleType expectedTypeErased = IrUtilsKt.getDefaultType((IrClass)expectedClassErased);
        if (Intrinsics.areEqual((Object)expectedTypeErased, (Object)(actualTypeErased = IrUtilsKt.getDefaultType((IrClass)actualClassErased)))) {
            return;
        }
        if (IrTypePredicatesKt.isNothing((IrType)((IrType)expectedTypeErased)) && !IrTypePredicatesKt.isNothing((IrType)((IrType)actualTypeErased))) {
            LocationUtilsKt.buildUnreachableAfterNothingType(this.body);
            return;
        }
        if (IrUtilsKt.isSubclassOf((IrClass)actualClassErased, (IrClass)expectedClassErased)) {
            return;
        }
        boolean expectedIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)expectedTypeErased), (boolean)false, (int)1, null) && !IrTypeUtilsKt.isNullable((IrType)expectedType);
        boolean bl = actualIsPrimitive = IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)actualTypeErased), (boolean)false, (int)1, null) && !IrTypeUtilsKt.isNullable((IrType)actualType);
        if (expectedIsPrimitive != actualIsPrimitive) {
            LocationUtilsKt.buildUnreachableForVerifier(this.body);
            return;
        }
        if (!expectedIsPrimitive) {
            if (IrUtilsKt.isSubclassOf((IrClass)expectedClassErased, (IrClass)actualClassErased)) {
                String string;
                if (IrTypeUtilsKt.isNullable((IrType)expectedType)) {
                    this.generateRefNullCast((IrType)actualTypeErased, (IrType)expectedTypeErased, location);
                } else {
                    this.generateRefCast((IrType)actualTypeErased, (IrType)expectedTypeErased, location);
                }
                WasmExpressionBuilder this_$iv = this.body;
                boolean $i$f$commentPreviousInstr = false;
                WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                int n = 0;
                WasmImmediate[] wasmImmediateArray2 = wasmImmediateArray;
                SourceLocation sourceLocation = SourceLocation.Companion.NoLocation("Pseudo-instruction");
                WasmOp wasmOp = WasmOp.PSEUDO_COMMENT_PREVIOUS_INSTR;
                WasmExpressionBuilder wasmExpressionBuilder = this_$iv;
                boolean bl2 = false;
                String string2 = string = "to make verifier happy";
                wasmImmediateArray2[n] = new WasmImmediate.ConstString(string2);
                wasmExpressionBuilder.buildInstr(wasmOp, sourceLocation, wasmImmediateArray);
            } else {
                LocationUtilsKt.buildUnreachableForVerifier(this.body);
            }
        }
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        IrReturnableBlockSymbol nonLocalReturnSymbol;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrReturnTargetSymbol irReturnTargetSymbol = expression2.getReturnTargetSymbol();
        IrReturnableBlockSymbol irReturnableBlockSymbol = nonLocalReturnSymbol = irReturnTargetSymbol instanceof IrReturnableBlockSymbol ? (IrReturnableBlockSymbol)irReturnTargetSymbol : null;
        if (nonLocalReturnSymbol != null) {
            this.generateWithExpectedType$backend_wasm(expression2.getValue(), ((IrReturnableBlock)nonLocalReturnSymbol.getOwner()).getType());
            this.body.buildBr(this.functionContext.referenceNonLocalReturnLevel(nonLocalReturnSymbol), this.getSourceLocation((IrElement)expression2));
        } else {
            this.visitFunctionReturn(expression2);
        }
    }

    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (OptimisedWhenGeneratorKt.tryGenerateOptimisedWhen(this, expression2, this.context.getBackendContext().getWasmSymbols())) {
            return;
        }
        WasmType resultType = this.context.transformBlockResultType(expression2.getType());
        int ifCount = 0;
        boolean seenElse = false;
        for (Object branch : expression2.getBranches()) {
            if (!IrUtilsKt.isElseBranch((IrBranch)branch)) {
                this.generateExpression$backend_wasm(branch.getCondition());
                this.body.buildIf(null, resultType);
                this.generateWithExpectedType$backend_wasm(branch.getResult(), expression2.getType());
                this.body.buildElse();
                ++ifCount;
                continue;
            }
            this.generateWithExpectedType$backend_wasm(branch.getResult(), expression2.getType());
            seenElse = true;
            break;
        }
        if (!seenElse && resultType != null) {
            boolean bl;
            boolean bl2 = bl = !Intrinsics.areEqual((Object)expression2.getType(), (Object)this.irBuiltIns.getNothingType());
            if (_Assertions.ENABLED && !bl) {
                Object branch;
                branch = "Assertion failed";
                throw new AssertionError(branch);
            }
            if (IrTypePredicatesKt.isUnit((IrType)expression2.getType())) {
                this.buildGetUnit(this.body);
            } else {
                throw new IllegalStateException(("'When' without else branch and non Unit type: " + DumpKotlinLikeKt.dumpKotlinLike((IrType)expression2.getType())).toString());
            }
        }
        int n = 0;
        while (n < ifCount) {
            int it = n++;
            boolean bl = false;
            this.body.buildEnd();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        void $this$iv;
        void $this$iv2;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv3 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv3.getNumberOfNestedBlocks();
        $this$iv3.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv3.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv3.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv2.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv2.getNumberOfNestedBlocks();
        boolean bl2 = false;
        WasmExpressionBuilder wasmExpressionBuilder2 = this.body;
        String label$iv2 = "CONTINUE_" + label;
        WasmType resultType$iv3 = null;
        boolean $i$f$buildBlock2 = false;
        int n3 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n3 + 1);
        WasmImmediate[] wasmImmediateArray3 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv3)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray3);
        int wasmContinueBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl3 = false;
        this.functionContext.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmContinueBlock);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl4 = false;
            this.generateAsStatement(it);
        }
        $this$iv.buildEnd();
        this.generateExpression$backend_wasm(loop.getCondition());
        this.body.buildBrIf(wasmLoop, this.getSourceLocation((IrElement)loop.getCondition()));
        $this$iv2.buildEnd();
        $this$iv3.buildEnd();
        this.buildGetUnit(this.body);
    }

    /*
     * WARNING - void declaration
     */
    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        void $this$iv;
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        String label = loop.getLabel();
        WasmExpressionBuilder $this$iv2 = this.body;
        WasmType resultType$iv = null;
        boolean $i$f$buildLoop = false;
        int n = $this$iv2.getNumberOfNestedBlocks();
        $this$iv2.setNumberOfNestedBlocks(n + 1);
        WasmImmediate[] wasmImmediateArray = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv)};
        $this$iv2.buildInstr(WasmOp.LOOP, SourceLocation.Companion.NoLocation("LOOP"), wasmImmediateArray);
        int wasmLoop = $this$iv2.getNumberOfNestedBlocks();
        boolean bl = false;
        WasmExpressionBuilder wasmExpressionBuilder = this.body;
        String label$iv = "BREAK_" + label;
        WasmType resultType$iv2 = null;
        boolean $i$f$buildBlock = false;
        int n2 = $this$iv.getNumberOfNestedBlocks();
        $this$iv.setNumberOfNestedBlocks(n2 + 1);
        WasmImmediate[] wasmImmediateArray2 = new WasmImmediate[]{new WasmImmediate.BlockType.Value(resultType$iv2)};
        $this$iv.buildInstr(WasmOp.BLOCK, SourceLocation.Companion.NoLocation("BLOCK"), wasmImmediateArray2);
        int wasmBreakBlock = $this$iv.getNumberOfNestedBlocks();
        boolean bl2 = false;
        this.functionContext.defineLoopLevel((IrLoop)loop, LoopLabelType.BREAK, wasmBreakBlock);
        this.functionContext.defineLoopLevel((IrLoop)loop, LoopLabelType.CONTINUE, wasmLoop);
        this.generateExpression$backend_wasm(loop.getCondition());
        SourceLocation location = this.getSourceLocation((IrElement)loop.getCondition());
        this.body.buildInstr(WasmOp.I32_EQZ, location, new WasmImmediate[0]);
        this.body.buildBrIf(wasmBreakBlock, location);
        IrExpression irExpression = loop.getBody();
        if (irExpression != null) {
            IrExpression it = irExpression;
            boolean bl3 = false;
            this.generateAsStatement(it);
        }
        this.body.buildBr(wasmLoop, SourceLocation.Companion.NoLocation("Continue in the loop"));
        $this$iv.buildEnd();
        $this$iv2.buildEnd();
        this.buildGetUnit(this.body);
    }

    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.functionContext.defineLocal((IrValueSymbol)declaration.getSymbol());
        if (declaration.getInitializer() == null) {
            return;
        }
        IrExpression irExpression = declaration.getInitializer();
        Intrinsics.checkNotNull((Object)irExpression);
        IrExpression init = irExpression;
        this.generateExpression$backend_wasm(init);
        WasmLocal varName = this.functionContext.referenceLocal((IrValueSymbol)declaration.getSymbol());
        this.body.buildSetLocal(varName, this.getSourceLocation((IrElement)declaration));
    }

    private final boolean tryToGenerateWasmOpIntrinsicCall(IrFunctionAccessExpression call2, IrFunction function2) {
        if (AnnotationsKt.hasWasmNoOpCastAnnotation((IrAnnotationContainer)function2)) {
            return true;
        }
        String opString = AnnotationsKt.getWasmOpAnnotation((IrAnnotationContainer)function2);
        if (opString != null) {
            SourceLocation location = this.getSourceLocation((IrElement)call2);
            WasmOp op = WasmOp.valueOf((String)opString);
            switch (op.getImmediates().size()) {
                case 0: {
                    this.body.buildInstr(op, location, new WasmImmediate[0]);
                    break;
                }
                case 1: {
                    WasmImmediate wasmImmediate;
                    WasmImmediate[] wasmImmediateArray = new WasmImmediate[1];
                    WasmImmediateKind imm = (WasmImmediateKind)op.getImmediates().get(0);
                    switch (WhenMappings.$EnumSwitchMapping$1[imm.ordinal()]) {
                        case 1: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.MemArg(0, 0, null);
                            break;
                        }
                        case 2: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.GcType(BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 3: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.HeapType((WasmHeapType)new WasmHeapType.Type((WasmSymbolReadOnly)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this)));
                            break;
                        }
                        case 4: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.TypeIdx((WasmSymbolReadOnly)BodyGenerator.tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(function2, call2, this));
                            break;
                        }
                        case 5: {
                            wasmImmediate = (WasmImmediate)new WasmImmediate.MemoryIdx(0);
                            break;
                        }
                        default: {
                            throw new IllegalStateException(("Immediate " + imm + " is unsupported").toString());
                        }
                    }
                    wasmImmediateArray[0] = wasmImmediate;
                    WasmImmediate[] immediates = wasmImmediateArray;
                    this.body.buildInstr(op, location, Arrays.copyOf(immediates, immediates.length));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Op " + opString + " is unsupported").toString());
                }
            }
            return true;
        }
        return false;
    }

    private final SourceLocation getSourceLocation(IrElement $this$getSourceLocation) {
        return LocationUtilsKt.getSourceLocation$default($this$getSourceLocation, IrUtilsKt.getFileOrNull((IrDeclaration)((IrDeclaration)this.functionContext.getCurrentFunction())), null, 2, null);
    }

    private final SourceLocation getSourceEndLocation(IrElement $this$getSourceEndLocation) {
        return LocationUtilsKt.getSourceLocation($this$getSourceEndLocation, IrUtilsKt.getFileOrNull((IrDeclaration)((IrDeclaration)this.functionContext.getCurrentFunction())), LocationType.END);
    }

    public void visitElement(@NotNull IrElement element, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
    }

    public void visitDeclaration(@NotNull IrDeclarationBase declaration) {
        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
    }

    public void visitValueParameter(@NotNull IrValueParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
    }

    public void visitClass(@NotNull IrClass declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
    }

    public void visitClass(@NotNull IrClass declaration) {
        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
    }

    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration) {
        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
    }

    public void visitTypeParameter(@NotNull IrTypeParameter declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
    }

    public void visitFunction(@NotNull IrFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
    }

    public void visitFunction(@NotNull IrFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration);
    }

    public void visitConstructor(@NotNull IrConstructor declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
    }

    public void visitConstructor(@NotNull IrConstructor declaration) {
        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
    }

    public void visitEnumEntry(@NotNull IrEnumEntry declaration) {
        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
    }

    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration) {
        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
    }

    public void visitField(@NotNull IrField declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
    }

    public void visitField(@NotNull IrField declaration) {
        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
    }

    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
    }

    public void visitModuleFragment(@NotNull IrModuleFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
    }

    public void visitProperty(@NotNull IrProperty declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
    }

    public void visitProperty(@NotNull IrProperty declaration) {
        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration);
    }

    public void visitScript(@NotNull IrScript declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
    }

    public void visitScript(@NotNull IrScript declaration) {
        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
    }

    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration) {
        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
    }

    public void visitTypeAlias(@NotNull IrTypeAlias declaration) {
        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
    }

    public void visitVariable(@NotNull IrVariable declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
    }

    public void visitPackageFragment(@NotNull IrPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
    }

    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration) {
        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
    }

    public void visitFile(@NotNull IrFile declaration, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
    }

    public void visitFile(@NotNull IrFile declaration) {
        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
    }

    public void visitExpression(@NotNull IrExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
    }

    public void visitExpression(@NotNull IrExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
    }

    public void visitBody(@NotNull IrBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
    }

    public void visitBody(@NotNull IrBody body) {
        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
    }

    public void visitExpressionBody(@NotNull IrExpressionBody body) {
        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
    }

    public void visitBlockBody(@NotNull IrBlockBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
    }

    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
    }

    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
    }

    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
    }

    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
    }

    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
    }

    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
    }

    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
    }

    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
    }

    public void visitBlock(@NotNull IrBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
    }

    public void visitComposite(@NotNull IrComposite expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
    }

    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2, (Void)data);
    }

    public void visitReturnableBlock(@NotNull IrReturnableBlock expression2) {
        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2);
    }

    public void visitInlinedFunctionBlock(@NotNull IrInlinedFunctionBlock inlinedBlock, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
    }

    public void visitSyntheticBody(@NotNull IrSyntheticBody body) {
        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
    }

    public void visitBreakContinue(@NotNull IrBreakContinue jump) {
        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
    }

    public void visitBreak(@NotNull IrBreak jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
    }

    public void visitContinue(@NotNull IrContinue jump, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
    }

    public void visitCall(@NotNull IrCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitCallableReference(@NotNull IrCallableReference<?> expression2) {
        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
    }

    public void visitFunctionReference(@NotNull IrFunctionReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
    }

    public void visitPropertyReference(@NotNull IrPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
    }

    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
    }

    public void visitClassReference(@NotNull IrClassReference expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
    }

    public void visitClassReference(@NotNull IrClassReference expression2) {
        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
    }

    public void visitConst(@NotNull IrConst<?> expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
    }

    public void visitConstantValue(@NotNull IrConstantValue expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
    }

    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
    }

    public void visitConstantObject(@NotNull IrConstantObject expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
    }

    public void visitConstantArray(@NotNull IrConstantArray expression2) {
        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
    }

    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
    }

    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
    }

    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
    }

    public void visitErrorExpression(@NotNull IrErrorExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
    }

    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
    }

    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
    }

    public void visitGetField(@NotNull IrGetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
    }

    public void visitSetField(@NotNull IrSetField expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
    }

    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
    }

    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2) {
        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
    }

    public void visitLoop(@NotNull IrLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
    }

    public void visitLoop(@NotNull IrLoop loop) {
        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
    }

    public void visitReturn(@NotNull IrReturn expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
    }

    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
    }

    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
    }

    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
    }

    public void visitThrow(@NotNull IrThrow expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
    }

    public void visitTry(@NotNull IrTry aTry, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
    }

    public void visitCatch(@NotNull IrCatch aCatch) {
        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
    }

    public void visitValueAccess(@NotNull IrValueAccessExpression expression2) {
        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
    }

    public void visitGetValue(@NotNull IrGetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
    }

    public void visitSetValue(@NotNull IrSetValue expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
    }

    public void visitVararg(@NotNull IrVararg expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
    }

    public void visitSpreadElement(@NotNull IrSpreadElement spread) {
        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
    }

    public void visitWhen(@NotNull IrWhen expression2, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
    }

    public void visitBranch(@NotNull IrBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch, @Nullable Void data) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
    }

    public void visitElseBranch(@NotNull IrElseBranch branch) {
        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
    }

    private static final IrSimpleFunction unitGetInstance_delegate$lambda$0(BodyGenerator this$0) {
        return MiscKt.findUnitGetInstanceFunction(this$0.backendContext);
    }

    private static final IrField unitInstanceField_delegate$lambda$1(BodyGenerator this$0) {
        return MiscKt.findUnitInstanceField(this$0.backendContext);
    }

    private static final IrType visitVararg$lambda$11(IrConstructor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrValueParameter irValueParameter = (IrValueParameter)CollectionsKt.singleOrNull((List)it.getValueParameters());
        return irValueParameter != null ? irValueParameter.getType() : null;
    }

    private static final WasmSymbol<WasmTypeDeclaration> tryToGenerateWasmOpIntrinsicCall$getReferenceGcType(IrFunction $function, IrFunctionAccessExpression $call, BodyGenerator this$0) {
        IrValueParameter irValueParameter = $function.getDispatchReceiverParameter();
        if (irValueParameter == null || (irValueParameter = irValueParameter.getType()) == null) {
            IrType irType = $call.getTypeArgument(0);
            irValueParameter = irType;
            Intrinsics.checkNotNull((Object)irType);
        }
        IrValueParameter type = irValueParameter;
        WasmModuleCodegenContext wasmModuleCodegenContext = this$0.context;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)type);
        Intrinsics.checkNotNull((Object)irClassSymbol);
        return wasmModuleCodegenContext.referenceGcType(irClassSymbol);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[IrTypeOperator.values().length];
            try {
                nArray[IrTypeOperator.REINTERPRET_CAST.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IrTypeOperator.IMPLICIT_COERCION_TO_UNIT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[WasmImmediateKind.values().length];
            try {
                nArray[WasmImmediateKind.MEM_ARG.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.STRUCT_TYPE_IDX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.HEAP_TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.TYPE_IDX.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[WasmImmediateKind.MEMORY_IDX.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

