/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.BackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.JvmIrAttributesKt;
import org.jetbrains.kotlin.backend.jvm.JvmLoweredDeclarationOrigin;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrCoroutineUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrUtilsKt;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLowering;
import org.jetbrains.kotlin.backend.jvm.lower.AddContinuationLoweringKt;
import org.jetbrains.kotlin.backend.jvm.lower.JvmLocalDeclarationsLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLambdaLowering;
import org.jetbrains.kotlin.backend.jvm.lower.SuspendLoweringUtils;
import org.jetbrains.kotlin.backend.jvm.lower.TailCallOptimizationLowering;
import org.jetbrains.kotlin.backend.jvm.mapping.MethodSignatureMapper;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFieldBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrAttributeContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationsKt;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrMutableAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrTypeParametersContainer;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInlinedFunctionBlock;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrFunctionReferenceImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeSystemContextKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.TransformKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.load.java.JavaDescriptorVisibilities;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.util.OperatorNameConventions;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="AddContinuation", description="Add continuation classes and parameters to suspend functions", prerequisite={SuspendLambdaLowering.class, JvmLocalDeclarationsLowering.class, TailCallOptimizationLowering.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J*\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u0017*\u00020\r2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J6\u0010\u001a\u001a\u00020\b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001d\u001a\u00020\u0015H\u0002J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\u000e\u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering;", "Lorg/jetbrains/kotlin/backend/jvm/lower/SuspendLoweringUtils;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "addContinuationParameterToSuspendCalls", "generateContinuationClassForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "dispatchReceiverParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "attributeContainer", "Lorg/jetbrains/kotlin/ir/declarations/IrAttributeContainer;", "capturesCrossinline", "", "addConstructorForNamedFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "capturedThisField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "addInvokeSuspendForNamedFunction", "resultField", "labelField", "isStaticSuspendImpl", "toSuspendImplementationName", "Lorg/jetbrains/kotlin/name/Name;", "createStaticSuspendImpl", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "addContinuationObjectAndContinuationParameterToSuspendFunctions", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nAddContinuationLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n+ 2 declarationBuilders.kt\norg/jetbrains/kotlin/ir/builders/declarations/DeclarationBuildersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 ExpressionHelpers.kt\norg/jetbrains/kotlin/ir/builders/ExpressionHelpersKt\n+ 6 IrBuilder.kt\norg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder\n*L\n1#1,501:1\n50#2,4:502\n80#2:506\n74#2,10:507\n80#2:517\n74#2,10:518\n289#2:528\n283#2,13:529\n1#3:542\n350#4,12:543\n350#4,12:567\n350#4,12:591\n416#5,10:555\n416#5,10:579\n72#6,2:565\n72#6,2:589\n*S KotlinDebug\n*F\n+ 1 AddContinuationLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/AddContinuationLowering\n*L\n91#1:502,4\n101#1:506\n101#1:507,10\n108#1:517\n108#1:518,10\n129#1:528\n129#1:529,13\n137#1:543,12\n157#1:567,12\n172#1:591,12\n138#1:555,10\n270#1:579,10\n138#1:565,2\n270#1:589,2\n*E\n"})
public final class AddContinuationLowering
extends SuspendLoweringUtils
implements FileLoweringPass {
    public AddContinuationLowering(@NotNull JvmBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        this.addContinuationObjectAndContinuationParameterToSuspendFunctions(irFile);
        this.addContinuationParameterToSuspendCalls(irFile);
    }

    private final void addContinuationParameterToSuspendCalls(IrFile irFile) {
        IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irFile), (IrElementTransformerVoid)new IrElementTransformerVoid(this){
            private final List<IrFunction> functionStack;
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
                this.functionStack = new ArrayList<E>();
            }

            public final List<IrFunction> getFunctionStack() {
                return this.functionStack;
            }

            public IrStatement visitFunction(IrFunction declaration) {
                IrStatement irStatement;
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                UtilsKt.push(this.functionStack, (Object)declaration);
                IrStatement it = irStatement = super.visitFunction(declaration);
                boolean bl = false;
                UtilsKt.pop(this.functionStack);
                return irStatement;
            }

            public IrExpression visitFunctionReference(IrFunctionReference expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitFunctionReference(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrFunctionReference");
                IrFunctionReference transformed = (IrFunctionReference)irExpression;
                return (IrExpression)AddContinuationLoweringKt.access$retargetToSuspendView((IrMemberAccessExpression)transformed, this.this$0.getContext(), null, addContinuationParameterToSuspendCalls.1::visitFunctionReference$lambda$1);
            }

            public IrExpression visitCall(IrCall expression2) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                IrExpression irExpression = super.visitCall(expression2);
                Intrinsics.checkNotNull((Object)irExpression, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrCall");
                IrCall transformed = (IrCall)irExpression;
                IrFunction irFunction = (IrFunction)UtilsKt.peek(this.functionStack);
                if (irFunction == null) {
                    return (IrExpression)transformed;
                }
                return (IrExpression)AddContinuationLoweringKt.access$retargetToSuspendView((IrMemberAccessExpression)transformed, this.this$0.getContext(), irFunction, addContinuationParameterToSuspendCalls.1::visitCall$lambda$2);
            }

            private static final IrFunctionReference visitFunctionReference$lambda$1(IrFunctionReference $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (IrFunctionReference)IrFunctionReferenceImpl.Companion.fromSymbolOwner($this$retargetToSuspendView.getStartOffset(), $this$retargetToSuspendView.getEndOffset(), $this$retargetToSuspendView.getType(), (IrFunctionSymbol)it, $this$retargetToSuspendView.getTypeArgumentsCount(), $this$retargetToSuspendView.getReflectionTarget(), $this$retargetToSuspendView.getOrigin());
            }

            private static final IrCall visitCall$lambda$2(IrCall $this$retargetToSuspendView, IrSimpleFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)$this$retargetToSuspendView, (String)"$this$retargetToSuspendView");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (IrCall)IrCallImpl.Companion.fromSymbolOwner$default((IrCallImpl.Companion)IrCallImpl.Companion, (int)$this$retargetToSuspendView.getStartOffset(), (int)$this$retargetToSuspendView.getEndOffset(), (IrType)$this$retargetToSuspendView.getType(), (IrSimpleFunctionSymbol)it, (int)0, (int)0, (IrStatementOrigin)$this$retargetToSuspendView.getOrigin(), (IrClassSymbol)$this$retargetToSuspendView.getSuperQualifierSymbol(), (int)48, null);
            }
        });
    }

    private final IrClass generateContinuationClassForNamedFunction(IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        IrField irField;
        IrClass irClass;
        DescriptorVisibility descriptorVisibility;
        IrFactory $this$buildClass$iv = this.getContext().getIrFactory();
        boolean $i$f$buildClass = false;
        IrClassBuilder $this$buildClass_u24lambda_u241$iv = new IrClassBuilder();
        boolean bl = false;
        IrClassBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u240 = $this$buildClass_u24lambda_u241$iv;
        boolean bl2 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setName(Name.special((String)"<Continuation>"));
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS());
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$generateContinuationClassForNamedFunction_u24lambda_u240.setVisibility(descriptorVisibility);
        IrClass $this$generateContinuationClassForNamedFunction_u24lambda_u244 = irClass = DeclarationBuildersKt.buildClass((IrFactory)$this$buildClass$iv, (IrClassBuilder)$this$buildClass_u24lambda_u241$iv);
        boolean bl3 = false;
        IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor((IrClass)$this$generateContinuationClassForNamedFunction_u24lambda_u244);
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setSuperTypes(CollectionsKt.plus((Collection)$this$generateContinuationClassForNamedFunction_u24lambda_u244.getSuperTypes(), (Object)IrUtilsKt.getDefaultType((IrClass)((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner()))));
        $this$generateContinuationClassForNamedFunction_u24lambda_u244.setParent((IrDeclarationParent)irFunction);
        IrUtilsKt.copyTypeParametersFrom$default((IrTypeParametersContainer)((IrTypeParametersContainer)$this$generateContinuationClassForNamedFunction_u24lambda_u244), (IrTypeParametersContainer)((IrTypeParametersContainer)irFunction), null, null, (int)6, null);
        IrClass $this$addField$iv = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
        boolean $i$f$addField = false;
        IrFactory $this$buildField$iv$iv = $this$addField$iv.getFactory();
        boolean $i$f$buildField = false;
        IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv = new IrFieldBuilder();
        boolean bl4 = false;
        IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241 = $this$buildField_u24lambda_u244$iv$iv;
        boolean bl5 = false;
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setOrigin((IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getCONTINUATION_CLASS_RESULT_FIELD());
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setName(Name.identifier((String)"result"));
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setType(this.getContext().getIr().getSymbols().getResultOfAnyType());
        $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u241.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
        IrFactory field$iv = $this$buildField$iv$iv = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv);
        boolean bl6 = false;
        field$iv.setParent((IrDeclarationParent)$this$addField$iv);
        $this$addField$iv.getDeclarations().add(field$iv);
        IrFactory resultField = $this$buildField$iv$iv;
        IrValueParameter irValueParameter = dispatchReceiverParameter;
        if (irValueParameter != null) {
            IrField irField2;
            IrValueParameter it = irValueParameter;
            boolean bl7 = false;
            IrClass $this$addField$iv2 = $this$generateContinuationClassForNamedFunction_u24lambda_u244;
            boolean $i$f$addField2 = false;
            IrFactory $this$buildField$iv$iv2 = $this$addField$iv2.getFactory();
            boolean $i$f$buildField2 = false;
            IrFieldBuilder $this$buildField_u24lambda_u244$iv$iv2 = new IrFieldBuilder();
            $i$a$-run-DeclarationBuildersKt$buildField$2$iv$iv = false;
            IrFieldBuilder $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242 = $this$buildField_u24lambda_u244$iv$iv2;
            boolean bl8 = false;
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setName(Name.identifier((String)"this$0"));
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setType(it.getType());
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setOrigin((IrDeclarationOrigin)IrDeclarationOrigin.Companion.getFIELD_FOR_OUTER_THIS());
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setVisibility(JavaDescriptorVisibilities.PACKAGE_VISIBILITY);
            $this$generateContinuationClassForNamedFunction_u24lambda_u244_u24lambda_u243_u24lambda_u242.setFinal(true);
            IrField field$iv2 = irField2 = DeclarationBuildersKt.buildField((IrFactory)$this$buildField$iv$iv2, (IrFieldBuilder)$this$buildField_u24lambda_u244$iv$iv2);
            $i$a$-also-DeclarationBuildersKt$addField$1$iv = false;
            field$iv2.setParent((IrDeclarationParent)$this$addField$iv2);
            $this$addField$iv2.getDeclarations().add(field$iv2);
            irField = irField2;
        } else {
            irField = null;
        }
        IrField capturedThisField = irField;
        IrType irType = this.getContext().getIrBuiltIns().getIntType();
        DescriptorVisibility descriptorVisibility4 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility4, (String)"PACKAGE_VISIBILITY");
        IrField labelField = DeclarationBuildersKt.addField((IrClass)$this$generateContinuationClassForNamedFunction_u24lambda_u244, (String)"label", (IrType)irType, (DescriptorVisibility)descriptorVisibility4);
        this.addConstructorForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, capturedThisField, capturesCrossinline);
        this.addInvokeSuspendForNamedFunction($this$generateContinuationClassForNamedFunction_u24lambda_u244, irFunction, (IrField)resultField, labelField, capturedThisField, Intrinsics.areEqual((Object)irFunction.getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION()));
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)((IrAttributeContainer)$this$generateContinuationClassForNamedFunction_u24lambda_u244), (IrAttributeContainer)attributeContainer);
        return irClass;
    }

    /*
     * WARNING - void declaration
     */
    private final IrConstructor addConstructorForNamedFunction(IrClass $this$addConstructorForNamedFunction, IrField capturedThisField, boolean capturesCrossinline) {
        void it;
        IrDelegatingConstructorCall irDelegatingConstructorCall;
        void $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        void this_$iv$iv;
        IrConstructor it2;
        IrValueParameter irValueParameter;
        IrFactory irFactory;
        DescriptorVisibility descriptorVisibility;
        IrClass $this$addConstructor$iv = $this$addConstructorForNamedFunction;
        boolean $i$f$addConstructor = false;
        IrFactory $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
        boolean $i$f$buildConstructor = false;
        IrFunctionBuilder $this$buildConstructor_u24lambda_u2424$iv$iv = new IrFunctionBuilder();
        boolean bl = false;
        IrFunctionBuilder $this$addConstructor_u24lambda_u2425$iv = $this$buildConstructor_u24lambda_u2424$iv$iv;
        boolean bl2 = false;
        IrFunctionBuilder $this$addConstructorForNamedFunction_u24lambda_u245 = $this$addConstructor_u24lambda_u2425$iv;
        boolean bl3 = false;
        $this$addConstructorForNamedFunction_u24lambda_u245.setPrimary(true);
        $this$addConstructorForNamedFunction_u24lambda_u245.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructorForNamedFunction));
        if (capturesCrossinline) {
            DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PUBLIC;
            descriptorVisibility = descriptorVisibility2;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PUBLIC");
        } else {
            DescriptorVisibility descriptorVisibility3 = JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
            descriptorVisibility = descriptorVisibility3;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility3, (String)"PACKAGE_VISIBILITY");
        }
        $this$addConstructorForNamedFunction_u24lambda_u245.setVisibility(descriptorVisibility);
        $this$addConstructor_u24lambda_u2425$iv.setReturnType((IrType)IrUtilsKt.getDefaultType((IrClass)$this$addConstructor$iv));
        IrFactory constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, (IrFunctionBuilder)$this$buildConstructor_u24lambda_u2424$iv$iv);
        boolean bl4 = false;
        $this$addConstructor$iv.getDeclarations().add(constructor$iv);
        constructor$iv.setParent((IrDeclarationParent)$this$addConstructor$iv);
        IrFactory constructor = irFactory = $this$buildConstructor$iv$iv;
        boolean bl5 = false;
        IrField irField = capturedThisField;
        if (irField != null) {
            IrField it3 = irField;
            boolean bl6 = false;
            IrFunction irFunction = (IrFunction)constructor;
            String string = it3.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            irValueParameter = DeclarationBuildersKt.addValueParameter$default((IrFunction)irFunction, (String)string, (IrType)it3.getType(), null, (int)4, null);
        } else {
            irValueParameter = null;
        }
        IrValueParameter capturedThisParameter = irValueParameter;
        IrValueParameter completionParameterSymbol = this.addCompletionValueParameter((IrFunction)constructor);
        Sequence $this$single$iv = IrUtilsKt.getConstructors((IrClass)((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner()));
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            it2 = (IrConstructor)element$iv;
            boolean bl7 = false;
            if (!(it2.getValueParameters().size() == 1)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrConstructor superClassConstructor = single$iv;
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.getContext()), (IrSymbol)((IrSymbol)constructor.getSymbol()), (int)0, (int)0, (int)6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        Iterator iterator2 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        it2 = this_$iv$iv;
        IrFactory irFactory2 = constructor;
        boolean bl8 = false;
        if (capturedThisField != null) {
            IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter2 = $this$addConstructorForNamedFunction.getThisReceiver();
            Intrinsics.checkNotNull((Object)irValueParameter2);
            IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2));
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
            IrValueParameter irValueParameter3 = capturedThisParameter;
            Intrinsics.checkNotNull((Object)irValueParameter3);
            $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)irBuilderWithScope, (IrExpression)irExpression, (IrField)capturedThisField, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter3))), null, (int)8, null));
        }
        IrDelegatingConstructorCall irDelegatingConstructorCall2 = irDelegatingConstructorCall = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249), (IrConstructor)superClassConstructor);
        void var21_29 = $this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249;
        boolean bl9 = false;
        it.putValueArgument(0, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addConstructorForNamedFunction_u24lambda_u2410_u24lambda_u249), (IrValueDeclaration)((IrValueDeclaration)completionParameterSymbol)));
        var21_29.unaryPlus((IrStatement)irDelegatingConstructorCall);
        irFactory2.setBody((IrBody)this_$iv$iv.doBuild());
        return irFactory;
    }

    /*
     * WARNING - void declaration
     */
    private final void addInvokeSuspendForNamedFunction(IrClass $this$addInvokeSuspendForNamedFunction, IrFunction irFunction, IrField resultField, IrField labelField, IrField capturedThisField, boolean isStaticSuspendImpl) {
        void $this$single$iv;
        JvmBackendContext backendContext = this.getContext();
        Sequence sequence = IrUtilsKt.getFunctions((IrClass)((IrClass)this.getContext().getIr().getSymbols().getContinuationImplClass().getOwner()));
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunction it = (IrSimpleFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)Name.identifier((String)"invokeSuspend"))) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        IrSimpleFunction invokeSuspend = single$iv;
        this.addFunctionOverride($this$addInvokeSuspendForNamedFunction, invokeSuspend, irFunction.getStartOffset(), irFunction.getEndOffset(), (Function2<? super IrBlockBodyBuilder, ? super IrFunction, Unit>)((Function2)(arg_0, arg_1) -> AddContinuationLowering.addInvokeSuspendForNamedFunction$lambda$16(resultField, labelField, irFunction, $this$addInvokeSuspendForNamedFunction, capturedThisField, backendContext, isStaticSuspendImpl, arg_0, arg_1)));
    }

    private final Name toSuspendImplementationName(Name $this$toSuspendImplementationName) {
        Name name = Name.guessByFirstCharacter((String)($this$toSuspendImplementationName.asString() + "$suspendImpl"));
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"guessByFirstCharacter(...)");
        return name;
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction createStaticSuspendImpl(IrSimpleFunction irFunction) {
        void it;
        int i;
        void $this$createStaticSuspendImpl_u24lambda_u2419;
        IrFunctionAccessExpression irFunctionAccessExpression;
        void this_$iv$iv;
        IrFactory irFactory = this.getContext().getIrFactory();
        IrDeclarationParent irDeclarationParent = irFunction.getParent();
        Name name = this.toSuspendImplementationName(irFunction.getName());
        IrFunction irFunction2 = (IrFunction)irFunction;
        IrDeclarationOrigin irDeclarationOrigin = (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getSUSPEND_IMPL_STATIC_FUNCTION();
        DescriptorVisibility descriptorVisibility = JvmIrUtilsKt.isJvmInterface(IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction))) ? DescriptorVisibilities.PUBLIC : JavaDescriptorVisibilities.PACKAGE_VISIBILITY;
        Intrinsics.checkNotNull((Object)descriptorVisibility);
        IrSimpleFunction irSimpleFunction = IrUtilsKt.createStaticFunctionWithReceivers$default((IrFactory)irFactory, (IrDeclarationParent)irDeclarationParent, (Name)name, (IrFunction)irFunction2, null, (IrDeclarationOrigin)irDeclarationOrigin, (Modality)Modality.OPEN, (DescriptorVisibility)descriptorVisibility, (boolean)false, (boolean)false, (List)IrTypeSystemContextKt.extractTypeParameters((IrDeclarationParent)((IrDeclarationParent)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction)))), (Function3)((Function3)new Function3<IrFunction, IrFunction, Map<IrValueParameter, ? extends IrValueParameter>, Unit>((Object)this.getContext()){

            public final void invoke(IrFunction p0, IrFunction p1, Map<IrValueParameter, ? extends IrValueParameter> p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                ((JvmBackendContext)this.receiver).remapMultiFieldValueClassStructure(p0, p1, p2);
            }

            public final String getSignature() {
                return "remapMultiFieldValueClassStructure(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Ljava/util/Map;)V";
            }

            public final String getName() {
                return "remapMultiFieldValueClassStructure";
            }

            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JvmBackendContext.class);
            }
        }), (int)8, null);
        irSimpleFunction.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)irFunction), (IrFunction)((IrFunction)irSimpleFunction)));
        if (IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)irFunction)).isInner()) {
            IrValueParameter movedDispatchParameter = (IrValueParameter)irSimpleFunction.getValueParameters().get(0);
            boolean bl = Intrinsics.areEqual((Object)movedDispatchParameter.getOrigin(), (Object)IrDeclarationOrigin.Companion.getMOVED_DISPATCH_RECEIVER());
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = false;
                String $i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22 = "MOVED_DISPATCH_RECEIVER should be the first parameter in " + RenderIrElementKt.render$default((IrElement)((IrElement)irSimpleFunction), null, (int)1, null);
                throw new AssertionError((Object)$i$a$-assert-AddContinuationLowering$createStaticSuspendImpl$22);
            }
            IrBody irBody = irSimpleFunction.getBody();
            Intrinsics.checkNotNull((Object)irBody);
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)((IrElement)irBody), (IrElementTransformerVoid)new IrElementTransformerVoid(irFunction, movedDispatchParameter, this){
                final /* synthetic */ IrSimpleFunction $irFunction;
                final /* synthetic */ IrValueParameter $movedDispatchParameter;
                final /* synthetic */ AddContinuationLowering this$0;
                {
                    this.$irFunction = $irFunction;
                    this.$movedDispatchParameter = $movedDispatchParameter;
                    this.this$0 = $receiver;
                }

                public IrExpression visitGetValue(IrGetValue expression2) {
                    Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                    IrValueDeclaration owner = expression2.getSymbol().getOwner();
                    if (owner instanceof IrValueParameter && this.isInstanceReceiverOfOuterClass((IrValueParameter)owner)) {
                        IrClass cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.$irFunction));
                        IrExpression value = (IrExpression)BuildersKt.IrGetValueImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrValueSymbol)((IrValueSymbol)this.$movedDispatchParameter.getSymbol()), null, (int)8, null);
                        while (!Intrinsics.areEqual((Object)cursor, (Object)((IrValueParameter)owner).getParent())) {
                            IrField outerThisField = this.this$0.getContext().getInnerClassesSupport().getOuterThisField(cursor);
                            value = (IrExpression)BuildersKt.IrGetFieldImpl$default((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrFieldSymbol)outerThisField.getSymbol(), (IrType)outerThisField.getType(), (IrExpression)value, null, null, (int)96, null);
                            cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)cursor));
                        }
                        return value;
                    }
                    return super.visitGetValue(expression2);
                }

                private final boolean isInstanceReceiverOfOuterClass(IrValueParameter param) {
                    if (!Intrinsics.areEqual((Object)param.getOrigin(), (Object)IrDeclarationOrigin.Companion.getINSTANCE_RECEIVER())) {
                        return false;
                    }
                    if (!(param.getParent() instanceof IrClass)) {
                        return false;
                    }
                    IrDeclarationParent cursor = IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)this.$irFunction)).getParent();
                    while (cursor instanceof IrClass) {
                        if (Intrinsics.areEqual((Object)cursor, (Object)param.getParent())) {
                            return true;
                        }
                        cursor = ((IrClass)cursor).getParent();
                    }
                    return false;
                }
            });
        }
        IrDeclarationsKt.copyAttributes((IrAttributeContainer)((IrAttributeContainer)irSimpleFunction), (IrAttributeContainer)((IrAttributeContainer)irFunction));
        IrBuilderWithScope $this$irBlockBody_u24default$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.getContext()), (IrSymbol)((IrSymbol)irFunction.getSymbol()), (int)0, (int)0, (int)6, null);
        int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
        int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
        boolean $i$f$irBlockBody = false;
        IrBlockBodyBuilder irBlockBodyBuilder = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
        boolean $i$f$blockBody = false;
        void var9_11 = this_$iv$iv;
        IrSimpleFunction irSimpleFunction2 = irFunction;
        boolean bl = false;
        IrFunctionAccessExpression irFunctionAccessExpression2 = irFunctionAccessExpression = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419), (IrFunction)((IrFunction)irSimpleFunction));
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
        void var14_17 = $this$createStaticSuspendImpl_u24lambda_u2419;
        boolean bl2 = false;
        int n = ((Collection)irFunction.getTypeParameters()).size();
        for (i = 0; i < n; ++i) {
            it.putTypeArgument(i, $this$createStaticSuspendImpl_u24lambda_u2419.getContext().getIrBuiltIns().getAnyNType());
        }
        i = 0;
        if (irFunction.getDispatchReceiverParameter() != null) {
            int n2 = i++;
            IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
            IrValueParameter irValueParameter = irFunction.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            it.putValueArgument(n2, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter)));
        }
        if (irFunction.getExtensionReceiverParameter() != null) {
            int n3 = i++;
            IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419;
            IrValueParameter irValueParameter = irFunction.getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter);
            it.putValueArgument(n3, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope3, (IrValueDeclaration)((IrValueDeclaration)irValueParameter)));
        }
        for (IrValueParameter parameter : irFunction.getValueParameters()) {
            it.putValueArgument(i++, (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$createStaticSuspendImpl_u24lambda_u2419), (IrValueDeclaration)((IrValueDeclaration)parameter)));
        }
        Unit unit = Unit.INSTANCE;
        var14_17.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)irFunctionAccessExpression)));
        irSimpleFunction2.setBody((IrBody)this_$iv$iv.doBuild());
        return irSimpleFunction;
    }

    private final void addContinuationObjectAndContinuationParameterToSuspendFunctions(IrFile irFile) {
        irFile.accept((IrElementVisitor)new IrElementTransformerVoid(this){
            final /* synthetic */ AddContinuationLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrStatement visitClass(IrClass declaration) {
                Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                TransformKt.transformDeclarationsFlat((IrDeclarationContainer)((IrDeclarationContainer)declaration), arg_0 -> addContinuationObjectAndContinuationParameterToSuspendFunctions.1.visitClass$lambda$0(this, arg_0));
                return (IrStatement)declaration;
            }

            /*
             * WARNING - void declaration
             */
            private final List<IrFunction> transformToView(IrSimpleFunction function2) {
                void $this$transformToView_u24lambda_u245;
                void this_$iv$iv;
                void $this$irBlockBody_u24default$iv;
                IrSimpleFunction irSimpleFunction;
                IrSimpleFunction $this$buildFun$iv;
                IrFunctionBuilder $this$transformToView_u24lambda_u242;
                Collection newType;
                IrFactory $this$filterTo$iv$iv;
                void $this$filter$iv;
                function2.accept((IrElementVisitor)this, null);
                boolean capturesCrossinline = this.isCapturingCrossinline(function2);
                IrSimpleFunction view = AddContinuationLoweringKt.access$suspendFunctionViewOrStub(function2, this.this$0.getContext());
                IrValueParameter continuationParameter = JvmIrCoroutineUtilsKt.continuationParameter((IrFunction)view);
                Iterable iterable = IrUtilsKt.getExplicitParameters((IrFunction)((IrFunction)view));
                Iterable iterable2 = IrUtilsKt.getExplicitParameters((IrFunction)((IrFunction)function2));
                boolean $i$f$filter22 = false;
                void var8_9 = $this$filter$iv;
                Object destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    IrValueParameter it = (IrValueParameter)element$iv$iv;
                    boolean bl = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)continuationParameter))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Map parameterMap = MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)iterable2, (Iterable)((List)destination$iv$iv)));
                view.setBody(IrInlineUtilsKt.moveBodyTo((IrFunction)((IrFunction)function2), (IrFunction)((IrFunction)view), (Map)parameterMap));
                Object[] $i$f$filter22 = new IrSimpleFunction[]{view};
                List result = CollectionsKt.mutableListOf((Object[])$i$f$filter22);
                if (function2.getBody() == null || !JvmIrCoroutineUtilsKt.hasContinuation((IrFunction)function2)) {
                    return result;
                }
                if (Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getLAMBDA_IMPL()) || Intrinsics.areEqual((Object)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)).getOrigin(), (Object)JvmLoweredDeclarationOrigin.INSTANCE.getFUNCTION_REFERENCE_IMPL())) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Type type = JvmIrAttributesKt.getLocalClassType((IrAttributeContainer)IrUtilsKt.getParentAsClass((IrDeclaration)((IrDeclaration)function2)));
                    Intrinsics.checkNotNull((Object)type);
                    newType = Type.getObjectType((String)stringBuilder.append(type.getInternalName()).append('$').append(function2.getName()).append("$1").toString());
                    JvmIrAttributesKt.setLocalClassType((IrAttributeContainer)function2, (Type)newType);
                }
                if (capturesCrossinline || function2.isInline()) {
                    DescriptorVisibility descriptorVisibility;
                    newType = result;
                    $this$filterTo$iv$iv = this.this$0.getContext().getIrFactory();
                    destination$iv$iv = this.this$0;
                    boolean $i$f$buildFun = false;
                    IrFunctionBuilder $this$buildFun_u24lambda_u2420$iv = new IrFunctionBuilder();
                    boolean bl = false;
                    $this$transformToView_u24lambda_u242 = $this$buildFun_u24lambda_u2420$iv;
                    boolean bl2 = false;
                    $this$transformToView_u24lambda_u242.setContainerSource(view.getContainerSource());
                    $this$transformToView_u24lambda_u242.setName(Name.identifier((String)(MethodSignatureMapper.mapFunctionName$default(((SuspendLoweringUtils)destination$iv$iv).getContext().getDefaultMethodSignatureMapper(), (IrFunction)view, false, 2, null) + "$$forInline")));
                    $this$transformToView_u24lambda_u242.setReturnType(view.getReturnType());
                    $this$transformToView_u24lambda_u242.setModality(view.getModality());
                    $this$transformToView_u24lambda_u242.setSuspend(view.isSuspend());
                    $this$transformToView_u24lambda_u242.setInline(view.isInline());
                    if (view.isInline()) {
                        DescriptorVisibility descriptorVisibility2 = DescriptorVisibilities.PRIVATE;
                        descriptorVisibility = descriptorVisibility2;
                        Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility2, (String)"PRIVATE");
                    } else {
                        descriptorVisibility = view.getVisibility();
                    }
                    $this$transformToView_u24lambda_u242.setVisibility(descriptorVisibility);
                    $this$transformToView_u24lambda_u242.setOrigin(view.isInline() ? (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE() : (IrDeclarationOrigin)JvmLoweredDeclarationOrigin.INSTANCE.getFOR_INLINE_STATE_MACHINE_TEMPLATE_CAPTURES_CROSSINLINE());
                    $this$buildFun$iv = DeclarationBuildersKt.buildFunction((IrFactory)$this$buildFun$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2420$iv);
                    destination$iv$iv = this.this$0;
                    IrSimpleFunction $this$transformToView_u24lambda_u243 = $this$buildFun$iv;
                    boolean bl3 = false;
                    IrUtilsKt.copyAnnotationsFrom((IrMutableAnnotationContainer)((IrMutableAnnotationContainer)$this$transformToView_u24lambda_u243), (IrAnnotationContainer)((IrAnnotationContainer)view));
                    IrUtilsKt.copyParameterDeclarationsFrom((IrFunction)((IrFunction)$this$transformToView_u24lambda_u243), (IrFunction)((IrFunction)view));
                    ((SuspendLoweringUtils)destination$iv$iv).getContext().remapMultiFieldValueClassStructure((IrFunction)view, (IrFunction)$this$transformToView_u24lambda_u243, null);
                    IrDeclarationsKt.copyAttributes((IrAttributeContainer)((IrAttributeContainer)$this$transformToView_u24lambda_u243), (IrAttributeContainer)((IrAttributeContainer)view));
                    ((SuspendLoweringUtils)destination$iv$iv).generateErrorForInlineBody($this$transformToView_u24lambda_u243);
                    newType.add($this$buildFun$iv);
                }
                if (IrUtilsKt.isOverridable((IrSimpleFunction)function2)) {
                    IrSimpleFunction it = $this$buildFun$iv = AddContinuationLowering.access$createStaticSuspendImpl(this.this$0, view);
                    boolean bl = false;
                    ((Collection)result).add(it);
                    irSimpleFunction = $this$buildFun$iv;
                } else {
                    irSimpleFunction = view;
                }
                IrSimpleFunction newFunction = irSimpleFunction;
                $this$buildFun$iv = (IrBuilderWithScope)LowerUtilsKt.createIrBuilder$default((BackendContext)((BackendContext)this.this$0.getContext()), (IrSymbol)((IrSymbol)newFunction.getSymbol()), (int)0, (int)0, (int)6, null);
                AddContinuationLowering addContinuationLowering = this.this$0;
                int startOffset$iv = $this$irBlockBody_u24default$iv.getStartOffset();
                int endOffset$iv = $this$irBlockBody_u24default$iv.getEndOffset();
                boolean $i$f$irBlockBody = false;
                $this$transformToView_u24lambda_u242 = new IrBlockBodyBuilder($this$irBlockBody_u24default$iv.getContext(), $this$irBlockBody_u24default$iv.getScope(), startOffset$iv, endOffset$iv);
                boolean $i$f$blockBody = false;
                void var15_22 = this_$iv$iv;
                iterable2 = newFunction;
                boolean bl = false;
                IrFunction irFunction = (IrFunction)newFunction;
                IrValueParameter irValueParameter = view.getDispatchReceiverParameter();
                Intrinsics.checkNotNull((Object)function2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrAttributeContainer");
                $this$transformToView_u24lambda_u245.unaryPlus((IrStatement)AddContinuationLowering.access$generateContinuationClassForNamedFunction(addContinuationLowering, irFunction, irValueParameter, (IrAttributeContainer)function2, capturesCrossinline));
                if (newFunction.getBody() instanceof IrExpressionBody) {
                    IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$transformToView_u24lambda_u245;
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    E e = IrUtilsKt.getStatements((IrBody)irBody).get(0);
                    Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    $this$transformToView_u24lambda_u245.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)e)));
                } else {
                    IrBody irBody = newFunction.getBody();
                    Intrinsics.checkNotNull((Object)irBody);
                    for (IrStatement statement : IrUtilsKt.getStatements((IrBody)irBody)) {
                        $this$transformToView_u24lambda_u245.unaryPlus(statement);
                    }
                }
                iterable2.setBody((IrBody)this_$iv$iv.doBuild());
                return result;
            }

            private final boolean isCapturingCrossinline(IrSimpleFunction $this$isCapturingCrossinline) {
                Ref.BooleanRef capturesCrossinline = new Ref.BooleanRef();
                IrAttributeContainer irAttributeContainer = $this$isCapturingCrossinline.getOriginalBeforeInline();
                if (irAttributeContainer == null) {
                    irAttributeContainer = (IrAttributeContainer)$this$isCapturingCrossinline;
                }
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)irAttributeContainer), (IrElementVisitorVoid)new IrElementVisitorVoid(capturesCrossinline){
                    final /* synthetic */ Ref.BooleanRef $capturesCrossinline;
                    {
                        this.$capturesCrossinline = $capturesCrossinline;
                    }

                    public void visitElement(IrElement element) {
                        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                        IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrElementVisitorVoid)this);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2) {
                        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                        if (Intrinsics.areEqual((Object)((IrField)expression2.getSymbol().getOwner()).getOrigin(), (Object)LocalDeclarationsLowering.Companion.getDECLARATION_ORIGIN_FIELD_FOR_CROSSINLINE_CAPTURED_VALUE())) {
                            this.$capturesCrossinline.element = true;
                            return;
                        }
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2);
                    }

                    public void visitClass(IrClass declaration) {
                        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    }

                    public void visitElement(IrElement element, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElement((IrElementVisitorVoid)this, (IrElement)element, (Void)data);
                    }

                    public void visitDeclaration(IrDeclarationBase declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration, (Void)data);
                    }

                    public void visitDeclaration(IrDeclarationBase declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclaration((IrElementVisitorVoid)this, (IrDeclarationBase)declaration);
                    }

                    public void visitValueParameter(IrValueParameter declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration, (Void)data);
                    }

                    public void visitValueParameter(IrValueParameter declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitValueParameter((IrElementVisitorVoid)this, (IrValueParameter)declaration);
                    }

                    public void visitClass(IrClass declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClass((IrElementVisitorVoid)this, (IrClass)declaration, (Void)data);
                    }

                    public void visitAnonymousInitializer(IrAnonymousInitializer declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration, (Void)data);
                    }

                    public void visitAnonymousInitializer(IrAnonymousInitializer declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitAnonymousInitializer((IrElementVisitorVoid)this, (IrAnonymousInitializer)declaration);
                    }

                    public void visitTypeParameter(IrTypeParameter declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration, (Void)data);
                    }

                    public void visitTypeParameter(IrTypeParameter declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeParameter((IrElementVisitorVoid)this, (IrTypeParameter)declaration);
                    }

                    public void visitFunction(IrFunction declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration, (Void)data);
                    }

                    public void visitFunction(IrFunction declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitFunction((IrElementVisitorVoid)this, (IrFunction)declaration);
                    }

                    public void visitConstructor(IrConstructor declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration, (Void)data);
                    }

                    public void visitConstructor(IrConstructor declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructor((IrElementVisitorVoid)this, (IrConstructor)declaration);
                    }

                    public void visitEnumEntry(IrEnumEntry declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration, (Void)data);
                    }

                    public void visitEnumEntry(IrEnumEntry declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumEntry((IrElementVisitorVoid)this, (IrEnumEntry)declaration);
                    }

                    public void visitErrorDeclaration(IrErrorDeclaration declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration, (Void)data);
                    }

                    public void visitErrorDeclaration(IrErrorDeclaration declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorDeclaration((IrElementVisitorVoid)this, (IrErrorDeclaration)declaration);
                    }

                    public void visitField(IrField declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration, (Void)data);
                    }

                    public void visitField(IrField declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitField((IrElementVisitorVoid)this, (IrField)declaration);
                    }

                    public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration, (Void)data);
                    }

                    public void visitLocalDelegatedProperty(IrLocalDelegatedProperty declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedProperty((IrElementVisitorVoid)this, (IrLocalDelegatedProperty)declaration);
                    }

                    public void visitModuleFragment(IrModuleFragment declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration, (Void)data);
                    }

                    public void visitModuleFragment(IrModuleFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitModuleFragment((IrElementVisitorVoid)this, (IrModuleFragment)declaration);
                    }

                    public void visitProperty(IrProperty declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration, (Void)data);
                    }

                    public void visitProperty(IrProperty declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitProperty((IrElementVisitorVoid)this, (IrProperty)declaration);
                    }

                    public void visitScript(IrScript declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration, (Void)data);
                    }

                    public void visitScript(IrScript declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitScript((IrElementVisitorVoid)this, (IrScript)declaration);
                    }

                    public void visitSimpleFunction(IrSimpleFunction declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration, (Void)data);
                    }

                    public void visitSimpleFunction(IrSimpleFunction declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitSimpleFunction((IrElementVisitorVoid)this, (IrSimpleFunction)declaration);
                    }

                    public void visitTypeAlias(IrTypeAlias declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration, (Void)data);
                    }

                    public void visitTypeAlias(IrTypeAlias declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeAlias((IrElementVisitorVoid)this, (IrTypeAlias)declaration);
                    }

                    public void visitVariable(IrVariable declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration, (Void)data);
                    }

                    public void visitVariable(IrVariable declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitVariable((IrElementVisitorVoid)this, (IrVariable)declaration);
                    }

                    public void visitPackageFragment(IrPackageFragment declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration, (Void)data);
                    }

                    public void visitPackageFragment(IrPackageFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitPackageFragment((IrElementVisitorVoid)this, (IrPackageFragment)declaration);
                    }

                    public void visitExternalPackageFragment(IrExternalPackageFragment declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration, (Void)data);
                    }

                    public void visitExternalPackageFragment(IrExternalPackageFragment declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitExternalPackageFragment((IrElementVisitorVoid)this, (IrExternalPackageFragment)declaration);
                    }

                    public void visitFile(IrFile declaration, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration, (Void)data);
                    }

                    public void visitFile(IrFile declaration) {
                        IrElementVisitorVoid.DefaultImpls.visitFile((IrElementVisitorVoid)this, (IrFile)declaration);
                    }

                    public void visitExpression(IrExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2, (Void)data);
                    }

                    public void visitExpression(IrExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitExpression((IrElementVisitorVoid)this, (IrExpression)expression2);
                    }

                    public void visitBody(IrBody body, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body, (Void)data);
                    }

                    public void visitBody(IrBody body) {
                        IrElementVisitorVoid.DefaultImpls.visitBody((IrElementVisitorVoid)this, (IrBody)body);
                    }

                    public void visitExpressionBody(IrExpressionBody body, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body, (Void)data);
                    }

                    public void visitExpressionBody(IrExpressionBody body) {
                        IrElementVisitorVoid.DefaultImpls.visitExpressionBody((IrElementVisitorVoid)this, (IrExpressionBody)body);
                    }

                    public void visitBlockBody(IrBlockBody body, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body, (Void)data);
                    }

                    public void visitBlockBody(IrBlockBody body) {
                        IrElementVisitorVoid.DefaultImpls.visitBlockBody((IrElementVisitorVoid)this, (IrBlockBody)body);
                    }

                    public void visitDeclarationReference(IrDeclarationReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2, (Void)data);
                    }

                    public void visitDeclarationReference(IrDeclarationReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDeclarationReference((IrElementVisitorVoid)this, (IrDeclarationReference)expression2);
                    }

                    public void visitMemberAccess(IrMemberAccessExpression<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2, (Void)data);
                    }

                    public void visitMemberAccess(IrMemberAccessExpression<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitMemberAccess((IrElementVisitorVoid)this, expression2);
                    }

                    public void visitFunctionAccess(IrFunctionAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2, (Void)data);
                    }

                    public void visitFunctionAccess(IrFunctionAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionAccess((IrElementVisitorVoid)this, (IrFunctionAccessExpression)expression2);
                    }

                    public void visitConstructorCall(IrConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2, (Void)data);
                    }

                    public void visitConstructorCall(IrConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstructorCall((IrElementVisitorVoid)this, (IrConstructorCall)expression2);
                    }

                    public void visitSingletonReference(IrGetSingletonValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2, (Void)data);
                    }

                    public void visitSingletonReference(IrGetSingletonValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSingletonReference((IrElementVisitorVoid)this, (IrGetSingletonValue)expression2);
                    }

                    public void visitGetObjectValue(IrGetObjectValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2, (Void)data);
                    }

                    public void visitGetObjectValue(IrGetObjectValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetObjectValue((IrElementVisitorVoid)this, (IrGetObjectValue)expression2);
                    }

                    public void visitGetEnumValue(IrGetEnumValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2, (Void)data);
                    }

                    public void visitGetEnumValue(IrGetEnumValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetEnumValue((IrElementVisitorVoid)this, (IrGetEnumValue)expression2);
                    }

                    public void visitRawFunctionReference(IrRawFunctionReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2, (Void)data);
                    }

                    public void visitRawFunctionReference(IrRawFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitRawFunctionReference((IrElementVisitorVoid)this, (IrRawFunctionReference)expression2);
                    }

                    public void visitContainerExpression(IrContainerExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2, (Void)data);
                    }

                    public void visitContainerExpression(IrContainerExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitContainerExpression((IrElementVisitorVoid)this, (IrContainerExpression)expression2);
                    }

                    public void visitBlock(IrBlock expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2, (Void)data);
                    }

                    public void visitBlock(IrBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitBlock((IrElementVisitorVoid)this, (IrBlock)expression2);
                    }

                    public void visitComposite(IrComposite expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2, (Void)data);
                    }

                    public void visitComposite(IrComposite expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitComposite((IrElementVisitorVoid)this, (IrComposite)expression2);
                    }

                    public void visitReturnableBlock(IrReturnableBlock expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2, (Void)data);
                    }

                    public void visitReturnableBlock(IrReturnableBlock expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturnableBlock((IrElementVisitorVoid)this, (IrReturnableBlock)expression2);
                    }

                    public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock, (Void)data);
                    }

                    public void visitInlinedFunctionBlock(IrInlinedFunctionBlock inlinedBlock) {
                        IrElementVisitorVoid.DefaultImpls.visitInlinedFunctionBlock((IrElementVisitorVoid)this, (IrInlinedFunctionBlock)inlinedBlock);
                    }

                    public void visitSyntheticBody(IrSyntheticBody body, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body, (Void)data);
                    }

                    public void visitSyntheticBody(IrSyntheticBody body) {
                        IrElementVisitorVoid.DefaultImpls.visitSyntheticBody((IrElementVisitorVoid)this, (IrSyntheticBody)body);
                    }

                    public void visitBreakContinue(IrBreakContinue jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump, (Void)data);
                    }

                    public void visitBreakContinue(IrBreakContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreakContinue((IrElementVisitorVoid)this, (IrBreakContinue)jump);
                    }

                    public void visitBreak(IrBreak jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump, (Void)data);
                    }

                    public void visitBreak(IrBreak jump) {
                        IrElementVisitorVoid.DefaultImpls.visitBreak((IrElementVisitorVoid)this, (IrBreak)jump);
                    }

                    public void visitContinue(IrContinue jump, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump, (Void)data);
                    }

                    public void visitContinue(IrContinue jump) {
                        IrElementVisitorVoid.DefaultImpls.visitContinue((IrElementVisitorVoid)this, (IrContinue)jump);
                    }

                    public void visitCall(IrCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2, (Void)data);
                    }

                    public void visitCall(IrCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCall((IrElementVisitorVoid)this, (IrCall)expression2);
                    }

                    public void visitCallableReference(IrCallableReference<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2, (Void)data);
                    }

                    public void visitCallableReference(IrCallableReference<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitCallableReference((IrElementVisitorVoid)this, expression2);
                    }

                    public void visitFunctionReference(IrFunctionReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2, (Void)data);
                    }

                    public void visitFunctionReference(IrFunctionReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionReference((IrElementVisitorVoid)this, (IrFunctionReference)expression2);
                    }

                    public void visitPropertyReference(IrPropertyReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2, (Void)data);
                    }

                    public void visitPropertyReference(IrPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitPropertyReference((IrElementVisitorVoid)this, (IrPropertyReference)expression2);
                    }

                    public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2, (Void)data);
                    }

                    public void visitLocalDelegatedPropertyReference(IrLocalDelegatedPropertyReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitLocalDelegatedPropertyReference((IrElementVisitorVoid)this, (IrLocalDelegatedPropertyReference)expression2);
                    }

                    public void visitClassReference(IrClassReference expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2, (Void)data);
                    }

                    public void visitClassReference(IrClassReference expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitClassReference((IrElementVisitorVoid)this, (IrClassReference)expression2);
                    }

                    public void visitConst(IrConst<?> expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2, (Void)data);
                    }

                    public void visitConst(IrConst<?> expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConst((IrElementVisitorVoid)this, expression2);
                    }

                    public void visitConstantValue(IrConstantValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2, (Void)data);
                    }

                    public void visitConstantValue(IrConstantValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantValue((IrElementVisitorVoid)this, (IrConstantValue)expression2);
                    }

                    public void visitConstantPrimitive(IrConstantPrimitive expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2, (Void)data);
                    }

                    public void visitConstantPrimitive(IrConstantPrimitive expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantPrimitive((IrElementVisitorVoid)this, (IrConstantPrimitive)expression2);
                    }

                    public void visitConstantObject(IrConstantObject expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2, (Void)data);
                    }

                    public void visitConstantObject(IrConstantObject expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantObject((IrElementVisitorVoid)this, (IrConstantObject)expression2);
                    }

                    public void visitConstantArray(IrConstantArray expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2, (Void)data);
                    }

                    public void visitConstantArray(IrConstantArray expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitConstantArray((IrElementVisitorVoid)this, (IrConstantArray)expression2);
                    }

                    public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2, (Void)data);
                    }

                    public void visitDelegatingConstructorCall(IrDelegatingConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDelegatingConstructorCall((IrElementVisitorVoid)this, (IrDelegatingConstructorCall)expression2);
                    }

                    public void visitDynamicExpression(IrDynamicExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2, (Void)data);
                    }

                    public void visitDynamicExpression(IrDynamicExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicExpression((IrElementVisitorVoid)this, (IrDynamicExpression)expression2);
                    }

                    public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2, (Void)data);
                    }

                    public void visitDynamicOperatorExpression(IrDynamicOperatorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicOperatorExpression((IrElementVisitorVoid)this, (IrDynamicOperatorExpression)expression2);
                    }

                    public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2, (Void)data);
                    }

                    public void visitDynamicMemberExpression(IrDynamicMemberExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitDynamicMemberExpression((IrElementVisitorVoid)this, (IrDynamicMemberExpression)expression2);
                    }

                    public void visitEnumConstructorCall(IrEnumConstructorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2, (Void)data);
                    }

                    public void visitEnumConstructorCall(IrEnumConstructorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitEnumConstructorCall((IrElementVisitorVoid)this, (IrEnumConstructorCall)expression2);
                    }

                    public void visitErrorExpression(IrErrorExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2, (Void)data);
                    }

                    public void visitErrorExpression(IrErrorExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorExpression((IrElementVisitorVoid)this, (IrErrorExpression)expression2);
                    }

                    public void visitErrorCallExpression(IrErrorCallExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2, (Void)data);
                    }

                    public void visitErrorCallExpression(IrErrorCallExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitErrorCallExpression((IrElementVisitorVoid)this, (IrErrorCallExpression)expression2);
                    }

                    public void visitFieldAccess(IrFieldAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFieldAccess((IrElementVisitorVoid)this, (IrFieldAccessExpression)expression2, (Void)data);
                    }

                    public void visitGetField(IrGetField expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2, (Void)data);
                    }

                    public void visitGetField(IrGetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetField((IrElementVisitorVoid)this, (IrGetField)expression2);
                    }

                    public void visitSetField(IrSetField expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2, (Void)data);
                    }

                    public void visitSetField(IrSetField expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetField((IrElementVisitorVoid)this, (IrSetField)expression2);
                    }

                    public void visitFunctionExpression(IrFunctionExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2, (Void)data);
                    }

                    public void visitFunctionExpression(IrFunctionExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitFunctionExpression((IrElementVisitorVoid)this, (IrFunctionExpression)expression2);
                    }

                    public void visitGetClass(IrGetClass expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2, (Void)data);
                    }

                    public void visitGetClass(IrGetClass expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetClass((IrElementVisitorVoid)this, (IrGetClass)expression2);
                    }

                    public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2, (Void)data);
                    }

                    public void visitInstanceInitializerCall(IrInstanceInitializerCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitInstanceInitializerCall((IrElementVisitorVoid)this, (IrInstanceInitializerCall)expression2);
                    }

                    public void visitLoop(IrLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop, (Void)data);
                    }

                    public void visitLoop(IrLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitLoop((IrElementVisitorVoid)this, (IrLoop)loop);
                    }

                    public void visitWhileLoop(IrWhileLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop, (Void)data);
                    }

                    public void visitWhileLoop(IrWhileLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitWhileLoop((IrElementVisitorVoid)this, (IrWhileLoop)loop);
                    }

                    public void visitDoWhileLoop(IrDoWhileLoop loop, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop, (Void)data);
                    }

                    public void visitDoWhileLoop(IrDoWhileLoop loop) {
                        IrElementVisitorVoid.DefaultImpls.visitDoWhileLoop((IrElementVisitorVoid)this, (IrDoWhileLoop)loop);
                    }

                    public void visitReturn(IrReturn expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2, (Void)data);
                    }

                    public void visitReturn(IrReturn expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitReturn((IrElementVisitorVoid)this, (IrReturn)expression2);
                    }

                    public void visitStringConcatenation(IrStringConcatenation expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2, (Void)data);
                    }

                    public void visitStringConcatenation(IrStringConcatenation expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitStringConcatenation((IrElementVisitorVoid)this, (IrStringConcatenation)expression2);
                    }

                    public void visitSuspensionPoint(IrSuspensionPoint expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2, (Void)data);
                    }

                    public void visitSuspensionPoint(IrSuspensionPoint expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspensionPoint((IrElementVisitorVoid)this, (IrSuspensionPoint)expression2);
                    }

                    public void visitSuspendableExpression(IrSuspendableExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2, (Void)data);
                    }

                    public void visitSuspendableExpression(IrSuspendableExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSuspendableExpression((IrElementVisitorVoid)this, (IrSuspendableExpression)expression2);
                    }

                    public void visitThrow(IrThrow expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2, (Void)data);
                    }

                    public void visitThrow(IrThrow expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitThrow((IrElementVisitorVoid)this, (IrThrow)expression2);
                    }

                    public void visitTry(IrTry aTry, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry, (Void)data);
                    }

                    public void visitTry(IrTry aTry) {
                        IrElementVisitorVoid.DefaultImpls.visitTry((IrElementVisitorVoid)this, (IrTry)aTry);
                    }

                    public void visitCatch(IrCatch aCatch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch, (Void)data);
                    }

                    public void visitCatch(IrCatch aCatch) {
                        IrElementVisitorVoid.DefaultImpls.visitCatch((IrElementVisitorVoid)this, (IrCatch)aCatch);
                    }

                    public void visitTypeOperator(IrTypeOperatorCall expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2, (Void)data);
                    }

                    public void visitTypeOperator(IrTypeOperatorCall expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitTypeOperator((IrElementVisitorVoid)this, (IrTypeOperatorCall)expression2);
                    }

                    public void visitValueAccess(IrValueAccessExpression expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2, (Void)data);
                    }

                    public void visitValueAccess(IrValueAccessExpression expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitValueAccess((IrElementVisitorVoid)this, (IrValueAccessExpression)expression2);
                    }

                    public void visitGetValue(IrGetValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2, (Void)data);
                    }

                    public void visitGetValue(IrGetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitGetValue((IrElementVisitorVoid)this, (IrGetValue)expression2);
                    }

                    public void visitSetValue(IrSetValue expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2, (Void)data);
                    }

                    public void visitSetValue(IrSetValue expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitSetValue((IrElementVisitorVoid)this, (IrSetValue)expression2);
                    }

                    public void visitVararg(IrVararg expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2, (Void)data);
                    }

                    public void visitVararg(IrVararg expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitVararg((IrElementVisitorVoid)this, (IrVararg)expression2);
                    }

                    public void visitSpreadElement(IrSpreadElement spread, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread, (Void)data);
                    }

                    public void visitSpreadElement(IrSpreadElement spread) {
                        IrElementVisitorVoid.DefaultImpls.visitSpreadElement((IrElementVisitorVoid)this, (IrSpreadElement)spread);
                    }

                    public void visitWhen(IrWhen expression2, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2, (Void)data);
                    }

                    public void visitWhen(IrWhen expression2) {
                        IrElementVisitorVoid.DefaultImpls.visitWhen((IrElementVisitorVoid)this, (IrWhen)expression2);
                    }

                    public void visitBranch(IrBranch branch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch, (Void)data);
                    }

                    public void visitBranch(IrBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitBranch((IrElementVisitorVoid)this, (IrBranch)branch);
                    }

                    public void visitElseBranch(IrElseBranch branch, Void data) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch, (Void)data);
                    }

                    public void visitElseBranch(IrElseBranch branch) {
                        IrElementVisitorVoid.DefaultImpls.visitElseBranch((IrElementVisitorVoid)this, (IrElseBranch)branch);
                    }
                });
                return capturesCrossinline.element;
            }

            private static final List visitClass$lambda$0(addContinuationObjectAndContinuationParameterToSuspendFunctions.1 this$0, IrDeclaration it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it instanceof IrSimpleFunction && ((IrSimpleFunction)it).isSuspend()) {
                    return this$0.transformToView((IrSimpleFunction)it);
                }
                it.accept((IrElementVisitor)this$0, null);
                return null;
            }
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit addInvokeSuspendForNamedFunction$lambda$16(IrField $resultField, IrField $labelField, IrFunction $irFunction, IrClass $this_addInvokeSuspendForNamedFunction, IrField $capturedThisField, JvmBackendContext $backendContext, boolean $isStaticSuspendImpl, IrBlockBodyBuilder $this$addFunctionOverride, IrFunction function2) {
        IrGetFieldImpl capturedThisValue;
        IrGetFieldImpl irGetFieldImpl;
        void it;
        void $this$single$iv;
        Intrinsics.checkNotNullParameter((Object)$this$addFunctionOverride, (String)"$this$addFunctionOverride");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter);
        $this$addFunctionOverride.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)irBuilderWithScope, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope2, (IrValueDeclaration)((IrValueDeclaration)irValueParameter))), (IrField)$resultField, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionOverride), (IrValueDeclaration)((IrValueDeclaration)function2.getValueParameters().get(0)))), null, (int)8, null));
        int signBit = Integer.MIN_VALUE;
        IrBuilderWithScope irBuilderWithScope3 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope4 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrValueParameter irValueParameter2 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter2);
        Sequence sequence = IrUtilsKt.getFunctions((IrClassSymbol)$this$addFunctionOverride.getContext().getIrBuiltIns().getIntClass());
        IrBuilderWithScope irBuilderWithScope5 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrField irField = $labelField;
        IrExpression irExpression = (IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope4, (IrValueDeclaration)((IrValueDeclaration)irValueParameter2));
        IrBuilderWithScope irBuilderWithScope6 = irBuilderWithScope3;
        IrBlockBodyBuilder irBlockBodyBuilder = $this$addFunctionOverride;
        boolean $i$f$single22 = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            IrSimpleFunctionSymbol it2 = (IrSimpleFunctionSymbol)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((IrSimpleFunction)it2.getOwner()).getName(), (Object)OperatorNameConventions.OR)) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Sequence contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Sequence contains no element matching the predicate.");
        }
        Object var23_33 = single$iv;
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = var23_33;
        IrType irType = $this$addFunctionOverride.getContext().getIrBuiltIns().getIntType();
        IrBuilderWithScope irBuilderWithScope7 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrBuilderWithScope irBuilderWithScope8 = (IrBuilderWithScope)$this$addFunctionOverride;
        IrValueParameter irValueParameter3 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter3);
        irBlockBodyBuilder.unaryPlus((IrStatement)ExpressionHelpersKt.irSetField$default((IrBuilderWithScope)irBuilderWithScope6, (IrExpression)irExpression, (IrField)irField, (IrExpression)((IrExpression)ExpressionHelpersKt.irCallOp$default((IrBuilderWithScope)irBuilderWithScope5, (IrSimpleFunctionSymbol)irSimpleFunctionSymbol, (IrType)irType, (IrExpression)((IrExpression)ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)irBuilderWithScope7, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope8, (IrValueDeclaration)((IrValueDeclaration)irValueParameter3))), (IrField)$labelField, null, (int)4, null)), (IrExpression)((IrExpression)ExpressionHelpersKt.irInt$default((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionOverride), (int)signBit, null, (int)2, null)), null, (int)16, null)), null, (int)8, null));
        Sequence $i$f$single22 = sequence = ExpressionHelpersKt.irCall((IrBuilderWithScope)((IrBuilderWithScope)$this$addFunctionOverride), (IrFunction)$irFunction);
        irBuilderWithScope6 = (IrBuilderWithScope)$this$addFunctionOverride;
        irBlockBodyBuilder = $this$addFunctionOverride;
        boolean bl = false;
        int n = ((Collection)$irFunction.getTypeParameters()).size();
        for (int i = 0; i < n; ++i) {
            it.putTypeArgument(i, (IrType)IrTypesKt.getDefaultType((IrTypeParameter)((IrTypeParameter)$this_addInvokeSuspendForNamedFunction.getTypeParameters().get(i))));
        }
        IrField irField2 = $capturedThisField;
        if (irField2 != null) {
            IrField irField3 = irField2;
            boolean bl2 = false;
            IrBuilderWithScope irBuilderWithScope9 = (IrBuilderWithScope)$this$addFunctionOverride;
            IrBuilderWithScope irBuilderWithScope10 = (IrBuilderWithScope)$this$addFunctionOverride;
            IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
            Intrinsics.checkNotNull((Object)irValueParameter4);
            irGetFieldImpl = ExpressionHelpersKt.irGetField$default((IrBuilderWithScope)irBuilderWithScope9, (IrExpression)((IrExpression)ExpressionHelpersKt.irGet((IrBuilderWithScope)irBuilderWithScope10, (IrValueDeclaration)((IrValueDeclaration)irValueParameter4))), (IrField)irField3, null, (int)4, null);
        } else {
            irGetFieldImpl = capturedThisValue = null;
        }
        if ($irFunction.getDispatchReceiverParameter() != null) {
            it.setDispatchReceiver((IrExpression)capturedThisValue);
        }
        IrValueParameter irValueParameter5 = $irFunction.getExtensionReceiverParameter();
        if (irValueParameter5 != null) {
            IrValueParameter extensionReceiverParameter = irValueParameter5;
            boolean bl3 = false;
            it.setExtensionReceiver(JvmIrTypeUtilsKt.defaultValue(extensionReceiverParameter.getType(), -1, -1, $backendContext));
        }
        Iterator iterator2 = ((Iterable)CollectionsKt.dropLast((List)$irFunction.getValueParameters(), (int)1)).iterator();
        int n2 = 0;
        while (iterator2.hasNext()) {
            int i = n2++;
            IrValueParameter parameter = (IrValueParameter)iterator2.next();
            it.putValueArgument(i, JvmIrTypeUtilsKt.defaultValue(parameter.getType(), -1, -1, $backendContext));
        }
        int n3 = $irFunction.getValueParameters().size() - 1;
        IrValueParameter irValueParameter6 = function2.getDispatchReceiverParameter();
        Intrinsics.checkNotNull((Object)irValueParameter6);
        it.putValueArgument(n3, (IrExpression)BuildersKt.IrGetValueImpl$default((int)-1, (int)-1, (IrValueSymbol)((IrValueSymbol)irValueParameter6.getSymbol()), null, (int)8, null));
        if ($isStaticSuspendImpl) {
            it.putValueArgument(0, (IrExpression)capturedThisValue);
        }
        irExpression = Unit.INSTANCE;
        irBlockBodyBuilder.unaryPlus((IrStatement)ExpressionHelpersKt.irReturn((IrBuilderWithScope)irBuilderWithScope6, (IrExpression)((IrExpression)sequence)));
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ IrSimpleFunction access$createStaticSuspendImpl(AddContinuationLowering $this, IrSimpleFunction irFunction) {
        return $this.createStaticSuspendImpl(irFunction);
    }

    public static final /* synthetic */ IrClass access$generateContinuationClassForNamedFunction(AddContinuationLowering $this, IrFunction irFunction, IrValueParameter dispatchReceiverParameter, IrAttributeContainer attributeContainer, boolean capturesCrossinline) {
        return $this.generateContinuationClassForNamedFunction(irFunction, dispatchReceiverParameter, attributeContainer, capturesCrossinline);
    }
}

