/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.ui;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterFreePainterAreaState;
import com.intellij.openapi.editor.ex.EditorPopupHandler;
import com.intellij.openapi.editor.impl.ContextMenuPopupHandler;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.TerminalColorPalette;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jediterm.core.Color;
import com.jediterm.core.util.TermSize;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.ui.AwtTransformers;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.block.output.TextAttributesProvider;
import org.jetbrains.plugins.terminal.block.output.TextStyleAdapter;
import org.jetbrains.plugins.terminal.block.ui.TerminalUiUtils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\"\u0010\u000e\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J%\u0010\u0016\u001a\u00020\u00172\u0016\u0010\u0018\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00170\u0019\"\u0004\u0018\u00010\u0017H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u001e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0010\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\tH\u0002J\u0014\u0010)\u001a\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010*\u001a\u00020+H\u0007J\u001a\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00102\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00103\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0018\u00104\u001a\u00020\u00172\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J\u0018\u00109\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010:\u001a\u00020\u000f2\u0006\u00105\u001a\u000206H\u0002J\u0016\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00042\u0006\u00100\u001a\u000201J\u0018\u0010>\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u000e\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u0004J\u0018\u0010B\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0002J\u0012\u0010C\u001a\u00020-*\u0002012\u0006\u0010D\u001a\u00020\u0004J\u0019\u0010E\u001a\u00020F*\u00020/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\bGR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006H"}, d2={"Lorg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils;", "", "()V", "GREEN_COLOR_INDEX", "", "TERMINAL_OUTPUT_CONTEXT_MENU", "", "YELLOW_COLOR_INDEX", "calculateTerminalSize", "Lcom/jediterm/core/util/TermSize;", "componentSize", "Ljava/awt/Dimension;", "charSize", "Ljava/awt/geom/Dimension2D;", "cancelFutureByTimeout", "", "future", "Ljava/util/concurrent/CompletableFuture;", "timeoutMillis", "", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "concatGroups", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "groups", "", "([Lcom/intellij/openapi/actionSystem/ActionGroup;)Lcom/intellij/openapi/actionSystem/ActionGroup;", "createOutputEditor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "createSingleShortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "keyCode", "modifiers", "ensureTermMinimumSize", "size", "getComponentSizeInitializedFuture", "component", "Ljava/awt/Component;", "getEffectiveBackgroundNoDefault", "Ljava/awt/Color;", "style", "Lcom/jediterm/terminal/TextStyle;", "palette", "Lcom/intellij/terminal/TerminalColorPalette;", "getEffectiveBackgroundOrDefault", "getEffectiveForegroundOrDefault", "getPopupMenuGroup", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "event", "Lcom/intellij/openapi/editor/event/EditorMouseEvent;", "getResultForeground", "installPopupMenu", "plainAttributesProvider", "Lorg/jetbrains/plugins/terminal/block/output/TextAttributesProvider;", "foregroundColorIndex", "toBackground", "toFloatAndScale", "", "value", "toForeground", "getAwtForegroundByIndex", "colorIndex", "toTextAttributes", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "toTextAttributes$intellij_terminal", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nTerminalUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,322:1\n14#2:323\n11383#3,9:324\n13309#3:333\n13310#3:337\n11392#3:338\n18#4:334\n26#5:335\n1#6:336\n1#6:339\n*S KotlinDebug\n*F\n+ 1 TerminalUiUtils.kt\norg/jetbrains/plugins/terminal/block/ui/TerminalUiUtils\n*L\n110#1:323\n116#1:324,9\n116#1:333\n116#1:337\n116#1:338\n117#1:334\n117#1:335\n116#1:336\n*E\n"})
public final class TerminalUiUtils {
    @NotNull
    public static final TerminalUiUtils INSTANCE = new TerminalUiUtils();
    @NotNull
    private static final String TERMINAL_OUTPUT_CONTEXT_MENU = "Terminal.OutputContextMenu";
    public static final int GREEN_COLOR_INDEX = 2;
    public static final int YELLOW_COLOR_INDEX = 3;

    private TerminalUiUtils() {
    }

    @NotNull
    public final EditorImpl createOutputEditor(@NotNull Document document, @NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settings) {
        EditorColorsScheme editorColorsScheme;
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Editor editor = EditorFactory.getInstance().createEditor(document, project, EditorKind.CONSOLE);
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
        EditorImpl editor2 = (EditorImpl)editor;
        editor2.setScrollToCaret(false);
        editor2.setRendererMode(true);
        editor2.getScrollPane().setBorder((Border)JBUI.Borders.empty());
        editor2.getScrollPane().setHorizontalScrollBarPolicy(31);
        editor2.getGutterComponentEx().setPaintBackground(false);
        editor2.getGutterComponentEx().setRightFreePaintersAreaState(EditorGutterFreePainterAreaState.HIDE);
        EditorColorsScheme $this$createOutputEditor_u24lambda_u240 = editorColorsScheme = editor2.getColorsScheme();
        boolean bl = false;
        $this$createOutputEditor_u24lambda_u240.setEditorFontName(settings.getTerminalFont().getFontName());
        $this$createOutputEditor_u24lambda_u240.setEditorFontSize(settings.getTerminalFont().getSize());
        $this$createOutputEditor_u24lambda_u240.setLineSpacing(1.0f);
        EditorColorsScheme $this$createOutputEditor_u24lambda_u241 = editorColorsScheme = editor2.getSettings();
        boolean bl2 = false;
        $this$createOutputEditor_u24lambda_u241.setShowingSpecialChars(false);
        $this$createOutputEditor_u24lambda_u241.setLineNumbersShown(false);
        $this$createOutputEditor_u24lambda_u241.setGutterIconsShown(false);
        $this$createOutputEditor_u24lambda_u241.setRightMarginShown(false);
        $this$createOutputEditor_u24lambda_u241.setFoldingOutlineShown(false);
        $this$createOutputEditor_u24lambda_u241.setCaretRowShown(false);
        $this$createOutputEditor_u24lambda_u241.setAdditionalLinesCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalColumnsCount(0);
        $this$createOutputEditor_u24lambda_u241.setAdditionalPageAtBottom(false);
        $this$createOutputEditor_u24lambda_u241.setBlockCursor(true);
        $this$createOutputEditor_u24lambda_u241.setWhitespacesShown(false);
        this.installPopupMenu((EditorEx)editor2);
        return editor2;
    }

    private final void installPopupMenu(EditorEx editor) {
        editor.installPopupHandler((EditorPopupHandler)new ContextMenuPopupHandler(editor){
            final /* synthetic */ EditorEx $editor;
            {
                this.$editor = $editor;
            }

            @NotNull
            public ActionGroup getActionGroup(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                return TerminalUiUtils.access$getPopupMenuGroup(TerminalUiUtils.INSTANCE, this.$editor, event);
            }
        });
    }

    private final ActionGroup getPopupMenuGroup(EditorEx editor, EditorMouseEvent event) {
        HyperlinkInfo info;
        ThreadingAssertions.assertEventDispatchThread();
        HyperlinkInfo $this$asSafely$iv = info = EditorHyperlinkSupport.get((Editor)((Editor)editor)).getHyperlinkInfoByEvent(event);
        boolean $i$f$asSafely = false;
        HyperlinkInfo hyperlinkInfo = $this$asSafely$iv;
        if (!(hyperlinkInfo instanceof HyperlinkWithPopupMenuInfo)) {
            hyperlinkInfo = null;
        }
        HyperlinkWithPopupMenuInfo hyperlinkWithPopupMenuInfo = (HyperlinkWithPopupMenuInfo)hyperlinkInfo;
        ActionGroup customPopupMenuGroup = hyperlinkWithPopupMenuInfo != null ? hyperlinkWithPopupMenuInfo.getPopupMenuGroup(event.getMouseEvent()) : null;
        AnAction anAction = ActionManager.getInstance().getAction(TERMINAL_OUTPUT_CONTEXT_MENU);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup defaultPopupMenuGroup = (ActionGroup)anAction;
        ActionGroup[] actionGroupArray = new ActionGroup[]{customPopupMenuGroup, defaultPopupMenuGroup};
        return this.concatGroups(actionGroupArray);
    }

    /*
     * WARNING - void declaration
     */
    private final ActionGroup concatGroups(ActionGroup ... groups) {
        void $this$mapNotNullTo$iv$iv;
        ActionGroup[] $this$mapNotNull$iv = groups;
        boolean $i$f$mapNotNull = false;
        Object object = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            List it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            void v0 = it;
            Object[] $this$orEmpty$iv = v0 != null ? v0.getChildren(null) : null;
            boolean $i$f$orEmpty = false;
            Object[] objectArray = $this$orEmpty$iv;
            if ($this$orEmpty$iv == null) {
                boolean $i$f$emptyArray = false;
                objectArray = new AnAction[]{};
            }
            if (UtilKt.nullize((List)ArraysKt.toList((Object[])objectArray)) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List actionsPerGroup = (List)destination$iv$iv;
        Iterable iterable = actionsPerGroup;
        object = new ArrayList();
        int n2 = 0;
        for (Object t : iterable) {
            void actions;
            int n3;
            if ((n3 = n2++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)t;
            int index = n3;
            boolean bl = false;
            CollectionsKt.addAll((Collection)object, (Iterable)((Iterable)(index > 0 ? CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)Separator.create()), (Iterable)((Iterable)actions)) : actions)));
        }
        List list = (List)object;
        return (ActionGroup)new DefaultActionGroup(list);
    }

    @NotNull
    public final ShortcutSet createSingleShortcutSet(int keyCode, int modifiers) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyCode, modifiers);
        return (ShortcutSet)new CustomShortcutSet(keyStroke);
    }

    @NotNull
    public final TermSize calculateTerminalSize(@NotNull Dimension componentSize, @NotNull Dimension2D charSize) {
        Intrinsics.checkNotNullParameter((Object)componentSize, (String)"componentSize");
        Intrinsics.checkNotNullParameter((Object)charSize, (String)"charSize");
        double width = (double)componentSize.width / charSize.getWidth();
        double height = (double)componentSize.height / charSize.getHeight();
        return this.ensureTermMinimumSize(new TermSize((int)width, (int)height));
    }

    private final TermSize ensureTermMinimumSize(TermSize size) {
        return new TermSize(Math.max(5, size.getColumns()), Math.max(2, size.getRows()));
    }

    @RequiresEdt
    @NotNull
    public final CompletableFuture<?> getComponentSizeInitializedFuture(@NotNull Component component2) {
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Dimension size = component2.getSize();
        if (size.width > 0 || size.height > 0) {
            CompletableFuture<Unit> completableFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            return completableFuture;
        }
        if (!UIUtil.isShowing((Component)component2, (boolean)false)) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new IllegalStateException("component should be showing"));
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(...)");
            return completableFuture;
        }
        CompletableFuture<Unit> componentResizedFuture = new CompletableFuture<Unit>();
        ComponentAdapter resizedListener2 = new ComponentAdapter(componentResizedFuture){
            final /* synthetic */ CompletableFuture<Unit> $componentResizedFuture;
            {
                this.$componentResizedFuture = $componentResizedFuture;
            }

            public void componentResized(@Nullable ComponentEvent e) {
                this.$componentResizedFuture.complete(Unit.INSTANCE);
            }
        };
        component2.addComponentListener(resizedListener2);
        componentResizedFuture.whenComplete((arg_0, arg_1) -> TerminalUiUtils.getComponentSizeInitializedFuture$lambda$4((Function2)new Function2<Unit, Throwable, Unit>(component2, resizedListener2){
            final /* synthetic */ Component $component;
            final /* synthetic */ getComponentSizeInitializedFuture.resizedListener.1 $resizedListener;
            {
                this.$component = $component;
                this.$resizedListener = $resizedListener;
                super(2);
            }

            public final void invoke(Unit unit, Throwable throwable) {
                this.$component.removeComponentListener(this.$resizedListener);
            }
        }, arg_0, arg_1));
        return componentResizedFuture;
    }

    public final void cancelFutureByTimeout(@NotNull CompletableFuture<?> future, long timeoutMillis, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter(future, (String)"future");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, parentDisposable);
        Runnable request2 = () -> TerminalUiUtils.cancelFutureByTimeout$lambda$5(future, timeoutMillis);
        alarm.addRequest(request2, timeoutMillis, ModalityState.any());
        Disposer.register((Disposable)((Disposable)alarm), () -> TerminalUiUtils.cancelFutureByTimeout$lambda$6(future));
        future.whenComplete((arg_0, arg_1) -> TerminalUiUtils.cancelFutureByTimeout$lambda$7((Function2)new Function2<Object, Throwable, Unit>(alarm){
            final /* synthetic */ Alarm $alarm;
            {
                this.$alarm = $alarm;
                super(2);
            }

            public final void invoke(Object object, Throwable throwable) {
                Disposer.dispose((Disposable)((Disposable)this.$alarm));
            }
        }, arg_0, arg_1));
    }

    public final float toFloatAndScale(int value) {
        return JBUIScale.scale((float)value);
    }

    @NotNull
    public final TextAttributes toTextAttributes$intellij_terminal(@NotNull TextStyle $this$toTextAttributes, @NotNull TerminalColorPalette palette) {
        TextAttributes textAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$toTextAttributes, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        TextAttributes attr = textAttributes = new TextAttributes();
        boolean bl = false;
        attr.setBackgroundColor(INSTANCE.getEffectiveBackgroundNoDefault($this$toTextAttributes, palette));
        attr.setForegroundColor(INSTANCE.getResultForeground($this$toTextAttributes, palette));
        if ($this$toTextAttributes.hasOption(TextStyle.Option.BOLD)) {
            attr.setFontType(attr.getFontType() | 1);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.ITALIC)) {
            attr.setFontType(attr.getFontType() | 2);
        }
        if ($this$toTextAttributes.hasOption(TextStyle.Option.UNDERLINED)) {
            attr.withAdditionalEffect(EffectType.LINE_UNDERSCORE, attr.getForegroundColor());
        }
        return textAttributes;
    }

    @NotNull
    public final java.awt.Color getAwtForegroundByIndex(@NotNull TerminalColorPalette $this$getAwtForegroundByIndex, int colorIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$getAwtForegroundByIndex, (String)"<this>");
        Color color = (0 <= colorIndex ? colorIndex < 16 : false) ? $this$getAwtForegroundByIndex.getForeground(TerminalColor.index((int)colorIndex)) : $this$getAwtForegroundByIndex.getDefaultForeground();
        Intrinsics.checkNotNull((Object)color);
        Color color2 = color;
        java.awt.Color color3 = AwtTransformers.toAwtColor((Color)color2);
        Intrinsics.checkNotNull((Object)color3);
        return color3;
    }

    private final java.awt.Color getResultForeground(TextStyle style, TerminalColorPalette palette) {
        java.awt.Color color;
        java.awt.Color foreground = this.getEffectiveForegroundOrDefault(style, palette);
        if (style.hasOption(TextStyle.Option.DIM)) {
            java.awt.Color background = this.getEffectiveBackgroundOrDefault(style, palette);
            color = new java.awt.Color((foreground.getRed() + background.getRed()) / 2, (foreground.getGreen() + background.getGreen()) / 2, (foreground.getBlue() + background.getBlue()) / 2, foreground.getAlpha());
        } else {
            color = foreground;
        }
        return color;
    }

    private final java.awt.Color getEffectiveForegroundOrDefault(TextStyle style, TerminalColorPalette palette) {
        return style.hasOption(TextStyle.Option.INVERSE) ? this.toBackground(style, palette) : this.toForeground(style, palette);
    }

    private final java.awt.Color getEffectiveBackgroundOrDefault(TextStyle style, TerminalColorPalette palette) {
        return style.hasOption(TextStyle.Option.INVERSE) ? this.toForeground(style, palette) : this.toBackground(style, palette);
    }

    private final java.awt.Color getEffectiveBackgroundNoDefault(TextStyle style, TerminalColorPalette palette) {
        java.awt.Color color;
        if (style.hasOption(TextStyle.Option.INVERSE)) {
            color = this.toForeground(style, palette);
        } else {
            TerminalColor terminalColor = style.getBackground();
            if (terminalColor != null) {
                TerminalColor it = terminalColor;
                boolean bl = false;
                color = AwtTransformers.toAwtColor((Color)palette.getBackground(it));
            } else {
                color = null;
            }
        }
        return color;
    }

    private final java.awt.Color toForeground(TextStyle style, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = style.getForeground();
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color = palette.getForeground(it);
                terminalColor = color;
                if (color != null) break block3;
            }
            terminalColor = palette.getDefaultForeground();
        }
        TerminalColor terminalColor2 = terminalColor;
        Intrinsics.checkNotNull((Object)terminalColor2);
        TerminalColor color = terminalColor2;
        java.awt.Color color2 = AwtTransformers.toAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    private final java.awt.Color toBackground(TextStyle style, TerminalColorPalette palette) {
        TerminalColor terminalColor;
        block3: {
            block2: {
                terminalColor = style.getBackground();
                if (terminalColor == null) break block2;
                TerminalColor it = terminalColor;
                boolean bl = false;
                Color color = palette.getBackground(it);
                terminalColor = color;
                if (color != null) break block3;
            }
            terminalColor = palette.getDefaultBackground();
        }
        TerminalColor terminalColor2 = terminalColor;
        Intrinsics.checkNotNull((Object)terminalColor2);
        TerminalColor color = terminalColor2;
        java.awt.Color color2 = AwtTransformers.toAwtColor((Color)color);
        Intrinsics.checkNotNull((Object)color2);
        return color2;
    }

    @NotNull
    public final TextAttributesProvider plainAttributesProvider(int foregroundColorIndex, @NotNull TerminalColorPalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new TextStyleAdapter(new TextStyle(new TerminalColor(foregroundColorIndex), null), palette);
    }

    private static final void getComponentSizeInitializedFuture$lambda$4(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final void cancelFutureByTimeout$lambda$5(CompletableFuture $future, long $timeoutMillis) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.completeExceptionally(new IllegalStateException("Terminal component layout is timed out (>" + $timeoutMillis + "ms)"));
    }

    private static final void cancelFutureByTimeout$lambda$6(CompletableFuture $future) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (!$future.isDone()) {
            ActionsKt.invokeLater((ModalityState)ModalityState.any(), (Function0)((Function0)new Function0<Unit>($future){
                final /* synthetic */ CompletableFuture<?> $future;
                {
                    this.$future = $future;
                    super(0);
                }

                public final void invoke() {
                    this.$future.completeExceptionally(new IllegalStateException("parent disposed"));
                }
            }));
        }
    }

    private static final void cancelFutureByTimeout$lambda$7(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ ActionGroup access$getPopupMenuGroup(TerminalUiUtils $this, EditorEx editor, EditorMouseEvent event) {
        return $this.getPopupMenuGroup(editor, event);
    }
}

