/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.block.output;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FocusChangeListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.jediterm.terminal.emulator.mouse.MouseMode;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.block.output.TerminalEventDispatcher;
import org.jetbrains.plugins.terminal.block.output.TerminalEventsHandler;
import org.jetbrains.plugins.terminal.block.session.TerminalModel;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a0\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\r"}, d2={"setupKeyEventDispatcher", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "eventsHandler", "Lorg/jetbrains/plugins/terminal/block/output/TerminalEventsHandler;", "disposable", "Lcom/intellij/openapi/Disposable;", "setupMouseListener", "settings", "Lcom/intellij/terminal/JBTerminalSystemSettingsProviderBase;", "model", "Lorg/jetbrains/plugins/terminal/block/session/TerminalModel;", "intellij.terminal"})
public final class TerminalEventDispatcherKt {
    public static final void setupKeyEventDispatcher(@NotNull EditorEx editor, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        TerminalEventDispatcher eventDispatcher2 = new TerminalEventDispatcher(editor, disposable, eventsHandler){
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            {
                this.$eventsHandler = $eventsHandler;
                super($editor, $disposable);
            }

            protected void handleKeyEvent(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getID() == 400) {
                    this.$eventsHandler.keyTyped(e);
                } else if (e.getID() == 401) {
                    this.$eventsHandler.keyPressed(e);
                }
            }
        };
        editor.addFocusListener(new FocusChangeListener(eventDispatcher2){
            final /* synthetic */ TerminalEventDispatcher $eventDispatcher;
            {
                this.$eventDispatcher = $eventDispatcher;
            }

            public void focusGained(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                List<AnAction> actionsToSkip = TerminalEventDispatcher.Companion.getActionsToSkip();
                this.$eventDispatcher.register(actionsToSkip);
            }

            public void focusLost(@NotNull Editor editor) {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                this.$eventDispatcher.unregister();
            }
        }, disposable);
    }

    public static final void setupMouseListener(@NotNull EditorEx editor, @NotNull JBTerminalSystemSettingsProviderBase settings, @NotNull TerminalModel model, @NotNull TerminalEventsHandler eventsHandler, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)eventsHandler, (String)"eventsHandler");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        editor.addEditorMouseListener(new EditorMouseListener(settings, eventsHandler, model){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalModel $model;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$model = $model;
            }

            public void mousePressed(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mousePressed(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseReleased(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseReleased(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        editor.addEditorMouseMotionListener(new EditorMouseMotionListener(settings, eventsHandler, model){
            final /* synthetic */ JBTerminalSystemSettingsProviderBase $settings;
            final /* synthetic */ TerminalEventsHandler $eventsHandler;
            final /* synthetic */ TerminalModel $model;
            {
                this.$settings = $settings;
                this.$eventsHandler = $eventsHandler;
                this.$model = $model;
            }

            public void mouseMoved(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseMoved(n, n2, mouseEvent2);
                    }
                }
            }

            public void mouseDragged(@NotNull EditorMouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.$settings.enableMouseReporting()) {
                    MouseEvent mouseEvent = event.getMouseEvent();
                    Intrinsics.checkNotNullExpressionValue((Object)mouseEvent, (String)"getMouseEvent(...)");
                    if (TerminalEventDispatcherKt.access$setupMouseListener$isRemoteMouseAction(this.$model, mouseEvent)) {
                        LogicalPosition logicalPosition = event.getLogicalPosition();
                        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"getLogicalPosition(...)");
                        LogicalPosition p = logicalPosition;
                        int n = p.column;
                        int n2 = p.line + TerminalEventDispatcherKt.access$setupMouseListener$historyLinesCount(this.$model);
                        MouseEvent mouseEvent2 = event.getMouseEvent();
                        Intrinsics.checkNotNullExpressionValue((Object)mouseEvent2, (String)"getMouseEvent(...)");
                        this.$eventsHandler.mouseDragged(n, n2, mouseEvent2);
                    }
                }
            }
        }, disposable);
        MouseWheelListener mouseWheelListener = arg_0 -> TerminalEventDispatcherKt.setupMouseListener$lambda$0(editor, eventsHandler, model, arg_0);
        editor.getScrollPane().addMouseWheelListener(mouseWheelListener);
        Disposer.register((Disposable)disposable, () -> TerminalEventDispatcherKt.setupMouseListener$lambda$1(editor, mouseWheelListener));
    }

    private static final boolean setupMouseListener$isRemoteMouseAction(TerminalModel $model, MouseEvent e) {
        return $model.getMouseMode() != MouseMode.MOUSE_REPORTING_NONE && !e.isShiftDown();
    }

    private static final int setupMouseListener$historyLinesCount(TerminalModel $model) {
        return $model.getUseAlternateBuffer() ? 0 : $model.getHistoryLinesCount();
    }

    private static final void setupMouseListener$lambda$0(EditorEx $editor, TerminalEventsHandler $eventsHandler, TerminalModel $model, MouseWheelEvent event) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$eventsHandler, (String)"$eventsHandler");
        Intrinsics.checkNotNullParameter((Object)$model, (String)"$model");
        LogicalPosition logicalPosition = $editor.xyToLogicalPosition(event.getPoint());
        Intrinsics.checkNotNullExpressionValue((Object)logicalPosition, (String)"xyToLogicalPosition(...)");
        LogicalPosition p = logicalPosition;
        int n = p.column;
        int n2 = p.line + TerminalEventDispatcherKt.setupMouseListener$historyLinesCount($model);
        Intrinsics.checkNotNull((Object)event);
        $eventsHandler.mouseWheelMoved(n, n2, event);
    }

    private static final void setupMouseListener$lambda$1(EditorEx $editor, MouseWheelListener $mouseWheelListener) {
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$mouseWheelListener, (String)"$mouseWheelListener");
        $editor.getScrollPane().removeMouseWheelListener($mouseWheelListener);
    }

    public static final /* synthetic */ boolean access$setupMouseListener$isRemoteMouseAction(TerminalModel $model, MouseEvent e) {
        return TerminalEventDispatcherKt.setupMouseListener$isRemoteMouseAction($model, e);
    }

    public static final /* synthetic */ int access$setupMouseListener$historyLinesCount(TerminalModel $model) {
        return TerminalEventDispatcherKt.setupMouseListener$historyLinesCount($model);
    }
}

