/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.startup.importSettings.providers.vsmac.parsers;

import com.intellij.ide.startup.importSettings.models.KeyBinding;
import com.intellij.ide.startup.importSettings.models.PatchedKeymap;
import com.intellij.ide.startup.importSettings.models.Settings;
import com.intellij.ide.startup.importSettings.providers.vsmac.mappings.KeyBindingsMappings;
import com.intellij.ide.startup.importSettings.providers.vsmac.parsers.KeyBindingsParserKt;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0002J\u0018\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u000bH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0019H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/parsers/KeyBindingsParser;", "", "settings", "Lcom/intellij/ide/startup/importSettings/models/Settings;", "(Lcom/intellij/ide/startup/importSettings/models/Settings;)V", "customShortcuts", "", "Lcom/intellij/ide/startup/importSettings/models/KeyBinding;", "addCustomShortcut", "", "foreignCommandId", "", "foreignShortcuts", "getKeyStroke", "Ljavax/swing/KeyStroke;", "s", "parseShortcuts", "", "Lcom/intellij/openapi/actionSystem/KeyboardShortcut;", "str", "process", "file", "Ljava/io/File;", "processCurrentScheme", "scheme", "Lorg/jdom/Element;", "processKeyBindings", "root", "Companion", "intellij.ide.startup.importSettings"})
@SourceDebugExtension(value={"SMAP\nKeyBindingsParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/providers/vsmac/parsers/KeyBindingsParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,109:1\n288#2,2:110\n1855#2,2:112\n1855#2,2:114\n1855#2,2:117\n1#3:116\n*S KotlinDebug\n*F\n+ 1 KeyBindingsParser.kt\ncom/intellij/ide/startup/importSettings/providers/vsmac/parsers/KeyBindingsParser\n*L\n39#1:110,2\n53#1:112,2\n84#1:114,2\n102#1:117,2\n*E\n"})
public final class KeyBindingsParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Settings settings;
    @NotNull
    private final List<KeyBinding> customShortcuts;
    @NotNull
    private static final String CURRENT = "current";
    @NotNull
    private static final String COMMAND = "command";
    @NotNull
    private static final String SHORTCUT = "shortcut";

    public KeyBindingsParser(@NotNull Settings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.customShortcuts = new ArrayList();
    }

    public final void process(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        try {
            KeyBindingsParserKt.access$getLogger$p().info("Processing a file: " + file);
            Element element = JDOMUtil.load((File)file);
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"load(...)");
            Element root = element;
            this.processKeyBindings(root);
        }
        catch (Throwable t) {
            KeyBindingsParserKt.access$getLogger$p().warn(t);
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void processKeyBindings(Element root) {
        block5: {
            v0 = root.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getChildren(...)");
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                block7: {
                    block6: {
                        scheme = (Element)element$iv;
                        $i$a$-firstOrNull-KeyBindingsParser$processKeyBindings$currentScheme$1 = false;
                        v1 = scheme;
                        v2 = var10_8 = v1 != null ? v1.getAttributes() : null;
                        if (v2 != null) break block6;
                        v3 = false;
                        break block7;
                    }
                    Intrinsics.checkNotNull((Object)v2);
                    schemeAttributes = var10_8;
                    if (schemeAttributes.size() != 1) ** GOTO lbl-1000
                    v4 = (Attribute)schemeAttributes.get(0);
                    if (Intrinsics.areEqual((Object)(v4 != null ? v4.getValue() : null), (Object)"current")) {
                        v3 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v3 = false;
                    }
                }
                if (!v3) continue;
                v5 = element$iv;
                break block5;
            }
            v5 = null;
        }
        v6 = v5;
        if (v6 == null) {
            return;
        }
        currentScheme = v6;
        this.processCurrentScheme(currentScheme);
        km = this.settings.getKeymap();
        if (((Collection)this.customShortcuts).isEmpty() == false && km != null) {
            this.settings.setKeymap(new PatchedKeymap(km.getTransferableId(), km, this.customShortcuts, CollectionsKt.emptyList()));
        }
    }

    private final void processCurrentScheme(Element scheme) {
        List list = scheme.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Element binding = (Element)element$iv;
            boolean bl = false;
            try {
                String string;
                String string2;
                List list2;
                Element element = binding;
                List list3 = list2 = element != null ? element.getAttributes() : null;
                if (list3 == null) continue;
                Intrinsics.checkNotNull((Object)list3);
                List attributes = list2;
                if (attributes.size() != 2) continue;
                Object object = (Attribute)attributes.get(0);
                boolean bl2 = object != null && (object = object.getName()) != null ? ((String)object).equals(COMMAND) : false;
                if (!bl2) continue;
                Object object2 = (Attribute)attributes.get(1);
                boolean bl3 = object2 != null && (object2 = object2.getName()) != null ? ((String)object2).equals(SHORTCUT) : false;
                if (!bl3) continue;
                Attribute attribute = (Attribute)attributes.get(0);
                String string3 = string2 = attribute != null ? attribute.getValue() : null;
                if (string3 == null) continue;
                Intrinsics.checkNotNull((Object)string3);
                String commandId = string2;
                Attribute attribute2 = (Attribute)attributes.get(1);
                String string4 = string = attribute2 != null ? attribute2.getValue() : null;
                if (string4 == null) continue;
                Intrinsics.checkNotNull((Object)string4);
                String shortcuts = string;
                this.addCustomShortcut(commandId, shortcuts);
            }
            catch (Throwable t) {
                KeyBindingsParserKt.access$getLogger$p().warn(t);
            }
        }
    }

    private final void addCustomShortcut(String foreignCommandId, String foreignShortcuts) {
        String string = KeyBindingsMappings.INSTANCE.commandIdMap(foreignCommandId);
        if (string == null) {
            return;
        }
        String commandId = string;
        List<KeyboardShortcut> list = this.parseShortcuts(foreignShortcuts);
        if (list == null) {
            return;
        }
        List<KeyboardShortcut> shortcuts = list;
        if (!Intrinsics.areEqual(KeyBindingsMappings.INSTANCE.getDefaultVSMacKeymap().get(commandId), shortcuts)) {
            this.customShortcuts.add(new KeyBinding(commandId, shortcuts, null, 4, null));
        }
    }

    private final List<KeyboardShortcut> parseShortcuts(String str) {
        Object object;
        SmartList shortcuts = new SmartList();
        Object object2 = new char[]{' '};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)str, (char[])object2, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KeyStroke firstKeyStroke;
            String shortcut = (String)element$iv;
            boolean bl = false;
            char[] cArray = new char[]{'|'};
            List strokes = StringsKt.split$default((CharSequence)shortcut, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            if (this.getKeyStroke((String)CollectionsKt.getOrNull((List)strokes, (int)0)) == null) {
                return null;
            }
            KeyStroke secondKeyStroke = this.getKeyStroke((String)CollectionsKt.getOrNull((List)strokes, (int)1));
            ((Collection)shortcuts).add(new KeyboardShortcut(firstKeyStroke, secondKeyStroke));
        }
        object2 = (Collection)shortcuts;
        if (object2.isEmpty()) {
            boolean bl = false;
            object = null;
        } else {
            object = object2;
        }
        return (List)object;
    }

    private final KeyStroke getKeyStroke(String s) {
        CharSequence charSequence = s;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        char[] cArray = new char[]{'+'};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)s, (String)"++", (String)"+Plus", (boolean)false, (int)4, null), (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            String normalizedShortcut = KeyBindingsMappings.INSTANCE.shortcutMap(it);
            sb.append(normalizedShortcut + " ");
        }
        return KeyStroke.getKeyStroke(((Object)StringsKt.dropLast((CharSequence)sb, (int)1)).toString());
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ide/startup/importSettings/providers/vsmac/parsers/KeyBindingsParser$Companion;", "", "()V", "COMMAND", "", "CURRENT", "SHORTCUT", "intellij.ide.startup.importSettings"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

