/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.memberPullUp;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.RefactoringHierarchyUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.classMembers.InterfaceContainmentVerifier;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.refactoring.GrRefactoringConflictsUtil;
import org.jetbrains.plugins.groovy.refactoring.classMembers.GrClassMemberReferenceVisitor;

public final class GrPullUpConflictsUtil {
    private GrPullUpConflictsUtil() {
    }

    public static MultiMap<PsiElement, String> checkConflicts(MemberInfoBase<? extends GrMember>[] infos, PsiClass subclass, @Nullable PsiClass superClass, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, InterfaceContainmentVerifier interfaceContainmentVerifier) {
        if (targetPackage == null) {
            GrPullUpConflictsUtil.$$$reportNull$$$0(0);
        }
        if (targetDirectory == null) {
            GrPullUpConflictsUtil.$$$reportNull$$$0(1);
        }
        return GrPullUpConflictsUtil.checkConflicts(infos, subclass, superClass, targetPackage, targetDirectory, interfaceContainmentVerifier, true);
    }

    /*
     * WARNING - void declaration
     * Issues handling annotations - annotations may be inaccurate
     */
    public static MultiMap<PsiElement, @Nls String> checkConflicts(MemberInfoBase<? extends GrMember>[] infos, @NotNull PsiClass subclass, @Nullable PsiClass superClass, @NotNull PsiPackage targetPackage, @NotNull PsiDirectory targetDirectory, InterfaceContainmentVerifier interfaceContainmentVerifier, boolean movedMembers2Super) {
        void var15_31;
        PsiDirectory targetRepresentativeElement;
        boolean isInterfaceTarget;
        if (subclass == null) {
            GrPullUpConflictsUtil.$$$reportNull$$$0(2);
        }
        if (targetPackage == null) {
            GrPullUpConflictsUtil.$$$reportNull$$$0(3);
        }
        if (targetDirectory == null) {
            GrPullUpConflictsUtil.$$$reportNull$$$0(4);
        }
        if (superClass != null) {
            isInterfaceTarget = superClass.isInterface();
            targetRepresentativeElement = superClass;
        } else {
            isInterfaceTarget = false;
            targetRepresentativeElement = targetDirectory;
        }
        final HashSet<GrMember> movedMembers = new HashSet<GrMember>();
        HashSet<GrMethod> abstractMethods = new HashSet<GrMethod>();
        for (MemberInfoBase<? extends GrMember> info : infos) {
            GrMember grMember = (GrMember)info.getMember();
            if (grMember instanceof GrMethod) {
                if (!info.isToAbstract() && !isInterfaceTarget) {
                    movedMembers.add(grMember);
                    continue;
                }
                abstractMethods.add((GrMethod)grMember);
                continue;
            }
            movedMembers.add(grMember);
        }
        HashSet<PsiMethod> allAbstractMethods = new HashSet<PsiMethod>(abstractMethods);
        if (superClass != null) {
            for (PsiMethod psiMethod : subclass.getMethods()) {
                if (movedMembers.contains(psiMethod) || psiMethod.hasModifierProperty("private") || psiMethod.findSuperMethods(superClass).length <= 0) continue;
                allAbstractMethods.add(psiMethod);
            }
        }
        final @Nls MultiMap conflicts = new MultiMap();
        GrRefactoringConflictsUtil.analyzeAccessibilityConflicts(movedMembers, superClass, (MultiMap<PsiElement, String>)conflicts, "EscalateVisible", (PsiElement)targetRepresentativeElement, allAbstractMethods);
        if (superClass != null) {
            if (movedMembers2Super) {
                GrPullUpConflictsUtil.checkSuperclassMembers(superClass, infos, (MultiMap<PsiElement, String>)conflicts);
                if (isInterfaceTarget) {
                    GrPullUpConflictsUtil.checkInterfaceTarget(infos, (MultiMap<PsiElement, String>)conflicts);
                }
            } else {
                String qualifiedName = superClass.getQualifiedName();
                assert (qualifiedName != null);
                if (superClass.hasModifierProperty("packageLocal") && !Comparing.strEqual((String)StringUtil.getPackageName((String)qualifiedName), (String)targetPackage.getQualifiedName())) {
                    conflicts.putValue((Object)superClass, (Object)GroovyBundle.message("pull.up.wont.be.accessible.from", RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)targetPackage, (boolean)true)));
                }
            }
        }
        ArrayList<PsiMember> checkModuleConflictsList = new ArrayList<PsiMember>();
        for (PsiMember psiMember : movedMembers) {
            if (psiMember instanceof PsiMethod || psiMember instanceof PsiClass && !(psiMember instanceof PsiCompiledElement)) {
                GrClassMemberReferenceVisitor visitor2 = movedMembers2Super ? new ConflictingUsagesOfSubClassMembers((PsiElement)psiMember, movedMembers, abstractMethods, subclass, superClass, superClass != null ? null : targetPackage, (MultiMap<PsiElement, String>)conflicts, interfaceContainmentVerifier) : new ConflictingUsagesOfSuperClassMembers(psiMember, subclass, targetPackage, movedMembers, (MultiMap<PsiElement, String>)conflicts);
                ((GroovyPsiElement)psiMember).accept(visitor2);
            }
            checkModuleConflictsList.add(psiMember);
        }
        for (PsiMethod psiMethod : abstractMethods) {
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)psiMethod.getParameterList());
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)psiMethod.getReturnTypeElement());
            ContainerUtil.addIfNotNull(checkModuleConflictsList, (Object)psiMethod.getTypeParameterList());
        }
        GrRefactoringConflictsUtil.analyzeModuleConflicts(subclass.getProject(), checkModuleConflictsList, UsageInfo.EMPTY_ARRAY, (PsiElement)targetRepresentativeElement, (MultiMap<PsiElement, String>)conflicts);
        String fqName = subclass.getQualifiedName();
        if (fqName != null) {
            String string = StringUtil.getPackageName((String)fqName);
        } else {
            PsiFile psiFile = (PsiFile)PsiTreeUtil.getParentOfType((PsiElement)subclass, PsiFile.class);
            if (psiFile instanceof PsiClassOwner) {
                String string = ((PsiClassOwner)psiFile).getPackageName();
            } else {
                Object var15_30 = null;
            }
        }
        final boolean toDifferentPackage = !Comparing.strEqual((String)targetPackage.getQualifiedName(), (String)var15_31);
        for (final GrMethod abstractMethod : abstractMethods) {
            abstractMethod.accept(new GrClassMemberReferenceVisitor(subclass){

                @Override
                protected void visitClassMemberReferenceElement(GrMember classMember, GrReferenceElement classMemberReference) {
                    if (classMember != null && GrPullUpConflictsUtil.willBeMoved(classMember, movedMembers)) {
                        boolean isAccessible = false;
                        if (classMember.hasModifierProperty("private")) {
                            isAccessible = true;
                        } else if (classMember.hasModifierProperty("packageLocal") && toDifferentPackage) {
                            isAccessible = true;
                        }
                        if (isAccessible) {
                            String message = GroovyBundle.message("pull.up.wont.be.accessible.from.the.subclass", RefactoringUIUtil.getDescription((PsiElement)abstractMethod, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true));
                            conflicts.putValue((Object)classMember, (Object)StringUtil.capitalize((String)message));
                        }
                    }
                }
            });
            if (!abstractMethod.hasModifierProperty("packageLocal") || !toDifferentPackage || isInterfaceTarget) continue;
            String message = GroovyBundle.message("pull.up.abstract.wont.be.accessible.from", RefactoringUIUtil.getDescription((PsiElement)abstractMethod, (boolean)false));
            conflicts.putValue((Object)abstractMethod, (Object)StringUtil.capitalize((String)message));
        }
        return conflicts;
    }

    private static void checkInterfaceTarget(MemberInfoBase<? extends GrMember>[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfoBase<? extends GrMember> info : infos) {
            String message;
            GrMember member = (GrMember)info.getMember();
            if (!(!(member instanceof PsiField) && !(member instanceof PsiClass) || member.hasModifierProperty("static") || member instanceof PsiClass && ((PsiClass)member).isInterface())) {
                message = JavaRefactoringBundle.message((String)"0.is.not.static.it.cannot.be.moved.to.the.interface", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                message = StringUtil.capitalize((String)message);
                conflictsList.putValue((Object)member, (Object)message);
            }
            if (!(member instanceof PsiField) || ((PsiField)member).getInitializer() != null) continue;
            message = JavaRefactoringBundle.message((String)"0.is.not.initialized.in.declaration.such.fields.are.not.allowed.in.interfaces", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
            conflictsList.putValue((Object)member, (Object)StringUtil.capitalize((String)message));
        }
    }

    private static void checkSuperclassMembers(PsiClass superClass, MemberInfoBase<? extends GrMember>[] infos, MultiMap<PsiElement, String> conflictsList) {
        for (MemberInfoBase<? extends GrMember> info : infos) {
            PsiMethod method;
            PsiModifierList modifierList;
            GrMember member = (GrMember)info.getMember();
            boolean isConflict = false;
            if (member instanceof PsiField) {
                String name = member.getName();
                isConflict = superClass.findFieldByName(name, false) != null;
            } else if (member instanceof PsiMethod) {
                PsiSubstitutor superSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)member.getContainingClass(), (PsiSubstitutor)PsiSubstitutor.EMPTY);
                MethodSignature signature = ((PsiMethod)member).getSignature(superSubstitutor);
                PsiMethod superClassMethod = MethodSignatureUtil.findMethodBySignature((PsiClass)superClass, (MethodSignature)signature, (boolean)false);
                boolean bl = isConflict = superClassMethod != null;
            }
            if (isConflict) {
                String message = RefactoringBundle.message((String)"0.already.contains.a.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)superClass, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)member, (boolean)false)});
                message = StringUtil.capitalize((String)message);
                conflictsList.putValue((Object)superClass, (Object)message);
            }
            if (!(member instanceof PsiMethod) || (modifierList = (method = (PsiMethod)member).getModifierList()).hasModifierProperty("private")) continue;
            for (PsiClass subClass : ClassInheritorsSearch.search((PsiClass)superClass)) {
                MethodSignature signature;
                PsiMethod wouldBeOverriden;
                if (method.getContainingClass() == subClass || (wouldBeOverriden = MethodSignatureUtil.findMethodBySignature((PsiClass)subClass, (MethodSignature)(signature = ((PsiMethod)member).getSignature(TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)subClass, (PsiSubstitutor)PsiSubstitutor.EMPTY))), (boolean)false)) == null || VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)wouldBeOverriden.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)modifierList)) <= 0) continue;
                conflictsList.putValue((Object)wouldBeOverriden, (Object)StringUtil.capitalize((String)(RefactoringUIUtil.getDescription((PsiElement)method, (boolean)true) + " in super class would clash with local method from " + RefactoringUIUtil.getDescription((PsiElement)subClass, (boolean)true))));
            }
        }
    }

    private static boolean willBeMoved(PsiElement element, Set<GrMember> movedMembers) {
        for (PsiElement parent2 = element; parent2 != null; parent2 = parent2.getParent()) {
            if (!movedMembers.contains(parent2)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "targetPackage";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "targetDirectory";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "subclass";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/groovy/refactoring/memberPullUp/GrPullUpConflictsUtil";
        objectArray[2] = "checkConflicts";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConflictingUsagesOfSubClassMembers
    extends GrClassMemberReferenceVisitor {
        private final PsiElement myScope;
        private final Set<GrMember> myMovedMembers;
        private final Set<GrMethod> myAbstractMethods;
        private final PsiClass mySubclass;
        private final PsiClass mySuperClass;
        private final PsiPackage myTargetPackage;
        private final MultiMap<PsiElement, String> myConflictsList;
        private final InterfaceContainmentVerifier myInterfaceContainmentVerifier;

        ConflictingUsagesOfSubClassMembers(PsiElement scope, Set<GrMember> movedMembers, Set<GrMethod> abstractMethods, PsiClass subclass, PsiClass superClass, PsiPackage targetPackage, MultiMap<PsiElement, String> conflictsList, InterfaceContainmentVerifier interfaceContainmentVerifier) {
            super(subclass);
            this.myScope = scope;
            this.myMovedMembers = movedMembers;
            this.myAbstractMethods = abstractMethods;
            this.mySubclass = subclass;
            this.mySuperClass = superClass;
            this.myTargetPackage = targetPackage;
            this.myConflictsList = conflictsList;
            this.myInterfaceContainmentVerifier = interfaceContainmentVerifier;
        }

        @Override
        protected void visitClassMemberReferenceElement(GrMember classMember, GrReferenceElement ref2) {
            if (classMember != null && RefactoringHierarchyUtil.isMemberBetween((PsiClass)this.mySuperClass, (PsiClass)this.mySubclass, (PsiMember)classMember)) {
                if (classMember.hasModifierProperty("static") && !GrPullUpConflictsUtil.willBeMoved(classMember, this.myMovedMembers)) {
                    boolean isAccessible;
                    boolean bl = this.mySuperClass != null ? PsiUtil.isAccessible((PsiMember)classMember, (PsiElement)this.mySuperClass, null) : (isAccessible = this.myTargetPackage != null ? PsiUtil.isAccessibleFromPackage((PsiModifierListOwner)classMember, (PsiPackage)this.myTargetPackage) : classMember.hasModifierProperty("public"));
                    if (!isAccessible) {
                        String message = RefactoringBundle.message((String)"0.uses.1.which.is.not.accessible.from.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)});
                        message = StringUtil.capitalize((String)message);
                        this.myConflictsList.putValue((Object)classMember, (Object)message);
                    }
                    return;
                }
                if (!(this.myAbstractMethods.contains(classMember) || GrPullUpConflictsUtil.willBeMoved(classMember, this.myMovedMembers) || this.existsInSuperClass(classMember))) {
                    String message = RefactoringBundle.message((String)"0.uses.1.which.is.not.moved.to.the.superclass", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)this.myScope, (boolean)false), RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true)});
                    message = StringUtil.capitalize((String)message);
                    this.myConflictsList.putValue((Object)classMember, (Object)message);
                }
            }
        }

        private boolean existsInSuperClass(PsiElement classMember) {
            if (!(classMember instanceof PsiMethod)) {
                return false;
            }
            PsiMethod method = (PsiMethod)classMember;
            if (this.myInterfaceContainmentVerifier.checkedInterfacesContain(method)) {
                return true;
            }
            if (this.mySuperClass == null) {
                return false;
            }
            PsiMethod methodBySignature = this.mySuperClass.findMethodBySignature(method, true);
            return methodBySignature != null;
        }
    }

    private static class ConflictingUsagesOfSuperClassMembers
    extends GrClassMemberReferenceVisitor {
        private final PsiMember myMember;
        private final PsiClass mySubClass;
        private final PsiPackage myTargetPackage;
        private final Set<GrMember> myMovedMembers;
        private final MultiMap<PsiElement, String> myConflicts;

        ConflictingUsagesOfSuperClassMembers(PsiMember member, PsiClass aClass, PsiPackage targetPackage, Set<GrMember> movedMembers, MultiMap<PsiElement, String> conflicts) {
            super(aClass);
            this.myMember = member;
            this.mySubClass = aClass;
            this.myTargetPackage = targetPackage;
            this.myMovedMembers = movedMembers;
            this.myConflicts = conflicts;
        }

        @Override
        protected void visitClassMemberReferenceElement(GrMember classMember, GrReferenceElement ref2) {
            PsiClass containingClass;
            if (classMember != null && !GrPullUpConflictsUtil.willBeMoved(classMember, this.myMovedMembers) && (containingClass = classMember.getContainingClass()) != null && !PsiUtil.isAccessibleFromPackage((PsiModifierListOwner)classMember, (PsiPackage)this.myTargetPackage) && (classMember.hasModifierProperty("packageLocal") || classMember.hasModifierProperty("protected") && !this.mySubClass.isInheritor(containingClass, true))) {
                this.myConflicts.putValue((Object)this.myMember, (Object)(RefactoringUIUtil.getDescription((PsiElement)classMember, (boolean)true) + " won't be accessible"));
            }
        }
    }
}

