/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.encapsulateFields;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldHelper;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldUsageInfo;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsDescriptor;
import com.intellij.refactoring.encapsulateFields.FieldDescriptor;
import com.intellij.refactoring.encapsulateFields.JavaEncapsulateFieldHelper;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.JavaStylePropertiesUtil;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GroovyScriptClass;
import org.jetbrains.plugins.groovy.lang.psi.util.GroovyPropertyUtils;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class GroovyEncapsulateFieldHelper
extends EncapsulateFieldHelper {
    private static final Logger LOG = Logger.getInstance(GroovyEncapsulateFieldHelper.class);

    public PsiField @NotNull [] getApplicableFields(@NotNull PsiClass aClass) {
        if (aClass == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(0);
        }
        if (aClass instanceof GrTypeDefinition) {
            PsiField[] psiFieldArray = ((GrTypeDefinition)aClass).getCodeFields();
            if (psiFieldArray == null) {
                GroovyEncapsulateFieldHelper.$$$reportNull$$$0(1);
            }
            return psiFieldArray;
        }
        PsiField[] psiFieldArray = aClass.getFields();
        if (psiFieldArray == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(2);
        }
        return psiFieldArray;
    }

    @NotNull
    public String suggestSetterName(@NotNull PsiField field2) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(3);
        }
        String string = PropertyUtilBase.suggestSetterName((PsiField)field2);
        if (string == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String suggestGetterName(@NotNull PsiField field2) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(5);
        }
        String string = PropertyUtilBase.suggestGetterName((PsiField)field2);
        if (string == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nullable
    public PsiMethod generateMethodPrototype(@NotNull PsiField field2, @NotNull String methodName, boolean isGetter) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(7);
        }
        if (methodName == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(8);
        }
        GrMethod prototype = isGetter ? GroovyPropertyUtils.generateGetterPrototype(field2) : GroovyPropertyUtils.generateSetterPrototype(field2);
        try {
            prototype.setName(methodName);
            return prototype;
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    @Nullable
    public EncapsulateFieldUsageInfo createUsage(@NotNull EncapsulateFieldsDescriptor descriptor2, @NotNull FieldDescriptor fieldDescriptor, @NotNull PsiReference reference) {
        if (descriptor2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(9);
        }
        if (fieldDescriptor == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(10);
        }
        if (reference == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(11);
        }
        if (!(reference instanceof GrReferenceExpression)) {
            return null;
        }
        GrReferenceExpression ref2 = (GrReferenceExpression)reference;
        boolean findSet = descriptor2.isToEncapsulateSet();
        boolean findGet = descriptor2.isToEncapsulateGet();
        if (findGet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor((PsiClass)descriptor2.getTargetClass(), (PsiMethod)fieldDescriptor.getGetterPrototype(), (PsiElement)ref2)) {
            return null;
        }
        if (findSet && JavaEncapsulateFieldHelper.isUsedInExistingAccessor((PsiClass)descriptor2.getTargetClass(), (PsiMethod)fieldDescriptor.getSetterPrototype(), (PsiElement)ref2)) {
            return null;
        }
        if (!findGet && !PsiUtil.isAccessedForWriting(ref2)) {
            return null;
        }
        if (!(findSet && !fieldDescriptor.getField().hasModifierProperty("final") || PsiUtil.isAccessedForReading(ref2))) {
            return null;
        }
        return new EncapsulateFieldUsageInfo((PsiReference)ref2, fieldDescriptor);
    }

    @Nullable
    private static PsiClass getAccessObject(@NotNull GrReferenceExpression ref2) {
        GrExpression qualifier;
        if (ref2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(12);
        }
        if ((qualifier = ref2.getQualifierExpression()) != null) {
            return (PsiClass)PsiUtil.getAccessObjectClass(qualifier).getElement();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processUsage(@NotNull EncapsulateFieldUsageInfo usage, @NotNull EncapsulateFieldsDescriptor descriptor2, PsiMethod setter, PsiMethod getter) {
        boolean processSet;
        PsiElement element;
        if (usage == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(13);
        }
        if (descriptor2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(14);
        }
        if (!((element = usage.getElement()) instanceof GrReferenceExpression)) return false;
        GrReferenceExpression expr = (GrReferenceExpression)element;
        FieldDescriptor fieldDescriptor = usage.getFieldDescriptor();
        PsiField field2 = fieldDescriptor.getField();
        boolean processGet = descriptor2.isToEncapsulateGet();
        boolean bl = processSet = descriptor2.isToEncapsulateSet() && !field2.hasModifierProperty("final");
        if (!processGet && !processSet) {
            return true;
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(descriptor2.getTargetClass().getProject());
        try {
            PsiElement parent2;
            if (!descriptor2.isToUseAccessorsWhenAccessible()) {
                PsiModifierList newModifierList = JavaEncapsulateFieldHelper.createNewModifierList((EncapsulateFieldsDescriptor)descriptor2);
                PsiClass accessObjectClass = GroovyEncapsulateFieldHelper.getAccessObject(expr);
                PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)expr.getProject()).getResolveHelper();
                if (helper.isAccessible((PsiMember)fieldDescriptor.getField(), newModifierList, (PsiElement)expr, accessObjectClass, null)) {
                    Object[] objectArray = expr.multiResolve(false);
                    if (!ContainerUtil.or((Object[])objectArray, it -> it.isValidResult() && it.getElement() instanceof PsiMethod)) return true;
                    GroovyEncapsulateFieldHelper.addMemberOperator(expr, field2);
                    return true;
                }
            }
            if ((parent2 = expr.getParent()) instanceof GrAssignmentExpression) {
                GrAssignmentExpression assignment = (GrAssignmentExpression)parent2;
                if (expr.equals(((GrAssignmentExpression)parent2).getLValue())) {
                    void var19_38;
                    void var16_26;
                    GrMethodCallExpression getterCall;
                    if (assignment.getRValue() == null) return true;
                    PsiElement opSign = assignment.getOperationToken();
                    if (!assignment.isOperatorAssignment()) {
                        if (!processSet) return true;
                        if (GroovyEncapsulateFieldHelper.checkSetterIsSimple(field2, setter) && GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field2, expr)) {
                            return true;
                        }
                        GrExpression grExpression = assignment.getRValue();
                        GrMethodCallExpression grMethodCallExpression = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, grExpression, expr, descriptor2.getTargetClass(), setter);
                        if (grMethodCallExpression == null) return true;
                        GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)assignment.replaceWithExpression(grMethodCallExpression, true));
                        return true;
                    }
                    if (GroovyEncapsulateFieldHelper.checkAccessorsAreSimpleAndFieldIsInaccessible(field2, setter, getter, expr)) {
                        return true;
                    }
                    String string = opSign.getText();
                    LOG.assertTrue(StringUtil.endsWithChar((CharSequence)string, (char)'='));
                    String string2 = string.substring(0, string.length() - 1);
                    GrReferenceExpression grReferenceExpression = expr;
                    if (processGet && (getterCall = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor2.getTargetClass(), getter)) != null) {
                        GrMethodCallExpression grMethodCallExpression = getterCall;
                    }
                    @NonNls Object text = "a" + string2 + "b";
                    GrBinaryExpression grBinaryExpression = (GrBinaryExpression)factory.createExpressionFromText((String)text, expr);
                    GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)grBinaryExpression.getLeftOperand().replaceWithExpression((GrExpression)var16_26, true));
                    grBinaryExpression.getRightOperand().replaceWithExpression(assignment.getRValue(), true);
                    if (processSet) {
                        GrMethodCallExpression grMethodCallExpression = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, grBinaryExpression, expr, descriptor2.getTargetClass(), setter);
                    } else {
                        text = "a = b";
                        GrAssignmentExpression newAssignment = (GrAssignmentExpression)factory.createExpressionFromText((String)text, null);
                        newAssignment.getLValue().replaceWithExpression(expr, true);
                        newAssignment.getRValue().replaceWithExpression(grBinaryExpression, true);
                        GrAssignmentExpression grAssignmentExpression = newAssignment;
                    }
                    GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)assignment.replaceWithExpression((GrExpression)var19_38, true));
                    return true;
                }
            }
            if (parent2 instanceof GrUnaryExpression && (((GrUnaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mINC || ((GrUnaryExpression)parent2).getOperationTokenType() == GroovyTokenTypes.mDEC)) {
                void var18_35;
                void var15_22;
                GrMethodCallExpression grMethodCallExpression;
                if (GroovyEncapsulateFieldHelper.checkAccessorsAreSimpleAndFieldIsInaccessible(field2, setter, getter, expr)) {
                    return true;
                }
                IElementType sign = ((GrUnaryExpression)parent2).getOperationTokenType();
                GrReferenceExpression grReferenceExpression = expr;
                if (processGet && (grMethodCallExpression = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor2.getTargetClass(), getter)) != null) {
                    GrMethodCallExpression grMethodCallExpression2 = grMethodCallExpression;
                }
                @NonNls String string = sign == GroovyTokenTypes.mINC ? "a+1" : "a-1";
                GrBinaryExpression binExpr = (GrBinaryExpression)factory.createExpressionFromText(string, parent2);
                GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)binExpr.getLeftOperand().replaceWithExpression((GrExpression)var15_22, true));
                if (processSet) {
                    GrMethodCallExpression grMethodCallExpression3 = GroovyEncapsulateFieldHelper.createSetterCall(fieldDescriptor, binExpr, expr, descriptor2.getTargetClass(), setter);
                } else {
                    @NonNls String string3 = "a = b";
                    GrAssignmentExpression grAssignmentExpression = (GrAssignmentExpression)factory.createExpressionFromText(string3, null);
                    grAssignmentExpression.getLValue().replaceWithExpression(expr, true);
                    grAssignmentExpression.getRValue().replaceWithExpression(binExpr, true);
                    GrAssignmentExpression grAssignmentExpression2 = grAssignmentExpression;
                }
                GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)((GrUnaryExpression)parent2).replaceWithExpression((GrExpression)var18_35, true));
                return true;
            }
            if (!processGet) return true;
            if (GroovyEncapsulateFieldHelper.checkGetterIsSimple(field2, getter) && GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field2, expr)) {
                return true;
            }
            GrMethodCallExpression methodCall = GroovyEncapsulateFieldHelper.createGetterCall(fieldDescriptor, expr, descriptor2.getTargetClass(), getter);
            if (methodCall == null) return true;
            GroovyEncapsulateFieldHelper.tryToSimplify((GrMethodCallExpression)expr.replaceWithExpression(methodCall, true));
            return true;
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    private static void addMemberOperator(@NotNull GrReferenceExpression ref2, @NotNull PsiField field2) {
        if (ref2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(15);
        }
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(16);
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(ref2.getProject());
        GrExpression qualifier = (GrExpression)ref2.getQualifier();
        if (qualifier == null) {
            PsiClass parentClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref2, PsiClass.class);
            PsiClass containingClass = GroovyEncapsulateFieldHelper.findContainingClass(ref2, field2);
            GrReferenceExpression thisRef = !ref2.getManager().areElementsEquivalent((PsiElement)parentClass, (PsiElement)containingClass) ? factory.createThisExpression(containingClass) : factory.createThisExpression(null);
            ref2.setQualifier(thisRef);
        }
        ref2.getNode().addLeaf(GroovyTokenTypes.mAT, (CharSequence)"@", ref2.getDotToken().getNode().getTreeNext());
    }

    private static PsiClass findContainingClass(@NotNull GrReferenceExpression ref2, @NotNull PsiField field2) {
        if (ref2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(17);
        }
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(18);
        }
        GrReferenceExpression context = ref2;
        PsiClass aClass;
        while ((aClass = PsiUtil.getContextClass(context)) != null) {
            PsiField found;
            PsiManager manager = context.getManager();
            if (manager.areElementsEquivalent((PsiElement)(found = aClass.findFieldByName(field2.getName(), true)), (PsiElement)field2)) {
                return aClass;
            }
            if (context instanceof GroovyScriptClass) {
                return null;
            }
            if (context.getParent() instanceof GroovyFile) {
                return null;
            }
            context = aClass.getParent();
        }
        return null;
    }

    private static boolean checkAccessorsAreSimpleAndFieldIsInaccessible(@NotNull PsiField field2, @Nullable PsiMethod setter, @Nullable PsiMethod getter, @NotNull GrReferenceExpression place) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(19);
        }
        if (place == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(20);
        }
        return !(setter != null && !GroovyEncapsulateFieldHelper.checkSetterIsSimple(field2, setter) || getter != null && !GroovyEncapsulateFieldHelper.checkGetterIsSimple(field2, getter) || !GroovyEncapsulateFieldHelper.checkFieldIsInaccessible(field2, place));
    }

    private static boolean checkSetterIsSimple(@NotNull PsiField field2, @NotNull PsiMethod setter) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(21);
        }
        if (setter == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(22);
        }
        String nameBySetter = GroovyPropertyUtils.getPropertyNameBySetterName(setter.getName());
        return field2.getName().equals(nameBySetter);
    }

    private static boolean checkGetterIsSimple(@NotNull PsiField field2, @NotNull PsiMethod getter) {
        if (field2 == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(23);
        }
        if (getter == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(24);
        }
        String nameByGetter = GroovyPropertyUtils.getPropertyNameByGetterName(getter.getName(), true);
        return field2.getName().equals(nameByGetter);
    }

    private static boolean checkFieldIsInaccessible(PsiField field2, @NotNull GrReferenceExpression place) {
        if (place == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(25);
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)field2.getProject()).getResolveHelper();
        return helper.isAccessible((PsiMember)field2, (PsiElement)place, GroovyEncapsulateFieldHelper.getAccessObject(place));
    }

    private static void tryToSimplify(@NotNull GrMethodCallExpression methodCall) {
        if (methodCall == null) {
            GroovyEncapsulateFieldHelper.$$$reportNull$$$0(26);
        }
        if (JavaStylePropertiesUtil.isPropertyAccessor(methodCall)) {
            JavaStylePropertiesUtil.fixJavaStyleProperty(methodCall);
        }
    }

    private static GrMethodCallExpression createSetterCall(FieldDescriptor fieldDescriptor, GrExpression setterArgument, GrReferenceExpression expr, PsiClass aClass, PsiMethod setter) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(fieldDescriptor.getField().getProject());
        String setterName = fieldDescriptor.getSetterName();
        @NonNls String text = setterName + "(a)";
        GrExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)factory.createExpressionFromText(text, expr);
        methodCall.getArgumentList().getExpressionArguments()[0].replace(setterArgument);
        if (qualifier != null) {
            ((GrReferenceExpression)methodCall.getInvokedExpression()).getQualifierExpression().replace(qualifier);
        }
        if ((methodCall = GroovyEncapsulateFieldHelper.checkMethodResolvable(methodCall, setter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static GrMethodCallExpression createGetterCall(FieldDescriptor fieldDescriptor, GrReferenceExpression expr, PsiClass aClass, PsiMethod getter) throws IncorrectOperationException {
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(fieldDescriptor.getField().getProject());
        String getterName = fieldDescriptor.getGetterName();
        @NonNls String text = getterName + "()";
        GrExpression qualifier = expr.getQualifierExpression();
        if (qualifier != null) {
            text = "q." + text;
        }
        GrMethodCallExpression methodCall = (GrMethodCallExpression)factory.createExpressionFromText(text, expr);
        if (qualifier != null) {
            ((GrReferenceExpression)methodCall.getInvokedExpression()).getQualifierExpression().replace(qualifier);
        }
        if ((methodCall = GroovyEncapsulateFieldHelper.checkMethodResolvable(methodCall, getter, expr, aClass)) == null) {
            VisibilityUtil.escalateVisibility((PsiMember)fieldDescriptor.getField(), (PsiElement)expr);
        }
        return methodCall;
    }

    @Nullable
    private static GrMethodCallExpression checkMethodResolvable(GrMethodCallExpression methodCall, PsiMethod targetMethod, GrReferenceExpression context, PsiClass aClass) throws IncorrectOperationException {
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)targetMethod.getProject()).getElementFactory();
        PsiElement resolved = ((GrReferenceExpression)methodCall.getInvokedExpression()).resolve();
        if (resolved != targetMethod) {
            PsiClass containingClass;
            if (resolved instanceof PsiMethod) {
                containingClass = ((PsiMethod)resolved).getContainingClass();
            } else if (resolved instanceof PsiClass) {
                containingClass = (PsiClass)resolved;
            } else {
                return null;
            }
            if (containingClass != null && containingClass.isInheritor(aClass, false)) {
                PsiExpression newMethodExpression = factory.createExpressionFromText("super." + targetMethod.getName(), (PsiElement)context);
                methodCall.getInvokedExpression().replace((PsiElement)newMethodExpression);
            } else {
                methodCall = null;
            }
        }
        return methodCall;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 16: 
            case 18: 
            case 19: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDescriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 20: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "setter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getter";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodCall";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/refactoring/encapsulateFields/GroovyEncapsulateFieldHelper";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableFields";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSetterName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestGetterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableFields";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestSetterName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "suggestGetterName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "generateMethodPrototype";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createUsage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAccessObject";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processUsage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addMemberOperator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findContainingClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkAccessorsAreSimpleAndFieldIsInaccessible";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkSetterIsSimple";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkGetterIsSimple";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldIsInaccessible";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "tryToSimplify";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 4, 6 -> new IllegalStateException(string);
        };
    }
}

