/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.sam;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;
import org.jetbrains.plugins.groovy.lang.sam.SamConversionKt;
import org.jetbrains.plugins.groovy.lang.typing.GroovyClosureType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J*\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J0\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0015H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/groovy/lang/sam/ClosureToSamConverter;", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter;", "()V", "myPositions", "", "Lorg/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrTypeConverter$Position;", "isApplicableTo", "", "position", "isConvertible", "Lorg/jetbrains/plugins/groovy/lang/psi/impl/statements/expressions/ConversionResult;", "targetType", "Lcom/intellij/psi/PsiType;", "actualType", "context", "Lorg/jetbrains/plugins/groovy/lang/psi/GroovyPsiElement;", "reduceTypeConstraint", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "leftType", "rightType", "Lcom/intellij/psi/PsiElement;", "intellij.groovy.psi"})
public final class ClosureToSamConverter
extends GrTypeConverter {
    @NotNull
    private final Set<GrTypeConverter.Position> myPositions;

    public ClosureToSamConverter() {
        GrTypeConverter.Position[] positionArray = new GrTypeConverter.Position[]{GrTypeConverter.Position.ASSIGNMENT, GrTypeConverter.Position.RETURN_VALUE, GrTypeConverter.Position.METHOD_PARAMETER};
        this.myPositions = SetsKt.setOf((Object[])positionArray);
    }

    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        return this.myPositions.contains((Object)position);
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        Intrinsics.checkNotNullParameter((Object)targetType, (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(targetType instanceof PsiClassType) || !(actualType instanceof GroovyClosureType) && !TypesUtil.isClassType(actualType, "groovy.lang.Closure")) {
            return null;
        }
        if (!SamConversionKt.isSamConversionAllowed(context)) {
            return null;
        }
        PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)targetType).resolveGenerics();
        Intrinsics.checkNotNullExpressionValue((Object)classResolveResult, (String)"resolveGenerics(...)");
        PsiClassType.ClassResolveResult result2 = classResolveResult;
        PsiClass psiClass = result2.getElement();
        if (psiClass == null) {
            return null;
        }
        PsiClass targetClass = psiClass;
        String string = targetClass.getQualifiedName();
        if (string == null) {
            return null;
        }
        String targetFqn = string;
        if (Intrinsics.areEqual((Object)targetFqn, (Object)"groovy.lang.Closure")) {
            return null;
        }
        if (SamConversionKt.findSingleAbstractSignature(targetClass) == null) {
            return null;
        }
        return ConversionResult.OK;
    }

    @Nullable
    public List<ConstraintFormula> reduceTypeConstraint(@NotNull PsiType leftType, @NotNull PsiType rightType, @NotNull GrTypeConverter.Position position, @NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)leftType, (String)"leftType");
        Intrinsics.checkNotNullParameter((Object)rightType, (String)"rightType");
        Intrinsics.checkNotNullParameter((Object)((Object)position), (String)"position");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(rightType instanceof GroovyClosureType)) {
            return null;
        }
        return SamConversionKt.processSAMConversion(leftType, (GroovyClosureType)rightType, context);
    }
}

